print -r Running ${HOME%/}/profile.ksh >&2

# MKS Toolkit sample profile.ksh -- Modify to taste.

# This file is executed by KornShells started either from login, or via
# "sh -L".  It contains initializations commands specific to a single
# KornShell user.
# There is also a sample $ROOTDIR/etc/profile.ksh which contains global
# initializations and is executed before this file.

# A default PATH should already be defined.  You can add to the PATH to
# suit a particular login.
export PATH="$PATH;${HOME%/}/bin"

# Set up environment file, to be processed by all shells at startup.
export ENVIRON=${HOME%/}/environ.ksh

# The following is the standard idiom for processing ENVIRON in
# *interactive* shells only.
#export ENV='${ENVIRON[(_$-=1)+(_=0)-(_$-!=_${-%%*i*})]}'

# The following is a simple definition that will process ENVIRON in
# *all* shells.
export ENV="$ENVIRON"

# If LOGNAME is com or cmd, then we really want to run command.com or
# cmd.exe, the standard command interpreters provided with DOS and OS/2
# respectively.
case "$LOGNAME" in
com)	. "$ROOTDIR/etc/dospath.ksh"
	export PROMPT='$p$g'
	unset SHELL
	exec $COMSPEC /e:1024;;	# adjust environment space to suit.
cmd)	. "$ROOTDIR/etc/dospath.ksh"
	export PROMPT='$p$g'
	unset SHELL
	exec $COMSPEC;;
esac
