cseg    segment byte public 'CODE'
	assume  cs:cseg, ds:nothing
	org     100h
start:  jmp     Main
	db      13,'COMCOM (c)1993 by khweis1@mvmpc7',13,10,26
ppp     db      '+++',0
hup     db      'ath',13,0
rate    db      1,2,3,6,0ch,18h,30h,60h
ports   dw      3f8h,2f8h,3e8h,2e8h,2f0h
irql    dw      4,3,4,3,5
port    dw      ?      ;Portadresse des Uarts (>100h)
irq     db      ?      ;IRQ-Level (2-7)
InIrq   db      ?      ;In-IRQ-Flag
iem     db      ?      ;alte Int. Enable-Maske f. Int-Controller (21h)
ier     db      ?      ;Int. Eanble -Register im uart (port+1)
mcr     db      ?      ;Modem Control-Register im uart (port+4)
stop    db      0bh
t0      dw      ?      ;Timeout-Variablen
t1      dw      ?
iflag   db      ?      ;Bedingungs-Flag (Errorlevel)
sz      dw      0h     ;Schreibzeiger fr Echos vom Uart
lz      dw      0h     ;Lesezeiger f. Konsolenausgabe
tsz     dw      81h    ;Temporaerer Schreibzeiger f. Interpreter/Commandline
hz      dw      0
oldint  dd      ?      ;Alter INT-Vektor f. Com-Port
old23   dd      ?      ;Ctrl-Break-Handler
buflen  equ     1024   ;Kommunikationsbuffer
buf     db     buflen dup(?)
wort    db     buflen dup(?)
;lower/upper-Case Koverter. Zeichen in al
upcase  proc   near
	cmp     al,'a'
	jb      nocvt
	cmp     al,'z'
	ja      nocvt
	sub     al,32
nocvt:  ret
upcase endp

;Hexa-Zahlen-Konverter. Zeichen in al. Zuerst Zwischenergebnis in dx
;mit 16 multiplizieren, dann Binr-Wert des Zeichens addieren
Hex     proc near
	mov  al,[si]
	call HexDig
	jc   HexEx
Hexok:  inc  si
	add  cx,cx
	add  cx,cx
	add  cx,cx
	add  cx,cx
	xor  ah,ah
	add  cx,ax
HexEx:  ret
Hex     Endp

HexDig  proc   near
	call upcase
	sub  al,'0'
	jc   @f
	cmp  al,0ah
	cmc
	jnc   @f
	sub  al, 7
	cmp  al, 10h
	cmc
@@:     ret
HexDig  Endp

;Leerzeichen berlesen
strsp   proc   near
	dec    si
@@:     inc     si
	mov    al,[si]
	cmp     al,' '
	jz      @b
@@:     ret
strsp   endp

;Mehrstellige Hexadezimalzahl nach Binr umwandeln
ReadHex Proc    near
	call    strsp
	jz      nohex
	mov     cx,0
@@:     call    Hex
	jnc     @b
NoHex:  ret
ReadHex Endp

;Dezimalzahl wandeln
ReadDez proc    near
	call    strsp
	jz      nodez
	mov     cx,0
@@:     mov     al,[si]
	call    HexDig
	jc      nodez
	cmp     al,10
	jnc     nodez
	inc     si
	push    ax
	push    dx
	mov     ax,cx
	mov     cx,10
	mul     cx
	mov     cx,ax
	pop     dx
	pop     ax
	sub     ah,ah
	add     cx,ax
	jmp     @b
nodez:  ret
Readdez endp

;Carrier Detect abwarten
DCD    proc     near
       call     ReadDez
       and      cx,cx
       jnz      @f
       mov      cx,1200    ;120 Sekunden max
@@:    call     setto
       inc      dx
dcdw1: call     getto
       mov      ax,0
       jc       dcdw2
       in       al,dx
       and      al,80h
       jz       dcdw1
       mov      al,4
dcdw2: dec      dx
       and      [iflag],0fbh
       or       [iflag],al
       ret
DCD    endp

IfCon   proc    near
	ret
IfCon   endp

Waitfor proc    near
       and      [iflag],0fch
       call     ReadDez
       call     strsp
       cmp      al,0dh
       stc
       jz       waitq
       and      cx,cx
       jnz      @f
       mov      cx,1200    ;120 Sekunden max
@@:    call     setto
Wait0: call     GetWort
       jc       waitq
       mov      bl,0
       push     si
@@:    inc      bl
       call     cmpwort
       jz       @f
       add      si,cx
       call     strsp
       cmp      al,0dh
       jnz      @b
       and      al,al
@@:    pop      si
       jnz      wait0
       and      bl,3
       or       [iflag],bl
waitq: cmp      byte ptr [si],0dh
       jz       @f
       cmp      byte ptr [si],'^'
       jz       @f
       inc      si
       jmp      waitq
@@:    ret
Waitfor endp

cmpwort proc    near
	push    si
	mov     cx,-1
	dec     si
@@:     inc     si
	inc     cx
	cmp     byte ptr [si],33  ;ds[si] ist der Vorgabestring
	jnc     @b
	pop     si
	cmp     di,cx
	jc      @f
	lea     di,wort
	cld
	push    si
	push    cx
	repe    cmpsb
	pop     cx
	pop     si
@@:     ret
cmpwort endp

GetWort proc    near
       mov      bx,[hz]    ;Zeiger in Empfangspuffer
       mov      di,0       ;Wortzeiger
@@:    call     getto
       jc       wq
       cmp      bx,[sz]
       jz       @b
       mov      al,buf[bx]
       inc      bx
       and      bx,buflen-1
       cmp      al,33
       jc       @b
       mov      wort[di],al
       inc      di
@@:    call     getto
       jc       wq
       cmp      bx,[sz]
       jz       @b
       mov      al,buf[bx]
       inc      bx
       and      bx,buflen-1
       mov      wort[di],al
       cmp      al,33
       cmc
       jnc      wq
       inc      di
       cmp      di,buflen
       jnz      @b
wq:    mov     [hz],bx
       ret
GetWort endp


;DTR setzen/Rcksetzen
dtr     proc    near
	call    ReadDez
dtr0:   dec     dx
	mov     al,cl
	or      al,0ah    ;RTS+Out2
	out     dx,al
	inc     dx
	mov     cx,5
	call    tdly
	ret
dtr     endp

;Break senden
sbrk    proc    near
	mov     al,43h
	sub     dx,2
	out     dx,al
	add     dx,2
	call    dly
	sub     dx,2
	mov     al,3h
	out     dx,al
	add     dx,2
	ret
sbrk    endp

;FCR  programmieren
fifo    proc    near
	call    readhex
	sub     dx,3
	mov     al,cl
	out     dx,al
	add     dx,3
	ret
fifo    endp

;COM-Port initialisieren (Baudrate setzen)
Baud    proc near
	call    ReadDez
Baud0:  cmp     cx,8
	jnc     nobaud
	push    bx
	mov     bx,cx
	mov     ah,[rate+bx]
	pop     bx
	dec     dx
	dec     dx
	mov     al,83h      ;LCR (8Bit,1 Stop, No Parity)
	out     dx,al
	sub     dx,2
	xor     al,al       ;baudrate, msb
	out     dx,al
	dec     dx
	mov     al,ah
	out     dx,al       ;Baudrate lsb
	add     dx,3
	mov     al,3
	out     dx,al
	add     dx,2
nobaud: ret
Baud    endp

;Delay-Routine
dly     proc    near
	call    ReadDez
tdly:   call    setto
@@:     call    getto
	jnc      @b
	ret
dly     endp
;Timeout starten, cx= 0.1Sek-Einheiten
setto   proc    near
	push    bx
	push    es
	add     cx,cx
	mov     bx,40h
	mov     es,bx
	mov     bx,es:[6ch]
	mov     [t0],bx
	mov     [t1],cx
	pop     es
	pop     bx
	ret
setto   endp

;Timeout abfragen
getto   proc    near
	push    bx
	push    es
	call    break
	jc     getqu
@@:     mov     bx,[t0]
	mov     cx,[t1]
	mov     ax,40h
	mov     es,ax
	mov     ax,es:[6ch]
	sub     ax,bx
	cmp     cx,ax
getqu:  pop     es
	pop     bx
	ret
getto   endp

break   proc    near
	mov     ah,1
	int     16h
	jz      @f
	push    ax
	mov     ah,0
	int     16h
	pop     ax
	test    al,0ffh
	jnz     @f
	cmp     ah,12h
	jnz     @f
	or     [iflag],8
	stc
@@:     ret
break   endp

;Interrupt-Handler
irx      proc   far
	 push    ax
	 push    bx
	 push    dx
	 mov    bx,[sz]
	 mov    dx,[port]
	 add    dx,4
irx1:    inc    dx
	 in     al,dx
	 sub    dx,5
	 and    al,1fh
	 cmp    al,1
	 jnz    irx2
	 in     al,dx
	 cmp     al,0ah
	 jnz     @f
	 mov    [hz],bx
@@:      mov    buf[bx],al
;Handshake
	 mov    ax,bx
	 sub    ax,[lz]
	 and    ax,buflen-1
	 inc    bx
	 and    bx,buflen-1
@@:      add    dx,4
	 cmp    ax,384
	 jc     irx1
	 mov    al,9
	 out    dx,al
	 jmp    irx1
irx2:    test   al,1
	 jz     @f
	 in     al,dx
@@:      mov    [sz],bx
	 mov    al,20h
	 out    20h,al
	 test   [InIrq],0ffh
	 jnz    @f
nochm:   call   rx
	 mov    dx,[sz]
	 cmp    bx,dx
	 jnz    nochm
@@:      sti
	 pop     dx
	 pop     bx
	 pop     ax
	 iret
irx      endp

rx      proc   near
	mov     [inirq],0ffh
	mov     bx,[lz]
	sti
rx1:    mov     dx,[sz]
	cmp     bx,dx
	jz      norx
	mov     al,buf[bx]
	int     29h
	inc     bx
	and     bx,buflen-1
	jmp     rx1
norx:   cli
	mov     dx,[port]
	add     dx,4
	mov     al,[stop]
	out     dx,al
	mov     [inirq],0
	mov     [lz],bx
	ret
rx      endp


;Script-Kommando abarbeiten (Zeiger si)
scriptcmd  proc    near
	mov     ax,offset qtx   ;Allg. Return ohne Carry
	push    ax
	call    strsp
	cmp     si,bx
	jc      @f
	ret
@@:     inc     si
	cmp     al,0dh
	jnz     @f
	ret
@@:     cmp     al,'^'
	jz      @f
	jmp     tx
@@:     mov     ax,[si]
	cmp     al,0dh
	jnz      @f
	pop     ax
	stc                     ;EOF
	mov     al,12h          ;Alt-E simulieren
	ret
@@:     call    upcase
	inc     si
	cmp     al,'T'       ;T-Wait
	jnz     @f
	jmp     dly          ;Wartezeit
@@:     cmp     al,'D'
	jnz     @f
	jmp    dtr           ;DTR
@@:     cmp     al,'B'
	jnz     @f
	jmp     baud         ;Baud-Rate
@@:     cmp     al,'F'       ;Fifo
	jnz     @f
	jmp     fifo
@@:     cmp     al, 'K'      ;Break
	jnz     @f
	jmp     sbrk
@@:     cmp     al,'W'
	jnz     @f
	call    WaitFor      ;Wait For String
	ret
@@:     cmp     al,'H'
	jnz     @f
	jmp     Hangup
@@:     mov     cl,al
	mov     al,ah
	call    upcase
	mov     ch,al
	inc     si
	cmp     cx, 'DC'
	jnz     @f
	jmp     DCD          ;Data Carrier Detect
@@:     cmp     cx, 'FI'
	jnz     @f
	jmp     Ifcon       ;If-Konstruct
@@:     mov     al,0dh
	cmp     cx,'RC'    ;CR-Zeichen
	jz      tx
	mov     al,0ah
	cmp     cx,'FL'    ;LF-Zeichen
	jz      tx
	mov     al,' '
	cmp     cx,'PS'    ;Space-Zeichen
	jz      tx
	dec     si
	dec     si
	mov     al,[si]
	call HexDig
	jc      @f
	call    readhex
	mov     al,cl
	dec     si
@@:     inc     si
tx:     cmp     al,0ah     ;0ah filtern!
	jz      notx
	push    ax
txlp:   in      al,dx
	and     al,30h
	jz      txlp
	pop     ax
	sub     dx,5
	out     dx,al
	add     dx,5
notx:   cmp     al,0dh
	jnz     notxq
	mov     [hz],-1
	push    ax        ;Echo- CR abwarten
	mov     cx,5      ;Maximal 0.5 Sekunden
	call    setto
@@:     call    getto
	jc      @f
	cmp     [hz],-1
	jz      @b
;        mov     cx,2     ;Ersatzweise 0.2 Sek warten
;        call    tdly
@@:      pop     ax
notxq:  ret
qtx:    and     al,al
	ret
scriptcmd  endp

keyb    proc near
	mov     ah,0bh
	int     21h
	and     al,al
	jz      @f
	mov     ah,07
	int     21h
	and     al,al
	jnz     @f
	mov     ah,07
	int     21h
	or      al,al
	stc               ;Alt-Taste
@@:     ret
keyb    endp

;Kommandoeingabe-Schleife
cmdloop proc   near
cmdl0:  mov     bx,[tsz]
	cmp     si,bx
	jnc    @f
	call    scriptcmd
	jnc     cmdl0
	jmp     cmdl3
@@:     call    keyb
	jz      cmdl0
	jc      cmdl3
@@:     cmp     si,bx
	jz      cmdl1
	inc     bx
	mov     [tsz],bx
	mov     [bx],al
	int     29h
	cmp     al,0dh
	jnz     cmdl2
	mov     al,0ah
	int     29h
	mov     si,80h
	jmp     cmdl2
cmdl1:  cmp     al,'^'
	jz      @f
	call    tx
	jmp     cmdl2
@@:     mov     si,100h
	mov     bx,80h
	mov     [tsz],bx
	mov     [bx],al
	int     29h
cmdl2:  and     al,al
cmdl3:  ret
cmdloop endp

;Terminal-Hauptprogramm
Terminal proc   near
Termi:
	 call   cmdloop   ;Kommandoschleife  = Console In
	 jnc    Termi
	 cmp    al,23h    ;Alt-H
	 jnz    @f
	 call   hangup
	 jmp    termi
@@:      cmp    al,12h    ;Alt-E
	 jz     fini
	 cmp    al,1fh    ;alt-s
	 jz     @f
	 push   ax
	 mov    al,0
	 call   tx
	 pop    ax
	 call   tx
	 jmp    Termi
@@:      mov    al,9
	 cmp    [stop],0bh
	 jz     @f
	 mov    al,0bh
@@:      mov    [stop],al
	 dec    dx
	 out    dx,al
	 inc    dx
	 jmp    termi
fini:    ret
Terminal endp

hangup   proc   near
	 mov    cx,5
	 call   tdly
	 push   bx
	 lea    bx, ppp
	 call   sends
	 mov    cx,15
	 call   tdly
	 lea    bx,hup
	 call   sends
	 pop    bx
	 mov    cx,5
	 call   tdly
	 ret
hangup   endp

sends   proc    near
	 mov    al,cs:[bx]
	 inc    bx
	 and    al,al
	 jz     @f
	 call   tx
	 jmp    sends
@@:      ret
sends   endp

;Ctrl-Break-Handling
new23   proc    far
	cli
	push    ax
	call    quit
	mov     al,7
	int     29h
	pop     ax
	jmp     [old23]
	iret
new23   endp

quit    proc    near
	push    dx
	push    ds
	mov     dx,[port]
	add     dx,4
	mov     ah,[mcr]
	and     ah,0eh
	in      al,dx
	and     al,1              ;Aktuelles DTR
	or      al,ah
	out     dx,al
	mov     al,[ier]
	sub     dx,3
	out     dx,al
	mov     al,[iem]
	out     21h,al
	lds     dx,[oldint]
	mov     ah,25h
	mov     al,[irq]
	int     21h
	lds     dx,old23
	mov     ah,25h
	mov     al,23h
	int     21h
	pop     ds
	pop     dx
	sti
	ret
quit    endp

;Initialisierung und Start des Programms
Main:
	mov     si,80h     ;PSP, Kommandozeile
	mov     al,[si]    ;Lof Commandline
	sub     ah,ah
	add     ax,82h
	mov     [tsz],ax   ;Schreibzeiger f. Script
	inc     si
	call    ReadHex    ;Portadresse lesen
	jz      quit       ;da fehlt was ...
	cmp     cx,6       ;Port-# 1-5
	jnc     isadr      ;Oder Port-Adresse
	dec     cx
	js      quit
	add     cx,cx      ;Port-Adresse aus Tabelle
	mov     bx,cx
	mov     cx,[ports+bx]
	mov     [port],cx
	mov     cx,[irql+bx]
	jmp     @f
isadr:  cmp     cx,100h    ;Plausibilittsprfung (>100h)
	jc      quitx
	mov     [port],cx     ;2f0
	call    readhex     ;IRQ-Nr. lesen
	jz      quitx       ;2-7 ist ok.
	cmp     cx,8
	jnc     quitx
	cmp     cx,2
	jc      quitx
@@:     add     cl,8        ;+Offset --> INT-Nummer
	mov     [irq],cl
	cli
	call    swapint
	call    ClearUart
	call    enirq             ;IRQ-Maske setzen
	sti
	mov     cx,5
	call    tdly
	push    cs
	pop     es
@@:     call    Terminal
	call    quit
quitx:  mov     ax,4c00h
	mov     al,[iflag]
	int     21h            ;Schluss der Vorstellung .....

;Hilfsprogramme zur Initialisierung
enirq   proc    near
	mov     cl,irq
	sub     cl,8
	mov     ch,0feh
	rol     ch,cl
	in      al,21h
	mov     [iem],al
	and     al,ch
	out     21h,al
	mov     al,20h
	out     20h,al
	ret
enirq   endp

swapint proc    near
	mov     al,23h
	mov     ah,35h
	int     21h
	mov     word ptr [old23],bx
	mov     word ptr [old23+2],es
	mov     al,[irq]
	mov     ah,35h      ;INT-Vector lesen
	int     21h
	mov     word ptr [oldint],bx
	mov     word ptr [oldint+2],es
	push    ds
	push    cs
	pop     ds
	mov     dx,offset new23
	mov     ah,25h
	mov     al,23h
	int     21h
	mov     dx,offset irx
	mov     ah,25h
	mov     al,[irq]
	int     21h
	pop     ds
	ret
swapint endp


ClearUart       proc    near
	mov     dx,[port]
	add     dx,4             ;MCR testen
	in      al,dx
	inc     dx
	and     al,10h           ;Uart schon gesetzt?
	jz      @f
	dec     dx
	mov     al,0            ;MCR reset
	out     dx,al
	inc     dx
	mov     cx,2             ;38400 Baud
	call    baud0
@@:     dec     dx
	in      al,dx
	mov     [mcr],al
	sub     dx,3
	in      al,dx
	mov     [ier],al         ;alte IER-Maske speichern
	mov     al,1             ;DAV zulassen
	out     dx,al
	inc     dx
	mov     al,0c1h
;        out     dx,al           ;ersetzt durch Fifo-Kommando
	add     dx,2             ;Zeiger wieder auf MCR (2f4)
	in      al,dx
	and     al,0fh
	or      al,0ah           ;RTS und Out2 Ein
	out     dx,al
	inc     dx
@@:     in      al,dx
	and     al,1
	jz      @f
	sub     dx,5
	in      al,dx
	add     dx,5
;        jmp     @b
@@:     ret
ClearUart       endp

cseg    ends
	end    start
