/*
    Dacstuf.h

    Header file for the DAC routines in Dacstuf.asm.
*/

#ifndef DACSTUF_H
#define DACSTUF_H

/*************************************************************************/
/*                                                                       */
/* Macros.                                                               */
/*                                                                       */
/*************************************************************************/



/*************************************************************************/
/*                                                                       */
/* Types.                                                                */
/*                                                                       */
/*************************************************************************/



/*************************************************************************/
/*                                                                       */
/* Global variables.                                                     */
/*                                                                       */
/*************************************************************************/

extern unsigned long clockspersec;   /* number of DAC clocks per second */
extern unsigned clockspersam;        /* number of clocks per output sample */
extern unsigned samprate;            /* output sampling rate */
extern unsigned char volume;         /* DAC volume setting */
    /* table of segment addresses of 2k buffers */
extern unsigned partbufs[];


/*************************************************************************/
/*                                                                       */
/* Function prototypes.                                                  */
/*                                                                       */
/*************************************************************************/

    /* DAC detection routine */
int pascal dacdetect( void );
    /* sound hardware initialization routine */
int pascal initdac( void );
    /* sound hardware finalization routine */
void pascal enddac( void );
    /* routine to start DMA */
void pascal dacstart( void );
    /* routine to stop or pause DMA */
void pascal dacstop( void );
    /* routine to resume DMA when paused */
void pascal dacresume( void );
    /* routine to change volume */
void pascal dacsetvol( unsigned char newvol );
    /* routine to change sampling rate */
void pascal dacsetspeed( unsigned newrate );
    /* routine to get the current 2k buffer number */
unsigned pascal dacgetpart( void );
    /* routine to get the last output sample */
unsigned char pascal dacgetlast( void );

#endif
