;------------------------------------------------
; CACHE.ASM:  Command-line support for EXPRESS.SYS
;------------------------------------------------


;This program is to be a .COM file, 8080 model

; Assembly instructions:
;	MASM CACHE;
;	LINK CACHE;
;	EXE2BIN CACHE.EXE CACHE.COM


;Errorlevel returns
elvl_on		equ 0
elvl_off	equ 1
elvl_denied	equ 2
elvl_fail	equ 3
elvl_badline	equ 4


;IOCTL action write counts
turnoff		equ 1				;returns 0 count on success
turnon		equ 2				;returns 0 count on success


; Generic equates
nul		equ 00h
bel		equ 07h
lf		equ 0Ah
cr		equ 0Dh


; DOS equates
dos		equ 21h
dev_ready	equ 0FFh

	c_puts		equ 09h
	f_hanopen	equ 3Dh
	f_hanclose	equ 3Eh
		readonly	equ 0
		writeonly	equ 1
		readwrite	equ 2
	d_ioctl		equ 44h
		ioctl_info	equ 0
		ioctl_write	equ 3
		ioctl_ostat	equ 7
	p_termstat	equ 4Ch


code	segment byte public 'CODE'

assume	cs:code, ds:code, es:nothing, ss:nothing


	org 100h

start:	;segments & stack
	mov ax, cs
	mov ds, ax
	mov es, ax

	cli
	mov ss, ax
	lea sp, stack
	sti

	;if no chars on line
	mov si, 80h
	lodsb
	test al, al
	jnz c1
		jmp quit

c1:	;for all chars in the line
	mov di, si
	mov cl, al
	sub ch, ch

c2:		lodsb
		call toupper
		stosb
	loop c2

	;if the first char is not 'O'
	mov si, 82h
	lodsb
	cmp al, 'O'
	je c3
		jmp quit

c3:	;if the second char is 'N'
	lodsb
	cmp al, 'N'
	jne c4
		;enable turn-on
		mov user_set, TURNON
		jmp short c6

c4:	;elseif the second char is 'F'
	cmp al, 'F'
	jne c5
		;enable turn-off
		mov user_set, TURNOFF
		jmp short c6

c5:	;else
		jmp quit

c6:	;if the device opens
	mov stat, ELVL_FAIL
	mov msg, offset no_gacd
	lea dx, dev_signature
	mov ah, F_HANOPEN
	mov al, READONLY
	int DOS
	jc quit9

		;save handle
		mov bx, ax

		;if we can't get device info
		mov ah, D_IOCTL
		mov al, IOCTL_INFO
		int DOS
			jc quit

		;orif it's not a device
		test dl, 80h
			jz quit

		;orif we can't get output status
		lea dx, io_block
		mov cx, 0
		mov ah, D_IOCTL
		mov al, IOCTL_OSTAT
		int DOS
			jc quit

		;orif the device is not ready
		cmp al, DEV_READY
			jne quit

		;else
			;advance error state
			mov msg, offset no_supp

			;send count as modified by user
			mov cx, user_set
			lea dx, io_block
			mov ah, D_IOCTL
			mov al, IOCTL_WRITE
			int DOS

			;if we sent
			jc quit

				;if the count was modified
				mov msg, offset req_denied
				mov stat, ELVL_DENIED
				cmp ax, user_set
				je quit
					;if user wanted ON
					cmp user_set, TURNON
					jne x1
						;mark it on
						mov stat, ELVL_ON
						mov msg, offset cache_ison
						jmp short quit

x1:					;else
						;mark off
						mov stat, ELVL_OFF
						mov msg, offset cache_isoff
						;jmp short quit

quit:		;close the device -- bx holds the handle
		mov ah, F_HANCLOSE
		int DOS

quit9:	;report message
	mov dx, msg
	mov ah, C_PUTS
	int DOS

	;exit with status
	mov al, stat
	mov ah, P_TERMSTAT
	int DOS


toupper: ;upper-case a character
;	input:	AL = character
;	output:	AL = upper-case character

	;if lower-case
	cmp al, 'a'
	jb tu9
	cmp al, 'z'
	ja tu9
		;upper-case it
		add al, 'A' - 'a'

tu9:	ret


;------------------------------------------------
; Messages and data
;------------------------------------------------

dev_signature	db 'GACDXXX0', 0
io_block	db 4 dup (0)

user_set	dw 0				;set to 1 or 2 for on or off

msg		dw offset bad_line		;updated upon success
stat		db ELVL_BADLINE			;updated upon success

bad_line	db 'Bad command line.  Ignored.', CR, LF, BEL, '$'
no_gacd		db 'Can''t find GACDXXX0.  Aborting.', CR, LF, BEL, '$'
no_supp		db 'The installed GACD does not support batch control.'
		db CR, LF, BEL, '$'
req_denied	db 'Cache control request denied.', CR, LF, BEL, '$'
cache_ison	db 'The cache is now turned ON.', CR, LF, '$'
cache_isoff	db 'The cache is now turned OFF.', CR, LF, '$'

		dw 128 dup (0AAAAh)
stack		dw 0DDDDh

code	ends

end	start
