/* --------------------------------- hudmenu.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* HUD Menus.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "fly.h"
#include "hud.h"

static int	mode = 2;

static void FAR
SetOption (short *i, int mask, int mode)
{
	switch (mode) {
	case 0:
		*i &= ~mask;
		break;
	case 1:
		*i |= mask;
		break;
	case 2:
		*i ^= mask;
		break;
	}
}

/* Select HUD type
*/

static MENU MenuHudType[] = {
	{'0', "Classic"},	/*  0 */
	{'1', "FA18"},		/*  1 */
	{'2', "F16"},		/*  2 */
	{'3', "F15"},		/*  3 */
{'\0', 0}};

extern int FAR
menu_hudtype (void)
{
	int	sel;

	sel = (EE(CV)->hud1&HUD_TYPES)/HUD_TYPE;
	sel = menu_open (MenuHudType, sel);

	switch (sel) {
	case MENU_ABORTED:
	case MENU_FAILED:
		break;
	default:
		EE(CV)->hud1 = (EE(CV)->hud1 & ~HUD_TYPES) | (sel*HUD_TYPE);
		hud_setup (CV);
		break;
	}
	if (MENU_FAILED != sel)
		menu_close ();

	return (0);
}

/* Select HUD parts
*/

static MENU MenuHudParts[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'l', "ladder"},	/*  3 */
	{'a', "altitude"},	/*  4 */
	{'s', "speed"},		/*  5 */
	{'h', "heading"},	/*  6 */
	{'P', "pendulum"},	/*  7 */
	{'b', "border"},	/*  8 */
	{'v', "vv"},		/*  9 */
	{'w', "vw"},		/* 10 */
	{'+', "plus"},		/* 11 */
	{'p', "pointer"},	/* 12 */
{'\0', 0}};

static int FAR
menu_hudparts (void)
{
	int	sel, quit;

	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuHudParts, 0);
		switch (sel) {
		case MENU_ABORTED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			mode = sel;
			break;
		case 3:
			SetOption (&EE(CV)->hud, HUD_LADDER, mode);
			break;
		case 4:
			SetOption (&EE(CV)->hud2, HUD_ALTITUDE, mode);
			break;
		case 5:
			SetOption (&EE(CV)->hud2, HUD_SPEED, mode);
			break;
		case 6:
			SetOption (&EE(CV)->hud2, HUD_HEADING, mode);
			break;
		case 7:
			SetOption (&EE(CV)->hud1, HUD_PENDULUM, mode);
			break;
		case 8:
			SetOption (&EE(CV)->hud1, HUD_BORDER, mode);
			break;
		case 9:
			SetOption (&EE(CV)->hud, HUD_VV, mode);
			break;
		case 10:
			SetOption (&EE(CV)->hud2, HUD_VW, mode);
			break;
		case 11:
			SetOption (&EE(CV)->hud, HUD_PLUS, mode);
			break;
		case 12:
			SetOption (&EE(CV)->hud, HUD_CURSOR, mode);
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

/* Select HUD options.
*/

static MENU MenuHudOptions1[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'3', "heading"},	/*  3 */
	{'k', "knots"},		/*  4 */
	{'T', "top"},		/*  5 */
	{'f', "fine"},		/*  6 */
	{'x', "xfine"},		/*  7 */
	{'b', "big"},		/*  8 */
	{'l', "scale"},		/*  9 */
	{'a', "area"},		/* 10 */
{'\0', 0}};

static int FAR
menu_hudoptions1 (void)
{
	int	sel, quit, ch;
	char	msg[80], prompt[80];

	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuHudOptions1, 0);
		switch (sel) {
		case MENU_ABORTED:
		case MENU_FAILED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			mode = sel;
			break;
		case 3:
			SetOption (&EE(CV)->hud, HUD_FULLHEADING, mode);
			break;
		case 4:
			SetOption (&EE(CV)->hud1, HUD_KNOTS, mode);
			break;
		case 5:
			SetOption (&EE(CV)->hud1, HUD_TOP, mode);
			break;
		case 6:
			SetOption (&EE(CV)->hud, HUD_FINE, mode);
			if (EE(CV)->hud & HUD_FINE)
				EE(CV)->hud &= ~HUD_XFINE;
			break;
		case 7:
			SetOption (&EE(CV)->hud, HUD_XFINE, mode);
			if (EE(CV)->hud & HUD_XFINE)
				EE(CV)->hud &= ~HUD_FINE;
			break;
		case 8:
			SetOption (&EE(CV)->hud, HUD_BIG, mode);
			break;
		case 9:
			for (;;) {
				sprintf (prompt, "scale len(%d)?[10-25]?",
					(int)EE(CV)->tapelen);
				getstr (prompt, msg, sizeof (msg));
				if ('\0' == msg[0])
					break;
				if (1 == sscanf (msg, "%u", &ch) &&
				    ch >= 10 && ch <= 25) {
					EE(CV)->tapelen = (short)ch;
					break;
				}
			}
			break;
		case 10:
			for (;;) {
				sprintf (prompt, "hud area(%dDeg)?[1-45]?",
					(int)EE(CV)->hudarea);
				getstr (prompt, msg, sizeof (msg));
				if ('\0' == msg[0])
					break;
				if (1 == sscanf (msg, "%u", &ch) &&
				    ch >= 1 && ch <= 45) {
					EE(CV)->hudarea = ch;
					break;
				}
			}
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

static MENU MenuHudOptions2[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'A', "a alarm"},	/*  3 */
	{'V', "v alarm"},	/*  4 */
	{'m', "misc"},		/*  5 */
	{'n', "nav"},		/*  6 */
	{'F', "font"},		/*  7 */
	{'S', "fontsize"},	/*  8 */
{'\0', 0}};

static int FAR
menu_hudoptions2 (void)
{
	int	sel, quit, ch;
	char	msg[80], prompt[80];
	HMSG	*m;

	sel = 0;
	for (quit = 0; !quit;) {
		sel = menu_open (MenuHudOptions2, 0);
		switch (sel) {
		case MENU_ABORTED:
		case MENU_FAILED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			mode = sel;
			break;
		case 3:
			SetOption (&EE(CV)->hud1, HUD_AALARM, mode);
			break;
		case 4:
			SetOption (&EE(CV)->hud1, HUD_VALARM, mode);
			break;
		case 5:
			SetOption (&EE(CV)->hud1, HUD_MISC, mode);
			break;
		case 6:
			SetOption (&EE(CV)->hud2, HUD_NAV, mode);
			break;
		case 7:
			for (;;) {
				m = MsgPrintf (0, "StFont(%d)?[0-9]",
					(int)st.StFont);
				ch = mgetch ();
				msg_del (m);
				if (ch >= '0' && ch <= '9') {
					st.StFont = ch - '0';
					break;
				}
			}
			break;
		case 8:
			for (;;) {
				sprintf (prompt, "StFontSize(%d)?[4-64]?",
					(int)st.StFontSize);
				getstr (prompt, msg, sizeof (msg));
				if ('\0' == msg[0])
					break;
				if (1 == sscanf (msg, "%u", &ch) &&
				    ch >= 8/2 && ch <= 8*8) {
					st.StFontSize = ch;
					break;
				}
			}
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

/* Select HUD radar options.
*/

static MENU MenuHudRadar[] = {
	{'0', "off"},		/*  0 */
	{'1', "on"},		/*  1 */
	{'2', "toggle"},	/*  2 */
	{'C', "corner"},	/*  3 */
	{'d', "data"},		/*  4 */
	{'D', "distance"},	/*  5 */
	{'n', "name"},		/*  6 */
	{'a', "accvect"},	/*  7 */
	{'r', "reticle"},	/*  8 */
	{'t', "target"},	/*  9 */
	{'z', "ross"},		/* 10 */
	{'L', "limit"},		/* 11 */
	{'H', "thick"},		/* 12 */
	{'h', "hidetgt"},	/* 13 */
{'\0', 0}};

static int FAR
menu_hudradar (void)
{
	int	sel, quit;

	sel = 0;

	for (quit = 0; !quit;) {
		sel = menu_open (MenuHudRadar, 0);
		switch (sel) {
		case MENU_ABORTED:
		case MENU_FAILED:
		default:
			quit = 1;
			break;
		case 0:
		case 1:
		case 2:
			mode = sel;
			break;
		case 3:
			SetOption (&EE(CV)->hud1, HUD_CORNER, mode);
			break;
		case 4:
			SetOption (&EE(CV)->hud, HUD_DATA, mode);
			break;
		case 5:
			SetOption (&EE(CV)->hud1, HUD_IDIST, mode);
			break;
		case 6:
			SetOption (&EE(CV)->hud1, HUD_INAME, mode);
			break;
		case 7:
			SetOption (&EE(CV)->hud1, HUD_ACCVECT, mode);
			break;
		case 8:
			SetOption (&EE(CV)->hud, HUD_RETICLE, mode);
			break;
		case 9:
			SetOption (&EE(CV)->hud, HUD_TARGET, mode);
			break;
		case 10:
			SetOption (&EE(CV)->hud, HUD_ROSS, mode);
			break;
		case 11:
			SetOption (&EE(CV)->hud1, HUD_LIMIT, mode);
			break;
		case 12:
			SetOption (&EE(CV)->hud1, HUD_THICK, mode);
			break;
		case 13:
			SetOption (&EE(CV)->hud2, HUD_HIDETGT, mode);
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	}

	return (0);
}

/* Select HUD sub-menu
*/

static MENU MenuHud[] = {
	{'y', "type"},		/*  0 */
	{'p', "parts"},		/*  1 */
	{'1', "options 1"},	/*  2 */
	{'2', "options 2"},	/*  3 */
	{'r', "radar"},		/*  4 */
	{'u', "on"},		/*  5 */
	{'i', "ils"},		/*  6 */
{'\0', 0}};

extern int FAR
menu_hud (void)
{
	int	sel;

	if (ET_PLANE != CV->e_type)
		return (0);

	st.flags &= ~SF_LISTS;
	st.flags |= SF_HUD;

	mode = 2;

	sel = menu_open (MenuHud, 0);

	switch (sel) {
	case MENU_ABORTED:
	case MENU_FAILED:
	default:
		break;
	case 0:
		menu_hudtype ();
		break;
	case 1:
		menu_hudparts ();
		break;
	case 2:
		menu_hudoptions1 ();
		break;
	case 3:
		menu_hudoptions2 ();
		break;
	case 4:
		menu_hudradar ();
		break;
	case 5:
		SetOption (&EE(CV)->hud, HUD_ON, mode);
		break;
	case 6:
		menu_ils ();
		break;
	}
	if (MENU_FAILED != sel)
		menu_close ();

	st.flags &= ~SF_HUD;
	return (0);
}
