/* ------------------------- line.c ----------------------------------------- */

/*
 * Draw lines on SVGA. Can be cery fast when usage of low level assembly
 * support is requested. It handles VGA page crossing.
 *
 * It originated from the DJgpp package but completely re-written since, the
 * only surviving clue being the WriteMode specification in the color field.
 *
 * GrMoveTo (x, y)
 * GrDrawTo (x, y, color)
 * GrLine (x0, y0, x1, y1, color)
*/

#include <dos.h>
#include <memory.h>

#include "vgr.h"

#define FAST_PLOT \
		if (_GrWriteMode == 0)		\
			VGA_PAGE[va] = c;	\
		else if (_GrWriteMode & GrXOR)	\
			VGA_PAGE[va] ^= c;	\
		else /* GrOr */			\
			VGA_PAGE[va] |= c;

#define LINE_PLOT \
      if (va >= VGA_PAGE_SIZE) {		\
      	va -= VGA_PAGE_SIZE;			\
      	++Page;					\
      	_GrSetPage (Page, Page);		\
      } else if (va < 0L) {			\
      	va += VGA_PAGE_SIZE;			\
      	--Page;					\
      	_GrSetPage (Page, Page);		\
      }						\
      FAST_PLOT

#ifndef	CLINEDRAW

extern int far _ILoop (uint iva, int dy, int dx, int dvx, int dvy,
	int c);
#define _InnerLoop	_ILoop
extern void far		GrTabInit () {}

#else

static int	divtab[1280];
static int	divtabinit = 1;
      
extern void far
GrTabInit ()
{
	int	i;

	divtabinit = 0;
	divtab[0] = 0L;
	for (i = 1; i < sizeof(divtab)/sizeof(divtab[0]); ++i)
		divtab[i] = (int)(0x00010000L / i);
}

static int far
_InnerLoop (iva, dy, dx, dvx, dvy, c)
uint	iva;
int	dy, dx, dvx, dvy, c;
{
	register long	err;		/* conceptualy */
	register int	count;
	long		va = iva;
	int		Page = _ReadPage;

	/* dx > dy  never =!!!	*/
	/* dx > 0 		*/
	/* dy >= 0		*/

	/* set:			*/
	/* dy = (dy*0x10000)/dx	*/
	/* dx = 0x10000		*/

	count = dx;
/*	dy = (int)((0x00010000L*dy)/dx);*/
	dy = dy * divtab[dx];

	err = 0x00008000L;
	for (; --count >= 0;) {
		va += dvx;
		if ((err += (ulong)(uint)dy) & 0xffff0000L) {
			err &= 0x0000ffffL;
			va += dvy;
		}
		LINE_PLOT
	}
	_ReadPage = Page;
	return (va);
}
#endif

static int far
_InnerLoopOld (iva, dy, dx, dvx, dvy, c)
uint	iva;
int	dy, dx, dvx, dvy, c;
{
	register int	count, err;
	long		va = iva;
	int		Page = _ReadPage;

	err = dx / 2;
	for (count = dx; --count >= 0;) {
		va += dvx;
		err += dy;
		if (err > dx) {
			err -= dx;
			va += dvy;
		}
		LINE_PLOT
	}
	_ReadPage = Page;
	return (va);
}

#if 1
extern int far _SLoop (uint va, int count, int sv, int c);
#define _SimpleLoop	_SLoop
#else
static int far
_SimpleLoop (vi, count, sv, c)
uint		vi;
register int	count;
register int	sv
int		c;
{
	register long		va;
	int		Page = _ReadPage;

	va = vi;
	while (--count >= 0) {
		va += sv;
		LINE_PLOT
	}
	_ReadPage = Page;
	return (va);
}
#endif

static uint	x1 = 0, y1 = 0, va = 0, xydone = 0;

extern void far
GrMoveTo (x, y)
int	x;
int	y;
{
#if 0
	if (x < 0)
		x = 0;
	else if (x >= _GrSizeX)
		x = _GrSizeX-1;

	if (y < 0)
		y = 0;
	else if (y >= _GrSizeY)
		y = _GrSizeY-1;
#endif
	x1 = x;
	y1 = y;
	xydone = 0;
}

extern void far
GrDrawTo (x2, y2, c)
int	x2;
int	y2;
uint	c;
{
	register int	dx, dy, svx, svy;

#ifdef	CLINEDRAW
	if (divtabinit)
		GrTabInit ();
#endif

#if 0
	if (x2 < 0)
		x2 = 0;
	else if (x2 >= _GrSizeX)
		x2 = _GrSizeX-1;

	if (y2 < 0)
		y2 = 0;
	else if (y2 >= _GrSizeY)
		y2 = _GrSizeY-1;
#endif
	if (!xydone) {
		xydone = 1;
		va = (uint)_GrAddr (x1, y1, _GrSizeX);
		FAST_PLOT
	}

	if ((dx = x2 - x1) < 0) {
		dx = -dx;
		svx = -1;
	} else
		svx = 1;

	if ((dy = y2 - y1) < 0) {
		dy = -dy;
		svy = -_GrSizeX;
	} else
		svy = _GrSizeX;

	if (dx == dy) {
		if (dx)
			va = _SimpleLoop (va, dy, svx+svy, c);
	} else if (0 == dx)
		va = _SimpleLoop (va, dy, svy, c);
	else if (0 == dy) {
		uint	vb;

		vb = va + x2 - x1;		/* end point */
		dy = (int)(va^vb);		/* >=0 if same page */
#ifdef	MYMEM
		if (dy>=0) {
			vgaset ((svx>0) ? va+1 : vb, c|_GrWriteMode, dx);
#else
		if (dy>=0 && !_GrWriteMode) {
			memset (VGA_PAGE + (svx>0 ? (va+1) : vb), c, dx);
#endif
			va = vb;
		} else {
			va = _SimpleLoop (va, dx, svx, c);
		}
	} else if (dx > dy)
		va = _InnerLoop (va, dy, dx, svx, svy, c);
	else
		va = _InnerLoop (va, dx, dy, svy, svx,  c);

	x1 = x2;
	y1 = y2;
}

extern void far
GrLine (xa, ya, xb, yb, c)
int	xa;
int	ya;
int	xb;
int	yb;
uint	c;
{
	if (xa != x1 || ya != y1 || !xydone)
		GrMoveTo (xa, ya);

	if ((c&0xff00) != _GrWriteMode)
		GrSetWriteMode (c);

	GrDrawTo (xb, yb, c);
}
