/* ------------------------------- t4k.c ------------------------------------ */

#include <conio.h>

#include "vgr.h"

#define MODE_TEXT2	0x01
#define MODE_TEXT16	0x02
#define MODE_TEXT	0x0f
#define MODE_GRAF2	0x10
#define MODE_GRAF4	0x20
#define MODE_GRAF16	0x30
#define MODE_GRAF256	0x40
#define MODE_GRAF256A	0x50
#define MODE_GRAF	0xf0

static struct GR_modes {
	uint	mode;
	uint	width;
	uint	hight;
	uint	type;
} GR_modes[] = {
/* 00 */	{0x00,   40,   25, MODE_TEXT2},
/* 01 */	{0x01,   40,   25, MODE_TEXT16},
/* 02 */	{0x02,   80,   25, MODE_TEXT2},
/*+03 */	{0x03,   80,   25, MODE_TEXT16},
/* 04 */	{0x07,   80,   25, MODE_TEXT2},
/* 05 */	{0x26,   80,   60, MODE_TEXT2},
/* 06 */	{0x2a,  100,   40, MODE_TEXT2},
/* 07 */	{0x23,  132,   25, MODE_TEXT2},
/* 08 */	{0x24,  132,   28, MODE_TEXT2},
/* 09 */	{0x22,  132,   44, MODE_TEXT2},
/* 10 */	{0x61,  132,   50, MODE_TEXT2},

/* 11 */	{0x04,  320,  200, MODE_GRAF4},
/* 12 */	{0x05,  320,  200, MODE_GRAF4},
/* 13 */	{0x0d,  320,  200, MODE_GRAF16},
/**14 */	{0x13,  320,  200, MODE_GRAF256},
/* 15 */	{0x06,  640,  200, MODE_GRAF2},
/* 16 */	{0x0e,  640,  200, MODE_GRAF16},
/* 17 */	{0x0f,  640,  350, MODE_GRAF4},
/**18 */	{0x2d,  640,  350, MODE_GRAF256},
/* 19 */	{0x78,  640,  400, MODE_GRAF256A},
/* 20 */	{0x11,  640,  480, MODE_GRAF2},
/* 21 */	{0x12,  640,  480, MODE_GRAF16},
/**22 */	{0x2e,  640,  480, MODE_GRAF256},
/* 23 */	{0x29,  800,  600, MODE_GRAF16},
/*+24 */	{0x30,  800,  600, MODE_GRAF256},
/* 25 */	{0x37, 1024,  768, MODE_GRAF16},
/**26 */	{0x38, 1024,  768, MODE_GRAF256},
/* 27 */	{0x3D, 1280, 1024, MODE_GRAF16}		/* maybe */

#ifdef PCjr
/*    */	{0x08,  160,  200, MODE_GRAF16},	/* PCjr */
/*    */	{0x09,  320,  200, MODE_GRAF16},	/* PCjr */
/*    */	{0x0a,  640,  200, MODE_GRAF4},		/* PCjr */
#endif
};

enum GR_graphics_modes _GrCurMode = 0;

static int	tdef_w = 80;
static int	tdef_h = 25;
static int	gdef_w = 800;
static int	gdef_h = 600;

static int far
FindMode (int w, int h, int type)
{
	int	i, m;

	for (m = -1, i = sizeof (GR_modes)/sizeof (GR_modes[0]); --i >= 0;)
		if (GR_modes[i].type  == type &&
		    GR_modes[i].width >= w &&
		    GR_modes[i].hight >= h)
			m = i;
	if (m < 0)
		m = (type & MODE_TEXT ? 3 : 24);

	return (m);
}

extern int far
GrSetBiosMode (n)
int			n;
{
	REGISTERS	regs;

	regs.ax = n;
	return (int10 (&regs));
}

extern int far
GrSetMode (mode, w, h)
enum GR_graphics_modes	mode;
int			w;
int			h;
{
	int		i, flags;

	switch (mode) {
	case GR_80_25_text:
		i = FindMode (80, 25, MODE_TEXT16);
		break;
	case GR_default_text:
		i = FindMode (tdef_w, tdef_h, MODE_TEXT16);
		break;
	case GR_width_height_text:
		i = FindMode (w, h, MODE_TEXT16);
		break;
	case GR_biggest_text:
		i = FindMode (132, 44, MODE_TEXT16);
		break;
	case GR_320_200_graphics:
		i = FindMode (320, 200, MODE_GRAF256);
		break;
	case GR_default_graphics:
		i = FindMode (gdef_w, gdef_h, MODE_GRAF256);
		break;
	case GR_width_height_graphics:
		i = FindMode (w, h, MODE_GRAF256);
		break;
	case GR_biggest_noninterlaced_graphics:
		i = FindMode (800, 600, MODE_GRAF256);
		break;
	case GR_biggest_graphics:
		i = FindMode (1024, 768, MODE_GRAF256);
		break;
	}

	flags = GrSetBiosMode (GR_modes[i].mode);
	GrSetXY (GR_modes[i].width, GR_modes[i].hight);
	_GrSetPage (0, 0);
	_GrCurMode = mode;
	return (flags);
}

uint	_ReadPage = 0L;
uint	_WritePage = 0L;

extern void far _fastcall
_GrSetPage (pread, pwrite)
int	pread;
int	pwrite;
{
	outp (0x3cd, ((pread & 0x0f) << 4) | (pwrite & 0x0f));
	_ReadPage = pread;
	_WritePage = pwrite;
}

extern uint far _fastcall
_GrGetPage ()
{
	return (_ReadPage);
}

extern uchar far * far _fastcall
_GrAddr (x, y, width)
uint	x;
uint	y;
uint	width;
{
	ulong	xy;
	uint	page;

	page = (uint)((xy = x + ActiveBase + y*(long)width) >> 16);
	if (page > 0x0f)
		return VGA_PAGE;
	if (page != _ReadPage)
		_GrSetPage (page, page);

	return (VGA_PAGE + (uint)xy);
}

extern uchar far * far _fastcall
_GrNewPage (xy)
ulong	xy;
{
	uint	page;

	page = (uint)(xy >> 16);
	if (page != _ReadPage)
		_GrSetPage (page, page);

	return (VGA_PAGE + (uint)xy);
}

static short far
Disable (void)
{
	short	flags;

	_asm {
		pushf
		pop	flags
		cli
	}
	return (flags);
}

static void far
Enable (short flags)
{
	_asm {
		push	flags
		popf
	}
}

extern void far _fastcall
_GrSetColor (color, r, g, b)
int	color;
int	r;
int	g;
int	b;
{
	short	flags;

	flags = Disable ();
	outp (0x3c8, color);	(void)inp (0x080);
	outp (0x3c9, r >> 2);	(void)inp (0x080);
	outp (0x3c9, g >> 2);	(void)inp (0x080);
	outp (0x3c9, b >> 2);
	Enable (flags);
}

extern void far
GrSetVisual (long base)
{
	int	i;
	short	flags;

	flags = Disable ();
	outp (0x3d4, 0x0d);	/* start baseess low */
	outp (0x3d5, (int)((base>>2)&0x00ff));

	outp (0x3d4, 0x0c);	/* start baseess high */
	outp (0x3d5, (int)((base>>10)&0x00ff));

	outp (0x3d4, 0x33);	/* start baseess very high */
	i = inp (0x3d5);
	outp (0x3d5, (i&~3)|(int)((base>>18)&3));
	Enable (flags);
}

extern void far
GrVsync (void)
{
	while (inp (0x3da) & 0x08)	/* wait for end Vsync */
		;
	while (!(inp (0x3da) & 0x08))	/* wait for start Vsync */
		;
}


