{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V+,X-}
{$M 16384,0,655360}
(*  ......................................................................  *)
(*  :            :							 :  *)
(*  :	program  :  MYNES!       (V1.10)                                 :  *)
(*  :            :							 :  *)
(*  :   includes :  MYNESDEF, MYNESINI, MYNESPLF, MYNESGAM, MYNESTTL	 :  *)
(*  :   units    :  DRAWSTR, GADGET, MOUSE, TILES, TIMER, TIMING,        :  *)
(*  :		 :  XPALETTE					         :  *)
(*  :            :							 :  *)
(*  :	author 	 :  Marc Palms, Am Forst 12, D-54597 Rommersheim, Germany:  *)
(*  :	release  :  30-AUG-92		last update:  07-JUL-93		 :  *)
(*  :	compiler :  TurboPascal 6.0					 :  *)
(*  :............:.......................................................:  *)

{$UNDEF debug}

PROGRAM		MYNES;

USES    (*  standard units  *)	CRT,	(*  Delay(), Sound(), NoSound  *)
				GRAPH,
                                DOS,	(*  GetDate() for HallOfFame  *)
                                	(*  FSplit for HOF_PathName   *)
	(*  new units  *)       DRAWSTR,
				GADGET,
				MOUSE,
                                TILES,
			        TIMER,
                                TIMING,
				XPALETTE;

{$I MYNESDEF.PAS }		(* defines *)
{$I MYNESINI.PAS }		(* palette and initialization *)
{$I MYNESPLF.PAS }		(* playfield, color_bar and explode  *)
{$I MYNESGAM.PAS }		(* the game itself *)
{$I MYNESTTL.PAS }		(* the intro, title, game_end, halloffame *)


VAR	scene	: SCENE_TYPE;    (*  local for main *)

BEGIN	(*  main program  *)
        initialize;

        intro;
        show_title(Level, Speed);

        WHILE  (GameStatus <> QUIT)  DO
        BEGIN
                scene := Scene_ARRAY[Level];
                scene.TimeLimit := scene.TimeLimit * SPEED_FACTOR[Speed];

		generate_playfield(scene);
		draw_playfield(scene);

                play_game(scene);

		HideMouse;

                IF  (GameStatus <> QUIT)  THEN
			game_end(Level);

                show_title(Level, Speed);
        END;  (*  WHILE  *)

        (* now write the Hall Of Fame and leave the rest to MynesExitProc *)
        WriteHOFfile;

END.	(*  PROGRAM MYNES  *)

