(*  .....................................................................  *)
(*  :	file    	:  MYNESINI.PAS                                 :  *)
(*  :  	contents	:  initialization, palette and HOF for MYNES!	:  *)
(*  :	last update	:  30-JUN-93                                    :  *)
(*  :...................:...............................................:  *)
(*
	- ESC_pressed	...   used in MYNESGAM and MYNESTTL
	- dim_palette
        - initialize
        - ReadHOF, WriteHOF  ... HallOfFame disk operations
        - print_error
*)


FUNCTION  ESC_pressed : BOOLEAN; (* TRUE if ESC-key has been pressed *)
BEGIN
  ESC_pressed := KeyPressed AND (ReadKey = #27);
END;

(*  dim_palette changes brightness to new_bright (0..100 %)  *)
PROCEDURE	dim_palette(new_bright : WORD; speed : BOOLEAN);

PROCEDURE	set_rgbpal(bright : WORD);
CONST	RGBPAL : ARRAY[0..15, 1..3] OF BYTE =
	( (*  BLACK		DKGREY		GREY  *)
	  ($00, $00, $00), ($14, $14, $14), ($28, $28, $28),
          (*  DKBLUE		BLUE		LTBLUE  *)
	  ($00, $00, $3f), ($1a, $1a, $3f), ($2a, $2a, $3f),
          (*  visible1 .. visible8  *)
	  ($3f, $3f, $00), ($3f, $3a, $04), ($3f, $33, $08), ($3f, $2c, $0c),
	  ($3f, $24, $10), ($3f, $17, $14), ($3f, $0a, $18), ($3f, $00, $20),
          (*  visible_mine   	WHITE  *)
	  ($30, $10, $25), ($3f, $3f, $3f) );

VAR	colnr, i : 0..15;
        rgbtemp  : ARRAY[0..15, 1..3] OF BYTE;
BEGIN
	FOR  colnr := 0  TO  15  DO
           FOR i := 1 TO 3 DO
              rgbtemp[colnr, i] := (RGBPAL[colnr,i] * bright DIV 100) AND 63;

   	XSetPalette(0, 16, rgbtemp);
END;	(*  set_rgbpal  *)

CONST   act_bright : WORD = 0;
VAR	step	   : SHORTINT;
	diff	   : SHORTINT;

BEGIN	(*  dim_palette  *)

        IF  (speed = SLOW_DIM)  THEN
	BEGIN
        	StartMeasure;
                diff := ABS(INTEGER(act_bright)-new_bright);

		IF (act_bright > new_bright)  THEN  step := -DIM_STEP
					      ELSE  step :=  DIM_STEP;
	        WHILE  ABS(DIM_STEP) < ABS(INTEGER(act_bright)-new_bright)  DO
		BEGIN
			INC(act_bright, step);
        	        set_rgbpal(act_bright);
                	MyDelay(DIM_DELAY);
	        END;  (* WHILE *)

                IF  diff = 100  THEN
		   GetStepDelay(OPT_DIM_TIME,
		                diff,
			        DIM_STEP,
			        DIM_DELAY);
        END;  (* IF (speed) *)

        act_bright := new_bright;
	set_rgbpal(new_bright);
END;	(*  dim_palette  *)


(* enhanced GADGET routines *)

(* initializes gadgets as not_pushed, not_active, in_screen with
   grey background and white text *)
PROCEDURE	init_gadget(VAR   gad  		: GADGET_TYPE;
			    x, y, width, height : WORD;
			    text 		: STRING;
                            split_at		: BYTE;
			    keep		: BOOLEAN);
BEGIN
	gad.init(x, y, width, height,
        	 GREY, DKGREY, WHITE,	(* in, upleft, lowright *)
                 GAD_NOT_PUSHED,
                 TRUE,			(*  mouse checking on *)
                 keep,
		 text, split_at, WHITE); (* text, split_position, textcol *)
END;	(*  init_gadget  *)


PROCEDURE	init_all_gadgets;
VAR	g : BYTE;
BEGIN
	(*  gad, x, y, width, height, text *)
  	init_gadget(GAME_QUIT_GADGET, 570, 426, 50, 12, 'QUIT', 0, GAD_NO_KEEP);
  	init_gadget(GAME_PAUSE_GADGET,570, 443, 50, 12, 'PAUSE', 0, GAD_NO_KEEP);
  	init_gadget(GAME_DEMO_GADGET, 570, 460, 50, 12, 'DEMO', 0, GAD_NO_KEEP);

        (*  the distance between two gadgets is 20 pix  *)
  	init_gadget(TITLE_QUIT_GADGET,  10, TITLE_GAD_Y, 64, 20, 'QUIT', 0, GAD_NO_KEEP);
  	init_gadget(TITLE_START_GADGET, 94, TITLE_GAD_Y, 72, 20, 'START', 0, GAD_NO_KEEP);
  	init_gadget(TITLE_DEMO_GADGET, 186, TITLE_GAD_Y, 64, 20, 'DEMO', 0, GAD_NO_KEEP);
        (* the SOUND ON/SOUND OFF text is split behind the 9th character .............v *)
  	init_gadget(TITLE_MUSIC_GADGET,270, TITLE_GAD_Y, 100, 20, 'SOUND OFFSOUND ON', 9, GAD_KEEP);
        TITLE_MUSIC_GADGET.set_state(SoundIsOn);	(* set actual mode *)
  	init_gadget(TITLE_LOOK_GADGET, 390, TITLE_GAD_Y, 88, 20, 'MP-LOOKPL-LOOK', 7, GAD_KEEP);
        TITLE_LOOK_GADGET.set_state(LookIsPL);
  	init_gadget(TITLE_HOF_GADGET,  498, TITLE_GAD_Y, 130, 20, 'HALL OF FAME', 0, GAD_NO_KEEP);

        (* set the radio-gadgets and activate the first of each type *)
        FOR  g := FIRSTLEVEL  TO  LASTLEVEL  DO
	        LEVEL_GAD[g].init(90 + g * 60, LEVEL_GAD_Y, 40, 40,
        	         NO_FILL, BLACK, WHITE,	(* in, upleft, lowright *)
                         (g = Level),     	(* set actual setting *)
                         TRUE,			(* mouse checking on *)
                         GAD_KEEP,
		         '', 0, WHITE);		(*  text, split, textcol  *)

        FOR  g := 1  TO  5  DO
        	init_gadget(SPEED_GAD[g], 38 + g * 98, SPEED_GAD_Y, 90, 20, SPEEDSTR[g], 0, GAD_KEEP);

        (*  set the actual Speed that has just been read from HOF-file  *)
        SPEED_GAD[Speed].set_state(GAD_PUSHED);

END;	(*  init_all_gadgets  *)


(*  the new exit procedure, releases memory and graphics  *)
{$F+}
PROCEDURE	MynesExitProc;
BEGIN
        (*  release resources ... *)
        FreeMem(TileImage[PUSHED_TILE], MaxTileSize);
        FreeMem(TileImage[NOT_PUSHED_TILE], MaxTileSize);

        CloseGraph;	(* close graphics *)
        RestoreCrtMode; (* restore old video mode *)

	WRITELN('Ŀ');
	WRITELN('  Thank you for playing  ');
	WRITELN('   Marc Palms'' MYNES!    ');
	WRITELN('ͼ'#13);

        (*  call the old exit procedure  *)
        ExitProc := OldExitProc;
END;	(*  MynesExitProc  *)
{$F-}


PROCEDURE	ReadHOFfile;	(* reads the Hall Of Fame *)
VAR	HOFfile	: FILE OF DISK_FILE_TYPE;
	filerec : DISK_FILE_TYPE;
        entry   : BYTE;
        Dir	: DirStr;
	Name	: NameStr;
  	Ext	: ExtStr;
BEGIN
	(* initialize HallOfFame, Sound/Look and Level/Speed defaults *)
        FOR  entry := 1  TO  HOF_SIZE  DO
                HallOfFame[entry] := HOF_DEFAULT;
        Level := FIRSTLEVEL;
        Speed := FIRSTSPEED;
        SoundIsON := FALSE;
        LookIsPL  := FALSE;

        (* generate complete HOF-Path *)
	FSplit(ParamStr(0), Dir, Name, Ext);
        HOF_PathName := Dir + HOF_FILENAME;

        (* read HALLofFAME *)
        Assign(HOFfile, HOF_PathName);
        {$I-}
        Reset(HOFfile);

        {$IFDEF debug}
	{$I+  switch on IO checking again }
	{$ENDIF}
        IF  (IOResult = 0)  AND
	    (FileSize(HOFfile) = 1)  THEN
        BEGIN
        	HOFexists := TRUE;
	        (* now, read the file *)
        	Read(HOFfile, filerec);
        	Close(HOFfile);
        	HallOfFame:= filerec.HOF;
	        Level     := filerec.Level;
                IF  (Level > LASTLEVEL)  OR
                    (Level < FIRSTLEVEL)  THEN  Level := FIRSTLEVEL;

	        Speed 	  := filerec.Speed;
                IF  (Speed > LASTSPEED)  OR
		    (Speed < FIRSTSPEED)  THEN  Speed := FIRSTSPEED;

	        LookIsPL  := filerec.LookIsPL;
	        SoundIsOn := filerec.SoundIsOn;
        END
        ELSE    HOFexists := FALSE;

END;	(*  ReadHOFfile  *)


PROCEDURE	WriteHOFfile;	(* writes the Hall Of Fame *)
VAR	HOFfile	: FILE OF DISK_FILE_TYPE;
	filerec : DISK_FILE_TYPE;
BEGIN
   (* Save Hall Of Fame only if it EXISTED or if a there is a new HIGH *)
   IF  HOFexists  THEN
   BEGIN
        Assign(HOFfile, HOF_PathName);
        {$I-}
        Rewrite(HOFfile);
        {$IFDEF debug}
	{$I+  switch on IO checking again }
	{$ENDIF}

        IF  (IOResult = 0)  THEN
        BEGIN
	        filerec.LookIsPL  := LookIsPL;
	        filerec.SoundIsOn := SoundIsOn;
	        filerec.Level     := Level;
	        filerec.Speed 	  := Speed;
        	filerec.HOF	  := HallOfFame;
	        (* now, write the file *)
                Write(HOFfile, filerec);
	        Close(HOFfile);
        END;  (* IF IOResult *)
   END; (* IF HOFexists *)
END;	(*  WriteHOFfile  *)


(* print an error message and HALT program *)
PROCEDURE	print_error(missing : STRING);
BEGIN
      	WRITELN(#13'Sorry, but  MYNES !  needs ',missing,' ... EXITING.'#13);
        HALT(1);
END;	(*  print_error  *)


(* the VGA driver is built-in *)
PROCEDURE	VGADriver;  EXTERNAL;	{$L EGAVGA.OBJ}


(* initialize graphics, mouse, memory, HallOfFame ... *)
PROCEDURE	initialize;

VAR	GrDevice, GrMode: INTEGER;
	color, dummy,
	entry		: BYTE;
	HOFfile		: FILE;
        h, m, s, hs	: WORD;
        time1, time2,
        time_dif,
	normal_time	: LONGINT;
BEGIN
	IF  NOT(HasMouse)  THEN  print_error('a MOUSE');

        (* I don't even know whether this error can ever happen ... *)
	IF  (RegisterBGIdriver(@VGADriver) < 0)  THEN  print_error('HELP');

	GrDevice := VGA;  GrMode := VGAHi;
	InitGraph(GrDevice, GrMode, '');

	IF  (GraphResult <> grOk)  THEN  print_error('VGA');

        MIDDLE_X := GetMaxX DIV 2;	(* for x-centered text *)

        MaxTileSize := ImageSize(1, 1, Scene_ARRAY[FIRSTLEVEL].Size.x,
	  			       Scene_ARRAY[FIRSTLEVEL].Size.y);

        IF  (MaxAvail < 2 * MaxTileSize)  THEN
	BEGIN
		CloseGraph;
		print_error('more MEMORY');
        END;  (* IF *)

	GetMem(TileImage[PUSHED_TILE], MaxTileSize);
	GetMem(TileImage[NOT_PUSHED_TILE], MaxTileSize);

        (*  now it's time to install the new exit procedure, if something goes
	    wrong in future everything will be cleared up afterwards  *)
        OldExitProc := ExitProc;
	ExitProc := @MynesExitProc;

	ReadHOFfile;  (* read HallOfFame BEFORE initializing the gagdets,
			 to be able to initialize the actual settings for
			 Level/Speed and Sound/Look *)
        init_all_gadgets;
        Randomize;
        (*  set the new palette  *)
        FOR  color := 0  TO  MaxColors  DO
        	SetPalette(color, color);  	(*  normalize palette  *)
        dim_palette(0, FAST_DIM);		(*  and set it fast  *)

    (* -- adjust VGA-dimming-speed for this machine *)
END;	(*  initialize  *)
