/*
    CGAEX: CGA video exerciser
    Copyright (C) 2003  John Elliott

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>

int getmode()
{
	union REGS rg;
	
	rg.x.ax = 0x0F00;
	int86(0x10, &rg, &rg);
	
	return rg.h.al;
}



void cls()
{
	union REGS rg;
	
	rg.x.ax = 0x7;
	int86(0x10, &rg, &rg);
}


void drawch(int r, int c, unsigned char ch, int a)
{
	unsigned char far *framebuf = MK_FP(0xB000, 0);

	framebuf[r*160+c*2]   = ch;
	framebuf[r*160+c*2+1] = a;
}

void drawstr(int r, int c, unsigned char *s, int a)
{
	while (*s)
	{
		drawch(r, c, *s, a);
		++s;
		++c;
		if (c >= 80) { c = 0; ++r; }
	}
}


int main(void)
{
	int r,c;
	char buf[3];

	if (getmode() != 7)
	{
		fprintf(stderr, "Not in MDA mono mode. Aborting.\n");
		return 1;
	}
	cls();
	for (r = 0; r < 25; r++) 
		for (c = 0; c < 80; c++)
		{
			drawch(r, c, 177, 7);
		}
	for (r = 0; r < 8; r++)
		for (c = 0; c < 32; c++)
		{
			drawch(r+1, c*2+8, r*32+c, 15);
		}

	for (r = 0; r < 8; r++)
		for (c = 0; c < 32; c++)
		{
			sprintf(buf, "%02x", r*32+c);
			drawstr(r+10, c*2+8, buf, r*32+c);
		}


	getch();
	cls();
	for (r = 0; r < 25; r++) 
		for (c = 0; c < 80; c++)
		{
			drawch(r, c, 177, 7);
		}
        for (r = 0; r < 8; r++)
                for (c = 0; c < 32; c++)
                {
                        drawch(r*3,   c*2+8, r*32+c, 0x07);
                        drawch(r*3+1, c*2+8, r*32+c, 0x70);
                        drawch(r*3+2, c*2+8, r*32+c, 0x78);
                }
	getch();
	cls();
	return 0;	
}
