//***************************************************************************
//
// Copyright (c) 1991-93 Sierra Semiconductor Corp.
//
// FILE:    pitches.h
//
// LANGUAGES:
//          Microsoft C Versions 5.0, 6.0, and 7.0
//          Borland Turbo C Versions 1.5 and 2.0
//
// DESCRIPTION:
//
//          Note frequency tables for Aria Synthesizer
//
// Aria, Aria Synthesizer and Aria Listener are trademarks of Sierra
//  Semiconductor Corp.
//
//***************************************************************************

// This array is used to look up the pitch value to be sent to the audio
// system.
//
//    array index        =   0  -> 127 -> 254
//    shift in semitones = -127 ->  0  -> 127
//
// The difference between the wave table's base MIDI note and the MIDI note
// to be played determines which value to use:
//
//    dwPitch = dwPitchTable[(MIDInote + 127) - base];
//
// The pitch value (dwPitch) is a 32-bit value that must be reduced to a 
// 16-bit value (wPitch) before sending to the audio system:
//
//    wPitch = (unsigned) (dwPitch >> 8);
//
//
// NOTE:  A correction factor must be applied to all looping wave tables 
//        to account for the fact that a sample table (when played at 
//        22 KHz) will not correspond exactly to a musical pitch frequency.
//
//        wPitch += dwCorrFactor[(MIDInote + 127) - base];

// $Header:   F:\projects\ariai\dos\archives\pitches.h_v   1.2   24 Jun 1993 14:04:24   golds  $
// $Log:   F:\projects\ariai\dos\archives\pitches.h_v  $
// 
//    Rev 1.2   24 Jun 1993 14:04:24   golds
// Initial revision.

static LONG dwPitchTable [255] = 
              {  
               0x0000002A,  // -127
               0x0000002D,  // -126
               0x0000002F,  // -125
               0x00000032,  // -124
               0x00000035,  // -123
               0x00000039,  // -122
               0x0000003C,  // -121
               0x00000040,  // -120

               0x00000043,  // -119
               0x00000047,  // -118
               0x0000004C,  // -117
               0x00000050,  // -116
               0x00000055,  // -115
               0x0000005A,  // -114
               0x0000005F,  // -113
               0x00000065,  // -112
               0x0000006B,  // -111
               0x00000072,  // -110
               0x00000078,  // -109
               0x00000080,  // -108

               0x00000087,  // -107
               0x0000008F,  // -106
               0x00000098,  // -105
               0x000000A1,  // -104
               0x000000AA,  // -103
               0x000000B5,  // -102
               0x000000BF,  // -101
               0x000000CB,  // -100
               0x000000D7,  // -99
               0x000000E4,  // -98
               0x000000F1,  // -97
               0x00000100,  // -96

               0x0000010F,  // -95
               0x0000011F,  // -94
               0x00000130,  // -93
               0x00000142,  // -92
               0x00000155,  // -91
               0x0000016A,  // -90
               0x0000017F,  // -89
               0x00000196,  // -88
               0x000001AE,  // -87
               0x000001C8,  // -86
               0x000001E3,  // -85
               0x00000200,  // -84

               0x0000021E,  // -83
               0x0000023E,  // -82
               0x00000260,  // -81
               0x00000285,  // -80
               0x000002AB,  // -79
               0x000002D4,  // -78
               0x000002FF,  // -77
               0x0000032C,  // -76
               0x0000035D,  // -75
               0x00000390,  // -74
               0x000003C6,  // -73
               0x00000400,  // -72

               0x0000043C,  // -71
               0x0000047D,  // -70
               0x000004C1,  // -69
               0x0000050A,  // -68
               0x00000556,  // -67
               0x000005A8,  // -66
               0x000005FE,  // -65
               0x00000659,  // -64
               0x000006BA,  // -63
               0x00000720,  // -62
               0x0000078D,  // -61
               0x00000800,  // -60

               0x00000879,  // -59
               0x000008FA,  // -58
               0x00000983,  // -57
               0x00000A14,  // -56
               0x00000AAD,  // -55
               0x00000B50,  // -54
               0x00000BFC,  // -53
               0x00000CB2,  // -52
               0x00000D74,  // -51
               0x00000E41,  // -50
               0x00000F1A,  // -49
               0x00001000,  // -48

               0x000010F3,  // -47
               0x000011F5,  // -46
               0x00001306,  // -45
               0x00001428,  // -44
               0x0000155B,  // -43
               0x000016A0,  // -42
               0x000017F9,  // -41
               0x00001965,  // -40
               0x00001AE9,  // -39
               0x00001C83,  // -38
               0x00001E34,  // -37
               0x00002000,  // -36

               0x000021E6,  // -35
               0x000023EA,  // -34
               0x0000260D,  // -33
               0x00002851,  // -32
               0x00002AB6,  // -31
               0x00002D41,  // -30
               0x00002FF2,  // -29
               0x000032CB,  // -28
               0x000035D2,  // -27
               0x00003906,  // -26
               0x00003C68,  // -25
               0x00004000,  // -24

               0x000043CD,  // -23
               0x000047D5,  // -22
               0x00004C1B,  // -21
               0x000050A3,  // -20
               0x0000556D,  // -19
               0x00005A82,  // -18
               0x00005FE5,  // -17
               0x00006597,  // -16
               0x00006BA5,  // -15
               0x0000720C,  // -14
               0x000078D1,  // -13
               0x00008000,  // -12

               0x0000879A,  // -11
               0x00008FAA,  // -10
               0x00009837,  // -9
               0x0000A147,  // -8
               0x0000AADA,  // -7
               0x0000B504,  // -6
               0x0000BFCB,  // -5
               0x0000CB2F,  // -4
               0x0000D74B,  // -3
               0x0000E418,  // -2
               0x0000F1A3,  // -1

               0x00010000,  //  0  BASE FREQ. NOTE

               0x00010F34,  //  1
               0x00011F55,  //  2
               0x0001306F,  //  3
               0x0001428F,  //  4
               0x000155B5,  //  5
               0x00016A09,  //  6
               0x00017F97,  //  7
               0x0001965F,  //  8
               0x0001AE97,  //  9
               0x0001C831,  //  10
               0x0001E346,  //  11

               0x00020000,  //  12
               0x00021E69,  //  13
               0x00023EAB,  //  14
               0x000260DE,  //  15
               0x0002851E,  //  16
               0x0002AB6A,  //  17
               0x0002D412,  //  18
               0x0002FF2E,  //  19
               0x00032CBF,  //  20
               0x00035D2F,  //  21
               0x00039062,  //  22
               0x0003C68D,  //  23

               0x00040000,  //  24
               0x00043CD3,  //  25
               0x00047D56,  //  26
               0x0004C1BD,  //  27
               0x00050A3D,  //  28
               0x000556D5,  //  29
               0x0005A824,  //  30
               0x0005FE5C,  //  31
               0x0006597F,  //  32
               0x0006BA5E,  //  33
               0x000720C4,  //  34
               0x00078D1B,  //  35

               0x00080000,  //  36
               0x000879A6,  //  37
               0x0008FAAC,  //  38
               0x0009837B,  //  39
               0x000A147A,  //  40
               0x000AADAB,  //  41
               0x000B5048,  //  42
               0x000BFCB9,  //  43
               0x000CB2FE,  //  44
               0x000D74BC,  //  45
               0x000E4189,  //  46
               0x000F1A36,  //  47

               0x00100000,  //  48
               0x0010F34D,  //  49
               0x0011F559,  //  50
               0x001306F6,  //  51
               0x001428F5,  //  52
               0x00155B57,  //  53
               0x0016A090,  //  54
               0x0017F972,  //  55
               0x001965FD,  //  56
               0x001AE978,  //  57
               0x001C8312,  //  58
               0x001E346D,  //  59

               0x00200000,  //  60
               0x0021E69A,  //  61
               0x0023EAB3,  //  62
               0x00260DED,  //  63
               0x002851EB,  //  64
               0x002AB6AE,  //  65
               0x002D4120,  //  66
               0x002FF2E4,  //  67
               0x0032CBFB,  //  68
               0x0035D2F1,  //  69
               0x00390624,  //  70
               0x003C68DB,  //  71

               0x00400000,  //  72
               0x0043CD35,  //  73
               0x0047D566,  //  74
               0x004C1BDA,  //  75
               0x0050A3D7,  //  76
               0x00556D5C,  //  77
               0x005A8240,  //  78
               0x005FE5C9,  //  79
               0x006597F6,  //  80
               0x006BA5E3,  //  81
               0x00720C49,  //  82
               0x0078D1B7,  //  83

               0x00800000,  //  84
               0x00879A6B,  //  85
               0x008FAACD,  //  86
               0x009837B4,  //  87
               0x00A147AE,  //  88
               0x00AADAB9,  //  89
               0x00B50481,  //  90
               0x00BFCB92,  //  91
               0x00CB2FEC,  //  92
               0x00D74BC6,  //  93
               0x00E41893,  //  94
               0x00F1A36E,  //  95

               0x01000000,  //  96
               0x010F34D6,  //  97
               0x011F559B,  //  98
               0x01306F69,  //  99
               0x01428F5C,  //  100
               0x0155B573,  //  101
               0x016A0902,  //  102
               0x017F9724,  //  103
               0x01965FD8,  //  104
               0x01AE978D,  //  105
               0x01C83126,  //  106
               0x01E346DC,  //  107

               0x02000000,  //  108
               0x021E69AD,  //  109
               0x023EAB36,  //  110
               0x0260DED2,  //  111
               0x02851EB8,  //  112
               0x02AB6AE7,  //  113
               0x02D41205,  //  114
               0x02FF2E48,  //  115
               0x032CBFB1,  //  116
               0x035D2F1A,  //  117
               0x0390624D,  //  118
               0x03C68DB8,  //  119

               0x04000000,  //  120
               0x043CD35A,  //  121
               0x047D566C,  //  122
               0x04C1BDA5,  //  123
               0x050A3D70,  //  124
               0x0556D5CF,  //  125
               0x05A8240B,  //  126
               0x05FE5C91,  //  127
              };

static LONG dwCorrFactor[255] =
              {
               0x00000000,  //  -127
               0x00000000,  //  -126
               0x00000000,  //  -125
               0x00000000,  //  -124
               0x00000000,  //  -123
               0x00000000,  //  -122
               0x00000000,  //  -121
               0x00000000,  //  -120

               0x00000000,  //  -119
               0x00000000,  //  -118
               0x00000001,  //  -117
               0x00000001,  //  -116
               0x00000001,  //  -115
               0x00000001,  //  -114
               0x00000001,  //  -113
               0x00000001,  //  -112
               0x00000001,  //  -111
               0x00000001,  //  -110
               0x00000001,  //  -109
               0x00000001,  //  -108

               0x00000001,  //  -107
               0x00000001,  //  -106
               0x00000002,  //  -105
               0x00000002,  //  -104
               0x00000002,  //  -103
               0x00000002,  //  -102
               0x00000002,  //  -101
               0x00000002,  //  -100
               0x00000002,  //  -99
               0x00000003,  //  -98
               0x00000003,  //  -97
               0x00000003,  //  -96

               0x00000003,  //  -95
               0x00000003,  //  -94
               0x00000004,  //  -93
               0x00000004,  //  -92
               0x00000004,  //  -91
               0x00000004,  //  -90
               0x00000005,  //  -89
               0x00000005,  //  -88
               0x00000005,  //  -87
               0x00000006,  //  -86
               0x00000006,  //  -85
               0x00000006,  //  -84

               0x00000007,  //  -83
               0x00000007,  //  -82
               0x00000008,  //  -81
               0x00000008,  //  -80
               0x00000009,  //  -79
               0x00000009,  //  -78
               0x0000000A,  //  -77
               0x0000000B,  //  -76
               0x0000000B,  //  -75
               0x0000000C,  //  -74
               0x0000000D,  //  -73
               0x0000000D,  //  -72
               0x0000000E,  //  -71

               0x0000000F,  //  -70
               0x00000010,  //  -69
               0x00000011,  //  -68
               0x00000012,  //  -67
               0x00000013,  //  -66
               0x00000014,  //  -65
               0x00000016,  //  -64
               0x00000017,  //  -63
               0x00000018,  //  -62
               0x0000001A,  //  -61
               0x0000001B,  //  -60

               0x0000001D,  //  -59
               0x0000001F,  //  -58
               0x00000021,  //  -57
               0x00000022,  //  -56
               0x00000025,  //  -55
               0x00000027,  //  -54
               0x00000029,  //  -53
               0x0000002C,  //  -52
               0x0000002E,  //  -51
               0x00000031,  //  -50
               0x00000034,  //  -49
               0x00000037,  //  -48

               0x0000003B,  //  -47
               0x0000003E,  //  -46
               0x00000042,  //  -45
               0x00000045,  //  -44
               0x0000004A,  //  -43
               0x0000004E,  //  -42
               0x00000053,  //  -41
               0x00000058,  //  -40
               0x0000005D,  //  -39
               0x00000062,  //  -38
               0x00000069,  //  -37
               0x0000006F,  //  -36

               0x00000076,  //  -35
               0x0000007D,  //  -34
               0x00000084,  //  -33
               0x0000008B,  //  -32
               0x00000095,  //  -31
               0x0000009D,  //  -30
               0x000000A6,  //  -29
               0x000000B1,  //  -28
               0x000000BA,  //  -27
               0x000000C5,  //  -26
               0x000000D2,  //  -25
               0x000000DF,  //  -24

               0x000000EC,  //  -23
               0x000000FB,  //  -22
               0x00000109,  //  -21
               0x00000117,  //  -20
               0x0000012A,  //  -19
               0x0000013B,  //  -18
               0x0000014D,  //  -17
               0x00000162,  //  -16
               0x00000174,  //  -15
               0x0000018A,  //  -14
               0x000001A4,  //  -13
               0x000001BF,  //  -12

               0x000001D9,  //  -11
               0x000001F7,  //  -10
               0x00000213,  //  -9
               0x0000022F,  //  -8
               0x00000255,  //  -7
               0x00000277,  //  -6
               0x0000029A,  //  -5
               0x000002C4,  //  -4
               0x000002E8,  //  -3
               0x00000315,  //  -2
               0x00000349,  //  -1

               0x0000037E,  //  0

               0x000003B2,  //  1
               0x000003EE,  //  2
               0x00000426,  //  3
               0x0000045F,  //  4
               0x000004AB,  //  5
               0x000004EF,  //  6
               0x00000534,  //  7
               0x00000589,  //  8
               0x000005D0,  //  9
               0x0000062B,  //  10
               0x00000692,  //  11

               0x000006FC,  //  12
               0x00000765,  //  13
               0x000007DD,  //  14
               0x0000084C,  //  15
               0x000008BF,  //  16
               0x00000956,  //  17
               0x000009DF,  //  18
               0x00000A68,  //  19
               0x00000B13,  //  20
               0x00000BA1,  //  21
               0x00000C56,  //  22
               0x00000D25,  //  23

               0x00000DF8,  //  24
               0x00000ECA,  //  25
               0x00000FBA,  //  26
               0x00001099,  //  27
               0x0000117F,  //  28
               0x000012AD,  //  29
               0x000013BF,  //  30
               0x000014D1,  //  31
               0x00001626,  //  32
               0x00001742,  //  33
               0x000018AD,  //  34
               0x00001A4B,  //  35

               0x00001BF0,  //  36
               0x00001D94,  //  37
               0x00001F74,  //  38
               0x00002133,  //  39
               0x000022FF,  //  40
               0x0000255A,  //  41
               0x0000277E,  //  42
               0x000029A2,  //  43
               0x00002C4C,  //  44
               0x00002E85,  //  45
               0x0000315A,  //  46
               0x00003497,  //  47

               0x000037E0,  //  48
               0x00003B29,  //  49
               0x00003EE8,  //  50
               0x00004266,  //  51
               0x000045FE,  //  52
               0x00004AB4,  //  53
               0x00004EFC,  //  54
               0x00005344,  //  55
               0x00005899,  //  56
               0x00005D0B,  //  57
               0x000062B4,  //  58
               0x0000692F,  //  59

               0x00006FC1,  //  60
               0x00007652,  //  61
               0x00007DD0,  //  62
               0x000084CC,  //  63
               0x00008BFD,  //  64
               0x00009569,  //  65
               0x00009DF8,  //  66
               0x0000A688,  //  67
               0x0000B133,  //  68
               0x0000BA16,  //  69
               0x0000C569,  //  70
               0x0000D25F,  //  71

               0x0000DF82,  //  72
               0x0000ECA5,  //  73
               0x0000FBA0,  //  74
               0x00010998,  //  75
               0x000117FB,  //  76
               0x00012AD3,  //  77
               0x00013BF1,  //  78
               0x00014D10,  //  79
               0x00016267,  //  80
               0x0001742D,  //  81
               0x00018AD3,  //  82
               0x0001A4BE,  //  83

               0x0001BF04,  //  84
               0x0001D94A,  //  85
               0x0001F740,  //  86
               0x00021330,  //  87
               0x00022FF6,  //  88
               0x000255A6,  //  89
               0x000277E2,  //  90
               0x00029A20,  //  91
               0x0002C4CE,  //  92
               0x0002E85A,  //  93
               0x000315A6,  //  94
               0x0003497C,  //  95

               0x00037E08,  //  96
               0x0003B294,  //  97
               0x0003EE80,  //  98
               0x00042660,  //  99
               0x00045FEC,  //  100
               0x0004AB4C,  //  101
               0x0004EFC4,  //  102
               0x00053440,  //  103
               0x0005899C,  //  104
               0x0005D0B4,  //  105
               0x00062B4C,  //  106
               0x000692F8,  //  107

               0x0006FC10,  //  108
               0x00076528,  //  109
               0x0007DD00,  //  110
               0x00084CC0,  //  111
               0x0008BFD8,  //  112
               0x00095698,  //  113
               0x0009DF88,  //  114
               0x000A6880,  //  115
               0x000B1338,  //  116
               0x000BA168,  //  117
               0x000C5698,  //  118
               0x000D25F0,  //  119

               0x000DF820,  //  120
               0x000ECA50,  //  121
               0x000FBA00,  //  122
               0x00109980,  //  123
               0x00117FB0,  //  124
               0x0012AD30,  //  125
               0x0013BF10,  //  126
               0x0014D100,  //  127
              };

