/* WAVE.C v0.01 */

#include <stdio.h>
#include <io.h>
#include <unistd.h>
#include <std.h>
#include <stdlib.h>
#include "wave.h"

#define memeql(s1,s2,n) (!memcmp(s1,s2,n))

unsigned short *get_wav_data(unsigned *format, char *Name)
{
    int handle;
    char buffer[25];
    short shortbuf;
    unsigned short *data = NULL;
    int i;
    int *length=0;
    unsigned long *rate=0;
    div_t temp;
    unsigned local_format=0;

    if((handle = open(Name,O_RDONLY|O_BINARY)) == -1)
    return(NULL);
    /* is it a file in "RIFF WAVE fmt" format ? */
    /*      there's 4 bytes of rLen in between, not used here */
    read(handle,buffer,16);
    if(!(memeql(buffer,"RIFF",4) && memeql(&(buffer[8]),"WAVEfmt ",8))) {
    goto EndFunc;
    }
    read(handle,&i,4);                   /* start of data from here */
    read(handle,&shortbuf,2);
    if(shortbuf != 1) {                  /* ID for PCM-files        */
    goto EndFunc;
    }
    read(handle,&shortbuf,2);
    if(shortbuf != 1 && shortbuf != 2) { /* Neither mono nor stereo */
    goto EndFunc;
    }
    local_format=shortbuf;
    read(handle,rate,4);
    read(handle,&shortbuf,2);            /* Skip 6 bytes */
    read(handle,&shortbuf,2);
    read(handle,&shortbuf,2);
    read(handle,&shortbuf,2);            /* Read number of bits per sample */

    local_format+=(((shortbuf/8)-1)*2)-1;
    temp=div(*rate,22050);
    local_format+=(16*temp.quot);

    read(handle,buffer,4);
    if(!memeql(buffer,"data",4)) {       /* must be data block */
    goto EndFunc;
    }
    read(handle,length,4);               /* actual data length */
    aria_samplesize=(unsigned int) *length;
    data = (unsigned short *) malloc(aria_samplesize);
    if(data)
      read(handle,data,aria_samplesize);
    *format=local_format;
EndFunc:
     close(handle);
     return(data);
}
