// TrackEdView.cpp : implementation of the CTrackEdView class
//

#include "stdafx.h"
#include <math.h>

#include "TrackEd.h"

#include "Track.h"
#include "TrackEdView.h"
#include "BestLineSeg.h"
#include "TrackHeader.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Standardfarben definieren
#define COLOR_BACKGRND		RGB( 0, 0, 0 )
#define COLOR_TRACK			RGB( 196, 196, 196 )
#define COLOR_TRACK_SEL		RGB( 255, 255, 255 )
#define COLOR_PIT			RGB( 0, 0, 196 )
#define COLOR_PIT_SEL		RGB( 128, 128, 255 )
#define COLOR_BEST_LINE		RGB( 196, 0, 0 )
#define COLOR_BEST_LINE_SEL	RGB( 255, 0, 0 )
#define COLOR_BEST_LINE_PRE RGB( 128, 255, 128 )
// Dunkelgrau fr Track Length Unit Segmentlinien
#define COLOR_SEGS			RGB( 128, 128, 128 )
// niedrige Kerbs grn
#define COLOR_KERB_2		RGB( 0, 255, 0 )
// hohe Kerbs gelb
#define COLOR_KERB_14		RGB( 255, 255, 0 )
// "Bridged" Wall: helles Cyan
#define COLOR_BRIDGE_11		RGB( 0, 255, 255 )
// Normale Wand dunkleres Cyan
#define COLOR_WALL_3		RGB( 0, 196, 196 )

/* Ersatz fr Borland Konstante fr die Zahl Pi */
#define M_PI (acos(-1))

/////////////////////////////////////////////////////////////////////////////
// CTrackEdView

IMPLEMENT_DYNCREATE(CTrackEdView, CView)

BEGIN_MESSAGE_MAP(CTrackEdView, CView)
	//{{AFX_MSG_MAP(CTrackEdView)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_WM_SYSCHAR()
	ON_COMMAND(ID_PREFERENCES_NEW_CCLINE, OnPreferencesNewCcline)
	ON_UPDATE_COMMAND_UI(ID_PREFERENCES_NEW_CCLINE, OnUpdatePreferencesNewCcline)
	ON_COMMAND(ID_PREFERENCES_OLD_CCLINE, OnPreferencesOldCcline)
	ON_UPDATE_COMMAND_UI(ID_PREFERENCES_OLD_CCLINE, OnUpdatePreferencesOldCcline)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTrackEdView construction/destruction

CTrackEdView::CTrackEdView()
{
	// Werte initialisieren, die bei der Grafikausgabe bentigt werden
	m_scale = 1.0;
	m_iMaxTx = 0;
	m_iMaxTy = 0;
	m_iDx = 0;
	m_iDy = 0;
	// Wenn m_bDrawPoints != 0 ist, werden Kreismittelpunkte und Radien fr
	// Ideallinie-Segmente gezeichnet.
	m_bDrawPoints = false;

	// Wenn m_bDrawSegs != 0 ist, werden TLUs von Piste und Box einzeln
	// durch graue Striche unterteilt.
	m_bDrawSegs = false;
}

CTrackEdView::~CTrackEdView()
{
}

BOOL CTrackEdView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CTrackEdView drawing

void CTrackEdView::OnDraw(CDC* pDC)
{
	CTrack* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	if ( pDC == NULL ) return;

	CString strAux;
	CRect rectDraw, rectClient;
	GetClientRect( rectClient );
	rectDraw = rectClient;
	// Mit Clipping-Rechteck schneiden.
	pDC->IntersectClipRect( rectDraw );

	// Steckenskizze
	DrawGraph( pDC );
}

/////////////////////////////////////////////////////////////////////////////
// CTrackEdView printing

BOOL CTrackEdView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CTrackEdView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

void CTrackEdView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

/////////////////////////////////////////////////////////////////////////////
// CTrackEdView diagnostics

#ifdef _DEBUG
void CTrackEdView::AssertValid() const
{
	CView::AssertValid();
}

void CTrackEdView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CTrack* CTrackEdView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTrack)));
	return (CTrack*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTrackEdView message handlers

void CTrackEdView::DrawGraph(CDC *pDC)
{
	CTrackSeg *ftr;
	CBestLineSeg *fbl;

	CRect rectClient, rectClip;
	GetClientRect( rectClient );
	m_iMaxTx = rectClient.right;
	m_iMaxTy = rectClient.bottom;
	rectClip = rectClient;
	pDC->IntersectClipRect( rectClip );

	// Hintergrund pinseln
	CBrush * pBrush = new CBrush( COLOR_BACKGRND );
	pDC->FillRect( rectClip, pBrush );
	delete pBrush;

	/*draw track segments*/
	ftr=GetDocument()->GetTrackSegs();
	CPen * pOldPen;
	CPen * pPen = new CPen( PS_SOLID, 1, COLOR_TRACK );
	pOldPen = pDC->SelectObject( pPen );
	while(ftr)
	{
		DrawTrackSegment(pDC, rectClip, ftr, false); // Param 4: no pit lane
		ftr=ftr->m_pNext;
	}
	pDC->SelectObject( pOldPen );
	delete pPen;
	pPen = NULL;
	// Das aktuelle Segment hervorheben
	if ( GetDocument()->GetCurrentTrackSeg() != NULL )
	{
		pPen = new CPen( PS_SOLID, 1, COLOR_TRACK_SEL );
		pDC->SelectObject( pPen );
		DrawTrackSegment( pDC, rectClip, GetDocument()->GetCurrentTrackSeg(), false );
		pDC->SelectObject( pOldPen );
		delete pPen;
		pPen = NULL;
	}

	/* draw pit lane segments */
	pPen = new CPen( PS_SOLID, 1, COLOR_PIT );
	pOldPen = pDC->SelectObject( pPen );
	ftr=GetDocument()->GetPitSegs();
	while(ftr)
	{
		DrawTrackSegment(pDC, rectClip, ftr, true); // Param4: pit lane
		ftr=ftr->m_pNext;
	}
	pDC->SelectObject( pOldPen );
	delete pPen;
	pPen = NULL;
	// Das aktuelle Segment hervorheben
	ftr = GetDocument()->GetCurrentPitSeg();
	if ( ftr != NULL )
	{
		pPen = new CPen( PS_SOLID, 1, COLOR_PIT_SEL );
		pDC->SelectObject( pPen );
		DrawTrackSegment( pDC, rectClip, ftr, false );
		pDC->SelectObject( pOldPen );
		delete pPen;
		pPen = NULL;
	}

	/*draw best line segments*/
	/*ksbb trlend!!!!!!!!!*/
	/**************/
	pPen = new CPen( PS_SOLID, 1, COLOR_BEST_LINE );
	pOldPen = pDC->SelectObject( pPen );
	fbl=GetDocument()->GetBestLineSegs();
	while(fbl)
	{
		DrawCCLineSegment(pDC, rectClip, fbl);
		fbl=fbl->m_pNext;
	}
	pDC->SelectObject( pOldPen );
	delete pPen;
	pPen = NULL;
	// Aktuelles Segment hervorheben
	fbl = GetDocument()->GetCurrentBestLineSeg();
	if ( fbl != NULL )
	{
		pPen = new CPen( PS_SOLID, 1, COLOR_BEST_LINE_SEL );
		pOldPen = pDC->SelectObject( pPen );
		DrawCCLineSegment( pDC, rectClip, fbl );
		pDC->SelectObject( pOldPen );
		delete pPen;
		pPen = NULL;
	}
}

void CTrackEdView::DrawTrackSegment(CDC *pDC, const CRect &rectClip, CTrackSeg *pTr, bool bPit)
{
	int pbkx,pbky,pbvx,pbvy, pjkx,pjky,pjvx,pjvy, pox,poy;
	int kbkx,kbky,kbvx,kbvy,kjkx,kjky,kjvx,kjvy;
	int wbkx,wbky,wbvx,wbvy,wjkx,wjky,wjvx,wjvy;
	double str,endr, ksr,kvr, wkr,wvr;
	double dfi, x,y,deltax,deltay, s[2];
	int i;
	unsigned short int lkerb,rkerb, lwall,rwall, lbridge,rbridge;
	double kbw,kjw,vbw,vjw;
	CPen * pPen, * pOldPen;
	
	if(pTr==NULL) {return;}
	if(pTr->sign==4) {return;}

	lkerb=pTr->flags&0x800; // 2048
	rkerb=pTr->flags&0x400; // 1024
	if( bPit )
	{
		lwall=pTr->flags&3; rwall=lwall; // Boxenbereich mit beidseitiger Mauer
		lbridge=pTr->flags&0x20; // 32
		rbridge=pTr->flags&0x10; // 16
	}
	else
	{
		// Normaler Steckenabschnitt
		lbridge=pTr->flags&0x20; // 32
		lwall=!( (pTr->flags&0x2000) // 8192
				 && (!lbridge) );
		rbridge=pTr->flags&0x10; // 16
		rwall=!( (pTr->flags&0x1000) // 4096
				 && (!rbridge) );
	}
	if(pTr->m_pPrev)
	{
		// Segment hat Vorgnger
		kbw=(1.0+pTr->m_pPrev->lbank/32.0);
		kjw=(1.0+pTr->m_pPrev->rbank/32.0);
	}
	else
	{
		// Kein Vorgnger: Trackheader ist Referenz
		kbw=(1.0+ GetDocument()->m_TrackHeader.lbank/32.0);
		kjw=(1.0+ GetDocument()->m_TrackHeader.rbank/32.0);
	}
	vbw=(1.0+pTr->lbank/32.0);
	vjw=(1.0+pTr->rbank/32.0);
	// Pixelkoordinaten ausrechnen
	if(pTr->middle)
	{
		// Rechnen mit der mittleren Koordinate mx/my
		pbvx = f2i((pTr->mx - (pTr->vs[0]) * cos(pTr->fiv)) * m_scale) + m_iDx;
		pbvy = m_iMaxTy - f2i((pTr->my - (pTr->vs[0]) * sin(pTr->fiv)) * m_scale) - m_iDy;
		pjvx = f2i((pTr->mx + (pTr->vs[1]) * cos(pTr->fiv)) * m_scale) + m_iDx;
		pjvy = m_iMaxTy - f2i((pTr->my + (pTr->vs[1]) * sin(pTr->fiv)) * m_scale) - m_iDy;
		kbvx = f2i((pTr->mx - 1.25 * pTr->vs[0] * cos(pTr->fiv)) * m_scale) + m_iDx;
		kbvy = m_iMaxTy - f2i((pTr->my - 1.25 * pTr->vs[0] * sin(pTr->fiv)) * m_scale) - m_iDy;
		kjvx = f2i((pTr->mx + 1.25 * pTr->vs[1] * cos(pTr->fiv)) * m_scale) + m_iDx;
		kjvy = m_iMaxTy - f2i((pTr->my + 1.25 * pTr->vs[1] * sin(pTr->fiv)) * m_scale) - m_iDy;
		wbvx = f2i((pTr->mx - vbw * pTr->vs[0] * cos(pTr->fiv)) * m_scale) + m_iDx;
		wbvy = m_iMaxTy - f2i((pTr->my - vbw * pTr->vs[0] * sin(pTr->fiv)) * m_scale) - m_iDy;
		wjvx = f2i((pTr->mx + vjw * pTr->vs[1] * cos(pTr->fiv)) * m_scale) + m_iDx;
		wjvy = m_iMaxTy - f2i((pTr->my + vjw * pTr->vs[1] * sin(pTr->fiv)) * m_scale) - m_iDy;
	}
	else
	{
		// Rechnen mit Anfangskoordinate vx/vy
		pbvx = f2i((pTr->vx - (pTr->vs[0]) * cos(pTr->fiv)) * m_scale) + m_iDx;
	    pbvy = m_iMaxTy - f2i((pTr->vy - (pTr->vs[0]) * sin(pTr->fiv)) * m_scale) - m_iDy;
		pjvx = f2i((pTr->vx + (pTr->vs[1]) * cos(pTr->fiv)) * m_scale) + m_iDx;
		pjvy = m_iMaxTy - f2i((pTr->vy + (pTr->vs[1]) * sin(pTr->fiv)) * m_scale) - m_iDy;
		kbvx = f2i((pTr->vx - 1.25 * pTr->vs[0] * cos(pTr->fiv)) * m_scale) + m_iDx;
		kbvy = m_iMaxTy - f2i((pTr->vy - 1.25 * pTr->vs[0] * sin(pTr->fiv)) * m_scale) - m_iDy;
		kjvx = f2i((pTr->vx + 1.25 * pTr->vs[1] * cos(pTr->fiv)) * m_scale) + m_iDx;
		kjvy = m_iMaxTy - f2i((pTr->vy + 1.25 * pTr->vs[1] * sin(pTr->fiv)) * m_scale) - m_iDy;
		wbvx = f2i((pTr->vx - vbw * pTr->vs[0] * cos(pTr->fiv)) * m_scale) + m_iDx;
		wbvy = m_iMaxTy - f2i((pTr->vy - vbw * pTr->vs[0] * sin(pTr->fiv)) * m_scale) - m_iDy;
		wjvx = f2i((pTr->vx + vjw * pTr->vs[1] * cos(pTr->fiv)) * m_scale) + m_iDx;
		wjvy = m_iMaxTy - f2i((pTr->vy + vjw * pTr->vs[1] * sin(pTr->fiv)) * m_scale) - m_iDy;
	}
	if(pTr->sign)
	{/*curve*/
		if(m_bDrawSegs)
		{
			// Trennungslinien fr einzelne Track length units zeichnen
			// Farbe setzen, alte dabei merken
			pPen = new CPen( PS_SOLID, 1, COLOR_SEGS );
			pOldPen = pDC->SelectObject( pPen );
			//setcolor(8);
			dfi=(pTr->fiv-pTr->fik) / ((float)pTr->tlu);
			for(i=1;i<pTr->tlu;i++)
			{
				if(pTr->middle)
				{
					if(pTr->sign*(pTr->fik+dfi*(float)i)<pTr->sign*pTr->fim)
					{
						s[0]=pTr->ks[0]+((pTr->vs[0]-pTr->ks[0])*dfi*(float)i)/(pTr->fim-pTr->fik);
						s[1]=pTr->ks[1]+((pTr->vs[1]-pTr->ks[1])*dfi*(float)i)/(pTr->fim-pTr->fik);
					}
					else
					{
						s[0]=pTr->vs[0];
						s[1]=pTr->vs[1];
					}
				}
				else
				{
					s[0]=pTr->ks[0]+((pTr->vs[0]-pTr->ks[0])*dfi*(float)i)/(pTr->fiv-pTr->fik);
					s[1]=pTr->ks[1]+((pTr->vs[1]-pTr->ks[1])*dfi*(float)i)/(pTr->fiv-pTr->fik);
				}
				x=pTr->ox+pTr->sign*pTr->r*cos(pTr->fik+dfi*((float)i));
				pbkx=f2i((x-s[0]*cos(pTr->fik+dfi*(float)i))*m_scale)+m_iDx;
				pjkx=f2i((x+s[1]*cos(pTr->fik+dfi*(float)i))*m_scale)+m_iDx;
				y=pTr->oy+pTr->sign*pTr->r*sin(pTr->fik+dfi*((float)i));
				pbky=m_iMaxTy-f2i((y-s[0]*sin(pTr->fik+dfi*(float)i))*m_scale)-m_iDy;
				pjky=m_iMaxTy-f2i((y+s[1]*sin(pTr->fik+dfi*(float)i))*m_scale)-m_iDy;
				pDC->MoveTo( pbkx, pbky );
				pDC->LineTo( pjkx, pjky );
			}
			pDC->SelectObject( pOldPen );
			delete pPen;
		} // drawsegs
		// convert coordinates
		pbkx=f2i((pTr->kx-(float)(pTr->ks[0])*cos(pTr->fik))*m_scale)+m_iDx;
		pbky=m_iMaxTy-f2i((pTr->ky-(float)(pTr->ks[0])*sin(pTr->fik))*m_scale)-m_iDy;
		pjkx=f2i((pTr->kx+(float)(pTr->ks[1])*cos(pTr->fik))*m_scale)+m_iDx;
		pjky=m_iMaxTy-f2i((pTr->ky+(float)(pTr->ks[1])*sin(pTr->fik))*m_scale)-m_iDy;
		kbkx=f2i((pTr->kx-1.25*(pTr->ks[0])*cos(pTr->fik))*m_scale)+m_iDx;
		kbky=m_iMaxTy-f2i((pTr->ky-1.25*(pTr->ks[0])*sin(pTr->fik))*m_scale)-m_iDy;
		kjkx=f2i((pTr->kx+1.25*(pTr->ks[1])*cos(pTr->fik))*m_scale)+m_iDx;
		kjky=m_iMaxTy-f2i((pTr->ky+1.25*(pTr->ks[1])*sin(pTr->fik))*m_scale)-m_iDy;
		wbkx=f2i((pTr->kx-kbw*(pTr->ks[0])*cos(pTr->fik))*m_scale)+m_iDx;
		wbky=m_iMaxTy-f2i((pTr->ky-kbw*(pTr->ks[0])*sin(pTr->fik))*m_scale)-m_iDy;
		wjkx=f2i((pTr->kx+kjw*(pTr->ks[1])*cos(pTr->fik))*m_scale)+m_iDx;
		wjky=m_iMaxTy-f2i((pTr->ky+kjw*(pTr->ks[1])*sin(pTr->fik))*m_scale)-m_iDy;
		pox=f2i(pTr->ox*m_scale)+m_iDx;
		poy=m_iMaxTy-f2i(pTr->oy*m_scale)-m_iDy;
		// check visibility
		if( ( (pbkx>=0)&&(pbkx<=m_iMaxTx)&&(pbky>=0)&&(pbky<=m_iMaxTy) )
			||( (pbvx>=0)&&(pbvx<=m_iMaxTx)&&(pbvy>=0)&&(pbvy<=m_iMaxTy) )
			||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
			||( (pbkx<m_iMaxTx)&&(pbvx>m_iMaxTx) )||( (pbvx<m_iMaxTx)&&(pbkx>m_iMaxTx) )
			||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
			||( (pbky<m_iMaxTy)&&(pbvy>m_iMaxTy) )||( (pbvy<m_iMaxTy)&&(pbky>m_iMaxTy) )
			)
		{
			// calculate radius at start (str) and end (endr) of segment
			str=(m_scale*(pTr->r-(pTr->sign)*(pTr->ks[0])));
			endr=(m_scale*(pTr->r-(pTr->sign)*(pTr->vs[0])));
			// calculate radius for kerbs
			ksr=(m_scale*(pTr->r-1.25*(pTr->sign)*(pTr->ks[0])));
			if(ksr<0.001){ksr=0.001;}
			kvr=(m_scale*(pTr->r-1.25*(pTr->sign)*(pTr->vs[0])));
			if(kvr<0.001){kvr=0.001;}
			// calculate radius for walls
			wkr=(m_scale*(pTr->r-kbw*(pTr->sign)*(pTr->ks[0])));
			if(wkr<0.001){wkr=0.001;}
			wvr=(m_scale*(pTr->r-vbw*(pTr->sign)*(pTr->vs[0])));
			if(wvr<0.001){wvr=0.001;}
			// select ending angle for arc drawing
			if(pTr->middle){dfi=pTr->fim;}
			else{dfi=pTr->fiv;}

			if(pTr->sign==1)
			{
				DrawArc( pDC, pox,poy,pTr->fik,dfi,str,endr);
				if(lkerb)
				{
					COLORREF colKerb;
					if(pTr->flags&4)
					{
						colKerb = COLOR_KERB_2;
					}
					else
					{
						colKerb = COLOR_KERB_14;
					}
					pPen = new CPen( PS_SOLID, 1, colKerb );
					pOldPen = pDC->SelectObject( pPen );
					DrawArc( pDC, pox,poy,pTr->fik,dfi,ksr,kvr);
					DrawLine( pDC, kbkx,kbky,pbkx,pbky);
					if(pTr->middle==0)
					{
						DrawLine( pDC, kbvx,kbvy,pbvx,pbvy);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
				if(lwall)
				{
					if(lbridge)
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
						pOldPen = pDC->SelectObject( pPen );
						DrawLine( pDC, wbkx,wbky,wbvx,wbvy);
					}
					else
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
						pOldPen = pDC->SelectObject( pPen );
						DrawArc( pDC, pox,poy,pTr->fik,dfi,wkr,wvr);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
			}
			if(pTr->sign==-1)
			{
				DrawArc( pDC, pox,poy,dfi+M_PI,pTr->fik+M_PI,endr,str);
				if(lkerb)
				{
					COLORREF colKerb;
					if(pTr->flags&4)
					{
						colKerb = COLOR_KERB_2;
					}
					else
					{
						colKerb = COLOR_KERB_14;
					}
					pPen = new CPen( PS_SOLID, 1, colKerb );
					pOldPen = pDC->SelectObject( pPen );
					DrawArc( pDC, pox,poy,dfi+M_PI,pTr->fik+M_PI,kvr,ksr);
					DrawLine( pDC, kbkx,kbky,pbkx,pbky);
					if(pTr->middle==0)
					{
						DrawLine( pDC, kbvx,kbvy,pbvx,pbvy);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
				if(lwall)
				{
					if(lbridge)
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
						pOldPen = pDC->SelectObject( pPen );
						DrawLine( pDC, wbkx,wbky,wbvx,wbvy);
					}
					else
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
						pOldPen = pDC->SelectObject( pPen );
						DrawArc( pDC, pox,poy,dfi+M_PI,pTr->fik+M_PI,wvr,wkr);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
			}
			DrawLine( pDC, pbkx,pbky,pjkx,pjky);
			if(pTr->middle==0)
			{
				DrawLine( pDC, pbvx,pbvy,pjvx,pjvy);
			}
		}
		// calculate visibility
		if( ( (pjkx>=0)&&(pjkx<=m_iMaxTx)&&(pjky>=0)&&(pjky<=m_iMaxTy) )
			||( (pjvx>=0)&&(pjvx<=m_iMaxTx)&&(pjvy>=0)&&(pjvy<=m_iMaxTy) )
			||( (pjkx<0)&&(pjvx>0) )||( (pjvx<0)&&(pjkx>0) )
			||( (pjkx<m_iMaxTx)&&(pjvx>m_iMaxTx) )||( (pjvx<m_iMaxTx)&&(pjkx>m_iMaxTx) )
			||( (pjky<0)&&(pjvy>0) )||( (pjvy<0)&&(pjky>0) )
			||( (pjky<m_iMaxTy)&&(pjvy>m_iMaxTy) )||( (pjvy<m_iMaxTy)&&(pjky>m_iMaxTy) )
			)
		{
			str=(m_scale*(pTr->r+(pTr->sign)*(pTr->ks[1])));
			endr=(m_scale*(pTr->r+(pTr->sign)*(pTr->vs[1])));
			ksr=(m_scale*(pTr->r+1.25*(pTr->sign)*(pTr->ks[1])));
			if(ksr<0.001){ksr=0.001;}
			kvr=(m_scale*(pTr->r+1.25*(pTr->sign)*(pTr->vs[1])));
			if(kvr<0.001){kvr=0.001;}
			wkr=(m_scale*(pTr->r+kjw*(pTr->sign)*(pTr->ks[1])));
			if(wkr<0.001){wkr=0.001;}
			wvr=(m_scale*(pTr->r+vjw*(pTr->sign)*(pTr->vs[1])));
			if(wvr<0.001){wvr=0.001;}
			if(pTr->middle){dfi=pTr->fim;}
			else{dfi=pTr->fiv;}
			if(pTr->sign==1)
			{
				DrawArc( pDC, pox,poy,pTr->fik,dfi,str,endr);
				if(rkerb)
				{
					COLORREF colKerb;
					if(pTr->flags&4)
					{
						colKerb = COLOR_KERB_2;
					}
					else
					{
						colKerb = COLOR_KERB_14;
					}
					pPen = new CPen( PS_SOLID, 1, colKerb );
					pOldPen = pDC->SelectObject( pPen );
					DrawArc( pDC, pox,poy,pTr->fik,dfi,ksr,kvr);
					DrawLine( pDC, kjkx,kjky,pjkx,pjky);
					if(pTr->middle==0)
					{
						DrawLine( pDC, kjvx,kjvy,pjvx,pjvy);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
				if(rwall)
				{
					if(rbridge)
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
						pOldPen = pDC->SelectObject( pPen );
						DrawLine( pDC, wjkx,wjky,wjvx,wjvy);
					}
					else
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
						pOldPen = pDC->SelectObject( pPen );
						DrawArc( pDC, pox,poy,pTr->fik,dfi,wkr,wvr);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
			}
			if(pTr->sign==-1)
			{
				DrawArc( pDC, pox,poy,dfi+M_PI,pTr->fik+M_PI,endr,str);
				if(rkerb)
				{
					COLORREF colKerb;
					if(pTr->flags&4)
					{
						colKerb = COLOR_KERB_2;
					}
					else
					{
						colKerb = COLOR_KERB_14;
					}
					pPen = new CPen( PS_SOLID, 1, colKerb );
					pOldPen = pDC->SelectObject( pPen );
					DrawArc( pDC, pox,poy,dfi+M_PI,pTr->fik+M_PI,kvr,ksr);
					DrawLine( pDC, kjkx,kjky,pjkx,pjky);
					if(pTr->middle==0)
					{
						DrawLine( pDC, kjvx,kjvy,pjvx,pjvy);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
				if(rwall)
				{
					if(rbridge)
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
						pOldPen = pDC->SelectObject( pPen );
						DrawLine( pDC, wjkx,wjky,wjvx,wjvy);
					}
					else
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
						pOldPen = pDC->SelectObject( pPen );
						DrawArc( pDC, pox,poy,dfi+M_PI,pTr->fik+M_PI,wvr,wkr);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
			}
			DrawLine( pDC, pbkx,pbky,pjkx,pjky);
			if(pTr->middle==0)
			{
				DrawLine( pDC, pbvx,pbvy,pjvx,pjvy);
			}
		}
		if(pTr->middle)
		{
			pbkx=pbvx; pbky=pbvy; pjkx=pjvx; pjky=pjvy;
			pbvx=f2i((pTr->vx-/*(float)*/(pTr->vs[0])*cos(pTr->fiv))*m_scale)+m_iDx;
			pbvy=m_iMaxTy-f2i((pTr->vy-/*(float)*/(pTr->vs[0])*sin(pTr->fiv))*m_scale)-m_iDy;
			pjvx=f2i((pTr->vx+/*(float)*/(pTr->vs[1])*cos(pTr->fiv))*m_scale)+m_iDx;
			pjvy=m_iMaxTy-f2i((pTr->vy+/*(float)*/(pTr->vs[1])*sin(pTr->fiv))*m_scale)-m_iDy;
			kbkx=kbvx; kbky=kbvy; kjkx=kjvx; kjky=kjvy;
			kbvx=f2i((pTr->vx-1.25*pTr->vs[0]*cos(pTr->fiv))*m_scale)+m_iDx;
			kbvy=m_iMaxTy-f2i((pTr->vy-1.25*pTr->vs[0]*sin(pTr->fiv))*m_scale)-m_iDy;
			kjvx=f2i((pTr->vx+1.25*pTr->vs[1]*cos(pTr->fiv))*m_scale)+m_iDx;
			kjvy=m_iMaxTy-f2i((pTr->vy+1.25*pTr->vs[1]*sin(pTr->fiv))*m_scale)-m_iDy;
			wbkx=wbvx; wbky=wbvy; wjkx=wjvx; wjky=wjvy;
			wbvx=f2i((pTr->vx-vbw*pTr->vs[0]*cos(pTr->fiv))*m_scale)+m_iDx;
			wbvy=m_iMaxTy-f2i((pTr->vy-vbw*pTr->vs[0]*sin(pTr->fiv))*m_scale)-m_iDy;
			wjvx=f2i((pTr->vx+vjw*pTr->vs[1]*cos(pTr->fiv))*m_scale)+m_iDx;
			wjvy=m_iMaxTy-f2i((pTr->vy+vjw*pTr->vs[1]*sin(pTr->fiv))*m_scale)-m_iDy;
			if( ( (pbkx>=0)&&(pbkx<=m_iMaxTx)&&(pbky>=0)&&(pbky<=m_iMaxTy) )
				||( (pbvx>=0)&&(pbvx<=m_iMaxTx)&&(pbvy>=0)&&(pbvy<=m_iMaxTy) )
				||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
				||( (pbkx<m_iMaxTx)&&(pbvx>m_iMaxTx) )||( (pbvx<m_iMaxTx)&&(pbkx>m_iMaxTx) )
				||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
				||( (pbky<m_iMaxTy)&&(pbvy>m_iMaxTy) )||( (pbvy<m_iMaxTy)&&(pbky>m_iMaxTy) )
				)
			{
				endr=(m_scale*(pTr->r-(pTr->sign)*(pTr->vs[0])));
				kvr=(m_scale*(pTr->r-1.25*(pTr->sign)*(pTr->vs[0])));
				if(kvr<0.001){kvr=0.001;}
				wvr=(m_scale*(pTr->r-vbw*(pTr->sign)*(pTr->vs[0])));
				if(wvr<0.001){wvr=0.001;}
				if(pTr->sign==1)
				{
					DrawArc( pDC, pox,poy,dfi,pTr->fiv,endr,endr);
					if(lkerb)
					{
						COLORREF colKerb;
						if(pTr->flags&4)
						{
							colKerb = COLOR_KERB_2;
						}
						else
						{
							colKerb = COLOR_KERB_14;
						}
						pPen = new CPen( PS_SOLID, 1, colKerb );
						pOldPen = pDC->SelectObject( pPen );
						DrawArc( pDC, pox,poy,dfi,pTr->fiv,kvr,kvr);
						DrawLine( pDC, kbvx,kbvy,pbvx,pbvy);
						pDC->SelectObject( pOldPen );
						delete pPen;
						pPen = NULL;
					}
					if(lwall)
					{
						if(lbridge)
						{
							pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
							pOldPen = pDC->SelectObject( pPen );
							DrawLine( pDC, wbkx,wbky,wbvx,wbvy);
						}
						else
						{
							pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
							pOldPen = pDC->SelectObject( pPen );
							DrawArc( pDC, pox,poy,dfi,pTr->fiv,wvr,wvr);
						}
						pDC->SelectObject( pOldPen );
						delete pPen;
						pPen = NULL;
					}
				}
				if(pTr->sign==-1)
				{
					DrawArc( pDC, pox,poy,pTr->fiv+M_PI,dfi+M_PI,endr,endr);
					if(lkerb)
					{
						COLORREF colKerb;
						if(pTr->flags&4)
						{
							colKerb = COLOR_KERB_2;
						}
						else
						{
							colKerb = COLOR_KERB_14;
						}
						pPen = new CPen( PS_SOLID, 1, colKerb );
						pOldPen = pDC->SelectObject( pPen );
						DrawArc( pDC, pox,poy,pTr->fiv+M_PI,dfi+M_PI,kvr,kvr);
						DrawLine( pDC, kbvx,kbvy,pbvx,pbvy);
						pDC->SelectObject( pOldPen );
						delete pPen;
						pPen = NULL;
					}
					if(lwall)
					{
						if(lbridge)
						{
							pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
							pOldPen = pDC->SelectObject( pPen );
							DrawLine( pDC, wbkx,wbky,wbvx,wbvy);
						}
						else
						{
							pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
							pOldPen = pDC->SelectObject( pPen );
							DrawArc( pDC, pox,poy,pTr->fiv+M_PI,dfi+M_PI,wvr,wvr);
						}
						pDC->SelectObject( pOldPen );
						delete pPen;
						pPen = NULL;
					}
				}
				DrawLine( pDC, pbvx,pbvy,pjvx,pjvy);
			}
			if( ( (pjkx>=0)&&(pjkx<=m_iMaxTx)&&(pjky>=0)&&(pjky<=m_iMaxTy) )
				||( (pjvx>=0)&&(pjvx<=m_iMaxTx)&&(pjvy>=0)&&(pjvy<=m_iMaxTy) )
				||( (pjkx<0)&&(pjvx>0) )||( (pjvx<0)&&(pjkx>0) )
				||( (pjkx<m_iMaxTx)&&(pjvx>m_iMaxTx) )||( (pjvx<m_iMaxTx)&&(pjkx>m_iMaxTx) )
				||( (pjky<0)&&(pjvy>0) )||( (pjvy<0)&&(pjky>0) )
				||( (pjky<m_iMaxTy)&&(pjvy>m_iMaxTy) )||( (pjvy<m_iMaxTy)&&(pjky>m_iMaxTy) )
				)
			{
				endr=(m_scale*(pTr->r+(pTr->sign)*(pTr->vs[1])));
				kvr=(m_scale*(pTr->r+1.25*(pTr->sign)*(pTr->vs[1])));
				if(kvr<0.001)
					{kvr=0.001;}
				wvr=(m_scale*(pTr->r+vjw*(pTr->sign)*(pTr->vs[1])));
				if(wvr<0.001)
					{wvr=0.001;}
				if(pTr->sign==1)
					{DrawArc( pDC, pox,poy,dfi,pTr->fiv,endr,endr);
					if(rkerb)
					{
						COLORREF colKerb;
						if(pTr->flags&4)
						{
							colKerb = COLOR_KERB_2;
						}
						else
						{
							colKerb = COLOR_KERB_14;
						}
						pPen = new CPen( PS_SOLID, 1, colKerb );
						pOldPen = pDC->SelectObject( pPen );
						DrawArc( pDC, pox,poy,dfi,pTr->fiv,kvr,kvr);
						DrawLine( pDC, kbvx,kbvy,pbvx,pbvy);
						pDC->SelectObject( pOldPen );
						delete pPen;
						pPen = NULL;
					}
					if(rwall)
					{
						if(rbridge)
						{
							pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
							pOldPen = pDC->SelectObject( pPen );
							DrawLine( pDC, wjkx,wjky,wjvx,wjvy);
						}
						else
						{
							pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
							pOldPen = pDC->SelectObject( pPen );
							DrawArc( pDC, pox,poy,dfi,pTr->fiv,wvr,wvr);
						}
						pDC->SelectObject( pOldPen );
						delete pPen;
						pPen = NULL;
					}
					}
				if(pTr->sign==-1)
				{DrawArc( pDC, pox,poy,pTr->fiv+M_PI,dfi+M_PI,endr,endr);
				if(rkerb)
				{
					COLORREF colKerb;
					if(pTr->flags&4)
					{
						colKerb = COLOR_KERB_2;
					}
					else
					{
						colKerb = COLOR_KERB_14;
					}
					pPen = new CPen( PS_SOLID, 1, colKerb );
					pOldPen = pDC->SelectObject( pPen );
					DrawArc( pDC, pox,poy,pTr->fiv+M_PI,dfi+M_PI,kvr,kvr);
					DrawLine( pDC, kbvx,kbvy,pbvx,pbvy);
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
				if(rwall)
				{
					if(rbridge)
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
						pOldPen = pDC->SelectObject( pPen );
						DrawLine( pDC, wjkx,wjky,wjvx,wjvy);
					}
					else
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
						pOldPen = pDC->SelectObject( pPen );
						DrawArc( pDC, pox,poy,pTr->fiv+M_PI,dfi+M_PI,wvr,wvr);
					}
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
				}
				DrawLine( pDC, pbvx,pbvy,pjvx,pjvy);
			}
		}
   }
   else
	{/*straight*/
		if(m_bDrawSegs)
		{
			pPen = new CPen( PS_SOLID, 1, COLOR_SEGS );
			pOldPen = pDC->SelectObject( pPen );

			deltax=(pTr->vx-pTr->kx)/((float)pTr->tlu);
			deltay=(pTr->vy-pTr->ky)/((float)pTr->tlu);
			for(i=1;i<pTr->tlu;i++)
			{
				if(pTr->middle)
				{
					if( (4.8768*(double)i)<pTr->fim )
					{
						s[0]=pTr->ks[0]+((pTr->vs[0]-pTr->ks[0])*4.8768*(float)i)/(pTr->fim);
						s[1]=pTr->ks[1]+((pTr->vs[1]-pTr->ks[1])*4.8768*(float)i)/(pTr->fim);
					}
					else
					{
						s[0]=pTr->vs[0];
						s[1]=pTr->vs[1];
					}
				}
				else
				{
					s[0]=pTr->ks[0]+((pTr->vs[0]-pTr->ks[0])*4.8768*(float)i)/(pTr->length);
					s[1]=pTr->ks[1]+((pTr->vs[1]-pTr->ks[1])*4.8768*(float)i)/(pTr->length);
				}
				x=pTr->kx+deltax*(float)i;
				pbkx=f2i((x-s[0]*cos(pTr->fik))*m_scale)+m_iDx;
				pjkx=f2i((x+s[1]*cos(pTr->fik))*m_scale)+m_iDx;
				y=pTr->ky+deltay*((float)i);
				pbky=m_iMaxTy-f2i((y-s[0]*sin(pTr->fik))*m_scale)-m_iDy;
				pjky=m_iMaxTy-f2i((y+s[1]*sin(pTr->fik))*m_scale)-m_iDy;
				DrawLine( pDC, pbkx,pbky,pjkx,pjky);
			}

			pDC->SelectObject( pOldPen );
			delete pPen;
			pPen = NULL;
		}

		pbkx=f2i((pTr->kx-(float)(pTr->ks[0])*cos(pTr->fik))*m_scale)+m_iDx;
		pbky=m_iMaxTy-f2i((pTr->ky-(float)(pTr->ks[0])*sin(pTr->fik))*m_scale)-m_iDy;
		pjkx=f2i((pTr->kx+(float)(pTr->ks[1])*cos(pTr->fik))*m_scale)+m_iDx;
		pjky=m_iMaxTy-f2i((pTr->ky+(float)(pTr->ks[1])*sin(pTr->fik))*m_scale)-m_iDy;
		kbkx=f2i((pTr->kx-1.25*(pTr->ks[0])*cos(pTr->fik))*m_scale)+m_iDx;
		kbky=m_iMaxTy-f2i((pTr->ky-1.25*(pTr->ks[0])*sin(pTr->fik))*m_scale)-m_iDy;
		kjkx=f2i((pTr->kx+1.25*(pTr->ks[1])*cos(pTr->fik))*m_scale)+m_iDx;
		kjky=m_iMaxTy-f2i((pTr->ky+1.25*(pTr->ks[1])*sin(pTr->fik))*m_scale)-m_iDy;
		wbkx=f2i((pTr->kx-kbw*(pTr->ks[0])*cos(pTr->fik))*m_scale)+m_iDx;
		wbky=m_iMaxTy-f2i((pTr->ky-kbw*(pTr->ks[0])*sin(pTr->fik))*m_scale)-m_iDy;
		wjkx=f2i((pTr->kx+kjw*(pTr->ks[1])*cos(pTr->fik))*m_scale)+m_iDx;
		wjky=m_iMaxTy-f2i((pTr->ky+kjw*(pTr->ks[1])*sin(pTr->fik))*m_scale)-m_iDy;
		if( ( (pbkx>=0)&&(pbkx<=m_iMaxTx)&&(pbky>=0)&&(pbky<=m_iMaxTy) )
		   ||( (pbvx>=0)&&(pbvx<=m_iMaxTx)&&(pbvy>=0)&&(pbvy<=m_iMaxTy) )
		   ||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
		   ||( (pbkx<m_iMaxTx)&&(pbvx>m_iMaxTx) )||( (pbvx<m_iMaxTx)&&(pbkx>m_iMaxTx) )
		   ||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
		   ||( (pbky<m_iMaxTy)&&(pbvy>m_iMaxTy) )||( (pbvy<m_iMaxTy)&&(pbky>m_iMaxTy) )
		   )
		{
			DrawLine( pDC, pbkx,pbky,pbvx,pbvy);
			DrawLine( pDC, pbkx,pbky,pjkx,pjky);
			if(!pTr->middle)
			{
				DrawLine( pDC, pbvx,pbvy,pjvx,pjvy);
			}
			if(lkerb)
			{
				COLORREF colKerb;
				if(pTr->flags&4)
				{
					colKerb = COLOR_KERB_2;
				}
				else
				{
					colKerb = COLOR_KERB_14;
				}
				pPen = new CPen( PS_SOLID, 1, colKerb );
				pOldPen = pDC->SelectObject( pPen );
				DrawLine( pDC, kbkx,kbky,kbvx,kbvy);
				DrawLine( pDC, kbkx,kbky,pbkx,pbky);
				if(!pTr->middle)
				{
					DrawLine( pDC, kbvx,kbvy,pbvx,pbvy);
				}
				pDC->SelectObject( pOldPen );
				delete pPen;
				pPen = NULL;
			}
			if(lwall)
			{
				if(lbridge)
				{
					pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
					pOldPen = pDC->SelectObject( pPen );
				}
				else
				{
					pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
					pOldPen = pDC->SelectObject( pPen );
				}
				DrawLine( pDC, wbkx,wbky,wbvx,wbvy);
				pDC->SelectObject( pOldPen );
				delete pPen;
				pPen = NULL;
			}
		}
		if( ( (pjkx>=0)&&(pjkx<=m_iMaxTx)&&(pjky>=0)&&(pjky<=m_iMaxTy) )
		   ||( (pjvx>=0)&&(pjvx<=m_iMaxTx)&&(pjvy>=0)&&(pjvy<=m_iMaxTy) )
		   ||( (pjkx<0)&&(pjvx>0) )||( (pjvx<0)&&(pjkx>0) )
		   ||( (pjkx<m_iMaxTx)&&(pjvx>m_iMaxTx) )||( (pjvx<m_iMaxTx)&&(pjkx>m_iMaxTx) )
		   ||( (pjky<0)&&(pjvy>0) )||( (pjvy<0)&&(pjky>0) )
		   ||( (pjky<m_iMaxTy)&&(pjvy>m_iMaxTy) )||( (pjvy<m_iMaxTy)&&(pjky>m_iMaxTy) )
		   )
		{
			DrawLine( pDC, pjkx,pjky,pjvx,pjvy);
			DrawLine( pDC, pbkx,pbky,pjkx,pjky);
			if(!pTr->middle)
			{
				DrawLine( pDC, pbvx,pbvy,pjvx,pjvy);
			}
			if(rkerb)
			{
				COLORREF colKerb;
				if(pTr->flags&4)
				{
					colKerb = COLOR_KERB_2;
				}
				else
				{
					colKerb = COLOR_KERB_14;
				}
				pPen = new CPen( PS_SOLID, 1, colKerb );
				pOldPen = pDC->SelectObject( pPen );
				DrawLine( pDC, kjkx,kjky,kjvx,kjvy);
				DrawLine( pDC, pjkx,pjky,kjkx,kjky);
				if(!pTr->middle)
				{
					DrawLine( pDC, pjvx,pjvy,kjvx,kjvy);
				}
				pDC->SelectObject( pOldPen );
				delete pPen;
				pPen = NULL;
			}
			if(rwall)
			{
				if(rbridge)
				{
					pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
					pOldPen = pDC->SelectObject( pPen );
				}
				else
				{
					pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
					pOldPen = pDC->SelectObject( pPen );
				}
				DrawLine( pDC, wjkx,wjky,wjvx,wjvy);
				pDC->SelectObject( pOldPen );
				delete pPen;
				pPen = NULL;
			}
		}
		if(pTr->middle)
		{
			pbkx=pbvx; pbky=pbvy; pjkx=pjvx; pjky=pjvy;
			pbvx=f2i((pTr->vx-/*(float)*/(pTr->vs[0])*cos(pTr->fiv))*m_scale)+m_iDx;
			pbvy=m_iMaxTy-f2i((pTr->vy-/*(float)*/(pTr->vs[0])*sin(pTr->fiv))*m_scale)-m_iDy;
			pjvx=f2i((pTr->vx+/*(float)*/(pTr->vs[1])*cos(pTr->fiv))*m_scale)+m_iDx;
			pjvy=m_iMaxTy-f2i((pTr->vy+/*(float)*/(pTr->vs[1])*sin(pTr->fiv))*m_scale)-m_iDy;
			kbkx=kbvx; kbky=kbvy; kjkx=kjvx; kjky=kjvy;
			kbvx=f2i((pTr->vx-1.25*(pTr->vs[0])*cos(pTr->fiv))*m_scale)+m_iDx;
			kbvy=m_iMaxTy-f2i((pTr->vy-1.25*(pTr->vs[0])*sin(pTr->fiv))*m_scale)-m_iDy;
			kjvx=f2i((pTr->vx+1.25*(pTr->vs[1])*cos(pTr->fiv))*m_scale)+m_iDx;
			kjvy=m_iMaxTy-f2i((pTr->vy+1.25*(pTr->vs[1])*sin(pTr->fiv))*m_scale)-m_iDy;
			wbkx=wbvx; wbky=wbvy; wjkx=wjvx; wjky=wjvy;
			wbvx=f2i((pTr->vx-vbw*(pTr->vs[0])*cos(pTr->fiv))*m_scale)+m_iDx;
			wbvy=m_iMaxTy-f2i((pTr->vy-vbw*(pTr->vs[0])*sin(pTr->fiv))*m_scale)-m_iDy;
			wjvx=f2i((pTr->vx+vjw*(pTr->vs[1])*cos(pTr->fiv))*m_scale)+m_iDx;
			wjvy=m_iMaxTy-f2i((pTr->vy+vjw*(pTr->vs[1])*sin(pTr->fiv))*m_scale)-m_iDy;
			if( ( (pbkx>=0)&&(pbkx<=m_iMaxTx)&&(pbky>=0)&&(pbky<=m_iMaxTy) )
				||( (pbvx>=0)&&(pbvx<=m_iMaxTx)&&(pbvy>=0)&&(pbvy<=m_iMaxTy) )
				||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
				||( (pbkx<m_iMaxTx)&&(pbvx>m_iMaxTx) )||( (pbvx<m_iMaxTx)&&(pbkx>m_iMaxTx) )
				||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
				||( (pbky<m_iMaxTy)&&(pbvy>m_iMaxTy) )||( (pbvy<m_iMaxTy)&&(pbky>m_iMaxTy) )
				)
			{
				DrawLine( pDC, pbkx,pbky,pbvx,pbvy);
				DrawLine( pDC, pbvx,pbvy,pjvx,pjvy);
				if(lkerb)
				{
					COLORREF colKerb;
					if(pTr->flags&4)
					{
						colKerb = COLOR_KERB_2;
					}
					else
					{
						colKerb = COLOR_KERB_14;
					}
					pPen = new CPen( PS_SOLID, 1, colKerb );
					pOldPen = pDC->SelectObject( pPen );
					DrawLine( pDC, kbkx,kbky,kbvx,kbvy);
					DrawLine( pDC, pbvx,pbvy,kbvx,kbvy);
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
				if(lwall)
				{
					if(lbridge)
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
						pOldPen = pDC->SelectObject( pPen );
					}
					else
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
						pOldPen = pDC->SelectObject( pPen );
					}
					DrawLine( pDC, wbkx,wbky,wbvx,wbvy);
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
			}
			if( ( (pjkx>=0)&&(pjkx<=m_iMaxTx)&&(pjky>=0)&&(pjky<=m_iMaxTy) )
				||( (pjvx>=0)&&(pjvx<=m_iMaxTx)&&(pjvy>=0)&&(pjvy<=m_iMaxTy) )
				||( (pjkx<0)&&(pjvx>0) )||( (pjvx<0)&&(pjkx>0) )
				||( (pjkx<m_iMaxTx)&&(pjvx>m_iMaxTx) )||( (pjvx<m_iMaxTx)&&(pjkx>m_iMaxTx) )
				||( (pjky<0)&&(pjvy>0) )||( (pjvy<0)&&(pjky>0) )
				||( (pjky<m_iMaxTy)&&(pjvy>m_iMaxTy) )||( (pjvy<m_iMaxTy)&&(pjky>m_iMaxTy) )
				)
			{
				DrawLine( pDC, pjkx,pjky,pjvx,pjvy);
				DrawLine( pDC, pbvx,pbvy,pjvx,pjvy);
				if(rkerb)
				{
					COLORREF colKerb;
					if(pTr->flags&4)
					{
						colKerb = COLOR_KERB_2;
					}
					else
					{
						colKerb = COLOR_KERB_14;
					}
					pPen = new CPen( PS_SOLID, 1, colKerb );
					pOldPen = pDC->SelectObject( pPen );
					DrawLine( pDC, kjkx,kjky,kjvx,kjvy);
					DrawLine( pDC, kjvx,kjvy,pjvx,pjvy);
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
				if(rwall)
				{
					if(rbridge)
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_BRIDGE_11 );
						pOldPen = pDC->SelectObject( pPen );
					}
					else
					{
						pPen = new CPen( PS_SOLID, 1, COLOR_WALL_3 );
						pOldPen = pDC->SelectObject( pPen );
					}
					DrawLine( pDC, wjkx,wjky,wjvx,wjvy);
					pDC->SelectObject( pOldPen );
					delete pPen;
					pPen = NULL;
				}
			}
		}
   } // straight

/*
   // Draw track profile
	int iS_Start, iH_Start, iS_End, iH_End, iS_Center, iH_Center, iR;
	if ( pTr->height )
	{
		// curved profile segment
		iS_Center = f2i( pTr->m_dS_Center * m_scale) + m_iDx;
		iH_Center = m_iMaxTy - f2i(pTr->m_dH_Center * m_scale) - m_iDy;
		iR = f2i( pTr->m_dR_Profile * m_scale );
		double f;
		if ( pTr->m_pPrev )
			f = pTr->m_pPrev->cumgrad;
		else
			f = 0.0; // @@@
		DrawArc( pDC, iS_Center, iH_Center,
				 f - M_PI / 2.0, pTr->cumgrad - M_PI / 2.0, iR, iR );
	}
	else
	{
		// staight profile segment
		iS_Start = f2i( pTr->m_dS_Start * m_scale) + m_iDx;
		iH_Start = m_iMaxTy - f2i(pTr->m_dH_Start * m_scale) - m_iDy;
		iS_End = f2i( pTr->m_dS_End * m_scale) + m_iDx;
		iH_End = m_iMaxTy - f2i(pTr->m_dH_End * m_scale) - m_iDy;
		DrawLine( pDC, iS_Start, iH_Start, iS_End, iH_End );
	}
*/
}

void CTrackEdView::DrawCCLineSegment(CDC *pDC, const CRect &rectClip, CBestLineSeg *pBl)
{
 int pbkx,pbky,pbvx,pbvy, pox,poy;
 float r;

 if(pBl->sign==4){return;}

 if(pBl->m_pAux != NULL)
 {
	 // Hilfssegment zeichnen
	 CPen * pPen = new CPen( PS_SOLID, 1, COLOR_BEST_LINE_PRE );
	 CPen * pOldPen = pDC->SelectObject( pPen );
	 DrawCCLineSegment( pDC, rectClip, pBl->m_pAux );
	 pDC->SelectObject( pOldPen );
	 delete pPen;
 }

 // Anfangskoordinate in Pixel umrechnen
 pbkx=f2i(pBl->kx*m_scale)+m_iDx;
 pbky=m_iMaxTy-f2i(pBl->ky*m_scale)-m_iDy;
 // Endkoordinate in Pixel umrechnen
 pbvx=f2i(pBl->vx*m_scale)+m_iDx;
 pbvy=m_iMaxTy-f2i(pBl->vy*m_scale)-m_iDy;

 // Sichtbarkeit prfen
 if( ( (pbkx>=0)&&(pbkx<=m_iMaxTx)&&(pbky>=0)&&(pbky<=m_iMaxTy) )				// Anfangspunkt sichtbar
	||( (pbvx>=0)&&(pbvx<=m_iMaxTx)&&(pbvy>=0)&&(pbvy<=m_iMaxTy) )			// Endpunkt sichtbar
	||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )					// berschreitet linken Rand
	||( (pbkx<m_iMaxTx)&&(pbvx>m_iMaxTx) )||( (pbvx<m_iMaxTx)&&(pbkx>m_iMaxTx) )	// berschreitet rechten Rand
	||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )					// berschreitet oberen Rand
	||( (pbky<m_iMaxTy)&&(pbvy>m_iMaxTy) )||( (pbvy<m_iMaxTy)&&(pbky>m_iMaxTy) )	// berschreiter unteren Rand
	)
 {
	 switch(pBl->sign)
	   {case  0:{/*straight*/
		     DrawLine(pDC, pbkx,pbky,pbvx,pbvy);
		     break;}
	    case  1:{/*left curve*/
			 // Kreismittelpunkt in Pixel umrechnen
			 pox=f2i(pBl->ox*m_scale)+m_iDx;
		     poy=m_iMaxTy-f2i(pBl->oy*m_scale)-m_iDy;
			 // Radius umrechnen
			 r=(m_scale*pBl->r);
			 // Kreissegment zeichnen
		     DrawArc( pDC, pox,poy,pBl->fik,pBl->fiv,r,r);
			 // Evtl. Linien zum Mittelpunkt ziehen.
		     if(m_bDrawPoints)
		       {DrawLine( pDC, pbkx,pbky,pox,poy);
				DrawLine( pDC, pbvx,pbvy,pox,poy);
		       }
		     break;}
	    case -1:{/*right curve*/
		     pox=f2i(pBl->ox*m_scale)+m_iDx;
		     poy=m_iMaxTy-f2i(pBl->oy*m_scale)-m_iDy;
		     r=(m_scale*pBl->r);
		     DrawArc( pDC, pox,poy,pBl->fiv+M_PI,pBl->fik+M_PI,r,r);
		     if(m_bDrawPoints)
		       {DrawLine( pDC, pbkx,pbky,pox,poy);
				DrawLine( pDC, pbvx,pbvy,pox,poy);
		       }
		     break;}
	   }
	}
}

/* Primitive Zeichenfunktionen */

void CTrackEdView::DrawLine(CDC *pDC, int x1, int y1, int x2, int y2)
{
	if ( pDC == NULL ) return;
	pDC->MoveTo( x1, y1 );
	pDC->LineTo( x2, y2 );
}

/* @@@ Ad-hoc Lsung */

void CTrackEdView::DrawArc(CDC *pDC, int x, int y, float stangle, float endangle, float str, float endr)
{
 float fi,r,a,fiv,r0;
 int color,px,py;

 fiv=endangle;
 fi=stangle;
 fi=fi;
 a=(endr-str)/(fiv-fi);
 r0=str-a*fi;
 do
   {r=r0+a*fi;
    px=x+f2i(r*cos(fi));
    py=y-f2i(r*sin(fi));
    if( (px>=0)&&(px<=m_iMaxTx)&&(py>=0)&&(py<=m_iMaxTy) )
	{
		// zwei Pixel lange Mini-Linie zeichnen @@@
		DrawLine(pDC,px,py,px+1,py+1);
	}
    if(r>10)fi+=1/r;
     else{fi+=0.1;}
   }
 while(fi<fiv);
 px=x+f2i(r*cos(fiv));
 py=y-f2i(r*sin(fiv));
 if( (px>=0)&&(px<=m_iMaxTx)&&(py>=0)&&(py<=m_iMaxTy) )
   {DrawLine(pDC,px,py,px+1,py+1);}
}

void CTrackEdView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	switch( nChar )
	{
	case '*':
		// zoom in
		m_scale = m_scale * 2.0;
		// adjust offset to keep center of map in the middle of the screen.
		m_iDx = m_iDx * 2 - m_iMaxTx / 2;
		m_iDy = m_iDy * 2 - m_iMaxTy / 2;
		Invalidate();
		break;
	case '/':
		// zoom out
		m_scale = m_scale / 2.0;
		// adjust offset to keep center of map in the middle of the screen.
		m_iDx = m_iDx / 2 + m_iMaxTx / 4;
		m_iDy = m_iDy / 2 + m_iMaxTy / 4;
		Invalidate();
		break;
	}

	// show border of single tlu units, when zoomed enough
	if ( m_scale > 2.0 )
		m_bDrawSegs=1;
	else
		m_bDrawSegs=0;

	CView::OnChar(nChar, nRepCnt, nFlags);
}

void CTrackEdView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	switch( nChar )
	{
	case VK_LEFT:
		// Ausschnitt nach links verschieben
		m_iDx = m_iDx + m_iMaxTx / 4;
		Invalidate();
		break;
	case VK_RIGHT:
		// Ausschnitt nach rechts verschieben
		m_iDx = m_iDx - m_iMaxTx / 4;
		Invalidate();
		break;
	case VK_UP:
		// Ausschnitt nach oben verschieben
		m_iDy = m_iDy - m_iMaxTy / 4;
		Invalidate();
		break;
	case VK_DOWN:
		// Ausschnitt nach unten verschieben
		m_iDy = m_iDy + m_iMaxTy / 4;
		Invalidate();
		break;
	case VK_HOME: // "Pos1"
	case VK_END: // "Ende"
		// aktuelles Segment der editierten Liste ndern
		GetDocument()->MoveEditPointer( nChar );
		Invalidate();
		GetDocument()->UpdateAllViews(this);
		break;
	}

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CTrackEdView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	if ( pSender == this )
		return;
	// Cause redraw of entire graphical display.
	Invalidate();
}

void CTrackEdView::OnSysChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	bool bProcessed = false;

	switch( nChar )
	{
	case 'n':
	case 'N':
		// Create new segment
		GetDocument()->AddSegment();
		bProcessed = true;
		break;
	case 'd':
	case 'D':
		// delete current segment
		GetDocument()->DeleteSegment();
		bProcessed = true;
		break;
	case 't':
	case 'T':
		// Switch to "track edit" mode
		GetDocument()->SetEditMode( CTrack::emTrack );
		bProcessed = true;
		break;
	case 'p':
	case 'P':
		// Switch to "pit lane edit" mode
		GetDocument()->SetEditMode( CTrack::emPit );
		bProcessed = true;
		break;
	case 'c':
	case 'C':
		// Switch to "CC line edit" mode
		GetDocument()->SetEditMode( CTrack::emBestLine );
		bProcessed = true;
		break;
	}

	if ( bProcessed )
	{
		Invalidate();
		GetDocument()->UpdateAllViews(this);
	}
	else
	{
		// Call default handler
		CView::OnSysChar(nChar, nRepCnt, nFlags);
	}
}

void CTrackEdView::OnPreferencesNewCcline() 
{
	GetDocument()->SetOldCCLineStyle( false );
	GetDocument()->RefreshCCLine();
	GetDocument()->UpdateAllViews(NULL);
}

void CTrackEdView::OnUpdatePreferencesNewCcline(CCmdUI* pCmdUI) 
{
	if ( GetDocument()->GetOldCCLineStyle() )
		// old style: remove check
		pCmdUI->SetCheck( 0 );
	else
		// new style: set check
		pCmdUI->SetCheck( 1 );
}

void CTrackEdView::OnPreferencesOldCcline() 
{
	GetDocument()->SetOldCCLineStyle( true );
	GetDocument()->RefreshCCLine();
	GetDocument()->UpdateAllViews(NULL);
}

void CTrackEdView::OnUpdatePreferencesOldCcline(CCmdUI* pCmdUI) 
{
	if ( GetDocument()->GetOldCCLineStyle() )
		// old style: set check
		pCmdUI->SetCheck( 1 );
	else
		// new style: remove check
		pCmdUI->SetCheck( 0 );
}
