/* f1gpfile.h - extract data from MicroProse F1GP save files

   Copyright (C) 1994 David P Gymer

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _F1GP_FILE_H
#define _F1GP_FILE_H

#include <time.h>

#define NUM_TRACKS 16
#define NUM_RATIOS 6

typedef struct {
  char wings[2];
  char ratios[NUM_RATIOS];
  char tyre_compound;
  char brake_balance;
} SETUP;

typedef struct {
  char name[25];
  char team[15];
  unsigned long lap_time;	/* In milliseconds.  */
  time_t date;
} RECORD;

typedef struct {
  const char *names[2];
  const int lap_length;		/* In `milli-miles'.  */
  const int lap_count;
  SETUP setups[2];
  RECORD records[2];
} TRACK;

TRACK *f1gp_new_tracks (TRACK *);
int f1gp_read_setup (const char *, TRACK *, int, int);
int f1gp_read_setups (const char *, TRACK *);
int f1gp_read_records (const char *, TRACK *);

#endif /* _F1GP_FILE_H */
