###################################################
import os
from os import system
import struct
system("title "+"WING HARD -- Version 1.5")
###################################################

def ReadTwoByteValue(FILENAME, OFFSET): #simple program to print and read a value.
    in_file = open(FILENAME, "r+b") #opens in binary write/read mode.
    in_file.seek(OFFSET) # Go to the file offset.
    TwoByteRead = in_file.read(2)	# Read two bytes from file.
    TwoByteValue = struct.unpack("h", TwoByteRead[0:2])
    TwoByteValue = int(TwoByteValue[0])
    print(str(TwoByteValue))
    in_file.close() #close file.
    return TwoByteValue

def MultiplyTwoByteValue(FILENAME, OFFSET, MULTIPLIER): #reads and multiplies something back.
    edited_file = open(FILENAME, "r+b") #opens in binary write/read mode.
    edited_file.seek(OFFSET) # Go to the file offset.
    TwoByteRead = edited_file.read(2)	# Read two bytes from file.
    TwoByteValue = struct.unpack("h", TwoByteRead[0:2]) #read into tuple.
    TwoByteValue = int(TwoByteValue[0]) #convert from tuple to int.
    ModifiedValue = TwoByteValue * MULTIPLIER
    ModifiedValue = int(ModifiedValue) #Convert to integer if we use 1.5 which makes a floor.
    ModifiedValueBinary = (ModifiedValue).to_bytes(2, byteorder='little') #convert to binary string

    edited_file.seek(OFFSET) # Go to the file offset.
    edited_file.write(ModifiedValueBinary) #Write to file.
    
    edited_file.close() #close file.

def EditTwoByteValue(FILENAME, OFFSET, STOCKVALUE, MULTIPLIER): #Edits something based off a value.
    ModifiedValue = STOCKVALUE * MULTIPLIER
    ModifiedValue = int(ModifiedValue) #Convert to integer if we use 1.5 which makes a floor.
    ModifiedValueBinary = (ModifiedValue).to_bytes(2, byteorder='little') #convert to binary string

    edited_file = open(FILENAME, "r+b") #opens in binary write/read mode.
    edited_file.seek(OFFSET) # Go to the file offset.
    edited_file.write(ModifiedValueBinary) #Write to file.
    edited_file.close() #close file.

##################################

###WC1 (GOG) (WC.EXE) Offsets for two byte variables
WC_Asteroid_Radius_STOCK = 100 #stock asteroid radius.

WC_Asteroid_1_Radius = 101806
WC_Asteroid_2_Radius = 101917
WC_Asteroid_3_Radius = 102028
WC_Asteroid_4_Radius = 102139
WC_Asteroid_5_Radius = 102250
WC_Asteroid_6_Radius = 102361

WC_Slot_1_FrontShield = 98119
WC_Slot_1_RearShield = 98121
WC_Slot_1_FrontArmor = 98123
WC_Slot_1_RearArmor = 98125
WC_Slot_1_LeftArmor = 98127
WC_Slot_1_RightArmor = 98129
WC_Slot_2_FrontShield = 98230
WC_Slot_2_RearShield = 98232
WC_Slot_2_FrontArmor = 98234
WC_Slot_2_RearArmor = 98236
WC_Slot_2_LeftArmor = 98238
WC_Slot_2_RightArmor = 98240
WC_Slot_3_FrontShield = 98341
WC_Slot_3_RearShield = 98343
WC_Slot_3_FrontArmor = 98345
WC_Slot_3_RearArmor = 98347
WC_Slot_3_LeftArmor = 98349
WC_Slot_3_RightArmor = 98351
WC_Slot_4_FrontShield = 98452
WC_Slot_4_RearShield = 98454
WC_Slot_4_FrontArmor = 98456
WC_Slot_4_RearArmor = 98458
WC_Slot_4_LeftArmor = 98460
WC_Slot_4_RightArmor = 98462
WC_Slot_5_FrontShield = 98563
WC_Slot_5_RearShield = 98565
WC_Slot_5_FrontArmor = 98567
WC_Slot_5_RearArmor = 98569
WC_Slot_5_LeftArmor = 98571
WC_Slot_5_RightArmor = 98573
WC_Slot_6_FrontShield = 98674
WC_Slot_6_RearShield = 98676
WC_Slot_6_FrontArmor = 98678
WC_Slot_6_RearArmor = 98680
WC_Slot_6_LeftArmor = 98682
WC_Slot_6_RightArmor = 98684
WC_Slot_7_FrontShield = 98785
WC_Slot_7_RearShield = 98787
WC_Slot_7_FrontArmor = 98789
WC_Slot_7_RearArmor = 98791
WC_Slot_7_LeftArmor = 98793
WC_Slot_7_RightArmor = 98795
WC_Slot_8_FrontShield = 98896
WC_Slot_8_RearShield = 98898
WC_Slot_8_FrontArmor = 98900
WC_Slot_8_RearArmor = 98902
WC_Slot_8_LeftArmor = 98904
WC_Slot_8_RightArmor = 98906
WC_Slot_9_FrontShield = 99007
WC_Slot_9_RearShield = 99009
WC_Slot_9_FrontArmor = 99011
WC_Slot_9_RearArmor = 99013
WC_Slot_9_LeftArmor = 99015
WC_Slot_9_RightArmor = 99017

WC_Slot_1_FrontShield_STOCK = 40
WC_Slot_1_RearShield_STOCK = 40
WC_Slot_1_FrontArmor_STOCK = 45
WC_Slot_1_RearArmor_STOCK = 40
WC_Slot_1_LeftArmor_STOCK = 30
WC_Slot_1_RightArmor_STOCK = 30
WC_Slot_2_FrontShield_STOCK = 80
WC_Slot_2_RearShield_STOCK = 75
WC_Slot_2_FrontArmor_STOCK = 60
WC_Slot_2_RearArmor_STOCK = 55
WC_Slot_2_LeftArmor_STOCK = 50
WC_Slot_2_RightArmor_STOCK = 50
WC_Slot_3_FrontShield_STOCK = 60
WC_Slot_3_RearShield_STOCK = 50
WC_Slot_3_FrontArmor_STOCK = 85
WC_Slot_3_RearArmor_STOCK = 80
WC_Slot_3_LeftArmor_STOCK = 65
WC_Slot_3_RightArmor_STOCK = 65
WC_Slot_4_FrontShield_STOCK = 70
WC_Slot_4_RearShield_STOCK = 70
WC_Slot_4_FrontArmor_STOCK = 100
WC_Slot_4_RearArmor_STOCK = 90
WC_Slot_4_LeftArmor_STOCK = 80
WC_Slot_4_RightArmor_STOCK = 80
WC_Slot_5_FrontShield_STOCK = 150
WC_Slot_5_RearShield_STOCK = 150
WC_Slot_5_FrontArmor_STOCK = 110
WC_Slot_5_RearArmor_STOCK = 100
WC_Slot_5_LeftArmor_STOCK = 100
WC_Slot_5_RightArmor_STOCK = 100
WC_Slot_6_FrontShield_STOCK = 120
WC_Slot_6_RearShield_STOCK = 120
WC_Slot_6_FrontArmor_STOCK = 80
WC_Slot_6_RearArmor_STOCK = 80
WC_Slot_6_LeftArmor_STOCK = 60
WC_Slot_6_RightArmor_STOCK = 60
WC_Slot_7_FrontShield_STOCK = 120
WC_Slot_7_RearShield_STOCK = 120
WC_Slot_7_FrontArmor_STOCK = 80
WC_Slot_7_RearArmor_STOCK = 80
WC_Slot_7_LeftArmor_STOCK = 60
WC_Slot_7_RightArmor_STOCK = 60
WC_Slot_8_FrontShield_STOCK = 240
WC_Slot_8_RearShield_STOCK = 240
WC_Slot_8_FrontArmor_STOCK = 220
WC_Slot_8_RearArmor_STOCK = 200
WC_Slot_8_LeftArmor_STOCK = 200
WC_Slot_8_RightArmor_STOCK = 200
WC_Slot_9_FrontShield_STOCK = 300
WC_Slot_9_RearShield_STOCK = 300
WC_Slot_9_FrontArmor_STOCK = 240
WC_Slot_9_RearArmor_STOCK = 200
WC_Slot_9_LeftArmor_STOCK = 250
WC_Slot_9_RightArmor_STOCK = 250

###WC1 SM (GOG) (SM2.EXE) Offsets for two byte variables
WC_SM_Asteroid_Radius_STOCK = 100 #stock asteroid radius.
WC_SM_Asteroid_1_Radius = 101358
WC_SM_Asteroid_2_Radius = 101469
WC_SM_Asteroid_3_Radius = 101580
WC_SM_Asteroid_4_Radius = 101691
WC_SM_Asteroid_5_Radius = 101802
WC_SM_Asteroid_6_Radius = 101913

WC_SM2_Slot_1_Front_Shield = 97671
WC_SM2_Slot_1_Rear_Shield = 97673
WC_SM2_Slot_1_Front_Arm = 97675
WC_SM2_Slot_1_Rear_Arm = 97677
WC_SM2_Slot_1_Left_Arm = 97679
WC_SM2_Slot_1_Right_Arm = 97681
WC_SM2_Slot_2_Front_Shield = 97782
WC_SM2_Slot_2_Rear_Shield = 97784
WC_SM2_Slot_2_Front_Arm = 97786
WC_SM2_Slot_2_Rear_Arm = 97788
WC_SM2_Slot_2_Left_Arm = 97790
WC_SM2_Slot_2_Right_Arm = 97792
WC_SM2_Slot_3_Front_Shield = 97893
WC_SM2_Slot_3_Rear_Shield = 97895
WC_SM2_Slot_3_Front_Arm = 97897
WC_SM2_Slot_3_Rear_Arm = 97899
WC_SM2_Slot_3_Left_Arm = 97901
WC_SM2_Slot_3_Right_Arm = 97903
WC_SM2_Slot_4_Front_Shield = 98004
WC_SM2_Slot_4_Rear_Shield = 98006
WC_SM2_Slot_4_Front_Arm = 98008
WC_SM2_Slot_4_Rear_Arm = 98010
WC_SM2_Slot_4_Left_Arm = 98012
WC_SM2_Slot_4_Right_Arm = 98014
WC_SM2_Slot_5_Front_Shield = 98115
WC_SM2_Slot_5_Rear_Shield = 98117
WC_SM2_Slot_5_Front_Arm = 98119
WC_SM2_Slot_5_Rear_Arm = 98121
WC_SM2_Slot_5_Left_Arm = 98123
WC_SM2_Slot_5_Right_Arm = 98125
WC_SM2_Slot_6_Front_Shield = 98226
WC_SM2_Slot_6_Rear_Shield = 98228
WC_SM2_Slot_6_Front_Arm = 98230
WC_SM2_Slot_6_Rear_Arm = 98232
WC_SM2_Slot_6_Left_Arm = 98234
WC_SM2_Slot_6_Right_Arm = 98236
WC_SM2_Slot_7_Front_Shield = 98337
WC_SM2_Slot_7_Rear_Shield = 98339
WC_SM2_Slot_7_Front_Arm = 98341
WC_SM2_Slot_7_Rear_Arm = 98343
WC_SM2_Slot_7_Left_Arm = 98345
WC_SM2_Slot_7_Right_Arm = 98347
WC_SM2_Slot_8_Front_Shield = 98448
WC_SM2_Slot_8_Rear_Shield = 98450
WC_SM2_Slot_8_Front_Arm = 98452
WC_SM2_Slot_8_Rear_Arm = 98454
WC_SM2_Slot_8_Left_Arm = 98456
WC_SM2_Slot_8_Right_Arm = 98458
WC_SM2_Slot_9_Front_Shield = 98559
WC_SM2_Slot_9_Rear_Shield = 98561
WC_SM2_Slot_9_Front_Arm = 98563
WC_SM2_Slot_9_Rear_Arm = 98565
WC_SM2_Slot_9_Left_Arm = 98567
WC_SM2_Slot_9_Right_Arm = 98569

WC_SM2_Slot_1_Front_Shield_STOCK = 40
WC_SM2_Slot_1_Rear_Shield_STOCK = 40
WC_SM2_Slot_1_Front_Arm_STOCK = 45
WC_SM2_Slot_1_Rear_Arm_STOCK = 40
WC_SM2_Slot_1_Left_Arm_STOCK = 30
WC_SM2_Slot_1_Right_Arm_STOCK = 30
WC_SM2_Slot_2_Front_Shield_STOCK = 80
WC_SM2_Slot_2_Rear_Shield_STOCK = 75
WC_SM2_Slot_2_Front_Arm_STOCK = 60
WC_SM2_Slot_2_Rear_Arm_STOCK = 55
WC_SM2_Slot_2_Left_Arm_STOCK = 50
WC_SM2_Slot_2_Right_Arm_STOCK = 50
WC_SM2_Slot_3_Front_Shield_STOCK = 60
WC_SM2_Slot_3_Rear_Shield_STOCK = 50
WC_SM2_Slot_3_Front_Arm_STOCK = 85
WC_SM2_Slot_3_Rear_Arm_STOCK = 80
WC_SM2_Slot_3_Left_Arm_STOCK = 65
WC_SM2_Slot_3_Right_Arm_STOCK = 65
WC_SM2_Slot_4_Front_Shield_STOCK = 70
WC_SM2_Slot_4_Rear_Shield_STOCK = 70
WC_SM2_Slot_4_Front_Arm_STOCK = 100
WC_SM2_Slot_4_Rear_Arm_STOCK = 90
WC_SM2_Slot_4_Left_Arm_STOCK = 80
WC_SM2_Slot_4_Right_Arm_STOCK = 80
WC_SM2_Slot_5_Front_Shield_STOCK = 150
WC_SM2_Slot_5_Rear_Shield_STOCK = 150
WC_SM2_Slot_5_Front_Arm_STOCK = 110
WC_SM2_Slot_5_Rear_Arm_STOCK = 100
WC_SM2_Slot_5_Left_Arm_STOCK = 100
WC_SM2_Slot_5_Right_Arm_STOCK = 110
WC_SM2_Slot_6_Front_Shield_STOCK = 120
WC_SM2_Slot_6_Rear_Shield_STOCK = 120
WC_SM2_Slot_6_Front_Arm_STOCK = 80
WC_SM2_Slot_6_Rear_Arm_STOCK = 80
WC_SM2_Slot_6_Left_Arm_STOCK = 60
WC_SM2_Slot_6_Right_Arm_STOCK = 60
WC_SM2_Slot_7_Front_Shield_STOCK = 120
WC_SM2_Slot_7_Rear_Shield_STOCK = 120
WC_SM2_Slot_7_Front_Arm_STOCK = 80
WC_SM2_Slot_7_Rear_Arm_STOCK = 80
WC_SM2_Slot_7_Left_Arm_STOCK = 60
WC_SM2_Slot_7_Right_Arm_STOCK = 60
WC_SM2_Slot_8_Front_Shield_STOCK = 240
WC_SM2_Slot_8_Rear_Shield_STOCK = 240
WC_SM2_Slot_8_Front_Arm_STOCK = 220
WC_SM2_Slot_8_Rear_Arm_STOCK = 200
WC_SM2_Slot_8_Left_Arm_STOCK = 200
WC_SM2_Slot_8_Right_Arm_STOCK = 200
WC_SM2_Slot_9_Front_Shield_STOCK = 300
WC_SM2_Slot_9_Rear_Shield_STOCK = 300
WC_SM2_Slot_9_Front_Arm_STOCK = 240
WC_SM2_Slot_9_Rear_Arm_STOCK = 200
WC_SM2_Slot_9_Left_Arm_STOCK = 250
WC_SM2_Slot_9_Right_Arm_STOCK = 250

##################################################
###WING COMMANDER II SHIT HERE
###################################################

WC2_Asteroid_Radius_STOCK = 100

###WC2.EXE (GOG) Asteroid Radius Offsets
WC2_Asteroid_1_Radius = 121624
WC2_Asteroid_2_Radius = 121867
WC2_Asteroid_3_Radius = 122110
WC2_Asteroid_4_Radius = 122353
WC2_Asteroid_5_Radius = 122596
WC2_Asteroid_6_Radius = 122839

###SO1.EXE (GOG) Asteroid Radius Offsets
WC2_SO1_Asteroid_1_Radius = 121938
WC2_SO1_Asteroid_2_Radius = 122181
WC2_SO1_Asteroid_3_Radius = 122424
WC2_SO1_Asteroid_4_Radius = 122667
WC2_SO1_Asteroid_5_Radius = 122910
WC2_SO1_Asteroid_6_Radius = 123153

###SO2.EXE (GOG) Asteroid Radius Offsets
WC2_SO2_Asteroid_1_Radius = 120504
WC2_SO2_Asteroid_2_Radius = 120747
WC2_SO2_Asteroid_3_Radius = 120990
WC2_SO2_Asteroid_4_Radius = 121233
WC2_SO2_Asteroid_5_Radius = 121476
WC2_SO2_Asteroid_6_Radius = 121719

########WC2 SHIPS########
FERRET_STOCK_FrontShield = 60
FERRET_STOCK_RearShield = 60
FERRET_STOCK_FrontArmor = 65
FERRET_STOCK_RearArmor = 65
FERRET_STOCK_LeftArmor = 45
FERRET_STOCK_RightArmor = 45
FERRET_FrontShield_OFFSET = 73369
FERRET_RearShield_OFFSET = 73371
FERRET_FrontArmor_OFFSET = 73373
FERRET_RearArmor_OFFSET = 73375
FERRET_LeftArmor_OFFSET = 73377
FERRET_RightArmor_OFFSET = 73379

WC2_RAPIER_STOCK_FrontShield = 115
WC2_RAPIER_STOCK_RearShield = 115
WC2_RAPIER_STOCK_FrontArmor = 75
WC2_RAPIER_STOCK_RearArmor = 75
WC2_RAPIER_STOCK_LeftArmor = 65
WC2_RAPIER_STOCK_RightArmor = 65
WC2_RAPIER_FrontShield_OFFSET = 76852
WC2_RAPIER_RearShield_OFFSET = 76854
WC2_RAPIER_FrontArmor_OFFSET = 76856
WC2_RAPIER_RearArmor_OFFSET = 76858
WC2_RAPIER_LeftArmor_OFFSET = 76860
WC2_RAPIER_RightArmor_OFFSET = 76862

BROADSWORD_STOCK_FrontShield = 500
BROADSWORD_STOCK_RearShield = 500
BROADSWORD_STOCK_FrontArmor = 400
BROADSWORD_STOCK_RearArmor = 400
BROADSWORD_STOCK_LeftArmor = 350
BROADSWORD_STOCK_RightArmor = 350
BROADSWORD_FrontShield_OFFSET = 80835
BROADSWORD_RearShield_OFFSET = 80837
BROADSWORD_FrontArmor_OFFSET = 80839
BROADSWORD_RearArmor_OFFSET = 80841
BROADSWORD_LeftArmor_OFFSET = 80843
BROADSWORD_RightArmor_OFFSET = 80845

EPEE_FILENAME = "SHIP.V03"
EPEE_STOCK_FrontShield = 60
EPEE_STOCK_RearShield = 60
EPEE_STOCK_FrontArmor = 35
EPEE_STOCK_RearArmor = 35
EPEE_STOCK_LeftArmor = 30
EPEE_STOCK_RightArmor = 30
EPEE_FrontShield_OFFSET = 71028
EPEE_RearShield_OFFSET = 71030
EPEE_FrontArmor_OFFSET = 71032
EPEE_RearArmor_OFFSET = 71034
EPEE_LeftArmor_OFFSET = 71036
EPEE_RightArmor_OFFSET = 71038

SABRE_STOCK_FrontShield = 80
SABRE_STOCK_RearShield = 80
SABRE_STOCK_FrontArmor = 200
SABRE_STOCK_RearArmor = 200
SABRE_STOCK_LeftArmor = 180
SABRE_STOCK_RightArmor = 180
SABRE_FrontShield_OFFSET = 73040
SABRE_RearShield_OFFSET = 73042
SABRE_FrontArmor_OFFSET = 73044
SABRE_RearArmor_OFFSET = 73046
SABRE_LeftArmor_OFFSET = 73048
SABRE_RightArmor_OFFSET = 73050

CLYDESDALE_STOCK_FrontShield = 300
CLYDESDALE_STOCK_RearShield = 300
CLYDESDALE_STOCK_FrontArmor = 240
CLYDESDALE_STOCK_RearArmor = 240
CLYDESDALE_STOCK_LeftArmor = 220
CLYDESDALE_STOCK_RightArmor = 220
CLYDESDALE_FrontShield_OFFSET = 157204
CLYDESDALE_RearShield_OFFSET = 157206
CLYDESDALE_FrontArmor_OFFSET = 157208
CLYDESDALE_RearArmor_OFFSET = 157210
CLYDESDALE_LeftArmor_OFFSET = 157212
CLYDESDALE_RightArmor_OFFSET = 157214

FREETRADER_STOCK_FrontShield = 95
FREETRADER_STOCK_RearShield = 95
FREETRADER_STOCK_FrontArmor = 240
FREETRADER_STOCK_RearArmor = 240
FREETRADER_STOCK_LeftArmor = 200
FREETRADER_STOCK_RightArmor = 200
FREETRADER_FrontShield_OFFSET = 123406
FREETRADER_RearShield_OFFSET = 123408
FREETRADER_FrontArmor_OFFSET = 123410
FREETRADER_RearArmor_OFFSET = 123412
FREETRADER_LeftArmor_OFFSET = 123414
FREETRADER_RightArmor_OFFSET = 123416

CROSSBOW_STOCK_FrontShield = 500
CROSSBOW_STOCK_RearShield = 500
CROSSBOW_STOCK_FrontArmor = 400
CROSSBOW_STOCK_RearArmor = 400
CROSSBOW_STOCK_LeftArmor = 350
CROSSBOW_STOCK_RightArmor = 350
CROSSBOW_FrontShield_OFFSET = 83841
CROSSBOW_RearShield_OFFSET = 83843
CROSSBOW_FrontArmor_OFFSET = 83845
CROSSBOW_RearArmor_OFFSET = 83847
CROSSBOW_LeftArmor_OFFSET = 83849
CROSSBOW_RightArmor_OFFSET = 83851

WATERLOO_STOCK_FrontShield = 1000
WATERLOO_STOCK_RearShield = 1000
WATERLOO_STOCK_FrontArmor = 300
WATERLOO_STOCK_RearArmor = 300
WATERLOO_STOCK_LeftArmor = 250
WATERLOO_STOCK_RightArmor = 250
WATERLOO_FrontShield_OFFSET = 137418
WATERLOO_RearShield_OFFSET = 137420
WATERLOO_FrontArmor_OFFSET = 137422
WATERLOO_RearArmor_OFFSET = 137424
WATERLOO_LeftArmor_OFFSET = 137426
WATERLOO_RightArmor_OFFSET = 137428

CONFEDERATION_STOCK_FrontShield = 5000
CONFEDERATION_STOCK_RearShield = 5000
CONFEDERATION_STOCK_FrontArmor = 775
CONFEDERATION_STOCK_RearArmor = 775
CONFEDERATION_STOCK_LeftArmor = 675
CONFEDERATION_STOCK_RightArmor = 675
CONFEDERATION_FrontShield_OFFSET = 176976
CONFEDERATION_RearShield_OFFSET = 176978
CONFEDERATION_FrontArmor_OFFSET = 176980
CONFEDERATION_RearArmor_OFFSET = 176982
CONFEDERATION_LeftArmor_OFFSET = 176984
CONFEDERATION_RightArmor_OFFSET = 176986

GILGAMESH_STOCK_FrontShield = 1100
GILGAMESH_STOCK_RearShield = 1100
GILGAMESH_STOCK_FrontArmor = 580
GILGAMESH_STOCK_RearArmor = 580
GILGAMESH_STOCK_LeftArmor = 500
GILGAMESH_STOCK_RightArmor = 500
GILGAMESH_FrontShield_OFFSET = 128833
GILGAMESH_RearShield_OFFSET = 128835
GILGAMESH_FrontArmor_OFFSET = 128837
GILGAMESH_RearArmor_OFFSET = 128839
GILGAMESH_LeftArmor_OFFSET = 128841
GILGAMESH_RightArmor_OFFSET = 128843

TERRAN_STARBASE_STOCK_FrontShield = 1000
TERRAN_STARBASE_STOCK_RearShield = 1000
TERRAN_STARBASE_STOCK_FrontArmor = 900
TERRAN_STARBASE_STOCK_RearArmor = 850
TERRAN_STARBASE_STOCK_LeftArmor = 850
TERRAN_STARBASE_STOCK_RightArmor = 850
TERRAN_STARBASE_FrontShield_OFFSET = 75235
TERRAN_STARBASE_RearShield_OFFSET = 75237
TERRAN_STARBASE_FrontArmor_OFFSET = 75239
TERRAN_STARBASE_RearArmor_OFFSET = 75241
TERRAN_STARBASE_LeftArmor_OFFSET = 75243
TERRAN_STARBASE_RightArmor_OFFSET = 75245

TERRAN_SUPPLYDEPOT_STOCK_FrontShield = 300
TERRAN_SUPPLYDEPOT_STOCK_RearShield = 300
TERRAN_SUPPLYDEPOT_STOCK_FrontArmor = 180
TERRAN_SUPPLYDEPOT_STOCK_RearArmor = 180
TERRAN_SUPPLYDEPOT_STOCK_LeftArmor = 160
TERRAN_SUPPLYDEPOT_STOCK_RightArmor = 160
TERRAN_SUPPLYDEPOT_FrontShield_OFFSET = 119474
TERRAN_SUPPLYDEPOT_RearShield_OFFSET = 119476
TERRAN_SUPPLYDEPOT_FrontArmor_OFFSET = 119478
TERRAN_SUPPLYDEPOT_RearArmor_OFFSET = 119480
TERRAN_SUPPLYDEPOT_LeftArmor_OFFSET = 119482
TERRAN_SUPPLYDEPOT_RightArmor_OFFSET = 119484

MORNINGSTAR_STOCK_FrontShield = 150
MORNINGSTAR_STOCK_RearShield = 150
MORNINGSTAR_STOCK_FrontArmor = 200
MORNINGSTAR_STOCK_RearArmor = 200
MORNINGSTAR_STOCK_LeftArmor = 200
MORNINGSTAR_STOCK_RightArmor = 200
MORNINGSTAR_FrontShield_OFFSET = 69100
MORNINGSTAR_RearShield_OFFSET = 69102
MORNINGSTAR_FrontArmor_OFFSET = 69104
MORNINGSTAR_RearArmor_OFFSET = 69106
MORNINGSTAR_LeftArmor_OFFSET = 69108
MORNINGSTAR_RightArmor_OFFSET = 69110

##################################

print ("WING HARD (v.1.5) is designed to allow you to adjust various")
print ("difficulty portions of Wing Commander I/II so that you")
print ("can get the difficulty you want; to enjoy the story and")
print ("have a good time in the dogfights in your middle-age;")
print ("as opposed to your youth, when you had near unlimited")
print ("free time to play the game over and over.")
print ("")
print ("Currently, only the GOG editions are supported. This is")
print ("unlikely to change.")
print ("")

#[DETECT GAMES INSTALLED HERE]

#INITIALIZATION OUTSIDE IF LOOPS TO PREVENT CRASHES.
WC1 = "FALSE"
WC2 = "FALSE"

if ((os.path.isfile("WC.EXE",) == True) and (os.path.isfile("SM2.EXE") == True) ):
    WC1 = "TRUE"
    print("Wing Commander 1 is in this directory!")

if ((os.path.isfile("WC2.EXE") == True) and (os.path.isfile("SO1.EXE") == True) and (os.path.isfile("SO2.EXE") == True) ):
    WC2 = "TRUE"
    print("Wing Commander 2 is in this directory!")

print ("")
print("#################################################")
print ("")
print("COMBAT DIFFICULTY")
print("")
print("Combat Difficulty is changed via increasing or decreasing the")
print("shield/armor values of all TCN craft in the game through a")
print("multiplication factor.")   
print("")
print("Entering 0.5 will decrease shield/armor ratings by 50% (4 cm now 2 cm)")
print("Entering 1.0 will multiply by 1 and reset your game to stock values.")
print("Entering 1.5 will increase shield/armor ratings by 50% (4 cm now 6 cm)")
print("")
print("This will allow adjustable difficulty for the game.")
print("")
print("If you are playing WC2, it is recommended to keep the multiplier below")
print("1.5x to avoid the Broadsword from having Phase Transit Shields.")
print("")
MULTIPLIER = input("Enter Multiplier Value to Use: ")
MULTIPLIER = float(MULTIPLIER)

if (WC1 == "TRUE"):
    EditTwoByteValue("WC.EXE", WC_Slot_1_FrontShield, WC_Slot_1_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_1_RearShield, WC_Slot_1_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_1_FrontArmor, WC_Slot_1_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_1_RearArmor, WC_Slot_1_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_1_LeftArmor, WC_Slot_1_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_1_RightArmor, WC_Slot_1_RightArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_2_FrontShield, WC_Slot_2_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_2_RearShield, WC_Slot_2_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_2_FrontArmor, WC_Slot_2_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_2_RearArmor, WC_Slot_2_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_2_LeftArmor, WC_Slot_2_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_2_RightArmor, WC_Slot_2_RightArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_3_FrontShield, WC_Slot_3_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_3_RearShield, WC_Slot_3_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_3_FrontArmor, WC_Slot_3_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_3_RearArmor, WC_Slot_3_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_3_LeftArmor, WC_Slot_3_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_3_RightArmor, WC_Slot_3_RightArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_4_FrontShield, WC_Slot_4_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_4_RearShield, WC_Slot_4_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_4_FrontArmor, WC_Slot_4_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_4_RearArmor, WC_Slot_4_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_4_LeftArmor, WC_Slot_4_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_4_RightArmor, WC_Slot_4_RightArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_5_FrontShield, WC_Slot_5_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_5_RearShield, WC_Slot_5_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_5_FrontArmor, WC_Slot_5_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_5_RearArmor, WC_Slot_5_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_5_LeftArmor, WC_Slot_5_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_5_RightArmor, WC_Slot_5_RightArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_6_FrontShield, WC_Slot_6_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_6_RearShield, WC_Slot_6_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_6_FrontArmor, WC_Slot_6_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_6_RearArmor, WC_Slot_6_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_6_LeftArmor, WC_Slot_6_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_6_RightArmor, WC_Slot_6_RightArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_7_FrontShield, WC_Slot_7_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_7_RearShield, WC_Slot_7_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_7_FrontArmor, WC_Slot_7_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_7_RearArmor, WC_Slot_7_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_7_LeftArmor, WC_Slot_7_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_7_RightArmor, WC_Slot_7_RightArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_8_FrontShield, WC_Slot_8_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_8_RearShield, WC_Slot_8_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_8_FrontArmor, WC_Slot_8_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_8_RearArmor, WC_Slot_8_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_8_LeftArmor, WC_Slot_8_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_8_RightArmor, WC_Slot_8_RightArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_9_FrontShield, WC_Slot_9_FrontShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_9_RearShield, WC_Slot_9_RearShield_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_9_FrontArmor, WC_Slot_9_FrontArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_9_RearArmor, WC_Slot_9_RearArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_9_LeftArmor, WC_Slot_9_LeftArmor_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Slot_9_RightArmor, WC_Slot_9_RightArmor_STOCK, MULTIPLIER)

    ##DO SECRET MISSIONS 2 STUFF HERE.
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_1_Front_Shield, WC_SM2_Slot_1_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_1_Rear_Shield, WC_SM2_Slot_1_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_1_Front_Arm, WC_SM2_Slot_1_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_1_Rear_Arm, WC_SM2_Slot_1_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_1_Left_Arm, WC_SM2_Slot_1_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_1_Right_Arm, WC_SM2_Slot_1_Right_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_2_Front_Shield, WC_SM2_Slot_2_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_2_Rear_Shield, WC_SM2_Slot_2_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_2_Front_Arm, WC_SM2_Slot_2_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_2_Rear_Arm, WC_SM2_Slot_2_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_2_Left_Arm, WC_SM2_Slot_2_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_2_Right_Arm, WC_SM2_Slot_2_Right_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_3_Front_Shield, WC_SM2_Slot_3_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_3_Rear_Shield, WC_SM2_Slot_3_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_3_Front_Arm, WC_SM2_Slot_3_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_3_Rear_Arm, WC_SM2_Slot_3_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_3_Left_Arm, WC_SM2_Slot_3_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_3_Right_Arm, WC_SM2_Slot_3_Right_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_4_Front_Shield, WC_SM2_Slot_4_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_4_Rear_Shield, WC_SM2_Slot_4_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_4_Front_Arm, WC_SM2_Slot_4_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_4_Rear_Arm, WC_SM2_Slot_4_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_4_Left_Arm, WC_SM2_Slot_4_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_4_Right_Arm, WC_SM2_Slot_4_Right_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_5_Front_Shield, WC_SM2_Slot_5_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_5_Rear_Shield, WC_SM2_Slot_5_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_5_Front_Arm, WC_SM2_Slot_5_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_5_Rear_Arm, WC_SM2_Slot_5_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_5_Left_Arm, WC_SM2_Slot_5_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_5_Right_Arm, WC_SM2_Slot_5_Right_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_6_Front_Shield, WC_SM2_Slot_6_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_6_Rear_Shield, WC_SM2_Slot_6_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_6_Front_Arm, WC_SM2_Slot_6_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_6_Rear_Arm, WC_SM2_Slot_6_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_6_Left_Arm, WC_SM2_Slot_6_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_6_Right_Arm, WC_SM2_Slot_6_Right_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_7_Front_Shield, WC_SM2_Slot_7_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_7_Rear_Shield, WC_SM2_Slot_7_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_7_Front_Arm, WC_SM2_Slot_7_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_7_Rear_Arm, WC_SM2_Slot_7_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_7_Left_Arm, WC_SM2_Slot_7_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_7_Right_Arm, WC_SM2_Slot_7_Right_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_8_Front_Shield, WC_SM2_Slot_8_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_8_Rear_Shield, WC_SM2_Slot_8_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_8_Front_Arm, WC_SM2_Slot_8_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_8_Rear_Arm, WC_SM2_Slot_8_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_8_Left_Arm, WC_SM2_Slot_8_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_8_Right_Arm, WC_SM2_Slot_8_Right_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_9_Front_Shield, WC_SM2_Slot_9_Front_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_9_Rear_Shield, WC_SM2_Slot_9_Rear_Shield_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_9_Front_Arm, WC_SM2_Slot_9_Front_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_9_Rear_Arm, WC_SM2_Slot_9_Rear_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_9_Left_Arm, WC_SM2_Slot_9_Left_Arm_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM2_Slot_9_Right_Arm, WC_SM2_Slot_9_Right_Arm_STOCK, MULTIPLIER)

###########################################################################################################
    
if (WC2 == "TRUE"):

    #FERRET
    EditTwoByteValue("GAMEDAT\SHIP.V00", FERRET_FrontShield_OFFSET, FERRET_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V00", FERRET_RearShield_OFFSET, FERRET_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V00", FERRET_FrontArmor_OFFSET, FERRET_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V00", FERRET_RearArmor_OFFSET, FERRET_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V00", FERRET_LeftArmor_OFFSET, FERRET_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V00", FERRET_RightArmor_OFFSET, FERRET_STOCK_RightArmor, MULTIPLIER)

    #RAPIER (WC2 VERSION)
    EditTwoByteValue("GAMEDAT\SHIP.V01", WC2_RAPIER_FrontShield_OFFSET, WC2_RAPIER_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V01", WC2_RAPIER_RearShield_OFFSET, WC2_RAPIER_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V01", WC2_RAPIER_FrontArmor_OFFSET, WC2_RAPIER_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V01", WC2_RAPIER_RearArmor_OFFSET, WC2_RAPIER_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V01", WC2_RAPIER_LeftArmor_OFFSET, WC2_RAPIER_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V01", WC2_RAPIER_RightArmor_OFFSET, WC2_RAPIER_STOCK_RightArmor, MULTIPLIER)

    #BROADSWORD
    EditTwoByteValue("GAMEDAT\SHIP.V02", BROADSWORD_FrontShield_OFFSET, BROADSWORD_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V02", BROADSWORD_RearShield_OFFSET, BROADSWORD_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V02", BROADSWORD_FrontArmor_OFFSET, BROADSWORD_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V02", BROADSWORD_RearArmor_OFFSET, BROADSWORD_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V02", BROADSWORD_LeftArmor_OFFSET, BROADSWORD_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V02", BROADSWORD_RightArmor_OFFSET, BROADSWORD_STOCK_RightArmor, MULTIPLIER)

    #EPEE
    EditTwoByteValue("GAMEDAT\SHIP.V03", EPEE_FrontShield_OFFSET, EPEE_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V03", EPEE_RearShield_OFFSET, EPEE_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V03", EPEE_FrontArmor_OFFSET, EPEE_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V03", EPEE_RearArmor_OFFSET, EPEE_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V03", EPEE_LeftArmor_OFFSET, EPEE_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V03", EPEE_RightArmor_OFFSET, EPEE_STOCK_RightArmor, MULTIPLIER)

    #SABRE
    EditTwoByteValue("GAMEDAT\SHIP.V04", SABRE_FrontShield_OFFSET, SABRE_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V04", SABRE_RearShield_OFFSET, SABRE_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V04", SABRE_FrontArmor_OFFSET, SABRE_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V04", SABRE_RearArmor_OFFSET, SABRE_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V04", SABRE_LeftArmor_OFFSET, SABRE_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V04", SABRE_RightArmor_OFFSET, SABRE_STOCK_RightArmor, MULTIPLIER)

    #CLYDESDALE
    EditTwoByteValue("GAMEDAT\SHIP.V11", CLYDESDALE_FrontShield_OFFSET, CLYDESDALE_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V11", CLYDESDALE_RearShield_OFFSET, CLYDESDALE_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V11", CLYDESDALE_FrontArmor_OFFSET, CLYDESDALE_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V11", CLYDESDALE_RearArmor_OFFSET, CLYDESDALE_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V11", CLYDESDALE_LeftArmor_OFFSET, CLYDESDALE_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V11", CLYDESDALE_RightArmor_OFFSET, CLYDESDALE_STOCK_RightArmor, MULTIPLIER)

    #FREE TRADER
    EditTwoByteValue("GAMEDAT\SHIP.V12", FREETRADER_FrontShield_OFFSET, FREETRADER_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V12", FREETRADER_RearShield_OFFSET, FREETRADER_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V12", FREETRADER_FrontArmor_OFFSET, FREETRADER_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V12", FREETRADER_RearArmor_OFFSET, FREETRADER_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V12", FREETRADER_LeftArmor_OFFSET, FREETRADER_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V12", FREETRADER_RightArmor_OFFSET, FREETRADER_STOCK_RightArmor, MULTIPLIER)

    #CROSSBOW
    EditTwoByteValue("GAMEDAT\SHIP.V15", CROSSBOW_FrontShield_OFFSET, CROSSBOW_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V15", CROSSBOW_RearShield_OFFSET, CROSSBOW_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V15", CROSSBOW_FrontArmor_OFFSET, CROSSBOW_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V15", CROSSBOW_RearArmor_OFFSET, CROSSBOW_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V15", CROSSBOW_LeftArmor_OFFSET, CROSSBOW_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V15", CROSSBOW_RightArmor_OFFSET, CROSSBOW_STOCK_RightArmor, MULTIPLIER)

    #WATERLOO
    EditTwoByteValue("GAMEDAT\SHIP.V17", WATERLOO_FrontShield_OFFSET, WATERLOO_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V17", WATERLOO_RearShield_OFFSET, WATERLOO_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V17", WATERLOO_FrontArmor_OFFSET, WATERLOO_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V17", WATERLOO_RearArmor_OFFSET, WATERLOO_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V17", WATERLOO_LeftArmor_OFFSET, WATERLOO_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V17", WATERLOO_RightArmor_OFFSET, WATERLOO_STOCK_RightArmor, MULTIPLIER)

    #CONFEDERATION (CONCORDIA)
    EditTwoByteValue("GAMEDAT\SHIP.V18", CONFEDERATION_FrontShield_OFFSET, CONFEDERATION_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V18", CONFEDERATION_RearShield_OFFSET, CONFEDERATION_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V18", CONFEDERATION_FrontArmor_OFFSET, CONFEDERATION_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V18", CONFEDERATION_RearArmor_OFFSET, CONFEDERATION_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V18", CONFEDERATION_LeftArmor_OFFSET, CONFEDERATION_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V18", CONFEDERATION_RightArmor_OFFSET, CONFEDERATION_STOCK_RightArmor, MULTIPLIER)

    #GILGAMESH
    EditTwoByteValue("GAMEDAT\SHIP.V19", GILGAMESH_FrontShield_OFFSET, GILGAMESH_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V19", GILGAMESH_RearShield_OFFSET, GILGAMESH_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V19", GILGAMESH_FrontArmor_OFFSET, GILGAMESH_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V19", GILGAMESH_RearArmor_OFFSET, GILGAMESH_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V19", GILGAMESH_LeftArmor_OFFSET, GILGAMESH_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V19", GILGAMESH_RightArmor_OFFSET, GILGAMESH_STOCK_RightArmor, MULTIPLIER)

    #TERRAN STARBASE
    EditTwoByteValue("GAMEDAT\SHIP.V23", TERRAN_STARBASE_FrontShield_OFFSET, TERRAN_STARBASE_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V23", TERRAN_STARBASE_RearShield_OFFSET, TERRAN_STARBASE_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V23", TERRAN_STARBASE_FrontArmor_OFFSET, TERRAN_STARBASE_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V23", TERRAN_STARBASE_RearArmor_OFFSET, TERRAN_STARBASE_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V23", TERRAN_STARBASE_LeftArmor_OFFSET, TERRAN_STARBASE_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V23", TERRAN_STARBASE_RightArmor_OFFSET, TERRAN_STARBASE_STOCK_RightArmor, MULTIPLIER)

    #TERRAN SUPPLY DEPOT
    EditTwoByteValue("GAMEDAT\SHIP.V24", TERRAN_SUPPLYDEPOT_FrontShield_OFFSET, TERRAN_SUPPLYDEPOT_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V24", TERRAN_SUPPLYDEPOT_RearShield_OFFSET, TERRAN_SUPPLYDEPOT_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V24", TERRAN_SUPPLYDEPOT_FrontArmor_OFFSET, TERRAN_SUPPLYDEPOT_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V24", TERRAN_SUPPLYDEPOT_RearArmor_OFFSET, TERRAN_SUPPLYDEPOT_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V24", TERRAN_SUPPLYDEPOT_LeftArmor_OFFSET, TERRAN_SUPPLYDEPOT_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V24", TERRAN_SUPPLYDEPOT_RightArmor_OFFSET, TERRAN_SUPPLYDEPOT_STOCK_RightArmor, MULTIPLIER)

    #MORNINGSTAR
    EditTwoByteValue("GAMEDAT\SHIP.V41", MORNINGSTAR_FrontShield_OFFSET, MORNINGSTAR_STOCK_FrontShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V41", MORNINGSTAR_RearShield_OFFSET, MORNINGSTAR_STOCK_RearShield, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V41", MORNINGSTAR_FrontArmor_OFFSET, MORNINGSTAR_STOCK_FrontArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V41", MORNINGSTAR_RearArmor_OFFSET, MORNINGSTAR_STOCK_RearArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V41", MORNINGSTAR_LeftArmor_OFFSET, MORNINGSTAR_STOCK_LeftArmor, MULTIPLIER)
    EditTwoByteValue("GAMEDAT\SHIP.V41", MORNINGSTAR_RightArmor_OFFSET, MORNINGSTAR_STOCK_RightArmor, MULTIPLIER)

#######################

print ("")
print("All TCN Ships/Craft have had their protective ratings multiplied by " + str(MULTIPLIER) +"x!")
print ("")
print("#################################################")
print ("")
print("ASTEROID DIFFICULTY")
print("")
print("Asteroid Difficulty is changed via changing the radius of asteroids")
print("in the game via a multiplier. Radius is effectively the size of the")
print("in-game collision hitbox.")
print("")
print("Stock Asteroids have a radius of 100 in both WC1 and WC2.")
print("")
print("Entering 0.5 will decrease radius by 50% (100 radius becomes 50 radius)")
print("Entering 1.0 will multiply by 1 and reset your game to stock values.")
print("Entering 1.5 will increase radius by 50% (100 radius becomes 150 radius)")
print("")
print("This will allow adjustable difficulty for in-game asteroid fields.")
print("")
print("NOTE: Entering 0.05 will decrease asteroid radius to 5, effectively")
print("neutering asteroid fields in the game, useful if you don't want to deal")
print("with them again.")
print("")
MULTIPLIER = input("Enter Multiplier Value to Use: ")
MULTIPLIER = float(MULTIPLIER)

if (WC1 == "TRUE"):
    EditTwoByteValue("WC.EXE", WC_Asteroid_1_Radius, WC_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Asteroid_2_Radius, WC_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Asteroid_3_Radius, WC_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Asteroid_4_Radius, WC_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Asteroid_5_Radius, WC_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC.EXE", WC_Asteroid_6_Radius, WC_Asteroid_Radius_STOCK, MULTIPLIER)
    
    EditTwoByteValue("SM2.EXE", WC_SM_Asteroid_1_Radius, WC_SM_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM_Asteroid_2_Radius, WC_SM_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM_Asteroid_3_Radius, WC_SM_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM_Asteroid_4_Radius, WC_SM_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM_Asteroid_5_Radius, WC_SM_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SM2.EXE", WC_SM_Asteroid_6_Radius, WC_SM_Asteroid_Radius_STOCK, MULTIPLIER)

###################
    
if (WC2 == "TRUE"):
    EditTwoByteValue("WC2.EXE", WC2_Asteroid_1_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC2.EXE", WC2_Asteroid_2_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC2.EXE", WC2_Asteroid_3_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC2.EXE", WC2_Asteroid_4_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC2.EXE", WC2_Asteroid_5_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("WC2.EXE", WC2_Asteroid_6_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    
    EditTwoByteValue("SO1.EXE", WC2_SO1_Asteroid_1_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO1.EXE", WC2_SO1_Asteroid_2_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO1.EXE", WC2_SO1_Asteroid_3_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO1.EXE", WC2_SO1_Asteroid_4_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO1.EXE", WC2_SO1_Asteroid_5_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO1.EXE", WC2_SO1_Asteroid_6_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    
    EditTwoByteValue("SO2.EXE", WC2_SO2_Asteroid_1_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO2.EXE", WC2_SO2_Asteroid_2_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO2.EXE", WC2_SO2_Asteroid_3_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO2.EXE", WC2_SO2_Asteroid_4_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO2.EXE", WC2_SO2_Asteroid_5_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)
    EditTwoByteValue("SO2.EXE", WC2_SO2_Asteroid_6_Radius, WC2_Asteroid_Radius_STOCK, MULTIPLIER)

print ("")
print("All Asteroids have had their in-game radius multiplied by " + str(MULTIPLIER) +"x!")
print ("")
input("All Edits Completed and HOLDING....")
