/*===================================*/
/*                                   */
/* Music Quet Programmer's ToolKit   */
/*                                   */
/* Tape sync features                */
/*                                   */
/* Copyright (c) 1988                */
/* By Music Quest, Inc.              */
/*                                   */
/*===================================*/
#include "stdio.h"
#include "stdlib.h"
#include "conio.h"
#include "bios.h"
#include "ctype.h"
#include "fcntl.h"
#include "stat.h"
#include "\ptk\asm\mcc.h"
#include "tkxmpl.h"

/*===================================*/
/*                                   */
/* Chase Lock - SPP display          */
/*                                   */
/*===================================*/
void show_spp()
{
  int running;
  int spp_val;
  int rtcmd;

  clrscr();
  gotoxy(12,1);
  cputs("MCC/MQX-32 Programmer's ToolKit - Song Position Pointer");
  gotoxy(21,23);
  cputs("Please start the tape or ESC to return");

  running=0;
  set_slih(coproc_slih);
  mcc_reset();                          /* return to coproc mode */
  mcc_command(DISABLE_ALL_THRU);        /* disable thru */
  mcc_command(DISABLE_THRU);
  mcc_command(ENABLE_SYSCOM_PC);        /* enable SPP msgs */
  mcc_command(ENABLE_RT_PC);            /* enable real time msgs */
  mcc_command(ACTIVE_TRACKS);           /* no tracks active */
  mcc_put(0);
  mcc_command(ENABLE_MIDI_CTRL);        /* enable external MIDI control */
  mcc_command(CLS_MODE);                /* enable CLS sync mode */
  mcc_command(MIDI_SYNCH);

  while (!bioskey(1))                   /* until some key is hit */
    {
      if (spp_efw(&spp_val))            /* if SPP received */
        {
          if (!running)                 /* replace prompt */
            {
              gotoxy(1,23);
              clreol();
              gotoxy(30,23);
              cputs("Press ESC to return");
            }
          running=1;
          gotoxy(20,12);
          cprintf("SPP=%d (%04X) Measure(4/4)=%d Beat(4/4)=%d",
                  spp_val,spp_val,(spp_val/16)+1,((spp_val%16)/4)+1);
        }
      if ((rtcmd=realtime_efw()) != 0)
        {
          gotoxy(33,14);                /* display MIDI status */
          clreol();
          switch (rtcmd)
            {
              case 0xFA:                /* start */
                gotoxy(20,12);
                clreol();
                gotoxy(33,14);
                clreol();
                cputs("MIDI Start");
                break;
              case 0xFB:                /* continue */
                cputs("MIDI Continue");
                break;
              case 0xFC:                /* stop */
                cputs("MIDI Stop");
                gotoxy(1,12);
                clreol();
                break;
              default:
                break;
            }
        }
    }

  mcc_reset();                          /* return to coproc mode */
  bioskey(0);                           /* read exit key */
}

/*===================================*/
/*                                   */
/* SMPTE frame trace                 */
/*                                   */
/*===================================*/
void show_smpte()
{
  int running;
  unsigned char smpte_addr[4];

  clrscr();
  gotoxy(15,1);
  cputs("MCC/MQX-32 Programmer's ToolKit - SMPTE Frame Trace");
  gotoxy(21,24);
  cputs("Please start the tape or ESC to return");

  running=0;
  set_slih(coproc_slih);
  mcc_command(ENABLE_SMPTE_MSG);
  mcc_command(DISABLE_ALL_THRU);
  mcc_command(DISABLE_THRU);

  mcc_command(SMPTE_MODE);
  mcc_command(START_SMPTE_READ);

  while (!bioskey(1))                   /* until some key is hit */
    {
      if (smpte_efw(smpte_addr))        /* if a SMPTE frame address received */
        {
          if (!running)                 /* replace prompt */
            {
              gotoxy(1,24);
              clreol();
              gotoxy(30,24);
              cputs("Press ESC to return");
            }
          running=1;
          gotoxy(36,12);                /* display frame address */
          cprintf("%02d:%02d:%02d:%02d",smpte_addr[0] & 0x1F,
                                        smpte_addr[1],
                                        smpte_addr[2],
                                        smpte_addr[3]);
        }
      if (strk_end_efw())               /* check for end of track */
        {
          gotoxy(31,16);
          cputs("End of SMPTE Track");
        }
    }

  mcc_reset();                          /* return to coproc mode */
  bioskey(0);                           /* read exit key */
}

/*===================================*/
/*                                   */
/* SMPTE cue point                   */
/*                                   */
/*===================================*/
void cue_point()
{
  int hh, mm, ss, fr;
  int running;
  unsigned char smpte_addr[4];


  clrscr();
  gotoxy(11,1);
  cputs("MCC/MQX-32 Programmer's ToolKit - SMPTE Cue Point Example");
  gotoxy(1,12);
  cputs("Enter cue point (hh mm ss fr): ");
  scanf("%d %d %d %d",&hh,&mm,&ss,&fr);
  gotoxy(1,12);;
  clreol();
  gotoxy(24,10);
  cprintf("Cue point = %02d:%02d:%02d:%02d",hh,mm,ss,fr);

  hh=hh | 0x60;

  set_slih(coproc_slih);
  mcc_command(DISABLE_ALL_THRU);
  mcc_command(DISABLE_THRU);
  mcc_command(ENABLE_SMPTE_MSG);        /* enable SMPTE frame messages */
  mcc_command(SMPTE_CONTROL);           /* set up the cue point */
  mcc_put(SMPTE_CUE_POINT);
  mcc_put(hh);
  mcc_put(mm);
  mcc_put(ss);
  mcc_put(fr);

  mcc_command(SMPTE_MODE);
  mcc_command(START_SMPTE_READ);

  gotoxy(21,24);
  cputs("Please start the tape or ESC to return");
  running=0;

  while (!bioskey(1))                   /* until some key is hit */
    {
      if (smpte_efw(smpte_addr))        /* if a SMPTE frame address received */
        {
          if (!running)                 /* replace prompt */
            {
              gotoxy(1,24);
              clreol();
              gotoxy(30,24);
              cputs("Press ESC to return");
            }
          running=1;
          gotoxy(36,12);                /* display frame address */
          cprintf("%02d:%02d:%02d:%02d",smpte_addr[0] & 0x1F,
                                        smpte_addr[1],
                                        smpte_addr[2],
                                        smpte_addr[3]);
        }

      if (cuepoint_efw())
        {
          gotoxy(32,14);                /* display frame address */
          cputs("CUE POINT HIT!!");
        }
      if (strk_end_efw())               /* check for end of track */
        {
          gotoxy(31,16);
          cputs("End of SMPTE Track");
        }
    }

  mcc_reset();                          /* return to coproc mode */
  bioskey(0);                           /* read exit key */
}

/*===================================*/
/*                                   */
/* Write SMPTE track                 */
/*                                   */
/*===================================*/
void write_smpte()
{
  int hh, mm;
  unsigned char smpte_addr[4];
  int ohh, omm, oss, ofr;
  int dur;
  int running;

  clrscr();
  gotoxy(11,1);
  cputs("MCC/MQX-32 Programmer's ToolKit - Write SMPTE Track");
  gotoxy(1,8);
  cputs("Enter SMPTE origin (hh mm ss fr): ");
  scanf("%d %d %d %d",&ohh,&omm,&oss,&ofr);
  cputs("How many minutes of tape (1-60): ");
  scanf("%d",&dur);

  ohh=ohh | 0x60;                       /* force 30 frame non-drop */
  mm=(omm+dur) % 60;                    /* calc cue point for end */
  hh=ohh+((omm+dur)/60);

  mcc_reset();                          /* put MQX-32 into known state */
  set_slih(coproc_slih);

  mcc_command(ENABLE_SMPTE_MSG);        /* enable SMPTE frame messages */
  mcc_command(SMPTE_CONTROL);           /* set up the origin frame address */
  mcc_put(SMPTE_ORIGIN);
  mcc_put(ohh);
  mcc_put(omm);
  mcc_put(oss);
  mcc_put(ofr);
  mcc_command(SMPTE_CONTROL);           /* set up the cue point */
  mcc_put(SMPTE_CUE_POINT);
  mcc_put(hh);
  mcc_put(mm);
  mcc_put(oss);
  mcc_put(ofr);

  puts("\n\nStart the tape in record mode");
  puts("Press any key when tape is running");
  bioskey(0);

  mcc_command(SMPTE_MODE);              /* put the MQX-32 into SMPTE mode */
  mcc_command(ENABLE_SMPTE_MSG);        /* enable SMPTE frame messages */
  mcc_command(START_RECSMPTE);          /* start writing */

  printf("Writing %d minutes of SMPTE track; press any key to stop\n",dur);

  /* spin until end of time or asked to quit */
  while (!bioskey(1) && (!cuepoint_efw()))
    {
      if (smpte_efw(smpte_addr))        /* if a SMPTE frame address received */
        {
          gotoxy(1,16);                 /* display frame address */
          cprintf("%02d:%02d:%02d:%02d",smpte_addr[0] & 0x1F,
                                        smpte_addr[1],
                                        smpte_addr[2],
                                        smpte_addr[3]);
        }
    }

  mcc_command(STOP_RECSMPTE);           /* stop writing */

  if (bioskey(1))                       /* if terminated from kbd */
    bioskey(0);                         /* read exit key */
  else
    {
      puts("\n\nSync track written; press any key to continue");
      bioskey(0);
    }
  mcc_reset();                          /* return to default mode */
}
