unit MenuDesigner;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, ComCtrls, ToolWin, Placemnt, SmartListView, Menus, ShellAPI;

type
  TMenuDesignerForm = class(TForm)
    cbMenuDesigner: TCoolBar;
    tbMenuDesigner: TToolBar;
    tbAddItem: TToolButton;
    tbDeleteItem: TToolButton;
    ImageList1: TImageList;
    tbEditItem: TToolButton;
    ToolButton4: TToolButton;
    tbMoveDownItem: TToolButton;
    tbMoveUpItem: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    FormStorage1: TFormStorage;
    lvItems: TSmartListView;
    mnuItems: TPopupMenu;
    AddItem1: TMenuItem;
    DeleteItem1: TMenuItem;
    N1: TMenuItem;
    EditProperties1: TMenuItem;
    N2: TMenuItem;
    MoveUp1: TMenuItem;
    MoveDown1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure tbAddItemClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure tbDeleteItemClick(Sender: TObject);
    procedure lvItemsDblClick(Sender: TObject);
    procedure LoadListItems;
    procedure AppendLastItems;
    procedure FormDeactivate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ItemClick(Sender: TObject);
    procedure lvItemsClick(Sender: TObject);
    procedure ToolButton8Click(Sender: TObject);
    procedure tbMoveUpItemClick(Sender: TObject);
    procedure lvItemsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure lvItemsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure tbMoveDownItemClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    EditProperties : Boolean;
  end;

var
  MenuDesignerForm: TMenuDesignerForm;
  Closing : Boolean;

implementation

uses defines, main1, MenuDesignerItems;

{$R *.DFM}

{*************************************************************}
procedure TMenuDesignerForm.FormCreate(Sender: TObject);
{*************************************************************}
begin
  if not FileExists(ExtractFilePath(Application.Exename)+'menu.dat') then    // Prepare the Utils menu for first use
  begin
    lvItems.SaveToFile(ExtractFilePath(Application.Exename)+'menu.dat');
    AppendLastItems;
  end;

  FormStorage1.IniFileName := SettingsFile.FileName;
  LoadListItems;
  Closing := False;
end;

{*************************************************************}
procedure TMenuDesignerForm.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
{*************************************************************}
begin
  if Key = VK_ESCAPE then close;
end;


{*************************************************************}
procedure TMenuDesignerForm.tbAddItemClick(Sender: TObject);
{*************************************************************}
var
  Item : TListItem;
  MenuDesignerItemsEd: TMenuDesignerItemsEd;
begin
  if lvItems.Items.Count = 50 then
    begin
      MessageDlg('The menu is limited to 50 items.', mtWarning,[mbOk], 0);
      Exit;
    end;
  try
    MenuDesignerItemsEd := TMenuDesignerItemsEd.Create(self);
    if MenuDesignerItemsEd.ShowModal = mrOK then
    begin
      if EditProperties = False then
      begin
        if (not MenuDesignerItemsEd.cbSeperator.Checked) and (MenuDesignerItemsEd.edTitle.Text = '') then Exit;
        Item := lvItems.Items.Add;
        if MenuDesignerItemsEd.cbSeperator.Checked then
          Item.Caption := '-' else
          begin
            Item.Caption  := MenuDesignerItemsEd.edTitle.Text;
            Item.SubItems.Add(MenuDesignerItemsEd.edLocation.Text);
          end;
      end else
      begin
        lvItems.Selected.Caption := MenuDesignerItemsEd.edTitle.Text;
        lvItems.Selected.SubItems[0] := MenuDesignerItemsEd.edLocation.Text;
      end;
    end;
  finally
    MenuDesignerItemsEd.Free;
    EditProperties := False;
  end;
end;
{
var
  Item : TListItem;
  MenuDesignerItemsEd: TMenuDesignerItemsEd;
begin
  if lvItems.Items.Count = 50 then
    begin
      MessageDlg('The menu is limited to 50 items.', mtWarning,[mbOk], 0);
      Exit;
    end;
  try
    MenuDesignerItemsEd := TMenuDesignerItemsEd.Create(self);
    if MenuDesignerItemsEd.ShowModal = mrOK then
    begin
      if EditProperties = False then
      begin
        if (not MenuDesignerItemsEd.cbSeperator.Checked) and (MenuDesignerItemsEd.edTitle.Text = '') then Exit;
        Item := lvItems.Items.Add;
        if MenuDesignerItemsEd.cbSeperator.Checked then
          Item.Caption := '-' else
          begin
            Item.Caption  := MenuDesignerItemsEd.edTitle.Text;
            Item.SubItems.Add(MenuDesignerItemsEd.edLocation.Text);
          end;
      end else
      begin
        lvItems.Selected.Caption := MenuDesignerItemsEd.edTitle.Text;
        lvItems.Selected.SubItems[0] := MenuDesignerItemsEd.edLocation.Text;
      end;
    end;
  finally
    MenuDesignerItemsEd.Free;
    EditProperties := False;
  end;
end;
}

{*************************************************************}
procedure TMenuDesignerForm.FormShow(Sender: TObject);
{*************************************************************}
begin
  LoadListItems;
  Closing := False;
end;

{*************************************************************}
procedure TMenuDesignerForm.tbDeleteItemClick(Sender: TObject);
{*************************************************************}
begin
  if lvItems.SelCount <> 0 then
  begin
    lvItems.Selected.Delete;
    lvItems.Selected := lvItems.ItemFocused;
  end;
end;

{*************************************************************}
procedure TMenuDesignerForm.lvItemsDblClick(Sender: TObject);
{*************************************************************}
begin
  if (lvItems.Selected = nil) or (lvItems.Selected.Caption = '-') then exit;
  EditProperties := True;
  tbAddItemClick(self);
end;

{*************************************************************}
procedure TMenuDesignerForm.LoadListItems;
{*************************************************************}
var
  Datafile : String;
  i : Integer;
  Item : Array[0..50] of TMenuItem;
begin
  Main.Utils1.Clear;
  Datafile := ExtractFilePath(Application.Exename)+'menu.dat';
  if FileExists(DataFile) then
    lvItems.LoadFromFile(ExtractFilePath(Application.Exename)+'menu.dat');

  if lvItems.Items.Count = 0 then
  begin
    AppendLastItems;
    exit;
  end;

  for i := 0 to 50 do
  Item[i] := TMenuItem.Create(Main.MainMenu1);

   for i := 0 to lvItems.Items.Count-1 do
    begin
      Item[i].Caption := lvItems.Items[i].Caption;
      Item[i].OnClick := ItemClick;
      Item[i].Tag := i;
      Main.Utils1.Add(Item[i]);
    end;
  AppendLastItems;
end;

{*************************************************************}
procedure TMenuDesignerForm.ItemClick(Sender: TObject);
{*************************************************************}
var
  CurNum : Integer;
  Location : PChar;
begin
  CurNum := TMenuitem(Sender).Tag;
  Location := Pchar(lvItems.Items[CurNum].SubItems[0]);
  ShellExecute(Application.Handle,'open',Location, nil, nil, SW_NORMAL);
end;

{*************************************************************}
procedure TMenuDesignerForm.AppendLastItems;
{*************************************************************}
var
  Item : Array[0..1] of TMenuItem;
begin
  Item[0] := TMenuItem.Create(Main.MainMenu1);
  Item[1] := TMenuItem.Create(Main.MainMenu1);
  Item[0].Caption := '-';
  Item[1].Caption := 'Customize Menu...';
  Item[1].OnClick := Main.Customize1Click;
  Main.Utils1.Add(Item);
end;

{*************************************************************}
procedure TMenuDesignerForm.FormDeactivate(Sender: TObject);
{*************************************************************}
begin
  if not Closing then
  MenuDesignerForm.Show;
end;

{*************************************************************}
procedure TMenuDesignerForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
{*************************************************************}
begin
  Closing := True;
  lvItems.SaveToFile(ExtractFilePath(Application.Exename)+'menu.dat');
  LoadListItems;
  CanClose := Closing;
end;

{*************************************************************}
procedure TMenuDesignerForm.lvItemsClick(Sender: TObject);
{*************************************************************}
begin
  if lvItems.SelCount <> 0 then
  begin
    tbDeleteItem.Enabled := True;
    DeleteItem1.Enabled := True;
    tbEditItem.Enabled := True;
    tbMoveUpItem.Enabled := True;
    tbMoveDownItem.Enabled := True;
    EditProperties1.Enabled := True;
    MoveUp1.Enabled := True;
    MoveDown1.Enabled := True;
  end else
  begin
    tbDeleteItem.Enabled := False;
    DeleteItem1.Enabled := False;
    tbEditItem.Enabled := False;
    tbMoveUpItem.Enabled := False;
    tbMoveDownItem.Enabled := False;
    EditProperties1.Enabled := False;
    MoveUp1.Enabled := False;
    MoveDown1.Enabled := False;
  end;
end;

{*************************************************************}
procedure TMenuDesignerForm.ToolButton8Click(Sender: TObject);
{*************************************************************}
begin
  MessageDlg('This Context Help is not yet implemented.'+#13#10+'It should be in the next version.', mtInformation,[mbOk], 0);
end;

{*************************************************************}
procedure TMenuDesignerForm.lvItemsDragDrop(Sender, Source: TObject; X, Y: Integer);
{*************************************************************}
var 
  DragItem, DropItem, CurrentItem, NextItem: TListItem; 
begin 
  if Sender = Source then 
    with TListView(Sender) do 
    begin 
      DropItem    := GetItemAt(X, Y);
      CurrentItem := Selected; 
      while CurrentItem <> nil do 
      begin 
        NextItem := GetNextItem(CurrentItem, SdAll, [IsSelected]); 
        if DropItem = nil then DragItem := Items.Add 
        else 
          DragItem := Items.Insert(DropItem.Index);
        DragItem.Assign(CurrentItem); 
        CurrentItem.Free; 
        CurrentItem := NextItem;
      end; 
    end; 
end;

{*************************************************************}
procedure TMenuDesignerForm.lvItemsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
{*************************************************************}
begin
  Accept := Sender = lvItems;
end;

{*************************************************************}
procedure TMenuDesignerForm.tbMoveDownItemClick(Sender: TObject);
{*************************************************************}
var 
  Source, Target: TListItem;
  CurNum : byte;
begin
  CurNum := lvItems.Items.IndexOf(lvItems.Selected);
  if CurNum = lvItems.Items.Count-1 then exit;

  lvItems.Items.BeginUpdate;

  Source := TListItem.Create(nil);
  Target := TListItem.Create(nil);
  try
    Source := lvItems.Items[CurNum];
    Target := lvItems.Items.Insert(CurNum+2);
    Target.Assign(Source);
    Source.Free;
  finally
    lvItems.Items.EndUpdate;
  end;
  lvItems.Selected := lvItems.Items[CurNum+1];
  lvItems.Items[CurNum+1].Focused := True;
end;

{*************************************************************}
procedure TMenuDesignerForm.tbMoveUpItemClick(Sender: TObject);
{*************************************************************}
var
  Source, Target: TListItem;
  CurNum : byte;
begin
  CurNum := lvItems.Items.IndexOf(lvItems.Selected);
  if CurNum-1 < 0 then exit;

  lvItems.Items.BeginUpdate;

  Source := TListItem.Create(nil);
  Target := TListItem.Create(nil);
  try
    Source := lvItems.Items[CurNum];
    Target := lvItems.Items.Insert(CurNum-1);
    Target.Assign(Source);
    Source.Free;
  finally
    lvItems.Items.EndUpdate;
  end;
  lvItems.Selected := Target;
  lvItems.Items[CurNum-1].Focused := True;
end;


end.
