unit MenuDesignerItems;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ToolEdit, ExtCtrls, SRGrad;

type
  TMenuDesignerItemsEd = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    edTitle: TEdit;
    Label2: TLabel;
    edLocation: TFilenameEdit;
    Bevel1: TBevel;
    OKBut: TButton;
    CancelBut: TButton;
    cbSeperator: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure cbSeperatorClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MenuDesignerItemsEd: TMenuDesignerItemsEd;

implementation

uses MenuDesigner;

{$R *.DFM}

{*************************************************************}
procedure TMenuDesignerItemsEd.FormShow(Sender: TObject);
{*************************************************************}
begin

end;

{*************************************************************}
procedure TMenuDesignerItemsEd.cbSeperatorClick(Sender: TObject);
{*************************************************************}
begin
  if cbSeperator.Checked then
  begin
    edTitle.Enabled := False;
    edLocation.Enabled := False;
    edTitle.Color := clSilver;
    edLocation.Color := clSilver;
  end else
  begin
    edTitle.Enabled := True;
    edLocation.Enabled := True;
    edTitle.Color := clWindow;
    edLocation.Color := clWindow;
  end;
end;

{*************************************************************}
procedure TMenuDesignerItemsEd.FormActivate(Sender: TObject);
{*************************************************************}
begin
  if MenuDesignerForm.EditProperties then
  begin
    edTitle.Text    := MenuDesignerForm.lvItems.Selected.Caption;
    edLocation.Text := MenuDesignerForm.lvItems.Selected.SubItems[0];
    Caption := 'Edit the menu item';
    cbSeperator.Enabled := False;
  end;
end;

end.
