{
    Main1.pas - Main window
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

}

unit main1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Grids, Outline, DirOutln, ComCtrls, ViewEdit1, defines,
  ExtCtrls, IniFiles, VolMan2, LogDecode, LogEdit1, ToolWin, Buttons,
  MRUList, SRGrad, ShellAPI, ImgList;

function OpenGame : boolean;

type
  TMain = class(TForm)
    MainMenu1: TMainMenu;
    GameMenu: TMenuItem;
    GameOpen: TMenuItem;
    N1: TMenuItem;
    GameExit: TMenuItem;
    ResourceExtractDialog: TSaveDialog;
    ResourceAddDialog: TOpenDialog;
    GameRun: TMenuItem;
    ExecutableSelectDialog: TOpenDialog;
    ToolsMenu: TMenuItem;
    ToolsPicedit: TMenuItem;
    HelpMenu: TMenuItem;
    HelpAbout: TMenuItem;
    ToolsViewEdit: TMenuItem;
    ToolsObjEdit: TMenuItem;
    N3: TMenuItem;
    Contents1: TMenuItem;
    Index1: TMenuItem;
    ToolsWordsEdit: TMenuItem;
    ToolBarPanel: TPanel;
    ToolbarOpenBut: TSpeedButton;
    ToolbarRunBut: TSpeedButton;
    ToolBarViewEditBut: TSpeedButton;
    ToolbarObjEditBut: TSpeedButton;
    ToolbarWordsEditBut: TSpeedButton;
    ToolbarPiceditBut: TSpeedButton;
    GameClose: TMenuItem;
    ToolbarCloseBut: TSpeedButton;
    N4: TMenuItem;
    GameMenu_Settings: TMenuItem;
    WindowMenu: TMenuItem;
    WindowCascade: TMenuItem;
    WindowTile: TMenuItem;
    WindowArrangeIcons: TMenuItem;
    WindowMinimizeAll: TMenuItem;
    ToolsTextEdit: TMenuItem;
    ToolsLogEdit: TMenuItem;
    GameNew: TMenuItem;
    GameNewTemplate: TMenuItem;
    GameNewBlank: TMenuItem;
    ToolbarLogEditBut: TSpeedButton;
    ToolbarTextEditBut: TSpeedButton;
    MRUManager1: TMRUManager;
    Reopen1: TMenuItem;
    SRGradient4: TSRGradient;
    Web1: TMenuItem;
    MessageBoard1: TMenuItem;
    OfficialAGIStudioSite1: TMenuItem;
    Download1: TMenuItem;
    PicEdit121: TMenuItem;
    AGIStudiov131aSourceCode1: TMenuItem;
    CheckforNewVersion1: TMenuItem;
    N2: TMenuItem;
    Tutorials1: TMenuItem;
    Items1: TMenuItem;
    Doors1: TMenuItem;
    Rooms1: TMenuItem;
    Defines1: TMenuItem;
    UltimateAGISCIWebsite1: TMenuItem;
    Createagamein9Steps1: TMenuItem;
    N5: TMenuItem;
    HowtomakeanAGIGame1: TMenuItem;
    PriorityScreens1: TMenuItem;
    limitationsofprioritybands1: TMenuItem;
    ThemakingofanAGIbackgroundpicture1: TMenuItem;
    N6: TMenuItem;
    MakingAGIGames1: TMenuItem;
    AGIStackPatch1: TMenuItem;
    N7: TMenuItem;
    NewAdventureGameInterpreters1: TMenuItem;
    ChrissAGIWebSite1: TMenuItem;
    CoolBar1: TCoolBar;
    AGIdevcom1: TMenuItem;
    ToolBar1: TToolBar;
    ToolBar2: TToolBar;
    tbFileNew: TToolButton;
    ImageList1: TImageList;
    tbFileOpen: TToolButton;
    tbFileSave: TToolButton;
    N8: TMenuItem;
    tbRun: TToolButton;
    tbCompile: TToolButton;
    tbRenumber: TToolButton;
    Utils1: TMenuItem;
    procedure GameExitClick(Sender: TObject);
    procedure GameOpenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure GameRunClick(Sender: TObject);
    procedure ToolsPiceditClick(Sender: TObject);
    procedure HelpAboutClick(Sender: TObject);
    procedure ToolsViewEditClick(Sender: TObject);
    procedure ToolsObjEditClick(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure Index1Click(Sender: TObject);
    procedure ToolsWordsEditClick(Sender: TObject);
    procedure ToolbarOpenButClick(Sender: TObject);
    procedure ToolbarRunButClick(Sender: TObject);
    procedure ToolBarViewEditButClick(Sender: TObject);
    procedure ToolbarObjEditButClick(Sender: TObject);
    procedure ToolbarWordsEditButClick(Sender: TObject);
    procedure ToolbarPiceditButClick(Sender: TObject);
    procedure GameCloseClick(Sender: TObject);
    procedure ToolbarCloseButClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure GameMenu_SettingsClick(Sender: TObject);
    procedure WindowCascadeClick(Sender: TObject);
    procedure WindowTileClick(Sender: TObject);
    procedure WindowArrangeIconsClick(Sender: TObject);
    procedure WindowMinimizeAllClick(Sender: TObject);
    procedure ToolsTextEditClick(Sender: TObject);
    procedure ToolsLogEditClick(Sender: TObject);
    procedure GameNewBlankClick(Sender: TObject);
    procedure GameNewTemplateClick(Sender: TObject);
    procedure ToolbarLogEditButClick(Sender: TObject);
    procedure ToolbarTextEditButClick(Sender: TObject);
    procedure MRUManager1Click(Sender: TObject; const RecentName,
      Caption: String; UserData: Integer);
    procedure MessageBoard1Click(Sender: TObject);
    procedure GoWeb(URL: String);
    procedure OfficialAGIStudioSite1Click(Sender: TObject);
    procedure PicEdit121Click(Sender: TObject);
    procedure AGIStudiov131aSourceCode1Click(Sender: TObject);
    procedure CheckforNewVersion1Click(Sender: TObject);
    procedure Items1Click(Sender: TObject);
    procedure Doors1Click(Sender: TObject);
    procedure Rooms1Click(Sender: TObject);
    procedure Defines1Click(Sender: TObject);
    procedure UltimateAGISCIWebsite1Click(Sender: TObject);
    procedure Createagamein9Steps1Click(Sender: TObject);
    procedure HowtomakeanAGIGame1Click(Sender: TObject);
    procedure PriorityScreens1Click(Sender: TObject);
    procedure limitationsofprioritybands1Click(Sender: TObject);
    procedure ThemakingofanAGIbackgroundpicture1Click(Sender: TObject);
    procedure MakingAGIGames1Click(Sender: TObject);
    procedure AGIStackPatch1Click(Sender: TObject);
    procedure ChrissAGIWebSite1Click(Sender: TObject);
    procedure AGIdevcom1Click(Sender: TObject);
    procedure tbFileSaveClick(Sender: TObject);
    procedure Customize1Click(Sender: TObject);
  private
    { Private declarations }
    procedure NewGame(UseTemplate:boolean);
  public
    { Public declarations }
    DefaultTop : integer;
    DefaultLeft : integer;
    DefaultWidth : integer;
    DefaultHeight : integer;
    procedure UpdateMenuItems(Sender: TObject);
    function CloseGame : boolean;
    function FixSlashes(Dest: string): string;
  end;

var
  Main: TMain;
  GameIsOpen : boolean;
  RecentSettingsFile : TIniFile;
  T : TTimer;

  EGAPalHandle: HPalette;      { handle to a palette }
  EGALogPal: PLogPalette;      { pointer to logical palette }
  EGAPalSize: Integer;         { size of logical palette record }
  BaseBitmap : TBitmap;

function CreateEGAPalette : HPalette;

implementation

uses ViewPreview1,PicPreview1, VolRebuild1, GetResourceName1,
  GetResourceNum1, About1, objed, WordsEditMain1, ResourceWin1, PreviewWin1,
  GameDirSelect1, SettingsWin1, AGICommands, LogoWin1, MenuDesigner;

const Startup : boolean = False;

{$R *.DFM}

{*************************************************************}
function CheckGame(CheckDir:String) : boolean;
{*************************************************************}
const ReqdFile     : array[2..3,1..7] of string = (('OBJECT','WORDS.TOK','VOL.0','VIEWDIR',
                                                   'PICDIR','LOGDIR','SNDDIR'),
                                                   ('OBJECT','WORDS.TOK','VOL.0','DIR','','',''));
      NumFilesReqd : array[2..3] of byte = (7,4);

var ErrorOccured : boolean;
    CurFile      : byte;
    TestFile     : file of byte;
    ver          : byte;
    CheckGameID  : string;

begin
  CheckGameID := FindAGIV3GameID(CheckDir);  // 'V2' if not found

  if CheckGameID = 'V2' then
    CheckGame := CanAccessFile(CheckDir+'OBJECT') and  CanAccessFile(CheckDir+'WORDS.TOK') and
                 CanAccessFile(CheckDir+'VOL.0') and CanAccessFile(CheckDir+'VIEWDIR') and
                 CanAccessFile(CheckDir+'PICDIR') and CanAccessFile(CheckDir+'LOGDIR') and
                 CanAccessFile(CheckDir+'SNDDIR')
  else CheckGame := CanAccessFile(CheckDir+'OBJECT') and  CanAccessFile(CheckDir+'WORDS.TOK') and
                    CanAccessFile(CheckDir+CheckGameID+'VOL.0') and CanAccessFile(CheckDir+CheckGameID+'DIR');
end;

{*************************************************************}
procedure ReadSettings;
{*************************************************************}
begin
  Settings.Windows.Main.Top := SettingsFile.ReadInteger('Window positions','Main.Top',-1);
  Settings.Windows.Main.Left := SettingsFile.ReadInteger('Window positions','Main.Left',-1);
  Settings.Windows.Main.Width := SettingsFile.ReadInteger('Window positions','Main.Width',-1);
  Settings.Windows.Main.Height := SettingsFile.ReadInteger('Window positions','Main.Height',-1);
  Settings.Windows.Main.Maximized := SettingsFile.ReadBool('Window positions','Main.Maximized',False);
  Settings.Windows.ResourceWin.Top := SettingsFile.ReadInteger('Window positions','ResourceWin.Top',-1);
  Settings.Windows.ResourceWin.Left := SettingsFile.ReadInteger('Window positions','ResourceWin.Left',-1);
  Settings.Windows.ResourceWin.Width := SettingsFile.ReadInteger('Window positions','ResourceWin.Width',-1);
  Settings.Windows.ResourceWin.Height := SettingsFile.ReadInteger('Window positions','ResourceWin.Height',-1);
  Settings.Windows.ResourceWin.Maximized := SettingsFile.ReadBool('Window positions','ResourceWin.Maximized',False);
  Settings.Windows.PreviewWin.Top := SettingsFile.ReadInteger('Window positions','PreviewWin.Top',-1);
  Settings.Windows.PreviewWin.Left := SettingsFile.ReadInteger('Window positions','PreviewWin.Left',-1);
  Settings.Windows.PreviewWin.Width := SettingsFile.ReadInteger('Window positions','PreviewWin.Width',-1);
  Settings.Windows.PreviewWin.Height := SettingsFile.ReadInteger('Window positions','PreviewWin.Height',-1);
  Settings.Windows.PreviewWin.Maximized := SettingsFile.ReadBool('Window positions','PreviewWin.Maximized',False);
  Settings.Resources.NameType := SettingsFile.ReadInteger('Resources','NameType',DefaultSettings.Resources.NameType);
  if (Settings.Resources.NameType < 0) or (Settings.Resources.NameType > 11 ) then
    Settings.Resources.NameType := 0;
  Settings.Resources.DefaultType := SettingsFile.ReadInteger('Resources','DefaultType',DefaultSettings.Resources.DefaultType);
  if (Settings.Resources.DefaultType < 0) or (Settings.Resources.DefaultType > 3) then
    Settings.Resources.DefaultType := VIEW;
  Settings.LogicEditor.MaximizeEditorWindow := SettingsFile.ReadBool('Logic editor','MaximizeEditorWindow',DefaultSettings.LogicEditor.MaximizeEditorWindow);
  Settings.LogicEditor.ShowAllMessages := SettingsFile.ReadBool('Logic editor','ShowAllMessages',DefaultSettings.LogicEditor.ShowAllMessages);
  Settings.LogicEditor.ShowAllElsesAsGotos := SettingsFile.ReadBool('Logic editor','ShowAllElsesAsGotos',DefaultSettings.LogicEditor.ShowAllElsesAsGotos);
  Settings.LogicEditor.ShowSpecialSyntax := SettingsFile.ReadBool('Logic editor','ShowSpecialSyntax',DefaultSettings.LogicEditor.ShowSpecialSyntax);
  Settings.General.ShowSplashScreen := SettingsFile.ReadBool('General','ShowSplashScreen',DefaultSettings.General.ShowSplashScreen);
  Settings.Controls.PreviewViewAnimSpeed := SettingsFile.ReadInteger('Controls','PreviewViewAnimSpeed',500);
  Settings.Controls.GameDirSelectDir := SettingsFile.ReadString('Controls','GameDirSelectDir','');
end;

{*************************************************************}
procedure WriteSettings;
{*************************************************************}
begin
  SettingsFile.WriteInteger('Window positions','Main.Top',Settings.Windows.Main.Top);
  SettingsFile.WriteInteger('Window positions','Main.Left',Settings.Windows.Main.Left);
  SettingsFile.WriteInteger('Window positions','Main.Width',Settings.Windows.Main.Width);
  SettingsFile.WriteInteger('Window positions','Main.Height',Settings.Windows.Main.Height);
  SettingsFile.WriteBool('Window positions','Main.Maximized',Settings.Windows.Main.Maximized);
  SettingsFile.WriteInteger('Window positions','ResourceWin.Top',Settings.Windows.ResourceWin.Top);
  SettingsFile.WriteInteger('Window positions','ResourceWin.Left',Settings.Windows.ResourceWin.Left);
  SettingsFile.WriteInteger('Window positions','ResourceWin.Width',Settings.Windows.ResourceWin.Width);
  SettingsFile.WriteInteger('Window positions','ResourceWin.Height',Settings.Windows.ResourceWin.Height);
  SettingsFile.WriteBool('Window positions','ResourceWin.Maximized',Settings.Windows.ResourceWin.Maximized);
  SettingsFile.WriteInteger('Window positions','PreviewWin.Top',Settings.Windows.PreviewWin.Top);
  SettingsFile.WriteInteger('Window positions','PreviewWin.Left',Settings.Windows.PreviewWin.Left);
  SettingsFile.WriteInteger('Window positions','PreviewWin.Width',Settings.Windows.PreviewWin.Width);
  SettingsFile.WriteInteger('Window positions','PreviewWin.Height',Settings.Windows.PreviewWin.Height);
  SettingsFile.WriteBool('Window positions','PreviewWin.Maximized',Settings.Windows.PreviewWin.Maximized);
  SettingsFile.WriteInteger('Resources','NameType',Settings.Resources.NameType);
  SettingsFile.WriteInteger('Resources','DefaultType',Settings.Resources.DefaultType);
  SettingsFile.WriteBool('Logic editor','MaximizeEditorWindow',Settings.LogicEditor.MaximizeEditorWindow);
  SettingsFile.WriteBool('Logic editor','ShowAllMessages',Settings.LogicEditor.ShowAllMessages);
  SettingsFile.WriteBool('Logic editor','ShowAllElsesAsGotos',Settings.LogicEditor.ShowAllElsesAsGotos);
  SettingsFile.WriteBool('Logic editor','ShowSpecialSyntax',Settings.LogicEditor.ShowSpecialSyntax);
  SettingsFile.WriteBool('General','ShowSplashScreen',Settings.General.ShowSplashScreen);
  SettingsFile.WriteInteger('Controls','PreviewViewAnimSpeed',Settings.Controls.PreviewViewAnimSpeed);
  SettingsFile.WriteString('Controls','GameDirSelectDir',Settings.Controls.GameDirSelectDir);
end;

{*************************************************************}
function CreateEGAPalette : HPalette;
{*************************************************************}
var I : Integer;
begin
  EGAPalSize := SizeOf(TLogPalette) + 15*SizeOf(TPaletteEntry);
  GetMem(EGALogPal, EGAPalSize);

  EGALogPal^.palVersion := $300;
  EGALogPal^.palNumEntries := 16;
{$R-}
  for I := 0 to 15 do
  begin
    EGALogPal^.palPalEntry[I].peRed   := EGAcols[I].rgbRed;
    EGALogPal^.palPalEntry[I].peGreen := EGAcols[I].rgbGreen;
    EGALogPal^.palPalEntry[I].peBlue  := EGAcols[I].rgbBlue;
    EGALogPal^.palPalEntry[I].peFlags := PC_NOCOLLAPSE;  // see online help for meaning
  end;
{$R+}  // turn on range checking again
  CreateEGAPalette := CreatePalette(EGALogPal^);
end;

{*************************************************************}
procedure TMain.UpdateMenuItems(Sender: TObject);
{*************************************************************}
begin
  WindowMenu.Enabled := MDIChildCount > 0;
end;

{*************************************************************}
function OpenGame : boolean;
{*************************************************************}
var CurResType          : byte;
    CurResNum           : byte;
    DirFile             : file;
    DirFilename         : string;
    byte1, byte2, byte3 : byte;
    TempString          : string;
    DirOffset           : longint;  // offset of this resource's directory in DIR file (for v3)
    DirSize             : longint;
    NumDirEntries       : word;
    ErrorOccured        : boolean;
    DirData             : array[0..4000] of byte;

begin
  GameID := FindAGIV3GameID(GameDir);  // 'V2' if not found
  GameIsV3 := (GameID <> 'V2');
  ErrorOccured := False;
  for CurResType := 0 to 3 do
    for CurResNum := 0 to 255 do
      ResourceInfo[CurResType,CurResNum].Exists := False;
  if not GameIsV3 then
  begin
    for CurResType := 0 to 3 do
    begin
      NumResources[CurResType] := 0;
      DIRFilename := GameDir + ResTypeAbbrv[CurResType] + 'DIR';
      AssignFile(DirFile,DirFilename);
      Reset(DirFile,1);
      if FileSize(DirFile) > 768 then
      begin
        ShowMessage('Error: '+DIRFilename+' is to big (should not be more than 768 bytes).');
        ErrorOccured := True;
      end
      else
      begin
        BlockRead(DirFile,DirData,FileSize(DirFile));
        if FileSize(DirFile) > 0 then
        for CurResNum := 0 to (FileSize(DirFile) div 3) - 1 do
        begin
          byte1 := DirData[CurResNum*3];
          byte2 := DirData[CurResNum*3+1];
          byte3 := DirData[CurResNum*3+2];
          if (not ((byte1=$FF) and (byte2=$FF) and (byte3=$FF))) then
          begin
            NumResources[CurResType] := NumResources[CurResType] + 1;
            ResourceNum[CurResType,NumResources[CurResType]-1] := CurResNum;
            ResourceInfo[CurResType,CurResNum].Loc := (byte1 mod 16)*$10000 + byte2*$100 + byte3;
            str(byte1 div 16,TempString);
            ResourceInfo[CurResType,CurResNum].Filename := 'VOL.'+TempString;
            ResourceInfo[CurResType,CurResNum].Exists := True;
          end;
        end;
      end;
      CloseFile(DirFile);
    end;
  end
  else  // if GameIsV3
  begin
    DIRFilename := GameDir + GameID + 'DIR';
    AssignFile(DirFile,DirFilename);
    Reset(DirFile,1);
    if FileSize(DirFile) > 3080 then
    begin
      ShowMessage('Error: '+DIRFilename+' is to big (should not be more than 3080 bytes).');
      ErrorOccured := True;
    end
    else
    begin
      BlockRead(DirFile,DirData,FileSize(DirFile));
      for CurResType := 0 to 3 do
      if not ErrorOccured then
      begin
        if CurResType = LOGIC then begin DirOffset := DirData[0] + DirData[1]*256; DirSize := DirData[2] + DirData[3]*256 - DirOffset; end
        else if CurResType = PICTURE then begin DirOffset := DirData[2] + DirData[3]*256; DirSize := DirData[4] + DirData[5]*256 - DirOffset; end
        else if CurResType = VIEW then begin DirOffset := DirData[4] + DirData[5]*256; DirSize := DirData[6] + DirData[7]*256 - DirOffset; end
        else begin DirOffset := DirData[6] + DirData[7]*256; DirSize := FileSize(DirFile) - DirOffset; end;
        if (DirOffset < 0) or (DirSize < 0) then
        begin
          ShowMessage('Error: DIR file is invalid.');
          ErrorOccured := True;
        end
        else if DirOffset + DirSize > FileSize(DirFile) then
        begin
          ShowMessage('Error: Directory is beyond end of '+DirFilename+' file.');
          ErrorOccured := True;
        end
        else
        begin
          NumResources[CurResType] := 0;
          if FileSize(DirFile) > 0 then
          if DirSize > 768 then NumDirEntries := 256
          else NumDirEntries := DirSize div 3;
          if NumDirEntries > 0 then
          for CurResNum := 0 to NumDirEntries - 1 do
          begin
            byte1 := DirData[DirOffset+CurResNum*3];
            byte2 := DirData[DirOffset+CurResNum*3+1];
            byte3 := DirData[DirOffset+CurResNum*3+2];
            if (not ((byte1=$FF) and (byte2=$FF) and (byte3=$FF))) then
            begin
              NumResources[CurResType] := NumResources[CurResType] + 1;
              ResourceNum[CurResType,NumResources[CurResType]-1] := CurResNum;
              ResourceInfo[CurResType,CurResNum].Loc := (byte1 mod 16)*$10000 + byte2*$100 + byte3;
              str(byte1 div 16,TempString);
              ResourceInfo[CurResType,CurResNum].Filename := GameID + 'VOL.'+TempString;
              ResourceInfo[CurResType,CurResNum].Exists := True;
            end;  // if (not ((byte1=$FF) and (byte2=$FF) and (byte3=$FF)))
          end;  // for CurResNum := 0 to (DirSize div 3) - 1
        end;  // if DirOffset + DirSize <= FileSize(DirFile)
      end;  // for CurResType := 0 to 3 do
    end;  // if FileSize(DirFile) <= 3080
    CloseFile(DirFile);
  end;
  if not ErrorOccured then
  begin
    AGIVersionNumber := GetAGIVersionNumber;
    CorrectCommands(AGIVersionNumber);
    Application.CreateForm(TResourceWin, ResourceWin);
    Application.CreateForm(TPreviewWin, PreviewWin);
    SelectedResourceType := Settings.Resources.DefaultType;
    ResourceWin.ResTypeSelect.ItemIndex := SelectedResourceType;
    ResourceWin.DisplayResourceList;
    ResourceWin.ResTypeSelect.Enabled := True;
    ResourceWin.ResourceList.Enabled := True;
    GameSettingsFile := TIniFile.Create(GameDir+'AGISTUDIO.INI');
    GameSettings.GameExecutable := GameSettingsFile.ReadString('GAME','EXECUTABLE','');
    GameSettings.GameExecutable := ExtractFilename(GameSettings.GameExecutable);
    if GameSettings.GameExecutable <> GameSettingsFile.ReadString('GAME','EXECUTABLE','')
    then GameSettingsFile.WriteString('GAME','EXECUTABLE',GameSettings.GameExecutable);
    Main.GameRun.Enabled := True;
    Main.ToolbarRunBut.Enabled := True;
    GameIsOpen := True;
    Main.GameClose.Enabled := True;
    Main.ToolbarCloseBut.Enabled := True;
    Main.ToolsViewEdit.Enabled := True;
    Main.ToolbarViewEditBut.Enabled := True;
    Main.ToolsLogEdit.Enabled := True;
    Main.ToolbarLogEditBut.Enabled := True;
    Main.Caption := 'AGI Studio - '+ExtractFilename(Copy(GameDir,1,Length(GameDir)-1));
    Application.Title := 'AGI Studio - '+ExtractFilename(Copy(GameDir,1,Length(GameDir)-1));
    if PreviewView.InUse then FreePreviewView;
    if PreviewPic.InUse then FreePreviewPic;
    if PreviewWin.ViewPreviewPanel.Visible then PreviewWin.ViewPreviewPanel.Visible := False;
    if PreviewWin.PicPreviewPanel.Visible then PreviewWin.PicPreviewPanel.Visible := False;
    GameIsOpen := True;
  end;
  OpenGame := not ErrorOccured;
end;

{*************************************************************}
function TMain.CloseGame : boolean;
{*************************************************************}
var CurMDIChild : integer;
    ContinueClose : boolean;
    CurViewEditWin : integer;
    CurLogEditWin : integer;
    ObjEditIsOpen : boolean;
    WordsEditIsOpen : boolean;
begin
  ObjEditIsOpen := False;
  WordsEditIsOpen := False;
  ContinueClose := True;
  if GameIsOpen then
  begin
    for CurMDIChild := MDIChildCount - 1 downto 0 do
    begin
      if MDIChildren[CurMDIChild] = ObjEditMain then ObjEditIsOpen := True;
      if MDIChildren[CurMDIChild] = WordsEditMain then WordsEditIsOpen := True;
    end;

    for CurViewEditWin := 1 to MaxViewEditWins do
    if ViewEditWinUsed[CurViewEditWin] then
    begin
      if ViewEditWin[CurViewEditWin].AskClose then
         ViewEditWin[CurViewEditWin].Close
      else ContinueClose := False;
    end;

    for CurLogEditWin := 1 to MaxLogEditWins do
    if LogEditWinUsed[CurLogEditWin] then
    begin
      if LogEditWin[CurLogEditWin].AskClose then
         LogEditWin[CurLogEditWin].Close
      else ContinueClose := False;
    end;

    if ObjEditIsOpen = True then
    begin
      if ObjEditMain.AskClose then
         ObjEditMain.Close
      else ContinueClose := False;
    end;

    if WordsEditIsOpen = True then
    begin
      if WordsEditMain.AskClose then
         WordsEditMain.Close
      else ContinueClose := False;
    end;

    if ContinueClose then
    begin
      GameIsOpen := False;
      ResourceWin.Close;
      PreviewWin.Close;
      ToolsViewEdit.Enabled := False;
      ToolbarViewEditBut.Enabled := False;
      ToolsLogEdit.Enabled := False;
      ToolbarLogEditBut.Enabled := False;
      GameRun.Enabled := False;
      ToolbarRunBut.Enabled := False;
      GameDir := '';
      GameClose.Enabled := False;
      ToolbarCloseBut.Enabled := False;
      Main.Caption := 'AGI Studio';
      Application.Title := 'AGI Studio';
    end;
  end; {if GameIsOpen}
  CloseGame := ContinueClose;
end;

{*************************************************************}
procedure TMain.NewGame(UseTemplate:boolean);
{*************************************************************}
const BlankObjectFile : array[0..7] of byte =
                        ($42,$76,$79,$70,$20,$44,$4A,$72);
      BlankWordsFile : array[0..71] of byte =
       ($00,$34,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
        $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
        $00,$00,$00,$41,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
        $00,$00,$00,$00,$00,$9E,$00,$00,$01,$11,$06,$08,$10,$0D,$9B,$00,
        $01,$00,$0D,$10,$93,$27,$0F,$00);

var Found : integer;
    SearchRec : TSearchRec;
    NewGameDir : string;
    SourceDirOK : boolean;
    TempFile : file;

  function DirIsEmpty(dir:string) : boolean;
  begin
    DirIsEmpty := False;
    if FileExists(dir+'nul') then
    begin
      Found := FindFirst(NewGameDir+'*.*', faAnyFile, SearchRec);
      while (Found = 0) and ((SearchRec.Name='.') or (SearchRec.Name='..')) do
        Found := FindNext(SearchRec);
      DirIsEmpty := (Found <> 0);
      FindClose(SearchRec);
    end;
  end;

  function CopyFile2(SourceFilename,DestFilename:string) : boolean;
  var SourceFilenamePChar : PChar;
      DestFilenamePChar : PChar;
  begin
    GetMem(SourceFilenamePChar,Length(SourceFilename)+1);
    GetMem(DestFilenamePChar,Length(DestFilename)+1);
    StrPCopy(SourceFilenamePChar,SourceFilename);
    StrPCopy(DestFilenamePChar,DestFilename);
    CopyFile2 := CopyFile(SourceFilenamePChar,DestFilenamePChar,True);
    FreeMem(SourceFilenamePChar,Length(SourceFilename)+1);
    FreeMem(DestFilenamePChar,Length(DestFilename)+1);
  end;

begin
  GameDirSelect.Left := Main.Left + (Main.Width div 2) - (GameDirSelect.Width div 2);
  GameDirSelect.Top := Main.Top + (Main.Height div 2) - (GameDirSelect.Height div 2);
  GameDirSelect.WindowFunction := wfNewGame;
  GameDirSelect.ShowModal;
  if GameDirSelect.DirectorySelected then
  begin
    if Copy(GameDirSelect.DirectoryListBox1.Directory,Length(GameDirSelect.DirectoryListBox1.Directory),1) <> '\' then
      NewGameDir := GameDirSelect.DirectoryListBox1.Directory+'\';
    if CloseGame then
    begin
      if (not FileExists(NewGameDir+'nul')) then
        ShowMessage('Error: Invalid directory "'+NewGameDir+'".')
      else
      if (not DirIsEmpty(NewGameDir)) then ShowMessage('Error: Directory not empty.')
      else
      begin
        SourceDirOK := True;
        if (not FileExists(NewGameDir+SourceDir+'\nul')) then
        begin
          if (not CreateDir(NewGameDir+SourceDir)) then
          begin
            ShowMessage('Error: Could not create '+SourceDir+' directory.');
            SourceDirOK := False;
          end;
        end  // if (not FileExists(NewGameDir+SourceDir+'\nul')
        else
        begin
          if (not DirIsEmpty(NewGameDir+SourceDir)) then
          begin
            ShowMessage('Error: '+SourceDir+' directory is not empty.');
            SourceDirOK := False;
          end;
        end;  // if FileExists(NewGameDir+SourceDir+'\nul')
        if SourceDirOK then
        begin
          if UseTemplate then
          begin
            if not FileExists(ProgramDir+'template\nul') then
              ShowMessage('Error: Could not find template directory.')
            else if not FileExists(ProgramDir+'template\src\nul') then
              ShowMessage('Error: Could not find template\src directory')
            else
            begin
              // copy template directory
              Found := FindFirst(ProgramDir+'template\'+'*.*', faAnyFile, SearchRec);
              while Found = 0 do
              begin
                if (SearchRec.Name<>'.') and (SearchRec.Name<>'..') and (SearchRec.Name<>'readme.txt') and (SearchRec.Name<>'src') then
                begin
                  if not CopyFile2(ProgramDir+'template\'+SearchRec.Name,NewGameDir+SearchRec.Name) then
                    ShowMessage('Error copying file "'+SearchRec.Name+'".');
                end;
                Found := FindNext(SearchRec);
              end;
              FindClose(SearchRec);
              // copy src directory
              Found := FindFirst(ProgramDir+'template\src\'+'*.*', faAnyFile, SearchRec);
              while Found = 0 do
              begin
                if (SearchRec.Name<>'.') and (SearchRec.Name<>'..') then
                begin
                  if not CopyFile2(ProgramDir+'template\src\'+SearchRec.Name,NewGameDir+'src\'+SearchRec.Name) then
                    ShowMessage('Error copying file "'+SearchRec.Name+'".');
                end;
                Found := FindNext(SearchRec);
              end;
              FindClose(SearchRec);
            end;
          end  // if UseTemplate
          else
          begin
            AssignFile(TempFile,NewGameDir+'VOL.0'); Rewrite(TempFile,1); CloseFile(TempFile);
            AssignFile(TempFile,NewGameDir+'VIEWDIR'); Rewrite(TempFile,1); CloseFile(TempFile);
            AssignFile(TempFile,NewGameDir+'LOGDIR'); Rewrite(TempFile,1); CloseFile(TempFile);
            AssignFile(TempFile,NewGameDir+'SNDDIR'); Rewrite(TempFile,1); CloseFile(TempFile);
            AssignFile(TempFile,NewGameDir+'PICDIR'); Rewrite(TempFile,1); CloseFile(TempFile);
            AssignFile(TempFile,NewGameDir+'OBJECT');
            Rewrite(TempFile,1);
            BlockWrite(TempFile,BlankObjectFile,8);
            CloseFile(TempFile);
            AssignFile(TempFile,NewGameDir+'WORDS.TOK');
            Rewrite(TempFile,1);
            BlockWrite(TempFile,BlankWordsFile,72);
            CloseFile(TempFile);
          end; // if not UseTemplate
          GameDir := FixSlashes(NewGameDir);
          OpenGame;
        end;  // if SourceDirOK
      end;  // if DirIsEmpty
    end;  // if CloseGame
  end;  // if GameDirSelect.DirectorySelected
end;

{*************************************************************}
                      {Component Events}

{*************************************************************}
procedure TMain.GameExitClick(Sender: TObject);
{*************************************************************}
begin
  Close;
end;

{*************************************************************}
procedure TMain.GameOpenClick(Sender: TObject);
{*************************************************************}
var CurChar      : byte;
begin
  GameDirSelect.Left := Main.Left + (Main.Width div 2) - (GameDirSelect.Width div 2);
  GameDirSelect.Top := Main.Top + (Main.Height div 2) - (GameDirSelect.Height div 2);
  GameDirSelect.WindowFunction := wfOpenGame;
  GameDirSelect.ShowModal;
  if GameDirSelect.DirectorySelected then
  begin
    if CheckGame(FixSlashes(GameDirSelect.DirectoryListBox1.Directory+'\')) then
    begin
      if (not GameIsOpen) or (GameIsOpen and CloseGame) then
      begin
        GameDir := FixSlashes(GameDirSelect.DirectoryListBox1.Directory+'\');
        OpenGame;
        MRUManager1.Add(GameDir,0);
        if MRUManager1.RecentMenu.Count = 1 then Reopen1.Enabled := False else Reopen1.Enabled := True;
          try
            RecentSettingsFile := TIniFile.Create(ProgramDir+'AGI Studio.ini');
            MRUManager1.SaveToIni(RecentSettingsFile,'Recent');
          finally
            RecentSettingsFile.Free;
          end;
      end; {if (not GameIsOpen) or (GameIsOpen and CloseGame)}
    end {if CheckGame(GameDirSelect.DirectoryListBox1.Directory+'\')}
    else ShowMessage('Either there was an error reading one or more files, or this directory does not contain a valid AGI version 2 or version 3 game.');
  end; {if GameDirSelect.DirectorySelected}
end;

procedure TMain.MRUManager1Click(Sender: TObject; const RecentName,
  Caption: String; UserData: Integer);
begin
  if (not GameIsOpen) or (GameIsOpen and CloseGame) then
    begin
      GameDir := RecentName;
      OpenGame;
    end;
end;

{*************************************************************}
procedure TMain.FormCreate(Sender: TObject);
{*************************************************************}
const BaseBMPFileData : array[0..123] of byte =
   ($42,$4D,$7C,$00,$00,$00,$00,$00,$00,$00,$76,$00,$00,$00,$28,$00,
    $00,$00,$01,$00,$00,$00,$01,$00,$00,$00,$01,$00,$04,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$12,$0B,$00,$00,$12,$0B,$00,$00,$00,$00,
    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$A0,$00,$00,$00,$00,$A0,
    $00,$00,$A0,$A0,$00,$00,$00,$00,$A0,$00,$A0,$00,$80,$00,$00,$50,
    $A0,$00,$A0,$A0,$A0,$00,$50,$50,$50,$00,$FF,$50,$50,$00,$50,$FF,
    $00,$00,$FF,$FF,$50,$00,$50,$50,$FF,$00,$FF,$50,$FF,$00,$50,$FF,
    $FF,$00,$FF,$FF,$FF,$00,$F0,$00,$00,$00,$00,$00);

var CurViewEditWinNum : byte;
    CurLogEditWinNum  : byte;
    TempStream : TMemoryStream;
    ScreenDC: HDC;
begin
  DefaultTop := Top;
  DefaultLeft := Left;
  DefaultWidth := Width;
  DefaultHeight := Height;
  GameIsOpen := False;
  for CurViewEditWinNum := 1 to MaxViewEditWins do
    ViewEditWinUsed[CurViewEditWinNum] := false;
  for CurLogEditWinNum := 1 to MaxLogEditWins do
    LogEditWinUsed[CurLogEditWinNum] := false;
  ProgramDir := (copy(ExpandFilename('a'),1,Length(ExpandFilename('a'))-1));
  Application.HelpFile := ProgramDir + 'AGI Studio.hlp';
  SettingsFile := TIniFile.Create(ProgramDir+'AGI Studio.ini');
  try
    RecentSettingsFile := TIniFile.Create(ProgramDir+'AGI Studio.ini');
    MRUManager1.LoadFromIni(RecentSettingsFile,'Recent');
  finally
    RecentSettingsFile.Free;
  end;
  if MRUManager1.RecentMenu.Count = 1 then Reopen1.Enabled := False else Reopen1.Enabled := True;
  ReadSettings;
  ResTypeName2 := TStringList.Create;
  SetResTypeName2;

  if FileExists(ProgramDir+'PICEDIT.EXE') then
  begin
    ToolsPicedit.Enabled := True;
    ToolbarPiceditBut.Enabled := True;
  end;

  if Settings.Windows.Main.Maximized then
  begin
    WindowState := wsMaximized
  end
  else
  begin
    if Settings.Windows.Main.Width >= Screen.Width then Settings.Windows.Main.Width := Screen.Width;
    if Settings.Windows.Main.Height >= Screen.Height then Settings.Windows.main.Height := Screen.Height;
    if Settings.Windows.Main.Top >= Screen.Height-20 then Settings.Windows.Main.Top := Screen.Height - Settings.Windows.Main.Height;
    if Settings.Windows.Main.Left >= Screen.Width-20 then Settings.Windows.Main.Left := Screen.Width - Settings.Windows.Main.Width;
    if Settings.Windows.Main.Top >= 0 then Top := Settings.Windows.Main.Top;
    if Settings.Windows.Main.Left >= 0 then Left := Settings.Windows.Main.Left;
    if Settings.Windows.Main.Width >= 0 then Width := Settings.Windows.Main.Width;
    if Settings.Windows.Main.Height >= 0 then Height := Settings.Windows.Main.Height;
  end;

  PreviewView.InUse := False;
  PreviewPic.InUse := False;
  GameIsOpen := False;
  Screen.OnActiveFormChange := UpdateMenuItems;
  if Settings.General.ShowSplashScreen then
  begin
    Main.Visible := True;
    LogoWin := TLogoWin.Create(Application);
    LogoWin.Left := Main.Left + (Main.Width div 2) - (LogoWin.Width div 2);
    LogoWin.Top := Main.Top + (Main.Height div 2) - (LogoWin.Height div 2);
    LogoWin.ShowModal;
    LogoWin.Free;
  end;
end;

{*************************************************************}
procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
{*************************************************************}
var CurMemoryItem : byte;
begin
  if PreviewView.InUse then FreePreviewView;
  if PreviewPic.InUse then FreePreviewPic;
  if GameIsOpen then
  if Length(GameSettings.GameExecutable) > 0 then
  GameSettingsFile.WriteString('GAME','EXECUTABLE',GameSettings.GameExecutable);
  if WindowState = wsMaximized then Settings.Windows.Main.Maximized := True
  else Settings.Windows.Main.Maximized := False;
  Settings.Windows.Main.Top := Main.Top;
  Settings.Windows.Main.Left := Main.Left;
  Settings.Windows.Main.Width := Main.Width;
  Settings.Windows.Main.Height := Main.Height;
  WriteSettings;
  ResTypeName2.Free;
  BaseBitmap.Free;
  FreeMem(EGALogPal, EGAPalSize);
  Screen.OnActiveFormChange := nil;
end;

{*************************************************************}
procedure TMain.GameRunClick(Sender: TObject);
{*************************************************************}
var GameExecutable : PChar;
    CurChar : byte;
    OldPath : string;

begin
  GetDir(0,OldPath);
  ChDir(GameDir);
  if Length(GameSettings.GameExecutable) = 0 then
  begin
    ShowMessage('Please select the game''s executable, e.g. SIERRA.COM');
    ExecutableSelectDialog.Execute;
    GameSettings.GameExecutable := ExtractFilename(ExecutableSelectDialog.Filename);
    GameSettingsFile.WriteString('GAME','EXECUTABLE',GameSettings.GameExecutable);
  end;
  if Length(GameSettings.GameExecutable) > 0 then
  begin
    GetMem(GameExecutable,Length(GameSettings.GameExecutable)+1);
    StrPCopy(GameExecutable,GameSettings.GameExecutable);
    WinExec(GameExecutable,SW_SHOW);
    FreeMem(GameExecutable,Length(GameSettings.GameExecutable)+1);
  end;
  ChDir(OldPath);
end;

{*************************************************************}
procedure TMain.ToolsPiceditClick(Sender: TObject);
{*************************************************************}
var TempPChar : PChar;
begin
  if FileExists(ProgramDir+'PICEDIT.EXE') then
  begin
    if GameIsOpen then ChDir(GameDir)
    else ChDir(ProgramDir);
    GetMem(TempPChar,Length(ProgramDir+'PICEDIT.EXE')+1);
    StrPCopy(TempPChar,ProgramDir+'PICEDIT.EXE');
    WinExec(TempPChar,SW_SHOW);
    FreeMem(TempPChar,Length(ProgramDir+'PICEDIT.EXE')+1);
  end
  else
  begin
    ToolsPicedit.Enabled := False;
    ShowMessage('File PICEDIT.EXE not found!');
  end;
end;

{*************************************************************}
procedure TMain.HelpAboutClick(Sender: TObject);
{*************************************************************}
begin
  About.Left := Main.Left + (Main.Width div 2) - (About.Width div 2);
  About.Top := Main.Top + (Main.Height div 2) - (About.Height div 2);
  About.ShowModal;
end;

{*************************************************************}
procedure TMain.ToolsViewEditClick(Sender: TObject);
{*************************************************************}
var ThisWinNum  : byte;
    CurWinNum   : byte;
    ResourceData : TResource;
    ResourceLoadSuccess : boolean;

begin
  ThisWinNum := 0;
  for CurWinNum := 1 to MaxViewEditWins do
    if not ViewEditWinUsed[CurWinNum] then ThisWinNum := CurWinNum;
  if ThisWinNum > 0 then
  begin
    ViewEditWinUsed[ThisWinNum] := true;
    ViewEditWin[ThisWinNum] := TViewEdit.Create(Main);
    ViewEditWin[ThisWinNum].ScaleFactor := 2;
    ViewEditWin[ThisWinNum].NewlyOpenedWindow := true;
    ViewEditWin[ThisWinNum].ViewEditorNum := ThisWinNum;
    ViewEditWin[ThisWinNum].MainView.NumLoops := 0;
    if ViewEditWin[ThisWinNum].ClientHeight < ViewEditWin[ThisWinNum].PaletteImage.Top + ViewEditWin[ThisWinNum].PaletteImage.Height then
      ViewEditWin[ThisWinNum].ClientHeight := ViewEditWin[ThisWinNum].PaletteImage.Top + ViewEditWin[ThisWinNum].PaletteImage.Height;
    ViewEditWin[ThisWinNum].OnResize(ResourceWin);
    ViewEditWin[ThisWinNum].NewView;
    ViewEditWin[ThisWinNum].Show;
  end;
end;

{*************************************************************}
procedure TMain.ToolsObjEditClick(Sender: TObject);
{*************************************************************}
var FoundObjedit : boolean;
    CurMDIChild : integer;
begin
  FoundObjedit := False;
  if MDIChildCount > 0 then
  for CurMDIChild := MDIChildCount - 1 downto 0 do
    if MDIChildren[CurMDIChild] = ObjEditMain then FoundObjedit := True;
  if not FoundObjedit then
  begin
    Application.CreateForm(TObjEditMain, ObjEditMain);
    ObjEditMain.OnResize(Main);
    if GameIsOpen then
    begin
      if not ObjEditMain.ReadFile(GameDir+'OBJECT') then
      ObjEditMain.NewFile;
    end
    else
      ObjEditMain.NewFile;
  end
  else
  begin
    ObjEditMain.Show;
    ObjEditMain.SetFocus;
  end;
end;

{*************************************************************}
procedure TMain.Contents1Click(Sender: TObject);
{*************************************************************}
begin
  Application.HelpJump('CONTENTS');
end;

{*************************************************************}
procedure TMain.Index1Click(Sender: TObject);
{*************************************************************}
begin
  Application.HelpCommand(HELP_FINDER,0);
end;

{*************************************************************}
procedure TMain.ToolsWordsEditClick(Sender: TObject);
{*************************************************************}
var FoundWordsEdit : boolean;
    CurMDIChild : integer;
begin
  FoundWordsEdit := False;
  if MDIChildCount > 0 then
  for CurMDIChild := MDIChildCount - 1 downto 0 do
    if MDIChildren[CurMDIChild] = WordsEditMain then FoundWordsEdit := True;
  if not FoundWordsEdit then
  begin
    Application.CreateForm(TWordsEditMain, WordsEditMain);
//    WordsEditMain.ClientWidth := WordsEditMain.WordPanel.Left + WordsEditMain.WordPanel.Width;
    WordsEditMain.OnResize(Main);
    if GameIsOpen then
    begin
      if not WordsEditMain.OpenFile(GameDir+'WORDS.TOK') then
      WordsEditMain.NewFile;
    end
    else
      WordsEditMain.NewFile;
  end
  else
  begin
    WordsEditMain.Show;
    WordsEditMain.SetFocus;
  end;
end;


{*************************************************************}
procedure TMain.ToolbarOpenButClick(Sender: TObject);
{*************************************************************}
begin
  GameOpenClick(Main);
end;

{*************************************************************}
procedure TMain.ToolbarRunButClick(Sender: TObject);
{*************************************************************}
begin
  if GameRun.Enabled then GameRunClick(Main);
end;

{*************************************************************}
procedure TMain.ToolBarViewEditButClick(Sender: TObject);
{*************************************************************}
begin
  if ToolsViewEdit.Enabled then ToolsViewEditClick(Main);
end;

{*************************************************************}
procedure TMain.ToolbarObjEditButClick(Sender: TObject);
{*************************************************************}
begin
  if ToolsObjedit.Enabled then ToolsObjeditClick(Main);
end;

{*************************************************************}
procedure TMain.ToolbarWordsEditButClick(Sender: TObject);
{*************************************************************}
begin
  if ToolsWordsEdit.Enabled then ToolsWordsEditClick(Main);
end;

{*************************************************************}
procedure TMain.ToolbarPiceditButClick(Sender: TObject);
{*************************************************************}
begin
  if ToolsPicedit.Enabled then ToolsPiceditClick(Main);
end;

{*************************************************************}
procedure TMain.GameCloseClick(Sender: TObject);
{*************************************************************}
begin
  CloseGame;
end;

{*************************************************************}
procedure TMain.ToolbarCloseButClick(Sender: TObject);
{*************************************************************}
begin
  if GameClose.Enabled then GameCloseClick(Main);
end;

{*************************************************************}
procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
{*************************************************************}
begin
  if not CloseGame then CanClose := False;
end;

{*************************************************************}
procedure TMain.GameMenu_SettingsClick(Sender: TObject);
{*************************************************************}
begin
  SettingsWin.Left := Main.Left + (Main.Width div 2) - (SettingsWin.Width div 2);
  SettingsWin.Top := Main.Top + (Main.Height div 2) - (SettingsWin.Height div 2);
  SettingsWin.ShowModal;
end;

{*************************************************************}
procedure TMain.WindowCascadeClick(Sender: TObject);
{*************************************************************}
begin
  Cascade;
end;
{*************************************************************}
procedure TMain.WindowTileClick(Sender: TObject);
{*************************************************************}
begin
  Tile;
end;

{*************************************************************}
procedure TMain.WindowArrangeIconsClick(Sender: TObject);
{*************************************************************}
begin
  ArrangeIcons;
end;

{*************************************************************}
procedure TMain.WindowMinimizeAllClick(Sender: TObject);
{*************************************************************}
var CurMDIChild : integer;
begin
  for CurMDIChild := MDIChildCount - 1 downto 0 do
    MDIChildren[CurMDIChild].WindowState := wsMinimized;
end;

{*************************************************************}
procedure TMain.ToolsTextEditClick(Sender: TObject);
{*************************************************************}
begin
  EditTextFile('');
end;

{*************************************************************}
procedure TMain.ToolsLogEditClick(Sender: TObject);
{*************************************************************}
begin
  EditLogic(0,True);  // new logic
end;

{*************************************************************}
procedure TMain.GameNewBlankClick(Sender: TObject);
{*************************************************************}
begin
  NewGame(False);
end;

{*************************************************************}
procedure TMain.GameNewTemplateClick(Sender: TObject);
{*************************************************************}
begin
  NewGame(True);
end;

{*************************************************************}
procedure TMain.ToolbarLogEditButClick(Sender: TObject);
{*************************************************************}
begin
  if ToolsLogEdit.Enabled then ToolsLogEditClick(Main);
end;

{*************************************************************}
procedure TMain.ToolbarTextEditButClick(Sender: TObject);
{*************************************************************}
begin
  if ToolsTextEdit.Enabled then ToolsTextEditClick(Main);
end;

{*************************************************************}
procedure TMain.GoWeb(URL:String);
{*************************************************************}
begin
  ShellExecute(Application.Handle,'open',PChar(URL), nil, nil, SW_NORMAL);
end;

{*************************************************************}
procedure TMain.MessageBoard1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.mega-tokyo.com/cgi-bin/yabb/YaBB.pl');
end;

{*************************************************************}
procedure TMain.OfficialAGIStudioSite1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://members.ozemail.com.au/~ptrkelly/agi/');
end;

{*************************************************************}
procedure TMain.PicEdit121Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://members.ozemail.com.au/~ptrkelly/agi/utils/picedit.zip');
end;

{*************************************************************}
procedure TMain.AGIStudiov131aSourceCode1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://members.ozemail.com.au/~ptrkelly/agi/agistudio.zip');
end;

{*************************************************************}
procedure TMain.CheckforNewVersion1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://nailhead.org/agistudio');
end;

{*************************************************************}
procedure TMain.Items1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://members.ozemail.com.au/~ptrkelly/agi/docs/items.html');
end;

{*************************************************************}
procedure TMain.Doors1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://members.ozemail.com.au/~ptrkelly/agi/docs/doors.html');
end;

{*************************************************************}
procedure TMain.Rooms1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.ozemail.com.au/~ptrkelly/agi/docs/room_structure.html');
end;

{*************************************************************}
procedure TMain.Defines1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://members.ozemail.com.au/~ptrkelly/agi/docs/defines.html');
end;

{*************************************************************}
procedure TMain.UltimateAGISCIWebsite1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://agisci.cjb.net');
end;

{*************************************************************}
procedure TMain.Createagamein9Steps1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.geocities.com/jonozon/Tutorial1/tutorial.htm');
end;

{*************************************************************}
procedure TMain.HowtomakeanAGIGame1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.eds.org/~david/agi/howto/');
end;

{*************************************************************}
procedure TMain.PriorityScreens1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.pp.htv.fi/jterho1/agi/priority-explanation/');
end;

{*************************************************************}
procedure TMain.limitationsofprioritybands1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.pp.htv.fi/jterho1/agi/priority-workarounds/');
end;

{*************************************************************}
procedure TMain.ThemakingofanAGIbackgroundpicture1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.pp.htv.fi/jterho1/agi/picture-creation/');
end;

{*************************************************************}
procedure TMain.MakingAGIGames1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.adventurecollective.com/articles/feature-agi-1.htm');
end;

{*************************************************************}
procedure TMain.AGIStackPatch1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://members.dingoblue.net.au/~sonneveld/agi/');
end;

{*************************************************************}
procedure TMain.ChrissAGIWebSite1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.agi.zzn.com');
end;

{*************************************************************}
procedure TMain.AGIdevcom1Click(Sender: TObject);
{*************************************************************}
begin
  GoWeb('http://www.agidev.com');
end;

{*************************************************************}
procedure TMain.tbFileSaveClick(Sender: TObject);
{*************************************************************}
begin
  LogEditWin[1].FileSave.Click;
end;

{*************************************************************}
function TMain.FixSlashes(Dest: string): string;
{*************************************************************}
var
  Position: Integer;
begin
  Position := Pos('//', Dest);
  if Position <> 0 then
  begin
    Delete(Dest, Position, 2);
    Insert('/', Dest, Position);
  end;
    Result := Dest;
end;

{*************************************************************}
procedure TMain.Customize1Click(Sender: TObject);
{*************************************************************}
begin
  MenuDesignerForm.Show;
end;



end.
