//---------------------------------------------------------------------------

#include <vcl.h>
#include <math.h>
#pragma hdrstop

#include "gfxedits.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

TColor clFados[5][16]={
	{(TColor)0x54FF40,(TColor)0x68EB40,(TColor)0x7DD640,(TColor)0x91C140,(TColor)0xA6AC40,(TColor)0xBC9640,(TColor)0xD27940,(TColor)0xE85C40,
     (TColor)0xFF4040,(TColor)0xE85C40,(TColor)0xD27940,(TColor)0xBC9640, (TColor)0xA6AC40,(TColor)0x91C140,(TColor)0x7DD640,(TColor)0x68EB40},
	{(TColor)0x4054FF,(TColor)0x3A68FF,(TColor)0x327DFF,(TColor)0x2B91FF,(TColor)0x24A6FF,(TColor)0x1DBCFF,(TColor)0x13D2FF,(TColor)0x09E8FF,
     (TColor)0x00FFFF,(TColor)0x09E8FF,(TColor)0x13D2FF,(TColor)0x1DBCFF,(TColor)0x24A6FF,(TColor)0x2B91FF,(TColor)0x327DFF,(TColor)0x3A68FF},
    {(TColor)0xC00000,(TColor)0xC90926,(TColor)0xD2134C,(TColor)0xDC1D72,(TColor)0xE32491,(TColor)0xea2bac,(TColor)0xF132C8,(TColor)0xf93ae4,
     (TColor)0xff00ff,(TColor)0xf93ae4,(TColor)0xF132C8,(TColor)0xea2bac,(TColor)0xE32491,(TColor)0xDC1D72,(TColor)0xD2134C,(TColor)0xC90926},
    {(TColor)0x80FF00,(TColor)0x70DF00,(TColor)0x60BF00,(TColor)0x509F00,(TColor)0x407F00,(TColor)0x305F00,(TColor)0x203F00,(TColor)0x101F00,
	 (TColor)0x000000,(TColor)0x101F00,(TColor)0x203F00,(TColor)0x305F00,(TColor)0x407F00,(TColor)0x509F00,(TColor)0x60BF00,(TColor)0x70DF00,},
	{(TColor)0xFF8000,(TColor)0xDF7000,(TColor)0xBF6000,(TColor)0x9F5000,(TColor)0x7F4000,(TColor)0x5F3000,(TColor)0x3F2000,(TColor)0x1F1000,
	 (TColor)0x000000,(TColor)0x1F1000,(TColor)0x3F2000,(TColor)0x5F3000,(TColor)0x7F4000,(TColor)0x9F5000,(TColor)0xBF6000,(TColor)0xDF7000,},
};
tsCSRRES csrRes[] = {
	{TOOL_PEN,			"PENCURSOR"},
	{TOOL_REPLACE,		"PENREPLACECURSOR"},
	{TOOL_LINE,			"LINECURSOR"},
	{TOOL_FILL,			"FILLCURSOR"},
	{TOOL_RECT,			"SQUARECURSOR"},
	{TOOL_RECTF,		"SQUAREFCURSOR"},
	{TOOL_RRECT,		"RSQUARECURSOR"},
	{TOOL_RRECTF,		"RSQUAREFCURSOR"},
	{TOOL_ELLIPSE,		"ELLIPSECURSOR"},
	{TOOL_ELLIPSEF,		"ELLIPSEFCURSOR"},

	{-1,				NULL},
	{TOOL_GRABBER,		"COLGRABCURSOR"},
	{TOOL_ZOOM,			"ZOOMCURSOR"},
	{TOOL_SCROLL,		"SCROLLCURSOR"},
	{TOOL_SELECTION,	"SELECTION"},
	{TOOL_SELRESIZE,	"SELECTIONRZCURSOR"},
	{TOOL_SELMOVE,		"DRAG"},
	{TOOL_SELCOPY,		"SELECTIONCOPYCURSOR"}
};

//---------------------------------------------------------------------------
U8 defView[56] = {
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0A, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00,
    0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x03, 0x00,
    0xF3, 0x13, 0xF3, 0x13, 0xF3, 0x13, 0xF3, 0x13,
    0xF3, 0x13, 0xF3, 0x13, 0xF3, 0x13, 0xF3, 0x13,
    0xF3, 0x13, 0xF3, 0x13, 0xF3, 0x13, 0xF3, 0x13,
    0xF3, 0x13, 0xF3, 0x13, 0xF3, 0x13, 0xF3, 0x13
};
//---------------------------------------------------------------------------
U8 defCursor[68] = {
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};
//---------------------------------------------------------------------------
U8 defFont[1308] = {
	0x00,0x00,0x80,0x00,0x08,0x00,0x06,0x01,0x0F,0x01,0x18,0x01,0x28,0x01,0x3F,0x01,
	0x49,0x01,0x52,0x01,0x5B,0x01,0x64,0x01,0x72,0x01,0x80,0x01,0x83,0x01,0x86,0x01,
	0x89,0x01,0x8C,0x01,0x8F,0x01,0x92,0x01,0x95,0x01,0x98,0x01,0x9B,0x01,0x9E,0x01,
	0xA1,0x01,0xA4,0x01,0xA7,0x01,0xAA,0x01,0xAD,0x01,0xB0,0x01,0xB3,0x01,0xB6,0x01,
	0xB9,0x01,0xBC,0x01,0xBF,0x01,0xC2,0x01,0xCB,0x01,0xD4,0x01,0xDD,0x01,0xE6,0x01,

	0xEF,0x01,0xF8,0x01,0x01,0x02,0x0A,0x02,0x13,0x02,0x1C,0x02,0x23,0x02,0x2D,0x02,
	0x36,0x02,0x3F,0x02,0x48,0x02,0x51,0x02,0x5A,0x02,0x63,0x02,0x6C,0x02,0x75,0x02,
	0x7E,0x02,0x87,0x02,0x90,0x02,0x99,0x02,0xA2,0x02,0xAB,0x02,0xB4,0x02,0xBD,0x02,
	0xC6,0x02,0xCF,0x02,0xD8,0x02,0xE1,0x02,0xEA,0x02,0xF3,0x02,0xFC,0x02,0x05,0x03,
	0x0E,0x03,0x17,0x03,0x20,0x03,0x29,0x03,0x32,0x03,0x3B,0x03,0x44,0x03,0x4D,0x03,

	0x56,0x03,0x5F,0x03,0x68,0x03,0x71,0x03,0x7A,0x03,0x83,0x03,0x8C,0x03,0x95,0x03,
	0x9E,0x03,0xA7,0x03,0xB0,0x03,0xB9,0x03,0xC2,0x03,0xCB,0x03,0xD4,0x03,0xDD,0x03,
	0xE6,0x03,0xEF,0x03,0xF8,0x03,0x01,0x04,0x0A,0x04,0x13,0x04,0x1C,0x04,0x25,0x04,
	0x2E,0x04,0x37,0x04,0x40,0x04,0x49,0x04,0x52,0x04,0x5B,0x04,0x64,0x04,0x6D,0x04,
	0x76,0x04,0x7F,0x04,0x88,0x04,0x91,0x04,0x9A,0x04,0xA3,0x04,0xAC,0x04,0xB5,0x04,

	0xBE,0x04,0xC7,0x04,0xD0,0x04,0xD9,0x04,0xE2,0x04,0xEB,0x04,0xF5,0x04,0xFE,0x04,
	0x07,0x05,0x10,0x05,0x19,0x05,0x08,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,
	0x07,0xE0,0xD0,0xEE,0xDD,0xDE,0xEC,0x0C,0x0C,0x07,0x00,0x00,0x48,0xE0,0xA8,0x40,
	0xA8,0x40,0xE8,0x40,0xAE,0x40,0x00,0x00,0x11,0x07,0x00,0x00,0x00,0x67,0x64,0x00,
	0x92,0x54,0x00,0x82,0x64,0x00,0x92,0x54,0x00,0x62,0x57,0x00,0x00,0x00,0x00,0x07,

	0x08,0x38,0x44,0x9A,0xA2,0xA2,0x9A,0x44,0x38,0x06,0x07,0xE0,0x40,0x40,0x40,0x28,
	0x38,0x28,0x08,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x07,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x09,0x06,0x10,0x00,0x30,0x00,0x7F,0x00,0x7F,0x00,0x30,0x00,
	0x10,0x00,0x0C,0x06,0x00,0x00,0x72,0x60,0x25,0x50,0x25,0x60,0x27,0x50,0x25,0x60,
	0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,

	0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,
	0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,
	0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,0x01,0x40,0x02,
	0x01,0x40,0x04,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x07,0x40,0x40,0x40,
	0x40,0x00,0x40,0x00,0x05,0x07,0x50,0x50,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x28,

	0x7C,0x28,0x28,0x7C,0x28,0x00,0x04,0x07,0x20,0x30,0x40,0x20,0x10,0x60,0x20,0x06,
	0x07,0x24,0x58,0x34,0x28,0x40,0x00,0x00,0x04,0x07,0x20,0x30,0x40,0x20,0x40,0x30,
	0x20,0x03,0x07,0x20,0x20,0x40,0x00,0x00,0x00,0x00,0x04,0x07,0x10,0x20,0x40,0x40,
	0x40,0x20,0x10,0x04,0x07,0x40,0x20,0x10,0x10,0x10,0x20,0x40,0x06,0x05,0x10,0x54,
	0x38,0x54,0x10,0x04,0x08,0x00,0x20,0x20,0x70,0x20,0x20,0x00,0x00,0x03,0x07,0x00,

	0x00,0x00,0x00,0x20,0x20,0x40,0x05,0x07,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x04,
	0x07,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x05,0x07,0x08,0x10,0x10,0x20,0x20,0x40,
	0x00,0x05,0x07,0x30,0x48,0x58,0x68,0x48,0x30,0x00,0x05,0x07,0x20,0x60,0x20,0x20,
	0x20,0x70,0x00,0x05,0x07,0x30,0x48,0x08,0x30,0x40,0x78,0x00,0x05,0x07,0x70,0x08,
	0x30,0x08,0x08,0x70,0x00,0x05,0x07,0x18,0x28,0x48,0x78,0x08,0x08,0x00,0x05,0x07,

	0x78,0x40,0x70,0x08,0x08,0x70,0x00,0x05,0x07,0x30,0x40,0x70,0x48,0x48,0x30,0x00,
	0x05,0x07,0x78,0x08,0x10,0x20,0x20,0x20,0x00,0x05,0x07,0x30,0x48,0x30,0x48,0x48,
	0x30,0x00,0x05,0x07,0x30,0x48,0x48,0x38,0x08,0x30,0x00,0x02,0x07,0x00,0x40,0x00,
	0x00,0x40,0x00,0x00,0x03,0x07,0x00,0x20,0x00,0x00,0x20,0x20,0x40,0x04,0x07,0x00,
	0x10,0x20,0x40,0x20,0x10,0x00,0x04,0x07,0x00,0x00,0x70,0x00,0x70,0x00,0x00,0x04,

	0x07,0x00,0x40,0x20,0x10,0x20,0x40,0x00,0x04,0x07,0x20,0x50,0x10,0x20,0x20,0x00,
	0x20,0x08,0x07,0x1C,0x2A,0x55,0x55,0x2E,0x18,0x00,0x05,0x07,0x30,0x48,0x48,0x78,
	0x48,0x48,0x00,0x05,0x07,0x70,0x48,0x70,0x48,0x48,0x70,0x00,0x05,0x07,0x30,0x48,
	0x40,0x40,0x48,0x30,0x00,0x05,0x07,0x70,0x48,0x48,0x48,0x48,0x70,0x00,0x05,0x07,
	0x78,0x40,0x70,0x40,0x40,0x78,0x00,0x05,0x07,0x78,0x40,0x70,0x40,0x40,0x40,0x00,

	0x05,0x07,0x30,0x48,0x40,0x58,0x48,0x30,0x00,0x05,0x07,0x48,0x48,0x78,0x48,0x48,
	0x48,0x00,0x04,0x07,0x70,0x20,0x20,0x20,0x20,0x70,0x00,0x05,0x07,0x08,0x08,0x08,
	0x08,0x48,0x30,0x00,0x05,0x07,0x48,0x50,0x60,0x50,0x48,0x48,0x00,0x05,0x07,0x40,
	0x40,0x40,0x40,0x40,0x78,0x00,0x06,0x07,0x44,0x6C,0x54,0x44,0x44,0x44,0x00,0x06,
	0x07,0x44,0x64,0x54,0x4C,0x44,0x44,0x00,0x05,0x07,0x30,0x48,0x48,0x48,0x48,0x30,

	0x00,0x05,0x07,0x70,0x48,0x48,0x70,0x40,0x40,0x00,0x06,0x07,0x30,0x48,0x48,0x48,
	0x48,0x38,0x04,0x05,0x07,0x70,0x48,0x48,0x70,0x48,0x48,0x00,0x05,0x07,0x30,0x48,
	0x20,0x10,0x48,0x30,0x00,0x06,0x07,0x7C,0x10,0x10,0x10,0x10,0x10,0x00,0x05,0x07,
	0x48,0x48,0x48,0x48,0x48,0x30,0x00,0x06,0x07,0x44,0x44,0x44,0x44,0x28,0x10,0x00,
	0x06,0x07,0x44,0x44,0x44,0x54,0x54,0x28,0x00,0x06,0x07,0x44,0x28,0x10,0x10,0x28,

	0x44,0x00,0x06,0x07,0x44,0x44,0x28,0x10,0x10,0x10,0x00,0x05,0x07,0x78,0x08,0x10,
	0x20,0x40,0x78,0x00,0x03,0x07,0x60,0x40,0x40,0x40,0x40,0x40,0x60,0x05,0x07,0x40,
	0x20,0x20,0x10,0x10,0x08,0x00,0x03,0x07,0x60,0x20,0x20,0x20,0x20,0x20,0x60,0x04,
	0x07,0x20,0x50,0x00,0x00,0x00,0x00,0x00,0x04,0x07,0x00,0x00,0x00,0x00,0x00,0x00,
	0x70,0x03,0x07,0x40,0x20,0x00,0x00,0x00,0x00,0x00,0x05,0x07,0x00,0x30,0x08,0x38,

	0x48,0x38,0x00,0x05,0x07,0x40,0x40,0x70,0x48,0x48,0x70,0x00,0x05,0x07,0x00,0x30,
	0x48,0x40,0x48,0x30,0x00,0x05,0x07,0x08,0x08,0x38,0x48,0x48,0x38,0x00,0x05,0x07,
	0x00,0x30,0x48,0x78,0x40,0x38,0x00,0x05,0x07,0x18,0x20,0x70,0x20,0x20,0x20,0x00,
	0x05,0x07,0x00,0x30,0x48,0x48,0x38,0x48,0x30,0x05,0x07,0x40,0x40,0x50,0x68,0x48,
	0x48,0x00,0x02,0x07,0x40,0x00,0x40,0x40,0x40,0x40,0x00,0x04,0x07,0x10,0x00,0x10,

	0x10,0x10,0x10,0x60,0x04,0x07,0x40,0x50,0x50,0x60,0x50,0x50,0x00,0x02,0x07,0x40,
	0x40,0x40,0x40,0x40,0x40,0x00,0x06,0x07,0x00,0x68,0x54,0x54,0x54,0x54,0x00,0x05,
	0x07,0x00,0x50,0x68,0x48,0x48,0x48,0x00,0x05,0x07,0x00,0x30,0x48,0x48,0x48,0x30,
	0x00,0x05,0x07,0x00,0x70,0x48,0x48,0x70,0x40,0x40,0x05,0x07,0x00,0x30,0x48,0x48,
	0x38,0x08,0x08,0x05,0x07,0x00,0x58,0x60,0x40,0x40,0x40,0x00,0x05,0x07,0x00,0x38,

	0x40,0x30,0x08,0x70,0x00,0x04,0x07,0x20,0x70,0x20,0x20,0x20,0x20,0x00,0x05,0x07,
	0x00,0x48,0x48,0x48,0x48,0x38,0x00,0x06,0x07,0x00,0x44,0x44,0x44,0x28,0x10,0x00,
	0x06,0x07,0x00,0x54,0x54,0x54,0x54,0x28,0x00,0x05,0x07,0x00,0x48,0x48,0x30,0x48,
	0x48,0x00,0x05,0x07,0x00,0x48,0x48,0x48,0x38,0x08,0x70,0x05,0x08,0x00,0x78,0x08,
	0x30,0x40,0x78,0x00,0x00,0x04,0x07,0x10,0x20,0x20,0x40,0x20,0x20,0x10,0x03,0x07,

	0x40,0x40,0x40,0x00,0x40,0x40,0x40,0x04,0x07,0x40,0x20,0x20,0x10,0x20,0x20,0x40,
	0x05,0x07,0x28,0x50,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x40
};        
//---------------------------------------------------------------------------
U8 defPic[178] = {
	0xFE,0x01,
    	0x00,
    	0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88,0x99,
        0xAA,0xBB,0xCC,0xDD,0xEE,0x88,0x88,0x01,0x02,0x03,
        0x04,0x05,0x06,0x88,0x88,0xF9,0xFA,0xFB,0xFC,0xFD,
        0xFE,0xFF,0x08,0x91,0x2A,0x3B,0x4C,0x5D,0x6E,0x88,
    0xFE,0x01,
    	0x01,
        0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x81,
        0x82,0x83,0x84,0x85,0xE6,0x87,0x87,0x71,0x72,0x73,
        0x74,0x75,0x76,0x78,0x87,0x89,0x8A,0x8B,0x8C,0x8D,
        0x8E,0x8F,0xF8,0xF1,0xFA,0x3B,0xFC,0xFD,0xFE,0xF8,
    0xFE,0x01,
    	0x02,
        0x00,0x51,0x12,0x23,0x24,0x65,0xC6,0x37,0x08,0x59,
        0x1A,0x2B,0x2C,0x6D,0xCE,0xB8,0x88,0xD1,0x92,0xA3,
        0xA4,0x65,0x46,0x38,0x78,0xD9,0x9A,0xAB,0xAC,0x6D,
        0x4E,0x3F,0x7F,0x94,0xDA,0xEB,0xBC,0x4D,0x54,0x88,
    0xFE,0x01,
    	0x03,
        0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0xE8,0xE9,
        0xEA,0xEB,0xEC,0xED,0xEE,0xE8,0x48,0x41,0x42,0x43,
        0x44,0x45,0x46,0x48,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,
        0xCE,0xCF,0x18,0x11,0x1A,0x0B,0x1C,0x1D,0x1E,0x18,
    0xF9,0x00,0xF1,0xF3,0xFC,0xFF
};
//---------------------------------------------------------------------------
void SetupLogPal(tPAL *pal)
{
	// Set up the palette
	pal->lPal = (PLOGPALETTE)ssAlloc(sizeof(LOGPALETTE) + (sizeof(PALETTEENTRY) * 256));
	pal->lPal->palNumEntries = 256;
	pal->lPal->palVersion = 0x300;
    int q=0;
	for (int i = 0; i < 256; i++){
		pal->lPal->palPalEntry[i].peRed   = pal->cols[q] & 0xFF;
		pal->lPal->palPalEntry[i].peGreen = (pal->cols[q] >> 8) & 0xFF;
		pal->lPal->palPalEntry[i].peBlue  = (pal->cols[q] >> 16) & 0xFF;
		pal->lPal->palPalEntry[i].peFlags = PC_NOCOLLAPSE;
        q++;
        if(q>pal->bitdepth) q=0;
	}
    pal->handle = CreatePalette(pal->lPal);
}
//---------------------------------------------------------------------------
void FreeLogPal(tPAL *pal)
{
	// Set up the palette
    ssFree(pal->lPal);
    DeleteObject(pal->handle);
}
//---------------------------------------------------------------------------
#include "main.h"
Graphics::TBitmap *NewPaledBitmap(tPAL *pal, int Width, int Height)
{
	Graphics::TBitmap *TempBitmap;

    HPALETTE handle = CreatePalette(pal->lPal);

	// Set up the palette
	TempBitmap = new Graphics::TBitmap;
	TempBitmap->PixelFormat = pf8bit;
	TempBitmap->Width = Width;
	TempBitmap->Height = Height;
	TempBitmap->Palette = handle;

	return TempBitmap;
}
//---------------------------------------------------------------------------
void xDeletePaledBitmap(Graphics::TBitmap *b)
{
	if(!b) return;
    if(b->Palette) DeleteObject((HPALETTE)b->Palette);
    b->Palette = NULL;
    delete b;
}
//---------------------------------------------------------------------------
U8 GetPaldex(TColor cl, tPAL *pal)
{
	for(int c=pal->bitdepth-1;c>=0;c--)
		if(pal->cols[c]==cl)
        	return c;
    return 0;
}      
//---------------------------------------------------------------------------
BOOL InRect(TRect r, int x, int y)
{
	return(x>r.left&&x<r.right&&y>r.Top&&y<r.bottom);
}
//---------------------------------------------------------------------------
U8 * ResizeBits(U8 *bits, int oWidth, int oHeight, int nWidth, int nHeight, U8 bkCol)
{
	if(nHeight < oHeight) oHeight = nHeight;
    int maxWidth = (nWidth>oWidth)?oWidth:nWidth;

	U8 *newBits = (U8*) ssAlloc(nWidth*nHeight);
    memset(newBits,bkCol,nWidth*nHeight);
    for(int y=0;y<oHeight;y++)
    	memcpy(newBits+(y*nWidth),bits+(y*oWidth),maxWidth);
    ssFree(bits);
 	return newBits;
}   
//---------------------------------------------------------------------------
void BitmapToBits(Graphics::TBitmap *bmp, U8 *bits, tPAL *pal)
{
	for(int y=0;y<bmp->Height;y++)
    	for(int x=0;x<bmp->Width;x++) {
        	*bits++ = GetPaldex(bmp->Canvas->Pixels[x][y],pal);
        }
}
//---------------------------------------------------------------------------
void PenDraw(Graphics::TBitmap *b,int x,int y)
{
    if(b->Canvas->Pen->Width==1)
    	b->Canvas->FillRect(
        	Rect(x,y,x+1,y+1)
    	);
    else
    	b->Canvas->FillRect(
        	Rect(
        		x-(b->Canvas->Pen->Width>>1),
        		y-(b->Canvas->Pen->Width>>1),
        		x+(b->Canvas->Pen->Width>>1),
        		y+(b->Canvas->Pen->Width>>1)
        	)
    	);
}
//--------------------------------------------------------------------------- 
void PenReplaceDraw(Graphics::TBitmap *b,int x,int y, TColor c1, TColor c2)
{
	int x1=x-(b->Canvas->Pen->Width>>1);
	int y1=y-(b->Canvas->Pen->Width>>1);
	int x2=x+(b->Canvas->Pen->Width>>1);
	int y2=y+(b->Canvas->Pen->Width>>1);

    if(x1==x2) x2++;
    if(y1==y2) y2++;

    for(y=y1;y<y2;y++)
    	for(x=x1;x<x2;x++)
        	if(b->Canvas->Pixels[x][y]==c1)
            	b->Canvas->Pixels[x][y]=c2;
}                                                                       
//---------------------------------------------------------------------------
void ShapeDraw(Graphics::TBitmap *b,int x1,int y1,int x2,int y2,int tool)
{
	TRect r;
    TBrushStyle OldBrush;
    TColor oldPenColor;
    r.Top = (y1>y2)? y2:y1;
    r.Left = (x1>x2)? x2:x1;
    r.Bottom = (y1>y2)? y1:y2;
    r.Right = (x1>x2)? x1:x2;

    OldBrush = b->Canvas->Brush->Style;
	oldPenColor = b->Canvas->Pen->Color;

    switch(tool) {
    	case TOOL_RECT:           
            b->Canvas->Brush->Style = bsClear;
			b->Canvas->Rectangle(r);
        	break;
    	case TOOL_RECTF:
			b->Canvas->FillRect(r);
        	break;
    	case TOOL_RRECT:
            b->Canvas->Brush->Style = bsClear;
            b->Canvas->RoundRect(r.Left,r.Top,r.Right,r.Bottom, 8, 8);
        	break;
    	case TOOL_RRECTF:
			b->Canvas->RoundRect(r.Left,r.Top,r.Right,r.Bottom,8,8);
        	break;    
    	case TOOL_ELLIPSE:
            b->Canvas->Brush->Style = bsClear;
            b->Canvas->Ellipse(r.Left,r.Top,r.Right,r.Bottom);
        	break;
    	case TOOL_ELLIPSEF:
            b->Canvas->Ellipse(r.Left,r.Top,r.Right,r.Bottom);
        	break;
    }      
	b->Canvas->Pen->Color = oldPenColor;   
	b->Canvas->Brush->Style = (TBrushStyle) OldBrush;
}   
//---------------------------------------------------------------------------
void LineDraw(Graphics::TBitmap *b,int x1,int y1,int x2,int y2)
{                           
	b->Canvas->Pen->Width = 1;
	b->Canvas->Pen->Style = psDot;
	b->Canvas->MoveTo(x1,y1);
	b->Canvas->LineTo(x2,y2);
}
//---------------------------------------------------------------------------
void ImageSetSize(TImage *im, int w, int h)
{
    Graphics::TBitmap *b = new Graphics::TBitmap;
    im->Width  = w;
    b->Width  = w;
    im->Height = h;
    b->Height = h;
    im->Picture->Bitmap->Assign(b);
    delete b;
}
//---------------------------------------------------------------------------
void DrawBufferToCanvas(TCanvas *c, int x, int y, U8 *b, int w, int h, tPAL *p)
{                                   
	Graphics::TBitmap *bm=new Graphics::TBitmap;
    bm->Width = w;
    bm->Height = h;
	for(int yy=0;yy<h;yy++)
    	for(int xx=0;xx<w;xx++)
        	bm->Canvas->Pixels[xx][yy] = p->cols[*b++];
    c->Draw(x,y,bm);
    delete bm;
}
//---------------------------------------------------------------------------
// make a VCL bitmap with a palette instead of in 24 bit
Graphics::TBitmap *DrawBufferToBitmap(U8 *b, int w, int h, tPAL *p, BOOL mirx, BOOL miry)
{
	Graphics::TBitmap *bm=NewPaledBitmap(p, w, h);

    if(mirx&&miry) {
		for(int y=h-1;y>=0;y--)
    		for(int x=w-1;x>=0;x--)
        		bm->Canvas->Pixels[x][y] = p->cols[*b++];
    } else if(mirx) {
		for(int y=0;y<h;y++)
    		for(int x=w-1;x>=0;x--)
        		bm->Canvas->Pixels[x][y] = p->cols[*b++];
    } else if(miry) {
		for(int y=h-1;y>=0;y--)
    		for(int x=0;x<w;x++)
        		bm->Canvas->Pixels[x][y] = p->cols[*b++];
    } else {
		for(int y=0;y<h;y++)
    		for(int x=0;x<w;x++)
        		bm->Canvas->Pixels[x][y] = p->cols[*b++];
    }
    return bm;
}                      
//---------------------------------------------------------------------------
void ViewSetUpUpDowns(sciVIEW *view,TUpDown *udLoop,TUpDown *udCel)
{
	if(!view) return;
    udLoop->Max = view->totalLoops-1;
    udLoop->Enabled = udLoop->Max;
    udCel->Max = ViewGetLoop(view,0)->totalCels-1;
    udCel->Enabled = udCel->Max;

    udLoop->Position = 0;
   	udCel->Position = 0;
}
//---------------------------------------------------------------------------
void ViewSetCelUpDown(sciVIEWLOOP *loop,TUpDown *udCel)
{
	if(!loop) return;
    udCel->Max = GetRealLoop(loop)->totalCels-1;
    udCel->Enabled = udCel->Max;
   	udCel->Position = 0;
}
//---------------------------------------------------------------------------
Graphics::TBitmap *ViewDrawCelBitmap(sciVIEW *view, int loop, int cel)
{
	sciVIEWLOOP *l = ViewGetLoop(view,loop);
    if(!l) return NULL;
    sciVIEWLOOP *rLp = GetRealLoop(l);

	sciVIEWCEL *c = ViewLoopGetCel(rLp,cel);
    if(!c) return NULL;
	Graphics::TBitmap *b = DrawBufferToBitmap(c->data, c->width, c->height, &palEGA, sCEL_ISMIRROR(l,c), FALSE);
    if(!b) return NULL;

    return b;
}
//---------------------------------------------------------------------------
void ViewDrawCelImage(TImage *imgView, sciVIEW *view, int loop, int cel)
{
	Graphics::TBitmap *b = ViewDrawCelBitmap(view, loop, cel);
    if(!b) return;
    ImageSetSize(imgView, b->Width<<1, b->Height<<1);
	imgView->Canvas->CopyRect(
    	Rect(0,0,imgView->Width,imgView->Height),
        b->Canvas,
        Rect(0,0,b->Width,b->Height)
    );
	DeletePaledBitmap(b);
}
//---------------------------------------------------------------------------
void CursorDrawImage(TImage *bm, sciCURSOR *cr)
{
	if(!cr||!bm) return;
    Graphics::TBitmap *bmCsr=DrawBufferToBitmap(cr->data,sCSR_WIDTH,sCSR_HEIGHT,&palCursor,FALSE,FALSE);
    if(bmCsr) {
    	bm->Canvas->CopyRect(
    		Rect(0,0,bm->Width,bm->Height),
        	bmCsr->Canvas,
    		Rect(0,0,bmCsr->Width,bmCsr->Height)
    	);
    	DeletePaledBitmap(bmCsr);
    }
}                                                                      
//---------------------------------------------------------------------------
Graphics::TBitmap *CursorDrawBitmap(sciCURSOR *cr)
{                 
	if(!cr) return NULL;
	return DrawBufferToBitmap(cr->data,sCSR_WIDTH,sCSR_HEIGHT,&palCursor,FALSE,FALSE);
}
//---------------------------------------------------------------------------
typedef struct {
	int width,height;
} WDHT;
int CalcFontBoundsHeight(sciFONT *fn,int maxWidth, int spacing, char *str)
{
	sciFONTCHAR *fc;

    int h=spacing;
    int x=0;
    int len;

    if(!str) len = fn->totalChars;
    else len = strlen(str);

    for(int c=0;c<len;c++) {
    	if((fc=GetFontChar(fn,str?str[c]:c))==NULL) continue;
        if(fc->width+x+spacing>=maxWidth||x>=maxWidth) {
         	x=spacing;
            h+=fn->height+spacing;
        }
        x+=fc->width+spacing;
    }
    if(x) h+=fn->height+spacing;
    return h;
}
//---------------------------------------------------------------------------
void FontDrawImage(TImage *im, sciFONT *fn)
{
	int spacing = 2;
	sciFONTCHAR *fc;
	if(!fn||!im) return;

    Graphics::TBitmap *bm=new Graphics::TBitmap;

    int maxW = (im->Width)>>1;
    bm->Width=maxW;
    bm->Height=CalcFontBoundsHeight(fn,maxW,spacing,NULL);
    bm->Canvas->Brush->Color = palFont.cols[0];
    bm->Canvas->FillRect(Rect(0,0,bm->Width,bm->Height));

    int x=spacing,y=spacing;
    for(int c=0;c<fn->totalChars;c++) {
    	if((fc=GetFontChar(fn,c))==NULL) continue;  
      	if(x+fc->width+spacing>=maxW) {
         	x=spacing;
            y+=fn->height+spacing;
        }
        DrawBufferToCanvas(bm->Canvas, x,y,fc->data, fc->width, fc->height, &palFont);
        x+=fc->width+spacing;
    }

    ImageSetSize(im,im->Width,bm->Height<<1);
    im->Canvas->CopyRect(
    		Rect(0,0,im->Width,im->Height),
        	bm->Canvas,
    		Rect(0,0,bm->Width,bm->Height)
    );
    delete bm;
}
//---------------------------------------------------------------------------
Graphics::TBitmap *FontDrawCharBitmap(sciFONT *font, int fChar)
{
	sciFONTCHAR *c = GetFontChar(font,fChar);
    if(!c) return NULL;
	Graphics::TBitmap *b = DrawBufferToBitmap(c->data, c->width, c->height, &palFont, FALSE, FALSE);
    return b;
}      
//---------------------------------------------------------------------------
// Clears the image's canvas to the specified colour using the fill rect
// command
void ClearImage(TImage *Image, TColor Colour)
{
    // Draws a rectangle the size of the image to quickly clear it   
    TColor oldCol = Image->Canvas->Brush->Color;
	Image->Canvas->Brush->Color = Colour;
	Image->Canvas->FillRect(Rect(0, 0, Image->Width, Image->Height));
	Image->Canvas->Brush->Color = oldCol;
}
//---------------------------------------------------------------------------
// Clears the image's canvas to the specified colour using the fill rect
// command
void ClearBitmap(Graphics::TBitmap *Bitmap, TColor Colour)
{
    // Draws a rectangle the size of the image to quickly clear it
    TColor oldCol = Bitmap->Canvas->Brush->Color;
	Bitmap->Canvas->Brush->Color = Colour;
	Bitmap->Canvas->FillRect(Rect(0, 0, Bitmap->Width, Bitmap->Height));
	Bitmap->Canvas->Brush->Color = oldCol;
}      
//---------------------------------------------------------------------------

void FlipBitmapH(Graphics::TBitmap *Bitmap)
{
    Graphics::TBitmap *Bitmap2=new Graphics::TBitmap;
    Bitmap2->Assign(Bitmap);
    for(int y=0;y<Bitmap->Height;y++)
        for(int x=0;x<Bitmap->Width;x++)
            Bitmap->Canvas->Pixels[x][y]=Bitmap2->Canvas->Pixels[Bitmap->Width-x-1][y];
    delete Bitmap2;
}
//---------------------------------------------------------------------------

void FlipBitmapV(Graphics::TBitmap *Bitmap)
{
    Graphics::TBitmap *Bitmap2=new Graphics::TBitmap;
    Bitmap2->Assign(Bitmap);
    for(int y=0;y<Bitmap->Height;y++)
        for(int x=0;x<Bitmap->Width;x++)
            Bitmap->Canvas->Pixels[x][y]=Bitmap2->Canvas->Pixels[x][Bitmap->Height-y-1];
    delete Bitmap2;
}
//---------------------------------------------------------------------------
// Image shift routines - Shift the image up/down/left/right
//---------------------------------------------------------------------------
void BitmapShiftUp(Graphics::TBitmap *Bitmap, TColor Colour, char Method)
{
    Graphics::TBitmap *TmpBitmap;
    switch(Method) {
	    case smWITH_COLOUR: // Shift with colour
            Bitmap->Canvas->CopyRect(
                Rect(0, 0, Bitmap->Width, Bitmap->Height-1),
                Bitmap->Canvas,
                Rect(0, 1, Bitmap->Width, Bitmap->Height)
            );
            Bitmap->Canvas->Brush->Color = (TColor) Colour;
	        Bitmap->Canvas->FillRect(Rect(0, Bitmap->Height - 1, Bitmap->Width, Bitmap->Height));
            break;
        case smWITH_LOOP: // Shift with loop
            TmpBitmap = new Graphics::TBitmap;
            TmpBitmap->Assign(Bitmap);
            Bitmap->Canvas->CopyRect(
                Rect(0, 0, Bitmap->Width, Bitmap->Height-1),
                Bitmap->Canvas,
                Rect(0, 1, Bitmap->Width, Bitmap->Height)
            );
	        Bitmap->Canvas->CopyRect(
                Rect(0, Bitmap->Height - 1, Bitmap->Width, Bitmap->Height),
                TmpBitmap->Canvas,
                Rect(0, 0, Bitmap->Width, 1)
            );
            delete TmpBitmap;
            break;
        case smWITHOUT_LOOP: // Shift without loop
            Bitmap->Canvas->CopyRect(
                Rect(0, 0, Bitmap->Width, Bitmap->Height-1),
                Bitmap->Canvas,
                Rect(0, 1, Bitmap->Width, Bitmap->Height)
            );
            break;
        default:;
    }
}
//---------------------------------------------------------------------------
void BitmapShiftDown(Graphics::TBitmap *Bitmap, TColor Colour, char Method)
{
    Graphics::TBitmap *TmpBitmap;
    switch(Method) {
	    case smWITH_COLOUR: // Shift with colour
            Bitmap->Canvas->CopyRect(
                Rect(0, 1, Bitmap->Width, Bitmap->Height),
                Bitmap->Canvas,
                Rect(0, 0, Bitmap->Width, Bitmap->Height - 1)
            );
            Bitmap->Canvas->Brush->Color = (TColor) Colour;
	        Bitmap->Canvas->FillRect(Rect(0, 0, Bitmap->Width, 1));
            break;
        case smWITH_LOOP: // Shift with loop
            TmpBitmap = new Graphics::TBitmap;
            TmpBitmap->Assign(Bitmap);
            Bitmap->Canvas->CopyRect(
                Rect(0, 1, Bitmap->Width, Bitmap->Height),
                Bitmap->Canvas,
                Rect(0, 0, Bitmap->Width, Bitmap->Height - 1)
            );
	        Bitmap->Canvas->CopyRect(
                Rect(0, 0, Bitmap->Width, 1),
                TmpBitmap->Canvas,
                Rect(0, Bitmap->Height-1, Bitmap->Width, Bitmap->Height)
            );
            delete TmpBitmap;
            break;
        case smWITHOUT_LOOP: // Shift without loop
            Bitmap->Canvas->CopyRect(
                Rect(0, 1, Bitmap->Width, Bitmap->Height),
                Bitmap->Canvas,
                Rect(0, 0, Bitmap->Width, Bitmap->Height - 1)
            );
            break;
        default:;
    }
}
//---------------------------------------------------------------------------
void BitmapShiftLeft(Graphics::TBitmap *Bitmap, TColor Colour, char Method)
{
    Graphics::TBitmap *TmpBitmap;
    switch(Method) {
	    case smWITH_COLOUR: // Shift with colour
            Bitmap->Canvas->CopyRect(
                Rect(0, 0, Bitmap->Width - 1, Bitmap->Height),
                Bitmap->Canvas,
                Rect(1, 0, Bitmap->Width, Bitmap->Height)
            );
            Bitmap->Canvas->Brush->Color = (TColor) Colour;
	        Bitmap->Canvas->FillRect(Rect(Bitmap->Width - 1, 0, Bitmap->Width, Bitmap->Height));
            break;
        case smWITH_LOOP: // Shift with loop
            TmpBitmap = new Graphics::TBitmap;
            TmpBitmap->Assign(Bitmap);
            Bitmap->Canvas->CopyRect(
                Rect(0, 0, Bitmap->Width - 1, Bitmap->Height),
                Bitmap->Canvas,
                Rect(1, 0, Bitmap->Width, Bitmap->Height)
            );
	        Bitmap->Canvas->CopyRect(
                Rect(Bitmap->Width - 1, 0, Bitmap->Width, Bitmap->Height),
                TmpBitmap->Canvas,
                Rect(0, 0, 1, Bitmap->Height)
            );
            delete TmpBitmap;
            break;
        case smWITHOUT_LOOP: // Shift without loop
            Bitmap->Canvas->CopyRect(
                Rect(0, 0, Bitmap->Width - 1, Bitmap->Height),
                Bitmap->Canvas,
                Rect(1, 0, Bitmap->Width, Bitmap->Height)
            );
            break;
        default:;
    }
}
//---------------------------------------------------------------------------
void BitmapShiftRight(Graphics::TBitmap *Bitmap, TColor Colour, char Method)
{
    Graphics::TBitmap *TmpBitmap;
    switch(Method) {
	    case smWITH_COLOUR: // Shift with colour
            Bitmap->Canvas->CopyRect(
                Rect(1, 0, Bitmap->Width, Bitmap->Height),
                Bitmap->Canvas,
                Rect(0, 0, Bitmap->Width - 1, Bitmap->Height)
            );
            Bitmap->Canvas->Brush->Color = (TColor) Colour;
	        Bitmap->Canvas->FillRect(Rect(0, 0, 1, Bitmap->Height));
            break;
        case smWITH_LOOP: // Shift with loop
            TmpBitmap = new Graphics::TBitmap;
            TmpBitmap->Assign(Bitmap);
	        Bitmap->Canvas->CopyRect(
                Rect(1, 0, Bitmap->Width, Bitmap->Height),
                Bitmap->Canvas,
                Rect(0, 0, Bitmap->Width - 1, Bitmap->Height)
            );
	        Bitmap->Canvas->CopyRect(
                Rect(0, 0, 1, Bitmap->Height),
                TmpBitmap->Canvas,
                Rect(Bitmap->Width - 1, 0, Bitmap->Width, Bitmap->Height)
            );
            delete TmpBitmap;
            break;
        case smWITHOUT_LOOP: // Shift without loop
	        Bitmap->Canvas->CopyRect(
                Rect(1, 0, Bitmap->Width, Bitmap->Height),
                Bitmap->Canvas,
                Rect(0, 0, Bitmap->Width - 1, Bitmap->Height)
            );
            break;
        default:;
    }
}
//---------------------------------------------------------------------------
void GreyScaleBitmap(Graphics::TBitmap *Bitmap)
{
    int X, Y;
    BYTE ColourAvg;
	long c;
	for(Y = 0; Y < Bitmap->Height; Y++) {
        for (X = 0; X < Bitmap->Width; X++) {
        	c = (long)Bitmap->Canvas->Pixels[X][Y];
        ColourAvg = (BYTE)(
        		(long)(
                	(((c >> 16) & 0xff) +
                	((c >> 8) & 0xff) +
                	(c & 0xff)) / 3
                ));

            Bitmap->Canvas->Pixels[X][Y] = (TColor)
                (ColourAvg + (ColourAvg << 8) + (ColourAvg << 16));
        }
    }
}
//---------------------------------------------------------------------------

void InvertBitmap(Graphics::TBitmap *Bitmap)
{
	Graphics::TBitmap *b = new Graphics::TBitmap;
    b->Width = Bitmap->Width;
    b->Height = Bitmap->Height;
    b->Canvas->CopyMode = cmNotSrcCopy;
    b->Canvas->CopyRect(
        Rect(0,0,Bitmap->Width, Bitmap->Height),
        Bitmap->Canvas,
        Rect(0,0,Bitmap->Width, Bitmap->Height)
    );
    Bitmap->Canvas->Draw(0,0,b);
    delete b;
}

//---------------------------------------------------------------------------
float PointsToAngle(float xOne, float yOne, float X, float Y)
{
    float nRatio, nASin;

    if(xOne == X && Y == yOne) return 0;

    X -= xOne;
    Y -= yOne;

    nRatio = X / sqrt(Y*Y + X*X);

    if(abs(nRatio) == 1)
        nASin = 90 * nRatio;
	else
        nASin = atan(nRatio / sqrt(-nRatio * nRatio + 1)) * (180 / M_PI);

	if(Y < 0)
        nASin = 90 - nASin + 90;
	else
    	if(X < 0)
        	nASin = nASin + 360;

    if(nASin<180) nASin += 180;
    else nASin-=180;

    nASin=abs(nASin-360);

	return nASin;
}
//---------------------------------------------------------------------------
int CalcAct(int x, int z)
{
	float fx = x;
    if(x==0||z==0) return 0;
    return fx/z;
}
//---------------------------------------------------------------------------

