/***************************************************************************
 *  SCI Studio: SCI Script Compiler
 *  Copyright (C) 2001 Brian Provinciano, http://www.bripro.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Notice
 *  You MUST distribute your source code if you release a program which
 *  uses ANY of my original source code. You MUST put my name in your
 *  program, source AND binary. You MUST leave this header in your source
 *
 *  Copyright (C) 1999-2001 Brian Provinciano, http://www.bripro.com
 ***************************************************************************/
 /******************************************************************************
 * SCI Script Compiler Win32 Shell
 * Created: 	April 9th, 2001
 * Modified: 	July 19th, 2002
 ******************************************************************************/
#define PLATFORM_NAME "Win32"

#include "scc.h"
/******************************************************************************/

typedef struct {

	short Script;


	char *Name;
} tsSCRIPTNAMES;






tsSCRIPTNAMES CompileOrder[] = {
#ifdef SCI11111111111
#define TOTAL_SCRIPT_NAMES 1  
/*issues***/{0,"inv"},
/*****non-lslish*/{0,"inventory"},
/*issues***/{0,"main"},
/****/{0,"feature"},
/****/{0,"features"},

/****/{0,"loopangle"},
/****/{0,"lang"},


/****/{0,"init"},
/****/{0,"borderwnd"},
/****/{0,"speedtest"},
/****/{0,"mcycle"},
/****/{0,"block"},
/****/{0,"randcycle"},
/****/{0,"disposecode"},
/****/{0,"chase"},
/****/{0,"osc"},
/****/{0,"fwdcounter"},
/****/{0,"egosprays"},
/****/{0,"pchase"},
/****/{0,"ego"},
/****/{0,"dcicon"},
/****/{0,"pseudomouse"},
/****/{0,"polygon"},
/****/{0,"polypath"},
/****/{0,"stopwalk"},
/****/{0,"wander"},
/****/{0,"rev"},
/****/{0,"obj"},
/****/{0,"syswindow"},
/****/{0,"gamecontrols"},
/****/{0,"sound"},
/****/{0,"cycle"},
/****/{0,"grooper"},
/****/{0,"game"},
/****/{0,"window"},
/****/{0,"controls"},
/****/{0,"disposeload"},
/****/{0,"user"},
/*issues***/{0,"room"},
/*issues***/{0,"jump"},
/*issues***/{0,"iconbar"},
/*****non-lslish*/{0,"titlescreen"},
/*****non-lslish*/{0,"about"},   
/*****non-lslish*/{0,"rm100"},

#else
#define TOTAL_SCRIPT_NAMES 1
 	{999,	"obj"},
 	{255,	"controls"},
 	{0,	"main"},
{994,	"game"},
{0,"initrooms"},
{0,"rm001"},
 	{0,	"titlescreen"},
 	{996,	"user"},

 	{997,	"menubar"},
 	{981,	"window"},
 	{973,	"timer"},
 	{989,	"sound"},
 	{969,	"rev"},
 	{971,	"follow"},
 	{970,	"wander"},
 	{991,	"jump"},
	{992,	"cycle"},
	{998,	"feature"},
 	{993,	"fileio"},
 	{995,	"inv"},
 	{967,	"dcicon"},
 	{987,	"gauge"},
 	{964,	"dpath"},
 	{988,	"extra"},
  	{51,	"autodoor"},
 	{50,	"door"},
 	{40,	"dying"},
 	{958,	"disposeload"},
{990,	"syswindow"},
#endif
};
#ifdef SCI11111111111
#define DIRECTORY  "E:\\sci\\vga\\"
#define SRC_DIRECTORY  "E:\\sci\\vga\\src\\"
#else
#define DIRECTORY  "E:\\programming\\SCIStudio\\Bin\\template\\"
#define SRC_DIRECTORY  "E:\\programming\\SCIStudio\\Bin\\template\\src\\"
#endif
int main(int argc, char *argv[])
{
	int i;
#ifdef SCI11111111111
    SCI1 = TRUE;
#else
    SCI1 = FALSE;
#endif
	printf(
		"SCI Script Compiler\n"
		"Version %d.%d.%d - (%s)\n"
		"By Brian Provinciano\n\n",
		VERSION.Major,VERSION.Minor,VERSION.Build,
		PLATFORM_NAME
	);          /*
	if(argc < 2) {
	    printf(
		    "\nUseage:\n"
		    "SCC [input.sc] [gamedirectory]\n"
	    );
		return FALSE;
	} else if(argc > 2) strcpy(Directory,argv[2]);
	else */
                                            /*
    lib_dirs=dirlist_add(lib_dirs,Directory);
    include_dirs=dirlist_add(include_dirs,Directory);
    include_dirs=dirlist_add(output_dir,Directory);         */
    include_dirs=dirlist_add(include_dirs,"E:\\programming\\SCIStudio\\Bin\\include");
    lib_dirs=dirlist_add(lib_dirs,SRC_DIRECTORY);
   	game_dir=dirlist_add(game_dir,DIRECTORY);
    source_dir=dirlist_add(source_dir,SRC_DIRECTORY);
    include_dirs=dirlist_add(include_dirs,SRC_DIRECTORY);

	/* Compile the script */
    for(i=0;i<TOTAL_SCRIPT_NAMES;i++) {
        sprintf(TempString,"%s%s.sc",SRC_DIRECTORY,CompileOrder[i].Name);
		ShowMessage(0,"\nCompiling File: %s...\n", TempString);
		if(CompileScript(TempString,-1)) ShowMessage(smCOMPILE,"Successful!");
		else {                        /*
    for(i=0;i<TOTAL_FILES;i++) {
        sprintf(TempString,"%s",FileList[i]);
		ShowMessage(0,"\nCompiling File: %s...\n", TempString);
		if(CompileScript(TempString)) ShowMessage(smCOMPILE,"Successful!");
		else {            */
    		ShowMessage(smCOMPILE,"Failed!");
        	getch();
    	}
		FreeEverything();
    }             
    dirlist_free(lib_dirs);
    dirlist_free(include_dirs);  
    dirlist_free(game_dir);
    dirlist_free(source_dir);


	return TRUE;
}
/******************************************************************************/
int ShowMessage(int Message, char *String, ...)
{
	va_list argptr;
	int cnt;
	if(Message!=smAPPEND) printf("\n");
	switch(Message) {
		case smNONE:
			break;
		case smERROR:
			printf("[Error]: ");
			break;
		case smWARNING:
			printf("[Warning]: ");
			break;
		case smCOMPILE:
			printf("[Compile]: ");
			break;
        case smAPPEND:
			break;
		default:
			printf("[Error]: %s(%d): ", IN_HEADER?IncludeFileName:ScriptName, LineNumber);

		    va_start(argptr, String);
		    cnt = vprintf(Errors[Message], argptr);
		    va_end(argptr);
	};
	if(Message<1) {
		va_start(argptr, String);
		cnt = vprintf((char*)String, argptr);
		va_end(argptr);
	}

	return(cnt);
}
/******************************************************************************/

/***************************************************************************
 *  Copyright (C) 1999-2001 Brian Provinciano, http://www.bripro.com
 ***************************************************************************/
