/*************************************************************************
 * SCI Script Compiler Header
 * By Brian Provinciano
 *************************************************************************/
(define KEY_BACK  			$08)
(define KEY_TAB   			$09)
(define KEY_SHIFTTAB		$F00)

(define KEY_CLEAR  			$0C)
(define KEY_RETURN  		$0D)

(define KEY_SHIFT  			$10)
(define KEY_CONTROL  		$11)
(define KEY_MENU  			$12)
(define KEY_PAUSE  			$13)
(define KEY_CAPITAL  		$14)

(define KEY_ESCAPE  		$1B)
(define KEY_ESC   			$1B)

(define KEY_SPACE  			$20)
(define KEY_PRIOR  			$21)
(define KEY_NEXT  			$22)
(define KEY_END   			$4F00)
(define KEY_HOME  			$4700)
(define KEY_LEFT  			$4B00)
(define KEY_UP   			$4800)
(define KEY_RIGHT  			$4D00)
(define KEY_DOWN  			$5000)
(define KEY_PAGEDOWN  		$4900)
(define KEY_PAGEUP  		$5100)
(define KEY_SELECT  		$29)
(define KEY_PRINT  			$2A)
(define KEY_EXECUTE  		$2B)
(define KEY_SNAPSHOT 		$2C)
(define KEY_INSERT  		$5200)
(define KEY_DELETE  		$5300)
(define KEY_HELP  			$2F)

(define KEY_0   			$30)
(define KEY_1   			$31)
(define KEY_2   			$32)
(define KEY_3   			$33)
(define KEY_4   			$34)
(define KEY_5   			$35)
(define KEY_6   			$36)
(define KEY_7   			$37)
(define KEY_8   			$38)
(define KEY_9   			$39)
(define KEY_A   			$41)
(define KEY_B   			$42)
(define KEY_C   			$43)
(define KEY_D   			$44)
(define KEY_E   			$45)
(define KEY_F   			$46)
(define KEY_G   			$47)
(define KEY_H   			$48)
(define KEY_I   			$49)
(define KEY_J   			$4A)
(define KEY_K   			$4B)
(define KEY_L   			$4C)
(define KEY_M   			$4D)
(define KEY_N   			$4E)
(define KEY_O   			$4F)
(define KEY_P   			$50)
(define KEY_Q   			$51)
(define KEY_R   			$52)
(define KEY_S   			$53)
(define KEY_T   			$54)
(define KEY_U   			$55)
(define KEY_V   			$56)
(define KEY_W   			$57)
(define KEY_X   			$58)
(define KEY_Y   			$59)
(define KEY_Z   			$5A)

(define KEY_NUMPAD0  		$5200)
(define KEY_NUMPAD1  		$4F00)
(define KEY_NUMPAD2  		$5000)
(define KEY_NUMPAD3  		$5100)
(define KEY_NUMPAD4  		$4B00)
(define KEY_NUMPAD5  		$4C00)
(define KEY_NUMPAD6  		$4D00)
(define KEY_NUMPAD7  		$4700)
(define KEY_NUMPAD8  		$4800)
(define KEY_NUMPAD9  		$4900)
(define KEY_MULTIPLY 		$2A)
(define KEY_ADD   			$2B)
(define KEY_SEPARATOR 		$2F)
(define KEY_SUBTRACT 		$2D)
(define KEY_DECIMAL  		$2E)
(define KEY_DIVIDE  		$2F)
(define KEY_F1   			$3B00)
(define KEY_F2   			$3C00)
(define KEY_F3   			$3D00)
(define KEY_F4   			$3E00)
(define KEY_F5   			$3F00)
(define KEY_F6   			$4000)
(define KEY_F7   			$4100)
(define KEY_F8   			$4200)
(define KEY_F9   			$4300)
(define KEY_F10   			$4400)
/*************************************************************************/
(define JOY_NULL			0)
(define JOY_UP				1)
(define JOY_UPRIGHT			2)
(define JOY_RIGHT			3)
(define JOY_DOWNRIGHT		4)
(define JOY_DOWN			5)
(define JOY_DOWNLEFT		6)
(define JOY_LEFT			7)
(define JOY_UPLEFT			8)
/*************************************************************************/
