/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

// LoopPointDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Soundbox.h"
#include "LoopPointDlg.h"
#include "SoundResource.h"


// CLoopPointDlg dialog

IMPLEMENT_DYNAMIC(CLoopPointDlg, CDialog)
CLoopPointDlg::CLoopPointDlg(SoundResource *sound, CWnd* pParent /*=NULL*/)
	: CDialog(CLoopPointDlg::IDD, pParent), mSound(sound)
{
}

CLoopPointDlg::~CLoopPointDlg()
{
}

void CLoopPointDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CLoopPointDlg, CDialog)
	ON_LBN_SELCHANGE(IDC_POINTLIST, OnPointListSelChange)
	ON_BN_CLICKED(IDC_DELBTN, OnDelBtnClicked)
	ON_BN_CLICKED(IDC_ADDBTN, OnAddBtnClicked)
END_MESSAGE_MAP()


// CLoopPointDlg message handlers

BOOL CLoopPointDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	int i;

	CListBox *listBox = (CListBox*)GetDlgItem(IDC_POINTLIST);
	listBox->SetFont(&CSoundboxApp::mListFont);

	// scan events, adding loop points to the list
	int n = mSound->GetNumEvents();
	for (i = 0; i < n; ++i) {
		sound_event event = mSound->GetEvent(i);
		if ((event.channel == 15) &&
			(event.status == sound_event::PATCH_CHANGE) &&
			(event.param1 == 127)) {

			char txt[16];
			sprintf(txt, "%d", event.absoluteTime);
			mIndex.Add(i);
			listBox->AddString(txt);
		}
	}

	// disable the delete button
	CButton *btn = (CButton*)GetDlgItem(IDC_DELBTN);
	btn->EnableWindow(false);

	// set spinner bounds
	CSpinButtonCtrl *spin = (CSpinButtonCtrl*)GetDlgItem(IDC_TIMESPIN);
	spin->SetRange(0, mSound->GetTotalTime());

	return TRUE;
}

void CLoopPointDlg::OnPointListSelChange()
{
	// enable delete button
	CListBox *listBox = (CListBox*)GetDlgItem(IDC_POINTLIST);
	CButton *btn = (CButton*)GetDlgItem(IDC_DELBTN);
	btn->EnableWindow(listBox->GetCurSel() != -1);
}

void CLoopPointDlg::OnDelBtnClicked()
{
	// remove the event and its entry from the list
	CListBox *listBox = (CListBox*)GetDlgItem(IDC_POINTLIST);
	int localIndex = listBox->GetCurSel();
	int soundIndex = mIndex.GetAt(localIndex);
	mSound->DeleteEvent(soundIndex);
	listBox->DeleteString(localIndex);

	// fix the index
	mIndex.RemoveAt(localIndex);
	int n = (int)mIndex.GetCount();
	for (int i = localIndex; i < n; ++i) {
		mIndex.SetAt(i, mIndex.GetAt(i) - 1);
	}

	// select another item from the list
	if (n > localIndex) {
		listBox->SetCurSel(localIndex);
	} else if (localIndex > 0) {
		listBox->SetCurSel(localIndex - 1);
	} else {
		CButton *delBtn = (CButton*)GetDlgItem(IDC_DELBTN);
 		delBtn->EnableWindow(false);
	}
}

void CLoopPointDlg::OnAddBtnClicked()
{
	CEdit *timeEdit = (CEdit*)GetDlgItem(IDC_TIMEEDIT);
	CString timeStr;
	timeEdit->GetWindowText(timeStr);
	int time = atoi(timeStr);

	// verify a valid time
	if (time < 0) {
		MessageBox("Time must be greater than or equal to 0");
		return;
	}
	if (time > mSound->GetTotalTime()) {
		MessageBox("Time cannot extend past end of soung");
		return;
	}

	// add the event
	sound_event event;
	event.absoluteTime = time;
	event.status = sound_event::PATCH_CHANGE;
	event.channel = 15;
	event.param1 = 127;
	event.param2 = 0xFF;

	// fix the index
	int soundIndex = mSound->InsertEvent(event);
	int localIndex = 0;
	int n = (int)mIndex.GetCount();
	while ((localIndex < n) && (mIndex.GetAt(localIndex) < soundIndex)) ++localIndex;
	mIndex.InsertAt(localIndex, soundIndex);
	for (int i = localIndex + 1; i < n; ++i) {
		mIndex.SetAt(i, mIndex.GetAt(i) + 1);
	}

	// add the point to the list box
	char txt[16];
	sprintf(txt, "%d", time);
	CListBox *listBox = (CListBox*)GetDlgItem(IDC_POINTLIST);
	listBox->InsertString(localIndex, txt);
}
