/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

/*
 * Sound player that extends RealtimePlayer. Plays sound events straight
 * through the Windows MIDI Mapper.
 */

#include "SoundPlayer.h"
#include <mmsystem.h>

class DataStream;
struct sound_event;

class MidiPlayer : public RealtimePlayer {
public:
	MidiPlayer(HWND listener);
	virtual ~MidiPlayer();
protected:
	virtual void OpenDevice(DataStream *patch);
	virtual void CloseDevice();
	virtual void HandleEvent(const sound_event &event);
	virtual void MapChannelVoices(int channel, int numVoices);

	HMIDIOUT mMidiOut;
};
