/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

/*
 * CPlayBar is the component class for the player GUI. It lets the user select
 * which filter and player to use and provides buttons for start/stop/pause.
 */

#include "ColorComboBox.h"

#define PLAYSTATE_NONE 0
#define PLAYSTATE_STOPPED 1
#define PLAYSTATE_PLAYING 2


// CPlayBar

class CPlayBar : public CWnd
{
	DECLARE_DYNAMIC(CPlayBar)

public:
	CPlayBar();
	virtual ~CPlayBar();
	void SetSignal(int signal);
	void SetPlayState(int state);

protected:
	DECLARE_MESSAGE_MAP()
	int mVUnit;
	int mHUnit;
	int mSignal;

	CColorComboBox mFilterList;
	CComboBox mPlayerList;
	CBitmapButton mPlayBtn;
	CBitmapButton mStopBtn;

public:
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnFilterListSelChange();
	afx_msg void OnPlayBtnClicked();
	afx_msg void OnStopBtnClicked();
};
