/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

// Soundbox.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Soundbox.h"
#include "MainFrm.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSoundboxApp

BEGIN_MESSAGE_MAP(CSoundboxApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
END_MESSAGE_MAP()

const int CSoundboxApp::FILTER_COLORS_LIGHT[] = {RGB(255, 204, 204),
												 RGB(255, 255, 204),
												 RGB(204, 255, 204),
												 RGB(204, 255, 255),
												 RGB(204, 204, 255),
												 RGB(255, 204, 255),
												 RGB(230, 230, 230),
												 RGB(255, 204, 153)};

const int CSoundboxApp::FILTER_COLORS[] = {RGB(255, 0, 0),
										   RGB(255, 255, 0),
										   RGB(0, 255, 0),
										   RGB(0, 255, 255),
										   RGB(0, 0, 255),
										   RGB(255, 0, 255),
										   RGB(128, 128, 128),
										   RGB(255, 100, 0)};

const int CSoundboxApp::FILTER_COLORS_DARK[] = {RGB(100, 0, 0),
												RGB(100, 100, 0),
												RGB(0, 100, 0),
												RGB(0, 100, 100),
												RGB(0, 0, 100),
												RGB(100, 0, 100),
												RGB(64, 64, 64),
												RGB(100, 50, 0)};

const char CSoundboxApp::FILTER_NAMES[][256] = {"01   MT-32",
												"02   Yamaha FB-01",
												"04   Adlib (OPL3)",
												"08   Casio MT540/CT460",
												"10   Tandy",
												"20   PC Speaker",
												"40",
												"80   New GM"};

// CSoundboxApp construction

CSoundboxApp::CSoundboxApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}


// The one and only CSoundboxApp object

CSoundboxApp theApp;

CFont CSoundboxApp::mListFont;

// CSoundboxApp initialization

BOOL CSoundboxApp::InitInstance()
{
	CWinApp::InitInstance();

	mListFont.CreateFont(HIWORD(GetDialogBaseUnits()), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "Courier New");

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	// of your final executable, you should remove from the following
	// the specific initialization routines you do not need
	// Change the registry key under which our settings are stored
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));
	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object
	CMainFrame* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;
	// create and load the frame with its resources
	pFrame->LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);
	// The one and only window has been initialized, so show and update it
	pFrame->ShowWindow(SW_SHOW);
	pFrame->UpdateWindow();
	// call DragAcceptFiles only if there's a suffix
	//  In an SDI app, this should occur after ProcessShellCommand
	return TRUE;
}


// CSoundboxApp message handlers



// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// App command to run the dialog
void CSoundboxApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


// CSoundboxApp message handlers

