/* FUNCTION list 	---	---	---	---	---	---	---

*/

/* BASE headers	---	---	---	---	---	---	--- */


/* LIBRARY headers	---	---	---	---	---	---	--- */
#include <stdlib.h>
#include <stdio.h>

#include <assert.h>

/* OTHER headers	---	---	---	---	---	---	--- */

#include "types.h"
#include "endian.h"

#include "common.h"
#include "param.h"

/* PROTOTYPES	---	---	---	---	---	---	--- */



/* VARIABLES	---	---	---	---	---	---	--- */


/* CODE	---	---	---	---	---	---	---	--- */


//~ 0 = not set
//~ n = abcdef note
//~ a = agi freq_count
//~ f = actual frequency
//~ w = agi white noise
//~ p = agi periodic noise

//~ the default type when printing out notes
#define TYPE_DEFAULT 'a'




u8 *in_name = 0;
u8 *out_name = 0;
int f_verbose = 0;

PARAM scr_param[] =
{
	{'i', "input", 0, -1, P_DATA},	// input scr file
	{'o', "output", 0, -1, P_DATA},	// output snd file
	{'h', "help", 0, -1, P_FLAG},	// need help
	{'v', "verbose", 0, -1, P_FLAG},	// want more crap on the screen?
	{'t', "type", 0, -1, P_DATA},	// type of output.. 
	{0, 0, 0, -1, P_DATA},	// default file..  input?
};


void param_check()
{
	// if help is set.. print help.. exit
	if ((scr_param[2].flag == 1) ||
		(scr_param[0].data == 0) ||
		(scr_param[1].data == 0) )
	{
		if (scr_param[2].flag != 1)
		{
			if (scr_param[0].data == 0) 
				printf("%s(): input file not defined\n\n", 
					__PRETTY_FUNCTION__);
			if (scr_param[1].data == 0) 
				printf("%s(): output file not defined\n\n", 
					__PRETTY_FUNCTION__);
		}
		
		printf("agi2scr %s by Nick Sonneveld\n", TOOL_VER);
		printf("decompile agi sound objects (.aso) to agi sound scripts (.ass)\n");
		printf("(no.. i don't think the names are funny.)\n");
		printf("\n");
		printf("-i, -input = input object name\n");
		printf("-o, -output = output script name\n");
		printf("-t, -type = type of info to represent notes (not implemented yet)\n");
		printf("-h, -help = print the help message\n");
		printf("-v, -verbose = print interesting messages that correspond with the current activity.\n");
		exit(0);
	}
	
	// check other flags.. if not set..  set to 1 or 0
	f_verbose = (scr_param[3].flag == 1);
	
	// check input
	// help prints out help if input and output aren't set.. but print error messages if 
	// help doesn't do this in another version
	
	in_name = scr_param[0].data;
	out_name = scr_param[1].data;
	
	// check default
	if (scr_param[4].data != 0)
	{
		printf("what do you want me to do with this: \"%s\"?\n", scr_param[4].data);
	}
}



int main (int argc, char **argv)
{
	FILE *out;
	
	u16 duration;
	u16 freq_count;
	u8 atten;
	
	void *ch;
	void *head;
	void *snd_data;
	int snd_size;
	int ch_len;
	
	char type = 0;
	
	int i;
	
	
	param_parse(argc, argv, 
			sizeof(scr_param)/sizeof(PARAM), scr_param);
	param_check(sizeof(scr_param)/sizeof(PARAM), scr_param);
	
	
	// read in input
	snd_data = file_to_buf(in_name);
	if (snd_data == 0)
	{
		printf("%s(): unable to open input\n", __PRETTY_FUNCTION__);
		exit(-1);
	}
	snd_size = file_buf_size;
	
	
	// open output
	if ((out=fopen(out_name, "wb")) == 0)
	{
		printf("%s(): unable to open output\n", __PRETTY_FUNCTION__);
		exit(-1);
	}
	
	fprintf(out, "# type, freq/note, attenuation, duration\n");
	fprintf(out, "# types: a=agi freq count, f=frequency, n=note\n");
	fprintf(out, "# w=white noise, p=periodic noise\n\n");
	
	head = snd_data;
	
	// iterate through 4 channels
	for (i=1; i <= 4; i++)
	{
		ch = (u8 *)snd_data + load_le_16(head);
		duration = load_le_16(ch);
		
		type = 0; // reset the type
		
		if (duration != 0xFFFF)
		{
			fprintf(out, "# tone %d @ 0x%08X\n", i,  load_le_16(head));
			
			if (i!=4)
				fprintf(out, "tone\n");
			else
				fprintf(out, "noise\n");
			
			ch_len = 0;
			
			while (duration != 0xFFFF)
			{
				ch_len += duration;

				atten = ((u8*)ch)[4] & 0xF;
				
				if (i != 4)
				{
					freq_count = (u16)((u8*)ch)[2] & 0x3F;
					freq_count <<= 4;
					freq_count |= ((u8*)ch)[3] & 0x0F;
					
					//if (type == 0)
					//	type = TYPE_DEFAULT;
					
					switch (TYPE_DEFAULT)
					{
						case 'n':
							break;
						case 'f':
							if (type != 'f')
							{
								type = 'f';
								fprintf(out, "f, ");
							}
							fprintf(out, "%6.2f, %6d, %6d\n", (float)111860/freq_count,atten,duration );
							break;
						default:
						case 'a':
							if (type != 'a')
							{
								type = 'a';
								fprintf(out, "a, ");
							}
							fprintf(out, "%6d, %6d, %6d\n", freq_count,atten,duration );
							break;
					}
					
					
				}
				else
				{
					freq_count = ((u8*)ch)[3] & 0x3;
					if ( ((u8*)ch)[3] & 4)
					{
						if (type != 'w')
						{
							type = 'w';
							fprintf(out, "w, ");
						}
					}
					else
						if (type != 'p')
						{
							type = 'p';
							fprintf(out, "p, ");
						}
					
					fprintf(out, "%6d, %6d, %6d\n", freq_count,atten,duration );
				}
					
				ch = (u8 *)ch + 5;
				duration = load_le_16(ch);
			}
			fprintf(out, "# length = %d (%0.2f s)\n", ch_len, (float)ch_len / 60);
			fprintf(out, "\n\n");
		}

		head = (u8 *)head + 2;
	}
	
	// close ouput
	if (fclose(out) != 0)
		printf("%s(): warning.  could not close output\n", __PRETTY_FUNCTION__);
	out = 0;
	
	return 0;
}