{
    GetResourceName1.pas - Dialog box to get name of resource
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit GetResourceName1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, defines, main1, VolMan2;

type
  TGetResourceName = class(TForm)
    Label1: TLabel;
    LogicRadio: TRadioButton;
    PictureRadio: TRadioButton;
    ViewRadio: TRadioButton;
    SoundRadio: TRadioButton;
    Label2: TLabel;
    NumberEdit: TEdit;
    NameDisplay: TLabel;
    Label3: TLabel;
    OKBut: TButton;
    CancelBut: TButton;
    procedure CancelButClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure NumberEditChange(Sender: TObject);
    procedure LogicRadioClick(Sender: TObject);
    procedure PictureRadioClick(Sender: TObject);
    procedure ViewRadioClick(Sender: TObject);
    procedure SoundRadioClick(Sender: TObject);
    procedure OKButClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
       ResType          : byte;
       ResNumber        : byte;
       NameEntered      : boolean;
       ValidNumber      : boolean;
       ValidType        : boolean;
       Filename         : string;
  end;

var
  GetResourceName: TGetResourceName;

implementation

{$R *.DFM}

var ValidNumber : boolean;
    ValidType   : boolean;

procedure TGetResourceName.CancelButClick(Sender: TObject);
begin
  Close;
end;

procedure TGetResourceName.FormShow(Sender: TObject);
begin
   GetResourceName.OKBut.SetFocus;
end;

procedure TGetResourceName.NumberEditChange(Sender: TObject);
var TempNum      : integer;
    Code         : integer;
begin
  Val(NumberEdit.Text,TempNum,Code);
  if (Code = 0) and (TempNum >= 0) and (TempNum <= 255) then
  begin
    GetResourceName.ResNumber := TempNum;
    GetResourceName.ValidNumber := True;
    if GetResourceName.ValidType then NameDisplay.Caption := ResourceName(GetResourceName.ResType,GetResourceName.ResNumber);
  end
  else
  begin
    NameDisplay.Caption := '';
    GetResourceName.ValidNumber := False;
  end;
end;

procedure TGetResourceName.LogicRadioClick(Sender: TObject);
begin
  GetResourcename.ResType := LOGIC;
  if GetResourceName.ValidNumber then GetResourceName.NameDisplay.Caption := ResourceName(GetResourceName.ResType,GetResourceName.ResNumber);
  GetResourceName.ValidType := True;
end;

procedure TGetResourceName.PictureRadioClick(Sender: TObject);
begin
  GetResourcename.ResType := PICTURE;
  if GetResourceName.ValidNumber then GetResourceName.NameDisplay.Caption := ResourceName(GetResourceName.ResType,GetResourceName.ResNumber);
  GetResourceName.ValidType := True;
end;

procedure TGetResourceName.ViewRadioClick(Sender: TObject);
begin
  GetResourcename.ResType := VIEW;
  if GetResourceName.ValidNumber then GetResourceName.NameDisplay.Caption := ResourceName(GetResourceName.ResType,GetResourceName.ResNumber);
  GetResourceName.ValidType := True;
end;

procedure TGetResourceName.SoundRadioClick(Sender: TObject);
begin
  GetResourcename.ResType := SOUND;
  if GetResourceName.ValidNumber then GetResourceName.NameDisplay.Caption := ResourceName(GetResourceName.ResType,GetResourceName.ResNumber);
  GetResourceName.ValidType := True;
end;

procedure TGetResourceName.OKButClick(Sender: TObject);
var ConfirmAdd : boolean;
    ConfirmMessageString : String;
    ConfirmMessagePChar : PChar;
    ResFile : file;
    ResourceToAdd : Tresource;
begin
  ConfirmAdd := True;
  if not GetResourceName.ValidType then ShowMessage('You must select a resource type.')
  else
  if not GetResourceName.ValidNumber then ShowMessage('You must enter an integer between 0 and 255.')
  else
  begin
    if ResourceInfo[GetResourceName.ResType,GetResourceName.ResNumber].Exists then
    begin
      ConfirmMessageString := 'Resource ' + ResourceName(GetResourceName.ResType,GetResourceName.ResNumber) + ' already exists. Overwrite?';
      GetMem(ConfirmMessagePChar,Length(ConfirmMessageString)+1);
      StrPCopy(ConfirmMessagePChar,ConfirmMessageString);
      if Application.MessageBox(ConfirmMessagePChar,'Add Resource',MB_OKCANCEL) = IDCANCEL then
        ConfirmAdd := False;
      FreeMem(ConfirmMessagePChar,Length(ConfirmMessageString)+1);
    end;
    if ConfirmAdd then
    begin
      GetResourceName.NameEntered := False;
      GetResourceName.Close;
{open the resource file, if we can}
      AssignFile(ResFile,GetResourceName.Filename);
      {$I-}
      Reset(ResFile,1);
      {$I+}
      if IOResult <> 0 then
        ShowMessage('Error accessing file '+GetResourceName.Filename)
      else
      begin
        if FileSize(ResFile) > MaxResourceSize then
        begin
          ShowMessage('Error: File too big (>'+IntToStr(MaxResourceSize)+' bytes)');
          CloseFile(ResFile);
        end
        else
        begin
          ResourceToAdd.Size := FileSize(ResFile);
          GetMem(ResourceToAdd.Data,ResourceToAdd.Size);
          BlockRead(ResFile,ResourceToAdd.Data^,ResourceToAdd.Size);
          CloseFile(ResFile);










          AddResource(ResourceToAdd,GetResourcename.ResType,GetResourceName.ResNumber);
            {AddResource frees the memory for ResourceToAdd}
        end; {if FileSize(ResFile) <= MaxResourceSize}
      end; {if IOResult = 0}
    end; {if ConfirmAdd}
  end; {if GetResourceName.ValidNumber}
end;

end.
