{
    PicPreview1.pas - PICTURE viewer
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit PicPreview1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Grids, Outline, DirOutln, ComCtrls, Defines, Math, VolMan2;

function LoadPreviewPic(PicNum:byte) : boolean;
procedure FreePreviewPic;

implementation

uses main1, PreviewWin1, ResourceWin1;

type
{      TPixelArray = array [0..26879] of TRGBTriple;}
{      TPixelArray = array [0..80639] of byte;}
      TPixelArray = array [0..26879] of byte;
      PPixelArray = ^TPixelArray;

var   VisPixelPtr: PPixelArray;  // ptr to visual pixel data
      PriPixelPtr: PPixelArray;  // ptr to priority pixel data

{*************************************************************}
procedure FreePreviewPic;
{*************************************************************}
begin
  if PreviewPic.InUse then
  begin
    PreviewPic.Visual.Free;
    PreviewPic.Priority.Free;
    PreviewPic.InUse := False;
  end;
end;

{*************************************************************}
procedure InitialisePreviewPicBitmaps;
{*************************************************************}

const cols   : array[0..15] of TRGBQUAD = ((rgbBlue:$00; rgbGreen:$00; rgbRed:$00; rgbReserved:$00),
                                           (rgbBlue:$A0; rgbGreen:$00; rgbRed:$00; rgbReserved:$00),
                                           (rgbBlue:$00; rgbGreen:$A0; rgbRed:$00; rgbReserved:$00),
                                           (rgbBlue:$A0; rgbGreen:$A0; rgbRed:$00; rgbReserved:$00),
                                           (rgbBlue:$00; rgbGreen:$00; rgbRed:$A0; rgbReserved:$00),
                                           (rgbBlue:$A0; rgbGreen:$00; rgbRed:$80; rgbReserved:$00),
                                           (rgbBlue:$00; rgbGreen:$50; rgbRed:$A0; rgbReserved:$00),
                                           (rgbBlue:$A0; rgbGreen:$A0; rgbRed:$A0; rgbReserved:$00),
                                           (rgbBlue:$50; rgbGreen:$50; rgbRed:$50; rgbReserved:$00),
                                           (rgbBlue:$FF; rgbGreen:$50; rgbRed:$50; rgbReserved:$00),
                                           (rgbBlue:$50; rgbGreen:$FF; rgbRed:$00; rgbReserved:$00),
                                           (rgbBlue:$FF; rgbGreen:$FF; rgbRed:$50; rgbReserved:$00),
                                           (rgbBlue:$50; rgbGreen:$50; rgbRed:$FF; rgbReserved:$00),
                                           (rgbBlue:$FF; rgbGreen:$50; rgbRed:$FF; rgbReserved:$00),
                                           (rgbBlue:$50; rgbGreen:$FF; rgbRed:$FF; rgbReserved:$00),
                                           (rgbBlue:$FF; rgbGreen:$FF; rgbRed:$FF; rgbReserved:$00));


var DIB : THandle;
    BI : PBitmapInfo;
    DC : HDC;
    CurCol : byte;
    BytesNeeded : integer;

begin
  PreviewPic.Visual := TBitmap.Create;
  PreviewPic.Priority := TBitmap.Create;
  PreviewPic.Visual.ReleaseHandle;
  PreviewPic.Priority.ReleaseHandle;
  BytesNeeded := sizeof(TBitmapInfoHeader)+16*sizeof(TRGBQuad);
  GetMem(BI,BytesNeeded);
  FillChar(BI^, sizeof(BI^), 0);
  with BI^.bmiHeader do
  begin
     biSize := sizeof(TBitmapInfoHeader);
     biWidth := 160;  // multiple of 4 simplifies dword alignment
     biHeight := -168;  // negative = top-down bitmap
     biPlanes := 1;  // must be 1 for DIBs
     biBitCount := 8;
     biSizeImage := 26880;
     biClrUsed := 16;
  end;
  for CurCol := 0 to 15 do
    BI^.bmiColors[CurCol] := cols[CurCol];
  DC := GetDC(0);
  DIB := CreateDIBSection(DC, BI^, DIB_RGB_COLORS, Pointer(VisPixelPtr), 0{nil}, 0);
  PreviewPic.Visual.Handle := DIB;

  DIB := CreateDIBSection(DC, BI^, DIB_RGB_COLORS, Pointer(PriPixelPtr), 0{nil}, 0);
  PreviewPic.Priority.Handle := DIB;

  ReleaseDC(0, DC);

  FreeMem(BI,BytesNeeded);
{  Main.PicImage.Picture.Bitmap.Handle := DIB;}
end;

{*************************************************************}
function LoadPreviewPic(PicNum:byte) : boolean;
{*************************************************************}
type TAxis             = (X,Y);
     Tpixmap           = array[0..159,0..199] of byte;

const CircleData : array[0.. 63] of byte =
                  ($80,
                   $C0,$C0,$C0,
                   $40,$E0,$E0,$E0,$40,
                   $60,$60,$F0,$F0,$F0,$60,$60,
                   $20,$70,$F8,$F8,$F8,$F8,$F8,$70,$20,
                   $30,$78,$78,$78,$FC,$FC,$FC,$78,$78,$78,$30,
                   $38,$7C,$7C,$7C,$FE,$FE,$FE,$FE,$FE,$7C,$7C,$7C,$38,
                   $18,$3C,$7E,$7E,$7E,$FF,$FF,$FF,$FF,$FF,$7E,$7E,$7E,$3C,$18);

const PatternData : array[0..31] of byte =
                                       ($20, $94, $02, $24, $90, $82, $a4, $a2,
                                        $82, $09, $0a, $22, $12, $10, $42, $14,
                                        $91, $4a, $91, $11, $08, $12, $25, $10,
                                        $22, $a8, $14, $24, $00, $50, $24, $04);

const PatternOffset : array[0..119] of byte =
                                       ($00, $18, $30, $c4, $dc, $65, $eb, $48,
                                        $60, $bd, $89, $04, $0a, $f4, $7d, $6d,
                                        $85, $b0, $8e, $95, $1f, $22, $0d, $df,
                                        $2a, $78, $d5, $73, $1c, $b4, $40, $a1,
                                        $b9, $3c, $ca, $58, $92, $34, $cc, $ce,
                                        $d7, $42, $90, $0f, $8b, $7f, $32, $ed,
                                        $5c, $9d, $c8, $99, $ad, $4e, $56, $a6,
                                        $f7, $68, $b7, $25, $82, $37, $3a, $51,
                                        $69, $26, $38, $52, $9e, $9a, $4f, $a7,
                                        $43, $10, $80, $ee, $3d, $59, $35, $cf,
                                        $79, $74, $b5, $a2, $b1, $96, $23, $e0,
                                        $be, $05, $f5, $6e, $19, $c5, $66, $49,
                                        $f0, $d1, $54, $a9, $70, $4b, $a4, $e2,
                                        $e6, $e5, $ab, $e4, $d2, $aa, $4c, $e3,
                                        $06, $6f, $c6, $4a, $75, $a3, $97, $e1);

var ResPos             : word;
    CurByte            : word;
    VisCol, PriCol     : byte;
    VisDraw, PriDraw   : boolean;
    FinishedDrawing    : boolean;
    TempStr            : string;
    tmpX, tmpY         : integer;
    CurBrushShape      : (bsRectangle,bsCircle);
    CurBrushStyle      : (bsSolid,bsSplatter);
    CurBrushSize       : byte;
    ErrorOccured       : boolean;
    TempBitmap : TBitmap;

  {ReadByte}
  function ReadByte : byte;
  begin
    if ResPos < PreviewPic.Resource.Size then
    begin
      ReadByte := PreviewPic.Resource.Data^[ResPos];
      ResPos := ResPos + 1;
    end
    else ReadByte := $FF;
  end;

  {PutPixel}
  procedure PutPixel(x,y:byte);
  begin
    if VisDraw then VisPixelPtr^[y*160+x] := VisCol;
    if PriDraw then PriPixelPtr^[y*160+x] := PriCol;
  end;

  {ReadWord}
  function ReadWord : word;
  var lsbyte,msbyte : byte;
  begin
    lsbyte := ReadByte;
    msbyte := ReadByte;
    ReadWord := msbyte * 256 + lsbyte;
  end;

  {ChangePicCol}
  procedure ChangePicCol;
  begin
    VisCol := ReadByte;
    VisDraw := True;
    CurByte := ReadByte;
  end;

  {DisablePicDraw}
  procedure DisablePicDraw;
  begin
    VisDraw := False;
    CurByte := ReadByte;
  end;

  {ChangePriCol}
  procedure ChangePriCol;
  begin
    PriCol := ReadByte;
    PriDraw := True;
    CurByte := ReadByte;
  end;

  {DisablePriDraw}
  procedure DisablePriDraw;
  begin
    PriDraw := False;
    CurByte := ReadByte;
  end;

  {DrawLine}
  procedure DrawLine(x1,y1,x2,y2:byte);
  var x, y            : real;
      xint, yint      : integer;
      FirstLine       : boolean;
      LineHeight      : real;{integer;}
      LineWidth       : real;{integer;}
      addX, addY      : real;

    function RoundNum(num,dirn:real) : integer;
    begin
      if dirn < 0 then
        if num - Floor(num) <= 0.501 then RoundNum := Floor(num)
        else RoundNum := Ceil(num)
      else
        if num - Floor(num) < 0.499 then RoundNum := Floor(num)
        else RoundNum := Ceil(num);
    end;

  begin
    PutPixel(x1,y1);
    LineHeight := y2 - y1;
    LineWidth := x2 - x1;
    if LineHeight = 0 then addX := 0
    else addX := LineWidth/abs(LineHeight);
    if LineWidth = 0 then addY := 0
    else addY := LineHeight/abs(LineWidth);
    if abs(LineWidth) > abs(LineHeight) then {line wider than higher}
      begin
       y := y1;
       if LineWidth > 0 then
         for xint := x1 to x2-1 do
           begin
             PutPixel(RoundNum(xint, addX),RoundNum(y, addY));
             y := y + addY;
           end
       else if LineWidth < 0 then
         for xint := x1 downto x2+1 do
           begin
             PutPixel(RoundNum(xint, addX),RoundNum(y, addY));
             y := y + addY;
           end;
        PutPixel(x2,y2);
       end
    else
      begin {line higher than wider}
        x := x1;
        if LineHeight > 0 then
          for yint := y1 to y2-1 do
            begin
              PutPixel(RoundNum(x, addX),RoundNum(yint, addY));
              x := x + addX;
            end
        else if LineHeight < 0 then
          for yint := y1 downto y2+1 do
            begin
              PutPixel(RoundNum(x, addX),RoundNum(yint, addY));
              x := x + addX;
            end;
        PutPixel(x2,y2);
      end;
  end;

  {DrawCorner}
  procedure DrawCorner(CurAxis:TAxis);
  var  x1,y1         : byte;
       x2,y2         : byte;

    procedure DrawCornerLine;
    begin
{      if VisDraw then
      begin
        PreviewPic.Visual.Canvas.Pen.Color := EGACOL[VisCol];
        PreviewPic.Visual.Canvas.MoveTo(x1,y1);
        PreviewPic.Visual.Canvas.LineTo(x2,y2);
        end;
      if PriDraw then
      begin
        PreviewPic.Priority.Canvas.Pen.Color := EGACOL[VisCol];
        PreviewPic.Priority.Canvas.MoveTo(x1,y1);
        PreviewPic.Priority.Canvas.LineTo(x2,y2);
      end;}
    end;

  begin
    x1 := ReadByte;
    y1 := ReadByte;
    repeat
    begin
      CurByte := ReadByte;
      if CurByte < $F0 then
      begin
        if CurAxis = X then
        begin
          x2 := CurByte;
{          for tmpX := x1 to x2 do
          if VisDraw then PreviewPic.Visual.Canvas.Pixels[tmpX,y1] := EGACOL[VisCol];}
          y2 := y1;
{          DrawCornerLine;}
          DrawLine(x1,y1,x2,y2);
          CurAxis := Y;
          x1 := x2;
        end
        else
        begin
          y2 := CurByte;
{          for tmpY := y1 to y2 do
          if VisDraw then PreviewPic.Visual.Canvas.Pixels[x1,tmpY] := EGACOL[VisCol];}
          x2 := x1;
{          DrawCornerLine;}
          DrawLine(x1,y1,x2,y2);
          CurAxis := X;
          y1 := y2;
        end;
      end;
    end;
    until CurByte >= $F0;
  end;

  {DrawAbsLine}
  procedure DrawAbsLine;
  var x1, y1 : byte;
      x2, y2 : byte;
  begin
    x1 := ReadByte;
    y1 := ReadByte;
    PutPixel(x1,y1);
    repeat
    begin
      CurByte := ReadByte;
      if CurByte < $F0 then
      begin
        x2 := CurByte;
        y2 := ReadByte;
        DrawLine(x1,y1,x2,y2);
        x1 := x2;
        y1 := y2;
      end;
    end;
    until CurByte >= $F0;
  end;

  {DrawRelLine}
  procedure DrawRelLine;
  var xdisp, ydisp        : integer;
      x, y                : integer;
  begin
    x := Readbyte;
    y := ReadByte;
    PutPixel(x,y);
    repeat
    begin
      CurByte := ReadByte;
      if CurByte < $F0 then
      begin
        if CurByte AND $80 = $80 then
          xdisp := 0 - ((CurByte AND $70) div $10)
        else xdisp := ((CurByte AND $70) div $10);
        if CurByte AND $08 = $08 then
          ydisp := 0 - (CurByte AND $07)
        else ydisp := (CurByte AND $07);
        DrawLine(x,y,x+xdisp,y+ydisp);
        x := x + xdisp;
        y := y + ydisp;
      end;
    end;
    until CurByte >= $F0;
  end;

  {DoFill}
  procedure DoFill;
  type TQueue = array[0..65535] of byte;
  const EMPTY  : byte = $FF;
        VisType : byte = 0;
        PriType : byte = 1;
        BothType : byte = 2;

  var x1, y1            : byte;
      buf               : array[0..4001] of byte;
      Queue             : ^TQueue;
      rpos              : word;
      spos              : word;
      DrawingType       : byte;

    procedure qstore(q1,q2:byte);
    begin
      if (spos+1<>rpos)  and (not((spos=65535) and (rpos>0))) then
      begin
        Queue^[spos] := q1;
        spos := spos + 1;
{        if spos=65535 then spos := 0;  {loop back}
        Queue^[spos] := q2;
        spos := spos + 1;
{        if spos=65535 then spos := 0;  {loop back}
      end;
    end;

    function qretrieve : byte;
    begin
{       if rpos=65535 then rpos := 0;  {loop back}
       if rpos=spos then qretrieve := EMPTY
       else
       begin
         qretrieve := Queue^[rpos];
         rpos := rpos + 1;
       end;
    end;

  begin
    if (VisDraw and PriDraw) then DrawingType := BothType
    else if VisDraw then DrawingType := VisType
    else if PriDraw then DrawingType := PriType;
    New(Queue);
    repeat
    begin
      CurByte := ReadByte;
      if CurByte < $F0 then
      begin
        if (VisDraw) and (not PriDraw) and (VisCol < $F) then
        begin
{          x1 := CurByte;
          y1 := ReadByte;
          PreviewPic.Visual.Canvas.Brush.Color := EGACOL[VisCol];
          PreviewPic.Visual.Canvas.FloodFill(x1,y1,EGACOL[15],fsSurface);}
          x1 := CurByte;
          y1 := ReadByte;
          rpos := 2;
          spos := 2;
          qstore(x1,y1);
          repeat
          begin
            x1 := qretrieve;
            y1 := qretrieve;
            if (x1 <> EMPTY) and (y1 <> EMPTY) then
            begin
              if VisPixelPtr^[y1*160+x1] = $F then
              begin
                VisPixelPtr^[y1*160+x1] := VisCol;
                if (y1>0)   and (VisPixelPtr^[(y1-1)*160+x1] = $F) then qstore(x1,y1-1);
                if (x1>0)   and (VisPixelPtr^[y1*160+(x1-1)] = $F) then qstore(x1-1,y1);
                if (x1<159) and (VisPixelPtr^[y1*160+(x1+1)] = $F) then qstore(x1+1,y1);
                if (y1<167) and (VisPixelPtr^[(y1+1)*160+x1] = $F) then qstore(x1,y1+1);
              end; {if okToFill(x1,y1)}
            end; {if (x1 <> EMPTY) and (y1 <> EMPTY)}
          end; until (x1=EMPTY) or (y1=EMPTY);
        end
        else if (PriDraw)and (not VisDraw) and (PriCol <> 4) then
        begin
{          x1 := CurByte;
          y1 := ReadByte;
          PreviewPic.Priority.Canvas.Brush.Color := EGACOL[PriCol];
          PreviewPic.Priority.Canvas.FloodFill(x1,y1,EGACOL[4],fsSurface);}
          x1 := CurByte;
          y1 := ReadByte;
          rpos := 2;
          spos := 2;
          qstore(x1,y1);
          repeat
          begin
            x1 := qretrieve;
            y1 := qretrieve;
            if (x1 <> EMPTY) and (y1 <> EMPTY) then
            begin
              if PriPixelPtr^[y1*160+x1] = 4 then
              begin
                PriPixelPtr^[y1*160+x1] := PriCol;
                if (y1>0)   and (PriPixelPtr^[(y1-1)*160+x1] = 4) then qstore(x1,y1-1);
                if (x1>0)   and (PriPixelPtr^[y1*160+(x1-1)] = 4) then qstore(x1-1,y1);
                if (x1<159) and (PriPixelPtr^[y1*160+(x1+1)] = 4) then qstore(x1+1,y1);
                if (y1<167) and (PriPixelPtr^[(y1+1)*160+x1] = 4) then qstore(x1,y1+1);
              end; {if okToFill(x1,y1)}
            end; {if (x1 <> EMPTY) and (y1 <> EMPTY)}
          end; until (x1=EMPTY) or (y1=EMPTY);
        end
        else if (VisDraw) and (PriDraw) and (VisCol < $F) then
        begin
          x1 := CurByte;
          y1 := ReadByte;
          rpos := 2;
          spos := 2;
          qstore(x1,y1);
          repeat
          begin
            x1 := qretrieve;
            y1 := qretrieve;
            if (x1 <> EMPTY) and (y1 <> EMPTY) then
            begin
              if VisPixelPtr^[y1*160+x1] = $F then
              begin
                VisPixelPtr^[y1*160+x1] := VisCol;
                PriPixelPtr^[y1*160+x1] := PriCol;
                if (y1>0)   and (VisPixelPtr^[(y1-1)*160+x1] = $F) then qstore(x1,y1-1);
                if (x1>0)   and (VisPixelPtr^[y1*160+(x1-1)] = $F) then qstore(x1-1,y1);
                if (x1<159) and (VisPixelPtr^[y1*160+(x1+1)] = $F) then qstore(x1+1,y1);
                if (y1<167) and (VisPixelPtr^[(y1+1)*160+x1] = $F) then qstore(x1,y1+1);
              end; {if okToFill(x1,y1)}
            end; {if (x1 <> EMPTY) and (y1 <> EMPTY)}
          end; until (x1=EMPTY) or (y1=EMPTY);
        end;
      end; {if CurByte < $F0}

    end until CurByte >= $F0;
    Dispose(Queue);
  end;

  {ChangeBrushStyle}
  procedure ChangeBrushStyle;
  begin
    CurByte := ReadByte;
    if CurByte AND $20 = $20 then CurBrushStyle := bsSplatter
    else CurBrushStyle := bsSolid;
    if CurByte AND $10 = $10 then CurBrushShape := bsRectangle
    else CurBrushShape := bsCircle;
    CurBrushSize := CurByte AND $07;
    CurByte := ReadByte;
  end;

  {BrushPlot}
  procedure BrushPlot;
  var PlotX, PlotY : byte;
      PatternNum : byte;
      pictureX, pictureY : integer;
      bitmapx,bitmapy : integer;
      bitpos : word;
      msg : string;
  begin
    CurByte := ReadByte;
    repeat
    begin
      if CurBrushStyle = bsSplatter then
      begin
        PatternNum := (CurByte AND $FE) SHR 1;
        if PatternNum > 119 then
        begin
          ShowMessage('Error: Invalid brush pattern ('+IntToStr(PatternNum)+') found at position 0x'+IntToHex(ResPos,4)+'.');
          halt;
        end;
        bitpos := PatternOffset[PatternNum];
        CurByte := ReadByte;
      end;
      PlotX := CurByte;
      CurByte := ReadByte;
      PlotY := CurByte;

      if plotX < Ceil(CurBrushSize/2) then plotX := Ceil(CurBrushSize/2)
      else if plotX > 159-Floor(CurBrushSize/2) then plotX := 159-Floor(CurBrushSize/2);
      if plotY < CurBrushSize then plotY := CurBrushSize
      else if plotY > 167-CurBrushSize then plotY := 167-CurBrushSize;

      if (CurBrushStyle = bsSolid) and (CurBrushShape = bsRectangle) then
        for pictureY := PlotY - CurBrushSize to PlotY + CurBrushSize do
          for pictureX := PlotX - Ceil(CurBrushSize/2) to PlotX + Floor(CurBrushSize/2) do
            PutPixel(pictureX,pictureY);

      if (CurBrushStyle = bsSplatter) and (CurBrushShape = bsRectangle) then
        for pictureY := PlotY - CurBrushSize to PlotY + CurBrushSize do
          for pictureX := PlotX - Ceil(CurBrushSize/2) to PlotX + Floor(CurBrushSize/2) do
          begin
            if (PatternData[bitpos div 8] SHR (7-(bitpos mod 8))) AND $01 = 1 then
              PutPixel(pictureX,pictureY);
            bitpos := bitpos + 1;
//            bitpos := bitpos mod 256;
            if bitpos = 255 then bitpos := 0; {not correct, but same as SHOWPIC}
          end;

      if (CurBrushStyle = bsSolid) and (CurBrushShape = bsCircle) then
        for pictureY := PlotY - CurBrushSize to PlotY + CurBrushSize do
          for pictureX := PlotX - Ceil(CurBrushSize/2) to PlotX + Floor(CurBrushSize/2) do
          if (CircleData[Sqr(CurBrushSize)+pictureY-PlotY+CurBrushSize] SHR (7-(pictureX-PlotX+Ceil(CurBrushSize/2)))) AND $01 = 1 then
            PutPixel(pictureX,pictureY);

      if (CurBrushStyle = bsSplatter) and (CurBrushShape = bsCircle) then
        for pictureY := PlotY - CurBrushSize to PlotY + CurBrushSize do
          for pictureX := PlotX - Ceil(CurBrushSize/2) to PlotX + Floor(CurBrushSize/2) do
          if (CircleData[Sqr(CurBrushSize)+pictureY-PlotY+CurBrushSize] SHR (7-(pictureX-PlotX+Ceil(CurBrushSize/2)))) AND $01 = 1 then
          begin
            if (PatternData[bitpos div 8] SHR (7-(bitpos mod 8))) AND $01 = 1 then
              PutPixel(pictureX,pictureY);
            bitpos := bitpos + 1;
//            bitpos := bitpos mod 256;
            if bitpos = 255 then bitpos := 0; {not correct, but same as SHOWPIC}
          end;
{      msg := 'BrushPlot: ';
      if CurBrushShape = bsRectangle then msg := msg + 'Rectangle/';
      if CurBrushShape = bsCircle then msg := msg + 'Circle/';
      if CurBrushStyle = bsSolid then msg := msg + 'Solid, ';
      if CurBrushStyle = bsSplatter then msg := msg + 'Splatter, ';
      msg := msg + 'size='+IntToStr(CurBrushSize)+', ';
      msg := msg + 'plotX='+IntToStr(plotX)+', plotY='+IntToStr(plotY);
      ShowMessage(msg);}
      CurByte := ReadByte;
    end;
    until CurByte >= $F0;
  end;

begin
  ErrorOccured := False;
  LoadPreviewPic := False;
  PreviewPic.Resource := ReadResource(Picture,PicNum);
  if PreviewPic.Resource.Size > 0 then
  begin
    PreviewWin.PicPreviewPanel.Width := 320;
    PreviewWin.PicImage.Width := 320;
    PreviewWin.PicImage.Height := 168;
    if PreviewWin.ClientWidth < PreviewWin.PicPreviewPanel.Width + PreviewWin.PicPreviewPanel.Left*2 then
      PreviewWin.ClientWidth := PreviewWin.PicPreviewPanel.Width + PreviewWin.PicPreviewPanel.Left*2;
    if PreviewWin.ClientHeight < PreviewWin.PicPreviewPanel.Height + PreviewWin.PicPreviewPanel.Top*2 then
      PreviewWin.ClientHeight := PreviewWin.PicPreviewPanel.Height + PreviewWin.PicPreviewPanel.Top*2;
    InitialisePreviewPicBitmaps;

    ResPos := 0;
    CurByte := ReadByte;
    VisCol := $F;
    PriCol := $4;
    CurBrushSize := 0;
    CurBrushShape := bsRectangle;
    CurBrushStyle := bsSolid;
    VisDraw := False;
    PriDraw := False;
    FinishedDrawing := False;
    for tmpX := 0 to 159 do
      for tmpY := 0 to 167 do
        begin
          VisPixelPtr^[tmpY*160+tmpX] := $F;
          PriPixelPtr^[tmpY*160+tmpX] := $4;
       end;
    repeat
    begin
      if not ErrorOccured then
      begin
        if CurByte = $F0 then ChangePicCol
        else if CurByte = $F1 then DisablePicDraw
        else if CurByte = $F2 then ChangePriCol
        else if CurByte = $F3 then DisablePriDraw
        else if CurByte = $F4 then DrawCorner(Y)
        else if CurByte = $F5 then DrawCorner(X)
        else if CurByte = $F6 then DrawAbsLine
        else if CurByte = $F7 then DrawRelLine
        else if CurByte = $F8 then DoFill
        else if CurByte = $F9 then ChangeBrushStyle
        else if CurByte = $FA then BrushPlot
        else if CurByte = $FF then FinishedDrawing := True
        else
        begin
          ShowMessage('Error: Unknown drawing action 0x'+IntToHex(CurByte,2)+' found at position 0x'+IntToHex(ResPos,4)+'.');
          ErrorOccured := True;
        end;
      end; {if not ErrorOccured}
    end; until (ResPos >= PreviewPic.Resource.Size - 1) or (FinishedDrawing) or ErrorOccured;
    if not ErrorOccured then
    begin
      PreviewWin.PicImage.Picture.Bitmap.Width := 160;
      PreviewWin.PicImage.Picture.Bitmap.Height := 168;
      if PreviewWin.PreviewPicVisRadio.Checked then
        PreviewWin.PicImage.Canvas.StretchDraw(Rect(0,0,160,168),PreviewPic.Visual)
      else PreviewWin.PicImage.Canvas.StretchDraw(Rect(0,0,160,168),PreviewPic.Priority);
      ResourceWin.Image1.Picture.Bitmap.Assign(PreviewWin.ViewImage.Picture.Bitmap);
//      ResourceWin.SetFocus;
{      TempBitmap := TBitmap.Create;
      TempBitmap.Assign(BaseBitmap);
      TempBitmap.Palette := EGAPalHandle;
      SelectPalette(TempBitmap.Canvas.Handle, EGAPalHandle, False);
      TempBitmap.Width := 160; TempBitmap.Height := 168;
      if PreviewWin.PreviewPicVisRadio.Checked then
        TempBitmap.Canvas.StretchDraw(Rect(0,0,160,168),PreviewPic.Visual)
      else TempBitmap.Canvas.StretchDraw(Rect(0,0,160,168),PreviewPic.Priority);
      PreviewWin.PicImage.Canvas.StretchDraw(Rect(0,0,160,168),TempBitmap);
      TempBitmap.Palette := 0;
      TempBitmap.Free;}
      PreviewWin.Caption := 'Preview - ' + ResourceName(PICTURE,PicNum);
      LoadPreviewPic := True;
    end;
    FreeMem(PreviewPic.Resource.Data,PreviewPic.Resource.Size);
    PreviewPic.InUse := True;
  end; {if PreviewPic.Resource.Size > 0}
end;

end.
