{
    PreviewWin1.pas - Picture viewer window
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit PreviewWin1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, Defines, ClipBrd;

type
  TPreviewWin = class(TForm)
    PicPreviewPanel: TPanel;
    PicImage: TImage;
    PreviewPicVisRadio: TRadioButton;
    PreviewPicPriRadio: TRadioButton;
    PreviewPicSaveBut: TButton;
    Button1: TButton;
    ViewPreviewPanel: TPanel;
    ViewImage: TImage;
    ViewDescription: TLabel;
    ViewPreviewAdjustPanel: TPanel;
    Label5: TLabel;
    Label6: TLabel;
    LoopDisplay: TLabel;
    CelDisplay: TLabel;
    LoopAdjust: TUpDown;
    CelAdjust: TUpDown;
    BMPSaveDialog: TSaveDialog;
    Image1: TImage;
    ErrorMessageLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure PreviewPicVisRadioClick(Sender: TObject);
    procedure PreviewPicPriRadioClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure PreviewPicSaveButClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LoopAdjustClick(Sender: TObject; Button: TUDBtnType);
    procedure CelAdjustClick(Sender: TObject; Button: TUDBtnType);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    DefaultClientWidth : integer;
    DefaultClientHeight : integer;
  end;

var
  PreviewWin: TPreviewWin;

implementation

uses main1, ViewPreview1, ResourceWin1;

{$R *.DFM}




procedure TPreviewWin.FormCreate(Sender: TObject);
begin
  DefaultClientWidth := PicPreviewPanel.Width + PicPreviewPanel.Left*2;
  DefaultClientHeight := PicPreviewPanel.Height + PicPreviewPanel.Top*2;
  if Settings.Windows.PreviewWin.Top >= 0 then Top := Settings.Windows.PreviewWin.Top
  else Top := 0;
  if Settings.Windows.PreviewWin.Left >= 0 then Left := Settings.Windows.PreviewWin.Left
  else Left := ResourceWin.Left + ResourceWin.Width;
  if Settings.Windows.PreviewWin.Width >= 0 then Width := Settings.Windows.PreviewWin.Width
  else ClientWidth := PicPreviewPanel.Width + PicPreviewPanel.Left*2;
  if Settings.Windows.PreviewWin.Height >= 0 then Height := Settings.Windows.PreviewWin.Height
  else ClientHeight := PicPreviewPanel.Height + PicPreviewPanel.Top*2;
  ResizeViewPreviewPanel;
  ViewImageInitialTop := ViewImage.Top;
  ViewImageInitialLeft := ViewImage.Left;
  ViewPreviewPanelInitialWidth := ViewPreviewPanel.Width;
  ViewPreviewPanelInitialHeight := ViewPreviewPanel.Height;
  if Settings.Windows.ResourceWin.Height >= 0 then ResourceWin.Height := Settings.Windows.ResourceWin.Height
  else ResourceWin.Height := PreviewWin.Height;
  EGAPalHandle := CreateEGAPalette;
  PreviewWin.PicImage.Picture.Bitmap.Assign(BaseBitmap);
  PreviewWin.PicImage.Picture.Bitmap.Palette := CreateEGAPalette;
  SelectPalette(PreviewWin.PicImage.Canvas.Handle, CreateEGAPalette, True);
  PreviewWin.ViewImage.Picture.Bitmap.Assign(BaseBitmap);
  PreviewWin.ViewImage.Picture.Bitmap.Palette := CreateEGAPalette;
  SelectPalette(PreviewWin.ViewImage.Canvas.Handle, CreateEGAPalette, True);
end;

procedure TPreviewWin.FormResize(Sender: TObject);
begin
  if ViewPreviewPanel.Visible then ResizeViewPreviewPanel;
end;

procedure TPreviewWin.PreviewPicVisRadioClick(Sender: TObject);
begin
  PreviewWin.PicImage.Canvas.StretchDraw(Rect(0,0,160,168),PreviewPic.Visual);
end;

procedure TPreviewWin.PreviewPicPriRadioClick(Sender: TObject);
begin
  PreviewWin.PicImage.Canvas.StretchDraw(Rect(0,0,160,168),PreviewPic.Priority);
end;

procedure TPreviewWin.Button1Click(Sender: TObject);
var TempBitmap : TBitmap;
begin
  TempBitmap := TBitmap.Create;
  TempBitmap.Width := 320;
  TempBitmap.Height := 168;
  if PreviewPicVisRadio.Checked then
    TempBitmap.Canvas.StretchDraw(Rect(0,0,320,168),PreviewPic.Visual)
  else TempBitmap.Canvas.StretchDraw(Rect(0,0,320,168),PreviewPic.Priority);
  Clipboard.Assign(TempBitmap);
  TempBitmap.Free;
end;

procedure TPreviewWin.PreviewPicSaveButClick(Sender: TObject);
var TempBitmap : TBitmap;
begin
  if PreviewPicVisRadio.Checked then
    BMPSaveDialog.Filename := 'picture'+IntToStr(ResourceNum[PICTURE,ResourceWin.ResourceList.ItemIndex])+'-vis.bmp'
  else BMPSaveDialog.Filename := 'picture'+IntToStr(ResourceNum[PICTURE,ResourceWin.ResourceList.ItemIndex])+'-pri.bmp';
  if BMPSaveDialog.Execute then
  begin
    TempBitmap := TBitmap.Create;
    TempBitmap.Width := 320;
    TempBitmap.Height := 168;
    if PreviewPicVisRadio.Checked then
      TempBitmap.Canvas.StretchDraw(Rect(0,0,320,168),PreviewPic.Visual)
    else TempBitmap.Canvas.StretchDraw(Rect(0,0,320,168),PreviewPic.Priority);
    TempBitmap.SaveToFile(BMPSaveDialog.Filename);
    TempBitmap.Free;
  end;
end;

procedure TPreviewWin.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ViewPreviewPanel.Visible then
  begin
    if (Upcase(chr(Key))='Q') and (PreviewView.SelectedLoop>0) then
    begin
      PreviewView.SelectedLoop := PreviewView.SelectedLoop - 1;
      LoopAdjust.Position := PreviewView.SelectedLoop;
      PreviewView.SelectedCel := 0;
      DisplayPreviewView(PreviewView.SelectedLoop,PreviewView.SelectedCel);
    end;
    if (Upcase(chr(Key))='W') and (PreviewView.SelectedLoop<PreviewView.NumLoops-1) then
    begin
      PreviewView.SelectedLoop := PreviewView.SelectedLoop + 1;
      LoopAdjust.Position := PreviewView.SelectedLoop;
      PreviewView.SelectedCel := 0;
      DisplayPreviewView(PreviewView.SelectedLoop,PreviewView.SelectedCel);
    end;
    if (Upcase(chr(Key))='A') and (PreviewView.SelectedCel>0) then
    begin
      PreviewView.SelectedCel := PreviewView.SelectedCel - 1;
      CelAdjust.Position := PreviewView.SelectedCel;
      DisplayPreviewView(PreviewView.SelectedLoop,PreviewView.SelectedCel);
    end;
    if (Upcase(chr(Key))='S') and (PreviewView.SelectedCel<PreviewView.NumCels[PreviewView.SelectedLoop]-1) then
    begin
      PreviewView.SelectedCel := PreviewView.SelectedCel + 1;
      CelAdjust.Position := PreviewView.SelectedCel;
      DisplayPreviewView(PreviewView.SelectedLoop,PreviewView.SelectedCel);
    end;
  end; {if ViewPreviewPanel.Visible}
  if PicPreviewPanel.Visible then
  begin
    if (Upcase(chr(Key))='1') and (not PreviewPicVisRadio.Checked) then
      begin
        PreviewWin.PicImage.Canvas.StretchDraw(Rect(0,0,160,168),PreviewPic.Visual);
        PreviewPicVisRadio.Checked := True;
      end;
    if (Upcase(chr(Key))='2') and (not PreviewPicPriRadio.Checked) then
      begin
        PreviewWin.PicImage.Canvas.StretchDraw(Rect(0,0,160,168),PreviewPic.Priority);
        PreviewPicPriRadio.Checked := True;
      end;
  end {if PicPreviewPanel.Visible}
end;

procedure TPreviewWin.LoopAdjustClick(Sender: TObject; Button: TUDBtnType);
begin
  PreviewView.SelectedLoop := LoopAdjust.Position;
  PreviewView.SelectedCel := 0;
  DisplayPreviewView(PreviewView.SelectedLoop,PreviewView.SelectedCel);
end;

procedure TPreviewWin.CelAdjustClick(Sender: TObject; Button: TUDBtnType);
begin
  PreviewView.SelectedCel := CelAdjust.Position;
  DisplayPreviewView(PreviewView.SelectedLoop,PreviewView.SelectedCel);
end;





procedure TPreviewWin.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if WindowState = wsMaximized then Settings.Windows.PreviewWin.Maximized := True
  else Settings.Windows.PreviewWin.Maximized := False;
  WindowState := wsNormal;
  Settings.Windows.PreviewWin.Top := Top;
  Settings.Windows.PreviewWin.Left := Left;
  Settings.Windows.PreviewWin.Width := Width;
  Settings.Windows.PreviewWin.Height := Height;
  if not GameIsOpen then Action := caFree;
end;

procedure TPreviewWin.Button2Click(Sender: TObject);
begin
  ShowMessage('PicImage: '+IntToHex(PreviewWin.PicImage.Picture.Bitmap.Handle,8));
  ShowMessage('ViewImage: '+IntToHex(PreviewWin.ViewImage.Picture.Bitmap.Handle,8));
end;

end.
