{
    Defines.pas - Various defenitions
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit Defines;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Grids, Outline, DirOutln, ComCtrls, IniFiles;

const
  MaxLoops = 16;
  MaxCels = 32;
  MaxResourceSize = 65530;

type String12 = String[12];
   TResourceInfo = record
                     Filename : String12;
                     Loc : longint;
                     Exists : boolean;
                   end;
  TResourceData = array[0..MaxResourceSize-1] of byte;
  PResourceData = ^TResourceData;
  TResource = record
                Data        : PResourceData;
                Size        : word;
              end;
  TRefPoint = (BotLeft,BotRight);
  TView = record
               Description  : TStringList;
               NumLoops     : byte;

               NumCels      : array[0..MaxLoops-1] of byte;
               MirrorLoop   : array[0..MaxLoops-1] of boolean;
               MirrorLoopNum: array[0..MaxLoops-1] of byte;
               MaxWidth     : array[0..MaxLoops-1] of byte;
               MaxHeight    : array[0..MaxLoops-1] of byte;

               CelWidth     : array[0..MaxLoops-1,0..MaxCels-1] of byte;
               CelHeight    : array[0..MaxLoops-1,0..MaxCels-1] of byte;
               CelTransCol  : array[0..MaxLoops-1,0..MaxCels-1] of byte;
               CelBitmap    : array[0..MaxLoops-1,0..MaxCels-1] of TBitmap;
             end;
  TPreviewView = record
               InUse        : boolean;
               NumLoops     : byte;
               NumCels      : array[0..MaxLoops-1] of byte;
               LoopStart    : array[0..MaxLoops-1] of word;
               CelStart     : array[0..MaxLoops-1,0..MaxCels-1] of word;
               Resource     : TResource;
               SelectedLoop : byte;
               SelectedCel  : byte;
               MaxWidth     : array[0..MaxLoops-1] of byte;
               MaxHeight    : array[0..MaxLoops-1] of byte;
               MirrorLoop   : array[0..MaxLoops-1] of boolean;
               MirrorLoopNum: array[0..MaxLoops-1] of byte;
               CurrentCelMirrored : boolean;
             end;
  TPreviewPic = record
                  InUse        : boolean;
                  Resource     : TResource;
                  Visual       : TBitmap;
                  Priority     : TBitmap;
                end;
  TSettingsWindowPos = record
                         Top    : integer;
                         Left   : integer;
                         Width  : integer;
                         Height : integer;
                         Maximized : boolean;
                       end;
  TSettingsWindows = record
                       Main : TSettingsWindowPos;
                       ResourceWin : TSettingsWindowPos;
                       PreviewWin : TSettingsWindowPos;
                      end;
  TSettingsResources = record
                         NameType : integer;
                         DefaultType : integer;
                       end;
  TSettingsLogicEditor = record
                           MaximizeEditorWindow : boolean;
                           ShowAllMessages      : boolean;
                           ShowAllElsesAsGotos  : boolean;
                           ShowSpecialSyntax    : boolean;
                         end;
  TSettingsGeneral = record
                       ShowSplashScreen : boolean;
                     end;
  TSettings   = record
                  Windows : TSettingsWindows;
                  Resources : TSettingsResources;
                  LogicEditor : TSettingsLogicEditor;
                  General : TSettingsGeneral;
                end;
  TGameSettings   = record
                  GameExecutable    : string;
                end;
const
  LOGIC   : byte = 0;
  PICTURE : byte = 1;
  VIEW    : byte = 2;
  SOUND   : byte = 3;
  ResTypeName : array[0..3] of String[8] = ('LOGIC','PICTURE','VIEW','SOUND');
  ResTypeAbbrv : array[0..3] of String[8] = ('LOG','PIC','VIEW','SND');
  DefaultSettings : TSettings = (Resources:(NameType:0;DefaultType:2);
                                 LogicEditor:(MaximizeEditorWindow:True;ShowAllMessages:True;
                                              ShowAllElsesAsGotos:False;ShowSpecialSyntax:True);
                                 General:(ShowSplashScreen:True));
  EGACOL : array[0..15] of cardinal = ($00000000,$00A00000,$0000A000,$00A0A000,
                                      $000000A0,$00A00080,$000050A0,$00A0A0A0,
                                      $00505050,$00FF5050,$0050FF00,$00FFFF50,
                                      $005050FF,$00FF50FF,$0050FFFF,$00FFFFFF);
 EGAcols   : array[0..15] of TRGBQUAD = ((rgbBlue:$00; rgbGreen:$00; rgbRed:$00; rgbReserved:$00),
                                         (rgbBlue:$A0; rgbGreen:$00; rgbRed:$00; rgbReserved:$00),
                                         (rgbBlue:$00; rgbGreen:$A0; rgbRed:$00; rgbReserved:$00),
                                         (rgbBlue:$A0; rgbGreen:$A0; rgbRed:$00; rgbReserved:$00),
                                         (rgbBlue:$00; rgbGreen:$00; rgbRed:$A0; rgbReserved:$00),
                                         (rgbBlue:$A0; rgbGreen:$00; rgbRed:$80; rgbReserved:$00),
                                         (rgbBlue:$00; rgbGreen:$50; rgbRed:$A0; rgbReserved:$00),
                                         (rgbBlue:$A0; rgbGreen:$A0; rgbRed:$A0; rgbReserved:$00),
                                         (rgbBlue:$50; rgbGreen:$50; rgbRed:$50; rgbReserved:$00),
                                         (rgbBlue:$FF; rgbGreen:$50; rgbRed:$50; rgbReserved:$00),
                                         (rgbBlue:$50; rgbGreen:$FF; rgbRed:$00; rgbReserved:$00),
                                         (rgbBlue:$FF; rgbGreen:$FF; rgbRed:$50; rgbReserved:$00),
                                         (rgbBlue:$50; rgbGreen:$50; rgbRed:$FF; rgbReserved:$00),
                                         (rgbBlue:$FF; rgbGreen:$50; rgbRed:$FF; rgbReserved:$00),
                                         (rgbBlue:$50; rgbGreen:$FF; rgbRed:$FF; rgbReserved:$00),
                                         (rgbBlue:$FF; rgbGreen:$FF; rgbRed:$FF; rgbReserved:$00));

  WhiteCol : integer = $00FFFFFF;
  DkRedCol : integer = $000000A0;

  EncryptionKey : string = 'Avis Durgan';  // What the hell does this mean, anyway?

  SourceDir = 'src';  // directory containing logic sources

var ResourceInfo           : array[0..3,0..255] of TResourceInfo;
    ResourceNum            : array[0..3,0..255] of byte;
    NumResources           : array[0..3] of word;
    SelectedResourceType   : byte;
    PreviewView            : TPreviewView;
    PreviewPic             : TPreviewPic;
    GameDir                : string;
    ProgramDir             : string;
    GameSettings           : TGameSettings;
    GameSettingsFile       : TIniFile;
    Settings               : TSettings;
    SettingsFile           : TIniFile;
    GameIsOpen             : boolean;
    ResTypeName2           : TStringList;
    AGIVersionNumber       : double;
    GameID                 : string; // used for filenames for AGI v3
    GameIsV3               : boolean;
    In256ColMode           : boolean;

function MultStr(TheStr:string;NumCopies:byte) : string;
function ResourceName(ResourceType1,ResourceID1:byte) : string;
function AskYesNo(MsgTitle,MsgText:string) : boolean;
procedure SetResTypeName2;

implementation

{*************************************************************}
function MultStr(TheStr:string;NumCopies:byte) : string;
{*************************************************************}

var i : word;
    MultStr1 : string;
begin
  MultStr1 := '';
  for i := 1 to NumCopies do
    begin
      MultStr1 := MultStr1 + TheStr;
    end;
  MultStr := MultStr1;
end;

{*************************************************************}
function ResourceName(ResourceType1,ResourceID1:byte) : string;
{*************************************************************}
var ResourceID1Str : string;



begin
  Str(ResourceID1,ResourceID1Str);
  if ResourceID1 < 10 then ResourceID1Str := '00' + ResourceID1Str
  else  if ResourceID1 < 100 then ResourceID1Str := '0' + ResourceID1Str
  else ResourceID1Str := ResourceID1Str;
  case Settings.Resources.NameType of
    0,4,8: ResourceName := ResTypeName2[ResourceType1] + '.' + ResourceID1Str;
    1,5,9: ResourceName := ResTypeName2[ResourceType1] + ' ' + ResourceID1Str;
    2,6,10: ResourceName := ResTypeName2[ResourceType1] + '.' + IntToStr(ResourceID1);
    3,7,11: ResourceName := ResTypeName2[ResourceType1] + ' ' + IntToStr(ResourceID1);
  end;
end;

{**********************************************************************}
function AskYesNo(MsgTitle,MsgText:string) : boolean;
{**********************************************************************}
var MessagePChar : PChar;
    TitlePChar : PChar;
begin
  GetMem(TitlePChar,Length(MsgTitle)+1);
  StrPCopy(TitlePChar,MsgTitle);
  GetMem(MessagePChar,Length(MsgText)+1);
  StrPCopy(MessagePChar,MsgText);
  if Application.MessageBox(MessagePChar,TitlePChar,MB_YESNO) = IDYES then AskYesNo := True
  else AskYesNo := False;
  FreeMem(TitlePChar,Length(MsgTitle)+1);
  FreeMem(MessagePChar,Length(MsgText)+1);
end;

{**********************************************************************}
procedure SetResTypeName2;
{**********************************************************************}
begin
  ResTypeName2.Clear;
  if Settings.Resources.NameType <= 3 then
  begin
    ResTypeName2.Add('LOGIC');
    ResTypeName2.Add('PICTURE');
    ResTypeName2.Add('VIEW');
    ResTypeName2.Add('SOUND');
  end
  else if Settings.Resources.NameType <= 7 then
  begin
    ResTypeName2.Add('Logic');
    ResTypeName2.Add('Picture');
    ResTypeName2.Add('View');
    ResTypeName2.Add('Sound');
  end
  else
  begin
    ResTypeName2.Add('logic');
    ResTypeName2.Add('picture');
    ResTypeName2.Add('view');
    ResTypeName2.Add('sound');
   end
end;

end.







{
EGA Colours:
    B  G  R
0   00 00 00
1   A0 00 00
2   00 A0 00
3   A0 A0 00
4   00 00 A0
5   A0 00 80
6   00 50 A0
7   A0 A0 A0
8   50 50 50
9   FF 50 50
10  50 FF 00
11  FF FF 50
12  50 50 FF
13  FF 50 FF
14  50 FF FF
15  FF FF FF
}
