{$i-}
program mergesnd;

{ An utility to merge Sierra AGI sound resources
  All this wonderful, messy code (c) Magnus Kristiansen 1998 }

  USES dos, crt, mergeutl;

  CONST
    EndMark : word = $FFFF;
    Version = '0.3 - 12/22/98';
    MaxSndC = 3; { Maximum number of sound resources/channels }

  TYPE

    channelX = record
       fileno : byte;   { Number of the file in SrcRes array }
       origc : byte;    { Number of channel to be retrieved from src file }
       startpos : word; { Start offset in src file }
       datasize : word; { Size of channel data }
    End;

    prebuf = array[1..65535] of byte;
    bufX = ^prebuf;

    resCq = array[1..maxsndc] of resource;

  VAR
    ReadBuf : bufX; { Buffer to read from source files }
    { SizeBuf : word; } { Size of the Resource bit in ReadBuf }

    SrcRes : resCq; { array[1..MaxSndC] of Resource; } { Info about up to 4 sound files }
    NewRes : Resource; { Sound resource to be created }
    Channels : array[1..MaxSndC] of channelX; { Destination info For channels }

    NumSndF : byte; { The number of source sound Resources }
    ChDiff : byte; { The difference between no of src files & max ch }
    ChExists : array[1..MaxSndC] of boolean; { If channel exists in src file }

    ChNr : byte; { The number of the new channel in each loop }
    LoopCh : byte; { Looping to collect no of channels from
                      single src file }

    Dump : word; { Dump values of no significance }
    Count, Count2, Count3 : byte; { General Count/temp vars }
    Check : boolean; { General boolean Check thingy }

  Procedure Panic;
    var
      b : byte;
    begin
      for b := 1 to MaxSndC do
        CloseIf(srcres[b]);

      CloseIf(newres);
      Halt;
    end;

  Procedure CheckError;
    var
      x : word;
    begin
      x := IOResult;
      if(x <> 0) then
      begin
        if(wherex > 1) then WriteLn;
        TextColor(lightred+blink);
        Write(#7,'Fatal error no. ',x,'!');
        Normvideo;
        WriteLn(' Program aborting.');
        Panic;
      end;
    end;


Begin { Begin program }
  { Initialization - Begin }

  For Count := 1 to MaxSndC do
    Begin
      with Channels[Count] do
        Begin
          fileno := 0;
          origc := 0;
          startpos := 0;
          datasize := 2; { $FFFF -> 2 bytes }
        End;
      with SrcRes[count] do
      Begin
        FileOpen := false; { No files opened yet }
        Attrib := Archive;
      End;
    End;

  NewRes.FileOpen := false;

  if((lo(WindMax) - lo(WindMin) + 1) < 80) then { 40-column is a pain }
    TextMode(co80);

  { Initialization - End }

  WriteLn;
  TextColor(Green);
  WriteLn('MERGESND - merges AGI sound resources');
  WriteLn('Version ',version);
  WriteLn('1998 (c) Magnus Kristiansen');
  WriteLn;

  if(MaxAvail < SizeOf(ReadBuf^)) then { If no space for buffer in heap }
    Begin
      WriteLn(#7,'Not enough memory!');
      Halt;
    End;

  GetMem(ReadBuf,sizeof(ReadBuf^));

  NormVideo;

  Write('Number of source files (1-',MaxSndC,')? ');
  Repeat
    Check := GetInt(NumSndF,'1',strOut(MaxSndC));
    if not Check then Panic; { If ESC is pressed during input }
  until((NumSndF > 0) and (NumSndF <= MaxSndC));

  ChDiff := MaxSndC - NumSndF; { Max no of src channels from ONE file }

  WriteLn;
  WriteLn;

  CheckBreak := false; { Only interrupt with ESC from now on }

  For Count := 1 to NumSndF do { Repeat info input a few times }
    Begin

      SrcRes[Count].name := ''; { Preventing nonsense values }

      Repeat
        gotoXY(1,WhereY);
        Write('Source file ',Count,': ');
        Check := getStr(SrcRes[Count].name,255,posEnd,gStr);
        if not Check then Panic; { If ESC is pressed during input }

        if(length(SrcRes[Count].name) > 0) then
        begin
          if not(FileExists(SrcRes[Count].name)) then
          Begin
            GotoXY(16,WhereY);
            Write(#7,'File doesn''t exist!');
            ClrEOL;
            PressNUL;
          End;
        End;

      until((length(SrcRes[Count].name) > 0) and
             FileExists(SrcRes[Count].name));

      WriteLn;

      With SrcRes[Count] do { Short cut }
        Assign(fil,name); CheckError;

      OpenIf(srcres[count]); CheckError;
      With SrcRes[Count] do { Short cut }
          { srcsize := filesize(fil); File size, is it at all useful? }
          BlockRead(fil,header,sizeof(header),Dump); { Read sndres header }
          CheckError;

      TextColor(Magenta);
      Write('Channels containing sound in this source file: ');
      For Count2 := 1 to MaxSndC do { Check For "empty" channels }
        Begin
          ChExists[Count2] := ((SrcRes[Count].header[Count2+1] -
                                SrcRes[Count].header[Count2]) > 2);
          if(ChExists[Count2]) then
            Begin
              Write(Count2);
              if(Count2 < MaxSndC) then Write(' ');
            End;
        End;

      NormVideo;

      WriteLn;

      if(ChDiff > 0) then
        Begin
          Write('- Number of channels to retrieve from this source file (1-',ChDiff+1,')? ');
          Check := getInt(LoopCh,'1',strOut(ChDiff+1));
          if not Check then Panic;
          WriteLn;
        End else LoopCh := 1;

      if(LoopCh > 1) then       { Reduce ChDiff when more than one channel }
        Dec(ChDiff,LoopCh - 1); { can be retrieved per source file }

      For Count2 := 1 to LoopCh do
        Begin
          if(LoopCh <= 1) then
            Write('  - Source channel (1-',MaxSndC,'): ')
          else
            Write('  - Source channel #',Count2,' (1-',MaxSndC,'): ');

          Check := getInt(Count3,'1',strOut(MaxSndC));
          if not Check then Panic;

          WriteLn;
          Write('    - Channel no. in target file (1-',MaxSndC,'): ');

          Repeat
            gotoXY(41,WhereY);
            ClrEOL;
            Check := getInt(ChNr,'1',strOut(MaxSndC));
            if not Check then Panic;

            if (not (Channels[ChNr].origc = 0)) and (ChNr > 0) then
              Begin
                Write(#8,#7,'Channel ',ChNr,' already filled!');
                PressNUL;
              End;

          until (Channels[ChNr].origc = 0) and (ChNr > 0);

          Channels[ChNr].origc := Count3;
          Channels[ChNr].fileno := Count;
          Channels[ChNr].startpos :=
            SrcRes[Count].header[Channels[ChNr].origc];
          Channels[ChNr].datasize :=
            SrcRes[Count].header[Channels[ChNr].origc+1]
            - SrcRes[Count].header[Channels[ChNr].origc];

          WriteLn;
        End; { Channel input info }

      WriteLn;
    End; { End input info }

  NewRes.name := ''; { Prevents nonsense value }

  Write('New file: '); { Name for new target resource }
  Check := getStr(NewRes.name,255,posEnd,gStr);

  if not Check then Panic; { If ESC is pressed during input }

  NewRes.header[1] := $0008; { First offset always seems to be 0008h }

  For Count := 2 to 4 do
      NewRes.header[Count] := NewRes.header[Count-1] +
                              (Channels[Count-1].datasize);

  Assign(NewRes.fil,NewRes.name); CheckError;
  ReWrite(NewRes.fil,1); CheckError;
  BlockWrite(NewRes.fil,NewRes.header,    { Write header w/offsets to }
             sizeof(NewRes.header),Dump); { new resource }
  CheckError;

  Count3 := 0;

  for Count := 1 to MaxSndC do
    Begin
      if(Channels[Count].fileno > 0) then { If file assigned to channel }
        Count3 := Count;               { Count3 is the number of the LAST
                                         non-empty channel }
    End;

  For Count := 1 to Count3 do
    Begin
      if (Channels[Count].fileno > 0) then
        Begin { Get channel data from source & write to target }
          Seek(SrcRes[Channels[Count].fileno].fil,
               Channels[Count].startpos); CheckError;

          BlockRead(SrcRes[Channels[Count].fileno].fil,
                    ReadBuf^,Channels[Count].datasize,Dump); CheckError;
          BlockWrite(NewRes.fil,ReadBuf^,Channels[Count].datasize);
          CheckError;

        End else
          Begin { If file not assigned to channel, write empty channel }
            BlockWrite(NewRes.fil,EndMark,sizeof(EndMark),Dump);
            CheckError;
          End;
    End;

  if (Count3 < 4) then { Channels after count3 will be empty }
    For Count := (Count3 + 1) to 4 do
      BlockWrite(NewRes.fil,EndMark,sizeof(EndMark));
      CheckError;
  Close(NewRes.fil);
  CheckError;
  For Count := 1 to NumSndF do
    Begin
      CloseIf(SrcRes[Count]);
      CheckError;
    End;

  FreeMem(ReadBuf,sizeof(ReadBuf^)); { Free memory occupied by buffer }

End.
