/*************************************************************************
** agicode.c
**
*************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <dos.h>
#include <ctype.h>

#include "general.h"
#include "linklist.h"

/* Warning: There is not enough memory to sustain the vgaScreen buffer if
** Turbo C is running in memory. */
byte *vgaScreen;

boolean backEnabled = FALSE, backAvail = FALSE;

byte far picture[55000];
byte far priority[55000];
boolean picDrawEnabled = FALSE, priDrawEnabled = FALSE;
byte picColour=0, priColour=0, patCode, patNum;

void showPicture();
void showPriority();


/* QUEUE DEFINITIONS */

#define MAX 4000
#define EMPTY 0xFF

byte buf[MAX+1];
word rpos = MAX, spos = 0;

void qstore(byte q)
{
   if (spos+1==rpos || (spos+1==MAX && !rpos)) {
      nosound();
      return;
   }
   buf[spos] = q;
   spos++;
   if (spos==MAX) spos = 0;  /* loop back */
}

byte qretrieve()
{
   if (rpos==MAX) rpos=0;  /* loop back */
   if (rpos==spos) {
      return EMPTY;
   }
   rpos++;
   return buf[rpos-1];
}

/**************************************************************************
** getCode
**
** Gets the next picture code from the linked list.
**************************************************************************/
byte getCode(struct picCodeNode **temp)
{
   byte retVal;

   if (*temp == NULL) return 0xFF;

   retVal = (*temp)->node;
   *temp = (*temp)->next;

   return retVal;
}

void graphicsScreen()
{
   asm {
      mov ah, 0
      mov al, 13h
      int 10h
   }
}

/**************************************************************************
** initAGIScreen
**
** Sets the screen mode to 320x200x256.
**************************************************************************/
void initAGIScreen()
{
   graphicsScreen();
   memset(&picture, 15, 53760);           /* Visual screen default, white */
   memset(&priority, 4, 53760);           /* Priority screen default, red */
}

/**************************************************************************
** closeAGIScreen
**
** Sets the screen back to text mode.
**************************************************************************/
void closeAGIScreen()
{
   asm {
      mov ah, 0
      mov al, 03h
      int 10h
   }
}

/**************************************************************************
** picPSet
**
** Draws a pixel in the picture screen.
**************************************************************************/
void picPSet(word x, byte y)
{
   const void *picturePtr = &picture;

   asm {
      les di, picturePtr
      mov di, x
      mov ah, y
      shl di, 1
      xor al, al
      add di, ax
      shr ax, 1
      mov cl, picColour
      shr ax, 1
      add di, ax
      mov [es:di], cl
      mov [es:di+1], cl
   }
}

/**************************************************************************
** priPSet
**
** Draws a pixel in the priority screen.
**************************************************************************/
void priPSet(word x, word y)
{
   const void *priorityPtr = &priority;

   asm {
      les di, priorityPtr
      mov di, x
      mov ah, y
      shl di, 1
      xor al, al
      add di, ax
      shr ax, 1
      mov cl, priColour
      shr ax, 1
      add di, ax
      mov [es:di], cl
      mov [es:di+1], cl
   }
}

/**************************************************************************
** pset
**
** Draws a pixel in each screen depending on whether drawing in that
** screen is enabled or not.
**************************************************************************/
void pset(word x, word y)
{
   if (picDrawEnabled) picPSet(x, y);
   if (priDrawEnabled) priPSet(x, y);
}

/**************************************************************************
** picGetPixel
**
** Get colour at x,y on the picture page.
**************************************************************************/
byte picGetPixel(word x, word y)
{
   byte retVal;
   const void *picturePtr = &picture;

   asm {
      les di, picturePtr
      mov di, x
      shl di, 1
      mov ax, y
      mov cl, 6
      shl ax, cl
      add di, ax
      shl ax, 1
      shl ax, 1
      add di, ax
      mov al, [es:di]
      mov retVal, al
   }

   return (retVal);
}

/**************************************************************************
** priGetPixel
**
** Get colour at x,y on the priority page.
**************************************************************************/
byte priGetPixel(word x, word y)
{
   byte retVal;
   const void *priorityPtr = &priority;

   asm {
      les di, priorityPtr
      mov di, x
      shl di, 1
      mov ax, y
      mov cl, 6
      shl ax, cl
      add di, ax
      shl ax, 1
      shl ax, 1
      add di, ax
      mov al, [es:di]
      mov retVal, al
   }

   return (retVal);
}

/**************************************************************************
** round
**
** Rounds a float to the closest int. Takes into actions which direction
** the current line is being drawn when it has a 50:50 decision about
** where to put a pixel.
**************************************************************************/
int round(float aNumber, float dirn)
{
   if (dirn < 0)
      return ((aNumber - floor(aNumber) <= 0.501)? floor(aNumber) : ceil(aNumber));
   return ((aNumber - floor(aNumber) < 0.499)? floor(aNumber) : ceil(aNumber));
}

/**************************************************************************
** drawline
**
** Draws an AGI line.
**************************************************************************/
void drawline(word x1, word y1, word x2, word y2)
{
   int height, width, startX, startY;
   float x, y, addX, addY;

   height = (y2 - y1);
   width = (x2 - x1);
   addX = (height==0?height:(float)width/abs(height));
   addY = (width==0?width:(float)height/abs(width));

   if (abs(width) > abs(height)) {
      y = y1;
      addX = (width == 0? 0 : (width/abs(width)));
      for (x=x1; x!=x2; x+=addX) {
	 pset(round(x, addX), round(y, addY));
	 y+=addY;
      }
      pset(x2,y2);
   }
   else {
      x = x1;
      addY = (height == 0? 0 : (height/abs(height)));
      for (y=y1; y!=y2; y+=addY) {
	 pset(round(x, addX), round(y, addY));
	 x+=addX;
      }
      pset(x2,y2);
   }

}

/**************************************************************************
** okToFill
**************************************************************************/
boolean okToFill(byte x, byte y)
{
   if (!picDrawEnabled && !priDrawEnabled) return FALSE;
   if (picColour == 15) return FALSE;
   if (!priDrawEnabled) return (picGetPixel(x, y) == 15);
   if (priDrawEnabled && !picDrawEnabled) return (priGetPixel(x, y) == 4);
   return (picGetPixel(x, y) == 15);
}

/**************************************************************************
** agiFill
**************************************************************************/
void agiFill(word x, word y)
{
   byte x1, y1;
   rpos = spos = 0;

   qstore(x);
   qstore(y);

   for (;;) {

      x1 = qretrieve();
      y1 = qretrieve();

      if ((x1 == EMPTY) || (y1 == EMPTY))
	 break;
      else {

	 if (okToFill(x1,y1)) {

	    pset(x1, y1);

	    if (okToFill(x1, y1-1) && (y1!=0)) {
	       qstore(x1);
	       qstore(y1-1);
	    }
	    if (okToFill(x1-1, y1) && (x1!=0)) {
	       qstore(x1-1);
	       qstore(y1);
	    }
	    if (okToFill(x1+1, y1) && (x1!=159)) {
	       qstore(x1+1);
	       qstore(y1);
	    }
	    if (okToFill(x1, y1+1) && (y1!=168)) {
	       qstore(x1);
	       qstore(y1+1);
	    }

	 }

      }

   }

}

/**************************************************************************
** xCorner
**
** Draws an xCorner  (drawing action 0xF5)
**************************************************************************/
void xCorner(struct picCodeNode **temp)
{
   byte x1, x2, y1, y2;

   x1 = getCode(temp);
   y1 = getCode(temp);

   pset(x1,y1);

   for (;;) {
      x2 = getCode(temp);
      if (x2 >= 0xF0) break;
      drawline(x1, y1, x2, y1);
      x1 = x2;
      y2 = getCode(temp);
      if (y2 >= 0xF0) break;
      drawline(x1, y1, x1, y2);
      y1 = y2;
   }

   if (*temp == NULL) *temp = NULL;
   else *temp = (*temp)->prior;
}

/**************************************************************************
** yCorner
**
** Draws an yCorner  (drawing action 0xF4)
**************************************************************************/
void yCorner(struct picCodeNode **temp)
{
   byte x1, x2, y1, y2;

   x1 = getCode(temp);
   y1 = getCode(temp);

   pset(x1, y1);

   for (;;) {
      y2 = getCode(temp);
      if (y2 >= 0xF0) break;
      drawline(x1, y1, x1, y2);
      y1 = y2;
      x2 = getCode(temp);
      if (x2 >= 0xF0) break;
      drawline(x1, y1, x2, y1);
      x1 = x2;
   }

   if (*temp == NULL) *temp = NULL;
   else *temp = (*temp)->prior;
}

/**************************************************************************
** relativeDraw
**
** Draws short lines relative to last position.  (drawing action 0xF7)
**************************************************************************/
void relativeDraw(struct picCodeNode **temp)
{
   byte x1, y1, disp;
   char dx, dy;

   x1 = getCode(temp);
   y1 = getCode(temp);

   pset(x1, y1);

   for (;;) {
      disp = getCode(temp);
      if (disp >= 0xF0) break;
      dx = ((disp & 0xF0) >> 4) & 0x0F;
      dy = (disp & 0x0F);
      if (dx & 0x08) dx = (-1)*(dx & 0x07);
      if (dy & 0x08) dy = (-1)*(dy & 0x07);
      drawline(x1, y1, x1 + dx, y1 + dy);
      x1 += dx;
      y1 += dy;
   }

   if (*temp == NULL) *temp = NULL;
   else *temp = (*temp)->prior;
}

/**************************************************************************
** fill
**
** Agi flood fill.  (drawing action 0xF8)
**************************************************************************/
void fill(struct picCodeNode **temp)
{
   byte x1, y1;

   for (;;) {
      if ((x1 = getCode(temp)) >= 0xF0) break;
      if ((y1 = getCode(temp)) >= 0xF0) break;
      agiFill(x1, y1);
   }

   if (*temp == NULL) *temp = NULL;
   else *temp = (*temp)->prior;
}

/**************************************************************************
** absoluteLine
**
** Draws long lines to actual locations (cf. relative) (drawing action 0xF6)
**************************************************************************/
void absoluteLine(struct picCodeNode **temp)
{
   byte x1, y1, x2, y2;

   x1 = getCode(temp);
   y1 = getCode(temp);

   pset(x1, y1);

   for (;;) {
      if ((x2 = getCode(temp)) >= 0xF0) break;
      if ((y2 = getCode(temp)) >= 0xF0) break;
      drawline(x1, y1, x2, y2);
      x1 = x2;
      y1 = y2;
   }

   if (*temp == NULL) *temp = NULL;
   else *temp = (*temp)->prior;
}


#define plotPatternPoint() \
   if (patCode & 0x20) { \
      if ((splatterMap[bitPos>>3] >> (7-(bitPos&7))) & 1) pset(x1, y1); \
      bitPos++; \
      if (bitPos == 0xff) bitPos=0; \
   } else pset(x1, y1)

/**************************************************************************
** plotPattern
**
** Draws pixels, circles, squares, or splatter brush patterns depending
** on the pattern code.
**************************************************************************/
void plotPattern(byte x, byte y)
{ 
  static char circles[][15] = { /* agi circle bitmaps */
    {0x80},
    {0xfc},
    {0x5f, 0xf4},
    {0x66, 0xff, 0xf6, 0x60},
    {0x23, 0xbf, 0xff, 0xff, 0xee, 0x20},
    {0x31, 0xe7, 0x9e, 0xff, 0xff, 0xde, 0x79, 0xe3, 0x00},
    {0x38, 0xf9, 0xf3, 0xef, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0xf3, 0xe3, 0x80},
    {0x18, 0x3c, 0x7e, 0x7e, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x7e,
     0x7e, 0x3c, 0x18}
  };

  static byte splatterMap[32] = { /* splatter brush bitmaps */
    0x20, 0x94, 0x02, 0x24, 0x90, 0x82, 0xa4, 0xa2,
    0x82, 0x09, 0x0a, 0x22, 0x12, 0x10, 0x42, 0x14,
    0x91, 0x4a, 0x91, 0x11, 0x08, 0x12, 0x25, 0x10,
    0x22, 0xa8, 0x14, 0x24, 0x00, 0x50, 0x24, 0x04
  };

  static byte splatterStart[128] = { /* starting bit position */
    0x00, 0x18, 0x30, 0xc4, 0xdc, 0x65, 0xeb, 0x48,
    0x60, 0xbd, 0x89, 0x05, 0x0a, 0xf4, 0x7d, 0x7d,
    0x85, 0xb0, 0x8e, 0x95, 0x1f, 0x22, 0x0d, 0xdf,
    0x2a, 0x78, 0xd5, 0x73, 0x1c, 0xb4, 0x40, 0xa1,
    0xb9, 0x3c, 0xca, 0x58, 0x92, 0x34, 0xcc, 0xce,
    0xd7, 0x42, 0x90, 0x0f, 0x8b, 0x7f, 0x32, 0xed,
    0x5c, 0x9d, 0xc8, 0x99, 0xad, 0x4e, 0x56, 0xa6,
    0xf7, 0x68, 0xb7, 0x25, 0x82, 0x37, 0x3a, 0x51,
    0x69, 0x26, 0x38, 0x52, 0x9e, 0x9a, 0x4f, 0xa7,
    0x43, 0x10, 0x80, 0xee, 0x3d, 0x59, 0x35, 0xcf,
    0x79, 0x74, 0xb5, 0xa2, 0xb1, 0x96, 0x23, 0xe0,
    0xbe, 0x05, 0xf5, 0x6e, 0x19, 0xc5, 0x66, 0x49,
    0xf0, 0xd1, 0x54, 0xa9, 0x70, 0x4b, 0xa4, 0xe2,
    0xe6, 0xe5, 0xab, 0xe4, 0xd2, 0xaa, 0x4c, 0xe3,
    0x06, 0x6f, 0xc6, 0x4a, 0xa4, 0x75, 0x97, 0xe1
  };

  int circlePos = 0;
  byte x1, y1, penSize, bitPos = splatterStart[patNum];

  penSize = (patCode&7);

  if (x<((penSize/2)+1)) x=((penSize/2)+1);
  else if (x>160-((penSize/2)+1)) x=160-((penSize/2)+1);
  if (y<penSize) y = penSize;
  else if (y>=168-penSize) y=167-penSize;

  for (y1=y-penSize; y1<=y+penSize; y1++) {
    for (x1=x-(ceil((float)penSize/2)); x1<=x+(floor((float)penSize/2)); x1++) {
      if (patCode & 0x10) { /* Square */
	plotPatternPoint();
      }
      else { /* Circle */
	if ((circles[patCode&7][circlePos>>3] >> (7-(circlePos&7)))&1) {
	  plotPatternPoint();
	}
	circlePos++;
      }
    }
  }

} 


/**************************************************************************
** plotBrush
**
** Plots points and various brush patterns.
**************************************************************************/
void plotBrush(struct picCodeNode **temp)
{
   byte x1, y1, store;

   for (;;) {
     if (patCode & 0x20) {
	if ((patNum = getCode(temp)) >= 0xF0) break;
	patNum = (patNum >> 1 & 0x7f);
     }
     if ((x1 = getCode(temp)) >= 0xF0) break;
     if ((y1 = getCode(temp)) >= 0xF0) break;
     plotPattern(x1, y1);
   }

   if (*temp == NULL) *temp = NULL;
   else *temp = (*temp)->prior;
}

byte *screen = MK_FP(0xA000, 9*320);

void showTransPri()
{
   register unsigned int pos;

   for (pos=0; pos<53760; pos++)
      screen[pos] = ((priority[pos] == 4)? vgaScreen[pos] : priority[pos]);
}

void showTransPic()
{
   register unsigned int pos;

   for (pos=0; pos<53760; pos++)
      screen[pos] = ((picture[pos] == 15)? vgaScreen[pos] : picture[pos]);
}

/**************************************************************************
** showPriority
**
** Show the current state of the priority screen.
**************************************************************************/
void showPriority()
{
   if (backEnabled)
      showTransPri();
   else
      memcpy(MK_FP(0xA000, 9*320), &priority, 53760);
}

/**************************************************************************
** showPicture
**
** Show the current state of the visual screen.
**************************************************************************/
void showPicture()
{
   if (backEnabled)
      showTransPic();
   else
      memcpy(MK_FP(0xA000, 9*320), picture, 53760);
}


void loadPicture(char *fileName)
{
   FILE *pictureFile;
   byte nodeData;
   struct picCodeNode *temp;
   boolean isFirst=TRUE, stillLoading=TRUE;

   if ((pictureFile = fopen(fileName, "rb")) == NULL) {
      textmode(C80);
      printf("Error loading picture : %s.\n", fileName);
      exit(1);
   }

   do {
      nodeData = fgetc(pictureFile);

      if (nodeData != 0xFF) {

	 temp = (struct picCodeNode *)malloc(sizeof(picCodes));
	 if (temp == NULL) {
	    textmode(C80);
	    printf("Error allocating memory while loading picture.\n");
	    exit(1);
	 }
	 if (isFirst) {
	    picStart = temp;
	    isFirst = FALSE;
	 }
	 temp->node = nodeData;
	 dlstore(temp);
      }
      else
	 stillLoading = FALSE;

   } while(!feof(pictureFile) && stillLoading);

   picLast = temp;
   picPos = NULL;

   fclose(pictureFile);
}

void savePicture(char *fileName)
{
   FILE *pictureFile;
   struct picCodeNode *temp;

   if ((pictureFile = fopen(fileName, "wb")) == NULL) {
      /* Message box saying that the filename is not acceptable */
   }
   else {

      if (picStart == NULL) {   /* Black picture */
	 fputc(0xFF, pictureFile);  /* End of picture marker */
	 fclose(pictureFile);
	 return;
      }

      temp = picStart;
      fputc(temp->node, pictureFile);

      do {
	 temp = temp->next;
	 fputc(temp->node, pictureFile);
      } while (temp->next != NULL);

      fputc(0xFF, pictureFile);  /* End of picture marker */
      fclose(pictureFile);
   }
}

void drawPicture()
{
   byte action;
   struct picCodeNode *temp;
   boolean finishedPic=FALSE;
   int pC, pN;

   memset(&picture, 15, 53760);           /* Visual screen default, white */
   memset(&priority, 4, 53760);           /* Priority screen default, red */

   if ((picStart != NULL) && (picLast != NULL)) {

      pC = patCode;
      pN = patNum;
      patCode = patNum = 0;

      temp = picStart;

      if (picPos != picStart) do {

	action = getCode(&temp);

	switch (action) {

	   case 0xF0: picColour = getCode(&temp);
		      picDrawEnabled = TRUE;
		      break;
	   case 0xF1: picDrawEnabled = FALSE; break;
	   case 0xF2: priColour = getCode(&temp);
		      priDrawEnabled = TRUE;
		      break;
	   case 0xF3: priDrawEnabled = FALSE; break;
	   case 0xF4: yCorner(&temp); break;
	   case 0xF5: xCorner(&temp); break;
	   case 0xF6: absoluteLine(&temp); break;
	   case 0xF7: relativeDraw(&temp); break;
	   case 0xF8: fill(&temp); break;
	   case 0xF9: patCode = getCode(&temp); break;
	   case 0xFA: plotBrush(&temp); break;
	   case 0xFF: finishedPic=TRUE; break;
	   default:
	      textmode(C80);
	      printf("Unknown picture code : %X\n", action);
	      printf("%X %X %X\n", picLast, picPos, temp);
	      exit(0);
	      break;
	}

      } while((temp != picPos) && !finishedPic);

      patCode = pC;
      patNum = pN;
   }

}
