

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                         *
 * Module Name : BCMLIB.H                                                  *
 *                                                                         *
 * Description : This is the BICOM standard header file.                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * BICOM (R) BCMLIB.H  Version 1.03                                        *
 * Copyright (c) BICOM 1990, 1991,1992,1993   All rights reserved.         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          REVISION HISTORY                               *
 *-------------------------------------------------------------------------*
 *  Date    New Rev.                    Changes                            *
 *                                                                         *
 * 9/25/92  1.01     Added Support for Bcm38_SetChanParam & Bcm39_Wink     *
 *                   functions                                             *
 *                                                                         *
 * 10/1/92  1.02     Added Bcm61_Monitor2Port  for 2LS board               *
 *                                                                         *
 * 10/20/92 1.03     SDB added SilenceDebounce and the CDB added Silence   *
 *                   Threshold and SilenceDebounce over write.             *
 * 11/03/92 1.04     Channel Bridge Support                                *
 * 11/23/92 1.05     Group Monitor  Support                                *
 * 04/12/93 1.06     TCB modifications for GTD and enhanced CPM            *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#pragma pack(1)

#include "dos.h"


/*
   Define data types
 */

#define  BYTE   unsigned char
#define  WORD   unsigned short int
#define  DWORD  unsigned long int


/*
   BICOM driver function codes
 */

#define  F_SSTART        1        /* Start system                          */
#define  F_SSTOP         3        /* Stop system                           */
#define  F_CHSTOP        4        /* Stop channel                          */
#define  F_CHSTAT        5        /* Get channel status                    */
#define  F_SETH          6        /* Set channel on/off hook               */
#define  F_SETCST        7        /* Set EG mask                           */
#define  F_CLRDT         8        /* Clear DTMF buffer                     */
#define  F_GETDT         9        /* Get one DTMF digit                    */
#define  F_RECF          12       /* Record to file                        */
#define  F_PLAYF         13       /* Playback from file                    */
#define  F_DIAL          14       /* Dial string                           */
#define  F_GETDTS        15       /* Get DTMF string                       */
#define  F_GETEVT        16       /* Get next event occurred               */
#define  F_SCHED         18       /* Set time slice for driver             */
#define  F_XPLAYF        19       /* Extended play                         */
#define  F_GETCAR        27       /* Get CA Results                        */
#define  F_SXPARM        28       /* Set parameters in SCB                 */
#define  F_SCPARM        29       /* Set channel parameters in CPB         */
#define  F_CALL          30       /* Call a number using call analysis     */
#define  F_SETD          31       /* Set digit control mask                */
#define  F_GETVER        32       /* Get driver version                    */
#define  F_SICPARM       38       /* Set individual channel parameter      */
#define  F_WINK          39       /* Wink                                  */
#define  F_GETDTMF       50       /* Get next DTMF                         */
#define  F_SPEED         51       /* Change playback speed                 */
#define  F_LEVEL         52       /* Change playback level                 */
#define  F_GEN_BEEP      53       /* Generate beep                         */
#define  F_GEN_DTMF      54       /* Generate DTMF                         */
#define  F_MONITOR       56       /* Monitor channel                       */
#define  F_STOP_MON      57       /* Stop monitor channel                  */
#define  F_GEN_TELCO     58       /* Generate telco tone                   */
#define  F_STOP_TASK     60       /* Terminate a multitasking function     */
#define  F_DIRECT_PORT   61       /* Monitor the activity for 2LS          */
#define  F_MAKE_BRIDGE   62       /* Make Bridge                           */
#define  F_BREAK_BRIDGE  63
#define  F_ADD_BRIDGE_CH 64
#define  F_DEL_BRIDGE_CH 65
#define  F_GRP_MONITOR   66
#define  F_LOAD_DSP_TBL  67       /* Load Data to DSP for CPM and GTD      */
#define  MAXFCN          67       /* Max(last) BICOM function #.           */

/* 
* Data Definition Formats for the Load DSP Table command, F_LOAD_DSP_TBL
*/
#define  LD_CPM_TBL     0x00       /* Tone CPM Data                    */
#define  LD_GTD_TBL     0x01       /* Tone GTD Data                    */
#define  LD_QUAL_TBL    0x02       /* Tone Qualification Data          */


/*
 * Service function Device level services function codes
 */
#define  F_XSRV     0x70

#define  X_MINFCN   0x00       /* Min (first) IDDS function             */
#define  X_REGDRV   0x00       /* Register driver                       */
#define  X_SIZEQ    0x01       /* Get the memory requirements of a Q    */
#define  X_OPENQ    0x02       /* Request to open a Q                   */
#define  X_PUTQ     0x03       /* Enqueue a message                     */
#define  X_GETQ     0x04       /* Get a message off a Q                 */
#define  X_EMPTYQ   0x05       /* Empty a queue                         */
#define  X_FLUSHQ   0x06       /* Flush 1 entry from the queue          */
#define  X_SCANQ    0x07       /* Scan the queue for a value            */
#define  X_GETLVL   0x08       /* Get the hardware interrupt level      */
#define  X_PUTLVL   0x09       /* Store the hardware interrupt level    */
#define  X_INSINT   0x0A       /* Install drivers interrupt handler     */
#define  X_UININT   0x0B       /* De-install drivers h/w intr handler   */
#define  X_GETIV    0x0C       /* Get the interrupt vector              */
#define  X_PUTIV    0x0D       /* Install this interrupt vector         */
#define  X_GETMSG   0x0E       /* Get vector to the interrupt msg hdlr  */
#define  X_PUTMSG   0x0F       /* Install h/w interrupt msg handler     */
#define  X_PUT55    0x10       /* Install a 55ms timer                  */
#define  X_DIS55    0x11       /* Deinstall a 55ms timer                */
#define  X_ISDRV    0x12       /* Determine if a driver is installed    */
#define  X_SCHED    0x13       /* Call the scheduler                    */
#define  X_PAUSE    0x14       /* Wait for a real time interval         */
#define  X_UREG     0x15       /* Unregister a device                   */
#define  X_USREVT   0x17       /* Put urer event onto event queue       */
#define  X_BEEP     0x18       /* Beep the speaker on error condition   */
#define  X_MAXFCN   0x18       /* Max (last) IDDS function              */


/*
   Mode definitions for CSB
 */

#define  M_IDLE      0         /* Channel idle or stopped               */
#define  M_RECORD    1         /* Record task active                    */
#define  M_PLAY      2         /* Playback task active                  */
#define  M_GETDTMF   3         /* DTMF string task active               */
#define  M_OFFHOOK   4         /* Channel in transition to offhook      */
#define  M_DIAL      5         /* Dialing task active                   */
#define  M_ONHOOK    6         /* Channel in transition to onhook       */
#define  M_CALL      7         /* Channel in call analysis task         */
#define  M_DEFUPD    8         /* Channel parameter being updated       */
#define  M_WINK      9         /* Channel waiting for wink complete     */
#define  M_DNLD      10        /* Download task active                  */
#define  M_DNLD_TBL  11        /* Download Data to DSP                  */


/*
   Event definitions
 */

#define  T_NOTERM    0         /* No termination received               */
#define  T_MAXDT     1         /* Maximum DTMF digits received          */
#define  T_TERMDT    2         /* Terminating DTMF digit received       */
#define  T_STOP      3         /* Record/play/getdtmf stopped           */
#define  T_DOSERR    4         /* Dos error                             */
#define  T_MAXBYT    5         /* Max bytes reached on play or record   */
#define  T_HFAIL     6         /* Hardware failure                      */
#define  T_TIME      7         /* Record/play/getdtmf time out          */
#define  T_OFFH      8         /* Offhook complete                      */
#define  T_DIAL      9         /* Dialing complete                      */
#define  T_SIL       10        /* Maximum silence received              */
#define  T_EOF       11        /* End of file reached on playback       */
#define  T_LCTERM    12        /* Terminate by drop in loop current     */
#define  T_DFULL     13        /* Disk full                             */
#define  T_ONH       14        /* Onhook complete                       */
#define  T_CATERM    18        /* Call analysis termination             */
#define  T_LC        20        /* Loop signal drop                      */
#define  T_RING      21        /* Rings received                        */
#define  T_SILOFF    22        /* Silence off                           */
#define  T_SILON     23        /* Silence on                            */
#define  T_LCON      26        /* Loop signal on                        */
#define  T_MDTMF     29        /* Terminated by masked DTMF digit       */
#define  T_IDTIME    30        /* Interdigit delay occurred             */
#define  T_NSIL      31        /* Terminated by a max non-silence       */
#define  T_EMSERR    34        /* Terminated by EMS error               */
#define  T_EMSLOW    35        /* EMS buffer low                        */
#define  T_EMSHI     36        /* EMS buffer high                       */
#define  T_STPARM    37        /* parameter updated                     */
#define  T_WINK      38        /* wink protocol complete                */
#define  T_WKRECV    39        /* wink received                         */
#define  T_DTMF      40        /* DTMF digit received                   */
#define  T_TONEON    41        /* Tone On event                         */
#define  T_TONEOFF   42        /* Tone Off event                        */
#define  T_DEF_COMP  43        /* Definition Complete for DownLoad TBL  */
#define  T_MTONEON   44        /* Terminating Tone On event             */
#define  T_MTONEOFF  45        /* Terminating Tone Off event            */


#define  MAXTERM     45        /* Max(last) termination type            */


/*
   Command return (error) codes
 */

#define  E_OK            0       /* Function successful                   */
#define  E_SELF_TEST     1       /* Board self test failed                */
#define  E_NO_DTMF       2       /* DTMF buffer empty                     */
#define  E_SYS_ACT       3       /* System already active                 */
#define  E_SYS_INACT     4       /* System not active                     */
#define  E_BOARD         5       /* Hardware error                        */
#define  E_INV_CMD       6       /* Invalid function code                 */
#define  E_INV_INT       7       /* Invalid interrupt level               */
#define  E_INV_SCB       8       /* SCB parmameter error                  */
#define  E_INV_CHAN      9       /* Invalid channel number                */
#define  E_TASK_ACT      10      /* Tasking function already active       */
#define  E_TASK_INACT    11      /* Tasking function not active           */
#define  E_INV_DATA      12      /* Invalid parameter                     */
#define  E_INV_VER       13      /* Feature not supported in this version */
#define  E_NOT_IMP       14      /* Function not implemented/available    */
#define  E_NO_TERM       15      /* Terminating condition not specified   */
#define  E_NO_MEM        16      /* Insufficent buffer memory             */
#define  E_DOS_ERR       24      /* DOS error (DOS error code in AL)      */
#define  E_DISK          25      /* Error in data read/write to disk      */
#define  E_INV_VOX       31      /* Bad TCB value                         */
#define  E_NO_EMS        32      /* EMM not installed or corrupted        */
#define  E_EMS_ERR       33      /* EMM reported error                    */
#define  E_NO_BUF        34      /* No buffer allocated for EMS RAM disk  */
#define  E_NO_HANDLES    36      /* No Bridge Handles                     */
#define  E_INV_HANDLE    37      /* Invalid Bridge Handle                 */
#define  E_CH_IN_USE     38      /* Channel already in bridge             */
#define  E_BRIDGE_FULL   39      /* Bridge all Full                       */
                                                                        
                                                                        
/*                                                                      
   Telco Tone Frequency                                                 
 */                                                                     
                                                                        
#define  TN_DIALTONE   1                           
#define  TN_LINEBUSY   2                           
#define  TN_REORDER    3                           
#define  TN_RINGING    4                           


/*
   System modes  (Bcm1_StartSystem)
 */

#define  SM_POLL     0         /* Polled mode                           */
#define  SM_EVENT    1         /* Event driven mode                     */


/*
   Hook status  (Bcm6_SetHook)
 */

#define  H_OFFH      0         /* Off hook                              */
#define  H_ONH       1         /* On hook                               */


/*
   Call Status masks  (Bcm7_SetEGMask)
 */
#define  C_LC        0x01      /* Loop signal drop                      */
#define  C_RING      0x02      /* Rings received                        */
#define  C_SILOFF    0x04      /* Silence off                           */
#define  C_SILON     0x08      /* Silence on                            */
#define  C_OFFH      0x10      /* Offhook complete                      */
#define  C_ONH       0x20      /* Onhook complete                       */
#define  C_LCON      0x40      /* Loop signal on                        */
#define  C_WKRECV    0x80      /* Received incoming wink                */
#define  C_TONEON    0x100     /* Enable GTD Tone On Events             */
#define  C_TONEOFF   0x200     /* Enable GTD Tone Off Events            */


/*
   Digit control masks and method (Bcm31_SetDTMFControl)
 */

#define  D_DTMF      1         /* Enable DTMF digit detection           */
#define  DT_FLUSH    1         /* Flush DTMF digit buffer               */


/*
   Call progress return codes  (Bcm27_GetCAResults)
 */

#define  CP_BUSY       7       /* Called line is busy                   */
#define  CP_NO_ANSR    8       /* Called line did not answer            */
#define  CP_NO_RESP    9       /* Called line did not ring              */
#define  CP_CONNECT    10      /* Called line connected                 */
#define  CP_INTERCEPT  11      /* Called line intercepted by operator   */


/*
     Access mode for Bcm_OpenFile
 */
#define READ    0              /* Read mode                             */
#define RDWR    1              /* Read/write mode                       */
#define CREATE  2              /* Create mode                           */
#define APPEND  3              /* Append mode                           */


/*
     Method for Bcm_MoveFilePtr
 */
#define MP_BEG  0              /* Beginning of the file                 */
#define MP_CUR  1              /* Current position                      */
#define MP_END  2              /* End of file                           */


/*
   Miscellaneous
 */

#define  Q_STDREQ    0         /* Standard request queue handle         */
#define  Q_STDEVT    1         /* Standard event queue handle           */


/*
   For Dialogic IDDS
 */

#define  D_SUCC       0        /* Function was successful               */
#define  D_REGERR   113        /* driver registration error             */
#define  D_INVHND   114        /* Bad handle                            */
#define  D_INVDEV   115        /* Bad device type specified             */
#define  D_MAXQS    116        /* Maximum number of queues              */
#define  D_INVQT    117        /* Queue type error                      */
#define  D_QFULL    118        /* Queue full                            */
#define  D_QEMPTY   119        /* Queue empty                           */
#define  D_INVFCN   120        /* bad function                          */
#define  D_INVPAR   121        /* bad parmeter                          */
#define  D_VECUSD   122        /* vector already in use                 */
#define  D_NOTIMP   123        /* function not implemented              */


/* * * * * * * * * * * *
 *       BIT MAPS      *
 * * * * * * * * * * * */

/*
   CSB line status masks
 */
#define  LS_RNGBCK   0x04      /* Call analysis detecting ring          */
#define  LS_HOOK     0x08      /* Hook status bit                       */
#define  LS_RING     0x10      /* Incoming ring present bit             */
#define  LS_LOOP     0x20      /* Loop current bit                      */
#define  LS_DTMF     0x40      /* DTMF present bit                      */
#define  LS_SILENCE  0x80      /* Silence present bit                   */


/*
   Initiation bits for flag in TCB
 */
#define  IB_INIT     0x01      /* DTMF initiation                       */
#define  IB_TONE     0x02      /* Tone initiation                       */
#define  IB_DELY     0x04      /* Interdigit delay begins after 1st dig */


/*
   Normal and indexed play file mode masks  (Bcm19_PlayIndexedFile)
 */
#define  PB_NORM     0x00      /* Normal playback                       */
#define  PB_IDX      0x01      /* Indexed playback                      */
#define  PB_FILE     0x08      /* Multiple files for index playback     */


/*
   Record file mode masks  (Bcm12_RecordFile)
 */

#define  RD_NORM     0x00      /* Normal record                         */
#define  RD_SILCOMP  0x01      /* Compress silence from incoming data   */


/*
   DTMF digit termination masks
 */

#define  Dtmf_D      0x0001    /* Mask for DTMF d                       */
#define  Dtmf_1      0x0002    /* Mask for DTMF 1                       */
#define  Dtmf_2      0x0004    /* Mask for DTMF 2                       */
#define  Dtmf_3      0x0008    /* Mask for DTMF 3                       */
#define  Dtmf_4      0x0010    /* Mask for DTMF 4                       */
#define  Dtmf_5      0x0020    /* Mask for DTMF 5                       */
#define  Dtmf_6      0x0040    /* Mask for DTMF 6                       */
#define  Dtmf_7      0x0080    /* Mask for DTMF 7                       */
#define  Dtmf_8      0x0100    /* Mask for DTMF 8                       */
#define  Dtmf_9      0x0200    /* Mask for DTMF 9                       */
#define  Dtmf_0      0x0400    /* Mask for DTMF 0                       */
#define  Dtmf_S      0x0800    /* Mask for DTMF *                       */
#define  Dtmf_P      0x1000    /* Mask for DTMF #                       */
#define  Dtmf_A      0x2000    /* Mask for DTMF a                       */
#define  Dtmf_B      0x4000    /* Mask for DTMF b                       */
#define  Dtmf_C      0x8000    /* Mask for DTMF c                       */


/*
   User defined devices
 */
#define  U_DEV1      0x0F0     /* User defined device 1                 */
#define  U_DEV2      0x0F1     /* User defined device 2                 */
#define  U_DEV3      0x0F2     /* User defined device 3                 */
#define  U_DEV4      0x0F3     /* User defined device 4                 */
#define  U_DEV5      0x0F4     /* User defined device 5                 */
#define  U_DEV6      0x0F5     /* User defined device 6                 */
#define  U_DEV7      0x0F6     /* User defined device 7                 */
#define  U_DEVF      0x0F7     /* User defined device 8                 */
#define  U_DEV9      0x0F8     /* User defined device 9                 */
#define  U_DEV10     0x0F9     /* User defined device 10                */
#define  U_DEV11     0x0FA     /* User defined device 11                */
#define  U_DEV12     0x0FB     /* User defined device 12                */
#define  U_DEV13     0x0FC     /* User defined device 13                */
#define  U_DEV14     0x0FD     /* User defined device 14                */
#define  U_DEV15     0x0FE     /* User defined device 15                */
#define  U_DEV16     0x0FF     /* User defined device 16                */



/*
     Ŀ
       BICOM System Control Block  
     
 */

#define  SCB_SIZE    128 

typedef struct
{
   BYTE FlashChar;             /* Flash character in dialing string     */
   WORD FlashDuration;         /* Flash duration                        */
   WORD PauseTime;             /* Dialing pause time                    */
   WORD ScbRsv10;              /* Reserved                              */
   WORD ScbRsv11;              /* Reserved                              */
   WORD PulseBreak;            /* Pulse break interval                  */
   WORD PulseMake;             /* Pulse make interval                   */
   WORD PulseDelay;            /* Pulse dial interdigit delay           */
   WORD ToneDelay;             /* Tone dial interdigit delay            */
   WORD HookDelay;             /* Offhook delay interval                */
   WORD RingOn;                /* Amount of inbound ring signal         */
   WORD RingOff;               /* Amount of no-ring signal              */
   WORD RingEvtDelay;          /* Delay after ring counter reset        */
   WORD SilenceDebounce;
   WORD ScbRsv2;               /* Reserved                              */
   BYTE ToneLength;            /* Duration of DTMF digit                */
   BYTE ScbRsv3;               /* Reserved                              */
   BYTE ScbRsv4;               /* Reserved                              */
   WORD ScbRsv5;               /* Reserved                              */
   WORD LoopDropTime;          /* Min. duration of loop current off     */
   BYTE ScbRsv6[4];            /* Reserved                              */
   BYTE ScbRsv7;               /* Reserved                              */
   WORD ScbRsv8;               /* Reserved                              */
   BYTE ScbRsv9[SCB_SIZE-43];   
} SCB;



/*
     Ŀ
       BICOM Channel Parameter Block  
     
 */

#define  CPB_SIZE    128    

typedef struct
{
   BYTE DTMFDuration;          /* DTMF minimum detection time           */
   BYTE DTMFEdge;              /* DTMF edge selection                   */
   WORD CdbRsv1;               /* Reserved                              */
   WORD SilenceRemDly;         /* Silence compress delay in bytes ????? */
   BYTE NoAnswer;              /* # of rings before no answer returned  */
   WORD CPDelay;               /* Delay after dialing before analysis   */
   WORD AnsTimeout;            /* Timeout delay before no signal posted */
   WORD LoopConn;              /* Delay after dialing before LC drop    */
   WORD LoopWait;              /* Delay after LC drop before evt posted */
   BYTE VoxAnswer;             /* Edge of speech to send connect signal */
   WORD HangUpTime;            /* Timeout delay before hang-up posted   */
   BYTE CdbRsv2;               /* Reserved                              */
   BYTE CdbRsv3;               /* Reserved                              */
   BYTE CdbRsv4;               /* Reserved                              */
   BYTE CdbRsv5;               /* Reserved                              */
   BYTE CdbRsv6;               /* Reserved                              */
   BYTE CdbRsv7;               /* Reserved                              */
   WORD CdbRsv8;               /* Reserved                              */
   WORD CdbRsv9;               /* Reserved                              */
   WORD CdbRsv10;              /* Reserved                              */
   BYTE CdbRsv11;              /* Reserved                              */
   WORD CdbRsv12;              /* Reserved                              */
   WORD CdbRsv13;              /* Reserved                              */
   WORD CdbRsv14;              /* Reserved                              */
   WORD CdbRsv15;              /* Reserved                              */
   BYTE CdbRsv16;              /* Reserved                              */
   BYTE CdbRsv17;              /* Reserved                              */
   BYTE CdbRsv18[14];          /* Reserved                              */
   WORD CdbRsv19;              /* Reserved                              */
   WORD CdbRsv20;              /* Reserved                              */
   WORD CdbRsv21;              /* Reserved                              */
   WORD CdbRsv22;              /* Reserved                              */
   BYTE CdbRsv23;              /* Reserved                              */
   WORD CdbRsv24;              /* Reserved                              */
   WORD CdbRsv25;              /* Reserved                              */
   WORD CdbRsv26;              /* Reserved                              */
   WORD CdbRsv27;              /* Reserved                              */
   BYTE CdbRsv28;              /* Reserved                              */
   BYTE CdbRsv29;              /* Reserved                              */
   WORD MaxAnswer;             /* Maximum duration of speech for a call */
   WORD AnsrFilter;            /* Silence deglitching value for answer  */
   BYTE TalkDown;              /* Talkdown tone enable(=1)/disable(=2)  */ 
   BYTE DTMFFRX;               /* DTMF detection enable(=1)/disable(=2) */
   BYTE NumRings;              /* # of rings before ring event posted   */
   BYTE SilenceRem;            /* Silence comp. enable(=1)/disable(=2)  */
   BYTE DialLevel;             /* Timeout value for received dialtone   */
   WORD SilenceDebounce;
   BYTE SilenceThreshold;
   BYTE CdbRsv30[CPB_SIZE-70]; 
} CPB;



/*
     Ŀ
       BICOM Task Control Block  
     
 */

#define  TCB_SIZE    96

typedef struct 
{
   WORD FileHandle;            /* DOS file handle                       */
   WORD BufferOff;             /* Offset of transfer buffer             */
   WORD BufferSeg;             /* Segment of transfer buffer            */
   WORD XferSizeH;             /* High word max bytes to transfer       */
   WORD XferSizeL;             /* Low word max bytes to transfer        */
   WORD TimeOut;               /* Max seconds before timeout            */
   BYTE DTMF_Max;              /* Max # of DTMF digits to cause term.   */
   BYTE DTMF_Term;             /* DTMF digit to cause termination       */
   BYTE SilenceCnt;            /* Max seconds of silence to cause term. */
   BYTE LoopDrop;              /* Terminate if loop current drops       */
   WORD IndxTblOff;            /* Offset of index table                 */
   WORD IndxTblSeg;            /* Segment of index table                */
   BYTE Flag;                  /* Record/playback initiation bit        */
   BYTE ToneData;              /* Initiation tone duration              */
   BYTE RwbRsv1;               /* Reserved                              */
   WORD VoxOffsetL;            /* Low word of cursor position           */
   WORD VoxOffsetH;            /* High word of cursor position          */
   BYTE SetExtended;           /* Extended RWB flag                     */
   BYTE RwbRsv2[4];            /* Reserved                              */
   WORD RwbRsv3[3];            /* Reserved                              */
   WORD PreDTMF;               /* DTMF function initiator set           */
   WORD PostDTMF;              /* DTMF function terminator set          */
   BYTE InterDigTime;          /* Maximum interdigit delay in seconds   */
   BYTE MaxDialTone;           /* Max seconds of non-sil to cause term. */
//   WORD RwbRsv4;      //         /* Reserved                              */
   WORD TrmDigitCnt;           /* Terminating Digit Count               */
   WORD TrmDigitOff;           /* Terminating Digit Offset              */
   WORD TrmDigitSeg;           /* Terminating Digit Segment             */
   WORD TnOnCnt;               /* Tone On Count                         */
   WORD TnOnOff;               /* Tone On Offset                        */
   WORD TnOnSeg;               /* Tone On Segment                       */
   WORD TnOffCnt;              /* Tone Off Count                        */
   WORD TnOffOff;              /* Tone Off Count                        */
   WORD TnOffSeg;              /* Tone Off Count                        */
   BYTE RwbRsv4[32];           /* Reserved                              */
} TCB;



/*
     Ŀ
       BICOM Channel Status Block  
     
 */

#define  CSB_SIZE    32       

typedef struct
{
   WORD EGMask;                /* Call status transition mask           */
   BYTE ChanMode;              /* Current channel status                */
   BYTE Error;                 /* Set if buffer overrun detected        */
   BYTE Function;              /* Tasking function in progress          */
   WORD TermEvent;             /* Last termination event                */
   WORD BufCntH;               /* High word of data transfer            */
   WORD BufCntL;               /* Low word of data transfer             */
   BYTE DTMF_Cnt;              /* Number of DTMFs in channel's buffer   */
   WORD DOS_Error;             /* DOS error code                        */
   BYTE LineStatus;            /* Current line status                   */
   WORD CallStatus;            /* Call Analysis termination type        */
   WORD CsbRsv2;               /* Reserved                              */
   BYTE DTMFFlag;              /* Digit control mask                    */
   BYTE CsbRsv1[CSB_SIZE-20];  
} CSB;




/*
     Ŀ
       BICOM Event Block  
     
 */

typedef struct
{
   unsigned short int  DeviceType;   /* device type                     */
   unsigned short int  EventCode;    /* event code                      */
   unsigned short int  EventData;    /* event data                      */
   unsigned short int  Chan;         /* channel number                  */
   unsigned char  far *pData;        /* far pointer to the data         */
   unsigned short int  Board;        /* board number                    */
   unsigned short int  EdbRsv1;      /* reserved                        */
} EB;



/*
     Ŀ
       BICOM Tone Descriptor Block  
     
 */

typedef struct 
{                              
   unsigned int   Frequency;   /* tone frequency                        */
   unsigned char  Amplitude;   /* tone amplitude                        */
   unsigned int   Duration;    /* tone length                           */
   unsigned int   RepPeriod;   /* repeat period                         */
} TDB;



/*
     Ŀ
       BICOM Call Analysis Block  
     
 */

#define  CAR_SIZE    32     

typedef struct
{
   BYTE TermType;              /* Last call progress termination        */
   BYTE CarRsv1;               /* Reserved                              */
   WORD CarRsv2;               /* Reserved                              */
   WORD CarRsv3;               /* Reserved                              */
   WORD CarRsv4;               /* Reserved                              */
   WORD CarRsv5;               /* Reserved                              */
   WORD AnswerSize;            /* Duration of answer                    */
   BYTE AdvInfo;               /* 0: Default, 1: Dial tone, 2: Fax      */
   BYTE CarRsv6[CAR_SIZE-11]; 
} CAR;


struct BcmToneCfg	{
			unsigned char Type;
			unsigned char Event;
			unsigned int	Freq_1;
			unsigned int	Freq_2;
			unsigned char	Edge;

      unsigned int	On_Time_1;
			unsigned char	On_Dev_1;
			unsigned int	Off_Time_1;
			unsigned char	Off_Dev_1;

			unsigned int	On_Time_2;
			unsigned char	On_Dev_2;
			unsigned int	Off_Time_2;
			unsigned char	Off_Dev_2;

			unsigned char	RepCnt;
};

/*
 * MSDOS function defintions
 */
#define F_CREAT   0x3C               /* MSDOS create file        */
#define F_OPNF    0x3D               /* MSDOS open file          */
#define F_CLSF    0x3E               /* MSDOS close file handle  */
#define F_SEEK    0x42               /* MSDOS seek function code */


 
static int BCM_SystemStatus = 0;  /* BICOM system status
                                      = 1 : active   set by Bcm_1StartSystem
                                      = 0 : idle     set by Bcm_3StopSystem
                                   */
  
static int BCM_DosError = 0;      /* DOS error
                                        for Bcm_OpenFile,
                                            Bcm_CloseFile,
                                        or  Bcm_MoveFilePtr
                                   */

static int BCM_SoftwareInt = 0x6B;
                            /* BICOM standard software interrupt level
                                 S/W interrupt can be changed when loading
                                 the BICOM driver and by the application.
                                 User could use Bcm_GetSWIntVctr to find
                                 out the software interrupt level in the
                                 application.
                             */

/*
   Register structures 
 */
static union   REGS   ireg, oreg;
static struct  SREGS  sr;

struct SO {                       /* structures for pointers */
   unsigned short int off;
   unsigned short int seg;
   };

union LXXPTR {                    /* structure for d4get-off/seg */
   struct SO so;
   unsigned char far *lptr;
   };

static union   LXXPTR lp;


/*
     Storage for the register
 */
static unsigned char RegAL;
static unsigned int  RegBX;
static unsigned int  RegCX;
static unsigned int  RegDX;
static unsigned int  RegDS;

static unsigned char *pRegAL = &RegAL;
static unsigned int  *pRegBX = &RegBX;
static unsigned int  *pRegCX = &RegCX;
static unsigned int  *pRegDX = &RegDX;

static int           ReturnCode;



/* 
 * BICOM Library function prototypes
 */      

int BcmDrvCall(unsigned char,unsigned char *,unsigned int *,unsigned int *,unsigned int *);
int BcmDrvCallP(unsigned char,unsigned char *,unsigned int *,unsigned int *, unsigned char *);
int DosOpenFile(unsigned char *,unsigned int *,unsigned int);
int DosCloseFile(unsigned int);
int DosMoveFilePtr(unsigned int,unsigned int,unsigned int *,unsigned int *);
int DosCreateFile(unsigned char *,unsigned int *,unsigned int);

unsigned short int FindOffset(unsigned char *);
unsigned short int FindSegment(unsigned char *);

int   Bcm1_StartSystem(unsigned int,unsigned int,unsigned int,unsigned int,unsigned int *);
int   Bcm3_StopSystem(void);
int   Bcm4_StopChannel(unsigned int);
int   Bcm5_GetChanStatus(unsigned int,CSB *);
int   Bcm6_SetHook(unsigned int,unsigned int);
int   Bcm7_SetEGMask(unsigned int,unsigned int,unsigned int);
int   Bcm8_ClearDTMFQ(unsigned int);
int   Bcm9_GetDTMFDigit(unsigned int,unsigned char *);
int   Bcm12_RecordFile(unsigned int, TCB *,unsigned int);
int   Bcm13_PlayFile(unsigned int, TCB *);
int   Bcm14_DialOut(unsigned int,unsigned char *);
int   Bcm15_GetDTMFString(unsigned int, TCB *);
int   Bcm16_GetEvent(unsigned int *,unsigned int *,unsigned int *);
int   Bcm18_Scheduler(void);
int   Bcm19_PlayIndexedFile(unsigned int,unsigned int,TCB *);
int   Bcm27_GetCAResults(unsigned int,CAR *);
int   Bcm28_SetSystemParams(SCB *);
int   Bcm29_SetChanParams(unsigned int,CPB *);
int   Bcm30_CallProgress(unsigned int,unsigned char *);
int   Bcm31_SetDTMFControl(unsigned int,unsigned int,unsigned int);
int   Bcm32_GetDrvVersion(unsigned int *,unsigned int *);
int   Bcm38_SetChanParam(unsigned int,unsigned int,unsigned int);
int   Bcm39_Wink(unsigned int);

int   Bcm70_GetEventBlock(EB *);
int   Bcm70_PutEventInQ(unsigned int,unsigned int,unsigned int);
void  Bcm_ClearTCB(TCB *);
void  Bcm_ClearSCB(SCB *);
void  Bcm_ClearCPB(CPB *);
int   Bcm_DrvInstalled(unsigned char);
int   Bcm_OpenFile(unsigned char *,unsigned int);
int   Bcm_CloseFile(unsigned int);
long  Bcm_MoveFilePtr(unsigned int,unsigned long,unsigned int);
char *Bcm_ShowErrorMsg(unsigned int);
unsigned int Bcm_GetSWIntVector(void);

int   Bcm50_GetNextDTMF(unsigned int *, char *);
int   Bcm51_SetPlaySpeed(unsigned int, unsigned int);
int   Bcm52_SetPlayVolume(unsigned int, unsigned int);
int   Bcm53_GenerateBeep(unsigned int, TDB *);
int   Bcm54_GenerateDTMF(unsigned int, TDB *);
int   Bcm56_MonitorChan(unsigned int, unsigned int, unsigned int);
int   Bcm57_StopMonitorChan(unsigned int);
int   Bcm58_GenerateTELCO(unsigned int, TDB *);
int   Bcm60_StopTask(unsigned int);
int   Bcm61_DirectPort(unsigned int, unsigned int);
int   Bcm62_MakeBridge(unsigned int *, unsigned int);
int   Bcm63_BreakBridge(unsigned int);
int   Bcm64_AddBridgeChan(unsigned int, unsigned int);
int   Bcm65_DelBridgeChan(unsigned int, unsigned int);
int   Bcm67_LoadDspTable(unsigned int, unsigned int, char *);

