#ifndef _LINUX_SYS_H
#define _LINUX_SYS_H
/*
 * system call entry points
 */

/*
 * This should match with what is in sys_call.S
 */
#define NR_syscalls 141

#define sys_clone sys_fork

/*
 * These are system calls that will be removed at some time
 * due to newer versions existing..
 */
#ifdef notdef
#define sys_waitpid	sys_old_syscall	/* sys_wait4	*/
#define sys_olduname	sys_old_syscall /* sys_newuname	*/
#define sys_uname	sys_old_syscall /* sys_newuname	*/
#define sys_stat	sys_old_syscall /* sys_newstat	*/
#define sys_fstat	sys_old_syscall	/* sys_newfstat	*/
#define sys_lstat	sys_old_syscall /* sys_newlstat	*/
#define sys_signal	sys_old_syscall	/* sys_sigaction */
#define sys_sgetmask	sys_old_syscall /* sys_sigprocmask */
#define sys_ssetmask	sys_old_syscall /* sig_sigprocmask */
#endif

/*
 * These are system calls that haven't been implemented yet
 * but have an entry in the table for future expansion..
 */

#define sys_quotactl	sys_ni_syscall
#define sys_bdflush	sys_ni_syscall
#define sys_sysfs	sys_ni_syscall
#define sys_personality	sys_ni_syscall
#define sys_setfsuid	sys_ni_syscall
#define sys_setfsgid	sys_ni_syscall
#define sys_llseek	sys_ni_syscall

#endif
