/*
 *  linux/kernel/panic.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

/*
 * This function is used through-out the kernel (includeinh mm and fs)
 * to indicate a major problem.
 */
#include <stdarg.h>

#include <linux/kernel.h>
#include <linux/sched.h>

asmlinkage void sys_sync(void);	/* it's really int */
extern void unblank_screen(void);

NORET_TYPE void panic_at(const void * location)
{
	printk(KERN_EMERG "Kernel panic at: %p\n",location);
	if (current == task[0])
		printk(KERN_EMERG "In swapper task - not syncing\n");
	else
		sys_sync();
	unblank_screen();
	for(;;);
}
