*********************************************************************
* PROCEDURE Edithelp                           FoxPro for MS-DOS 2.6
* Locates the currently selected topic (SET TOPIC TO) in the helpfile
* that you specify and lets you edit the help text. If the topic
* doesn't exist in the help file, a browse window is shown and the
* name of the topic is displayed. If no topic is set only the browse
* window appears.
*
* Suggested usage: Attach to hot key with:
*        ON KEY LABEL ALT-H DO EDITHELP WITH "HELPFILE"
*********************************************************************
PROCEDURE EDITHELP
PARAMETER HELPFILE
cAlias=ALIAS()          && Save the current workarea, to restore later
SET HELP OFF            && Turn help off before opening the help file
SELECT 0                && Select an available work area
USE (helpfile)          && Open the helpfile

* Get the current help topic and search for it in the helpfile
cTopic = SET("TOPIC")
LOCATE FOR TOPIC = cTopic

IF !FOUND() OR EMPTY(cTopic)
   IF !EMPTY(cTopic)    && If the topic is not in the helpfile yet
      WAIT WINDOW NOWAIT "Current Topic: "+cTopic
   ENDIF

   * Browse the helpfile
   DEFINE WINDOW HELPTOPICS FROM 3,10 TO 20,70 ;
      SYSTEM COLOR SCHEME 10 SHADOW FLOAT MINIMIZE
   ACTIVATE WINDOW HELPTOPICS
   BROWSE FIELDS DETAILS, TOPIC
   RELEASE WINDOW HELPTOPICS
ELSE                    && Topic was found, edit the help text
   MODIFY MEMO details
ENDIF

USE                     && Close the help file
IF !EMPTY(cAlias)
   SELECT (cAlias)      && Restore the workarea
ENDIF

SET HELP ON
SET HELP TO (helpfile)  && Set help back on
RETURN
