Program HSCExample;

{ Little Example To Show The Use Of The Antares HSC Player }
{ Coded By Access/ADV - 05/94 }
{ Modified By Access/ADV - 06/94 }

{ Polling Version }

Uses Crt,ADVHSC;

{ The 3 Following Routine Were Extracted From The Antares GFX Tpu }
{ Coming Soon On Your Screen ... }

PROCEDURE VerticalRetrace; Assembler;
ASM
        mov dx,$3da
@1:     in al,dx
        test al,8
        jz @1
@2:     in al,dx
        test al,8
        jnz @2
END;

PROCEDURE Wait4Line;Assembler;
ASM
        mov dx,$3da
@1:     in al,dx
        test al,1
        jnz @1
@2:     in al,dx
        test al,1
        jz @2
END;

PROCEDURE SetColor(Nr,R,G,B:Byte);Assembler;
Asm
  mov  dx, 3C8h   {Color port}
  mov  al, Nr  {number of color to change}
  out  dx, al
  inc  dx         {inc dx to write}
  mov  al, r      {red value}
  out  dx, al
  mov  al, g      {green}
  out  dx, al
  mov  al, b      {blue}
  out  dx, al
END;

Var i,CountAdd:Byte;
    j,Count:Word;

Begin
LOADSONG('MUSIC.HSC');  { Loading the Song Into Memory }

SetMode(1,1); { Turn Polling Mode On And Tell HSC To Call The Old Interrupt }
PLAYSONG; { Play The Song }

Count:=0; { InitiaLiZe Raster Variable }
CountAdd:=1;
Repeat

if Count=200 then CountAdd:=0; { Sum Test For The Raster }
if Count=0 then CountAdd:=1;
if CountAdd=0 then Dec(Count) Else Inc(Count);

VerticalRetrace; { Wait For Video Vertical Retrace }

Asm
   Cli  { Turn Off All Interrupt - Used To Avoid A Interruption During
          The Raster Process }
End;

For j:=1 to Count Do Wait4Line; { Wait The Line Number J }
For i:=0 to 63 Do { Do The FadeIn Raster }
Begin
     Wait4Line;
     SetColor(0,i,i,i);
End;
For i:=63 Downto 0 do { Do The FadeOut Raster }
Begin
     Wait4Line;
     SetColor(0,i,i,i);
End;

Asm
   Sti  { Turn Interrupt On Again }
End;

POLLMUSIC;  { Call The Player To Do Some Music }
            { Must Be Called At Least 18x By Second }
Until KeyPressed;

STOPSONG; { Stop The Player }
CLEARMEM; { Free Memory }
End.