.386p
code32	segment para public use32
	assume cs:code32, ds:code32

_filebufloc	dd	0		; location must be in low mem
_filebuflen	dw	4000h

public	_filebufloc, _filebuflen
public	_closefile,_createfile,_createhiddenfile,_openfile,_deletefile,_lseekfile
public	_filesize,_readfile,_writefile,_filecopy,_findfile,_renfile

extrn	v86r_eax:dword, v86r_ebx:dword, v86r_ecx:dword, v86r_edx:dword
extrn	v86r_esi:dword, v86r_edi:dword, v86r_ebp:dword
extrn	v86r_ah:byte, v86r_al:byte, v86r_bh:byte, v86r_bl:byte
extrn	v86r_ch:byte, v86r_cl:byte, v86r_dh:byte, v86r_dl:byte
extrn	v86r_ax:word, v86r_bx:word, v86r_cx:word, v86r_dx:word
extrn	v86r_si:word, v86r_di:word, v86r_bp:word
extrn	v86r_ds:word, v86r_es:word, v86r_fs:word, v86r_gs:word
extrn	_selcode:word, _seldata:word, _selzero:word, _lomembase:dword
extrn	_lomemtop:dword, _himembase:dword, _himemtop:dword, _pspa:dword
extrn	_code16a:dword, _code32a:dword, _getirqvect:dword, _setirqvect:dword
extrn	_sysbyte0:byte, _irqmode:word

;
; Create file
; In:
;   EDX -> ASCIIZ filename
; Out:
;   CF=1 - Error creating file
;   CF=0 - File created succesfully
;     V86R_BX - file handle
;
_createfile:
	push ax
	push edx
	add edx,_code32a
	mov ax,dx
	shr edx,4
	and ax,0fh
	mov v86r_dx,ax
	mov v86r_ds,dx
	mov v86r_ax,3c00h
	mov v86r_cx,20h
	mov al,21h
	int 33h
	mov ax,v86r_ax
	mov v86r_bx,ax
	pop edx
	pop ax
	ret

;
; Create hidden file
; In:
;   EDX -> ASCIIZ filename
; Out:
;   CF=1 - Error creating file
;   CF=0 - File created succesfully
;     V86R_BX - file handle
;
_createhiddenfile:
	push ax
	push edx
	add edx,_code32a
	mov ax,dx
	shr edx,4
	and ax,0fh
	mov v86r_dx,ax
	mov v86r_ds,dx
	mov v86r_ax,3c00h
	mov v86r_cx,02h
	mov al,21h
	int 33h
	mov ax,v86r_ax
	mov v86r_bx,ax
	pop edx
	pop ax
	ret

;
; Open file
; In:
;   EDX -> ASCIIZ filename
; Out:
;   CF=1 - Error opening file
;   CF=0 - File opened succesfully
;     V86R_BX - file handle
;
_openfile:
	push ax
	push edx
	add edx,_code32a
	mov ax,dx
	shr edx,4
	and ax,0fh
	mov v86r_dx,ax
	mov v86r_ds,dx
	mov v86r_ax,3d02h
	mov al,21h
	int 33h
	mov ax,v86r_ax
	mov v86r_bx,ax
	pop edx
	pop ax
	ret

;
; Close a file
; In:
;   V86R_BX - file handle
;
_closefile:
	push ax
	mov v86r_ax,3e00h
	mov al,21h
	int 33h
	pop ax
	ret

;
; Delete a file
; In:
;   EDX -> ASCIIZ filename
; Out:
;   CF=1 - Error opening file
;   CF=0 - File opened succesfully
;
_deletefile:
	push ax
	push edx
	add edx,_code32a
	mov ax,dx
	shr edx,4
	and ax,0fh
	mov v86r_dx,ax
	mov v86r_ds,dx
	mov v86r_ah,41h
	mov al,21h
	int 33h
	pop edx
	pop ax
	ret

;
; Seek position in file
; In:
;   V86R_BX - file handle
;   EAX - signed offset to move to
;   BL - from: 0-beginning of file, 1-current location, 2-end of file
; Out:
;   CF=1  - Error seeking in file
;     EAX - ?
;   CF=0  - Seek fine
;     EAX - new offset from beginning of file
;
_lseekfile:
	mov v86r_ah,42h
	mov v86r_al,bl
	mov v86r_dx,ax
	shr eax,16
	mov v86r_cx,ax
	mov al,21h
	int 33h
	pushf
	mov ax,v86r_dx
	shl eax,16
	mov ax,v86r_ax
	popf
	ret

;
; Get size of file
; In:
;   V86R_BX - file handle
; Out:
;   CF=1  - Error checking file
;     EAX - ?
;   CF=0  - chek fine
;     EAX - size of file
;
_filesize:
	mov v86r_ax,4201h
	xor eax,eax
	mov v86r_cx,ax
	mov v86r_dx,ax
	mov al,21h
	int 33h
	push v86r_dx
	push v86r_ax
	mov v86r_ax,4202h
	xor eax,eax
	mov v86r_cx,ax
	mov v86r_dx,ax
	mov al,21h
	int 33h
	mov ax,v86r_dx
	shl eax,16
	mov ax,v86r_ax
	pop v86r_dx
	pop v86r_cx
	mov v86r_ax,4200h
	push eax
	mov al,21h
	int 33h
	pop eax
	ret

;
; Read from file
; In:
;   V86R_BX - file handle
;   EDX -> buffer to read to
;   ECX - number of bytes to read
; Out:
;   CF=1 - Error reading file
;     EAX - ?
;   CF=0 - Read went fine
;     EAX - number of bytes read
;
_readfile:
	pushad
	xor ebp,ebp
	add edx,_code32a
	lea ebx,[ecx+edx]
	cmp ebx,100000h
	ja readlong
	mov eax,edx
	shr eax,4
	and dx,0fh
	mov v86r_ds,ax
	mov v86r_dx,dx
readl:
	mov eax,0fff0h
	cmp eax,ecx
	jbe readlf1
	mov eax,ecx
readlf1:
	mov v86r_cx,ax
	mov v86r_ax,3f00h
	mov al,21h
	int 33h
	jc readdone2
	movzx ebx,v86r_ax
	add ebp,ebx
	sub ecx,ebx
	jbe readdone
	or ebx,ebx
	jz readdone
	add v86r_ds,0fffh
	jmp readl
readlong:
	mov edi,edx
	sub edi,_code32a
	mov edx,ecx
	mov eax,_filebufloc
	add eax,_code32a
	mov ebx,eax
	shr eax,4
	and bx,0fh
	mov v86r_ds,ax
	mov v86r_dx,bx
	movzx ebx,_filebuflen
readlongl:
	mov eax,ebx
	cmp eax,edx
	jbe readlonglf1
	mov eax,edx
readlonglf1:
	mov v86r_cx,ax
	mov v86r_ax,3f00h
	mov al,21h
	int 33h
	jc short readdone2
	movzx ecx,v86r_ax
	add ebp,ecx
	mov eax,ecx
	or eax,eax
	jz readdone
	mov esi,_filebufloc
	rep movsb
	sub edx,eax
	ja readlongl
readdone:
	clc
readdone2:
	mov [esp+28],ebp
	popad
	ret

;
; Write to file
; In:
;   V86R_BX - file handle
;   EDX -> buffer to write from
;   ECX - number of bytes to write
; Out:
;   CF=1 - Error writing file
;     EAX - ?
;   CF=0 - Write went fine
;     EAX - number of bytes written
;
_writefile:
	pushad
	xor ebp,ebp
	add edx,_code32a
	lea ebx,[ecx+edx]
	cmp ebx,100000h
	ja writelong
	mov eax,edx
	shr edx,4
	and ax,0fh
	mov v86r_ds,dx
	mov v86r_dx,ax
writel:
	mov eax,0fff0h
	cmp eax,ecx
	jbe writelf1
	mov eax,ecx
writelf1:
	mov v86r_cx,ax
	mov v86r_ax,4000h
	mov al,21h
	int 33h
	jc writedone2
	movzx ebx,v86r_ax
	cmp v86r_cx,bx
	jnz writedone3
	add ebp,ebx
	sub ecx,ebx
	jbe writedone
	add v86r_ds,0fffh
	jmp writel
writelong:
	mov esi,edx
	sub esi,_code32a
	mov edx,ecx
	mov eax,_filebufloc
	add eax,_code32a
	mov ebx,eax
	shr eax,4
	and bx,0fh
	mov v86r_ds,ax
	mov v86r_dx,bx
	movzx ebx,_filebuflen
writelongl:
	mov eax,ebx
	cmp eax,edx
	jbe writelonglf1
	mov eax,edx
writelonglf1:
	mov ecx,eax
	mov edi,_filebufloc
	rep movsb
	mov v86r_cx,ax
	mov v86r_ax,4000h
	mov al,21h
	int 33h
	jc writedone2
	movzx ecx,v86r_ax
	cmp v86r_cx,cx
	jnz writedone3
	add ebp,ecx
	sub edx,ecx
	ja writelongl
writedone:
	clc
writedone2:
	mov [esp+28],ebp
	popad
	ret
writedone3:
	stc
	jmp writedone2

;
; Copy some bytes from one file to another
; In:
;   V86R_SI - source file handle
;   V86R_DI - destination file handle
;   ECX - number of bytes to copy
; Out:
;   CF=1  - Error copying file
;     EAX - ?
;   CF=0  - copied fine
;     EAX - number of bytes copied
;
_filecopy:
	pushad
	xor ebp,ebp
	mov edx,_filebufloc
	add edx,_code32a
	mov al,dl
	and ax,0fh
	shr edx,4
	mov v86r_ds,dx
	mov v86r_dx,ax
	movzx ebx,_filebuflen
copylongl:
	mov eax,ebx
	cmp eax,ecx
	jbe copylonglf1
	mov eax,ecx
copylonglf1:
	mov v86r_cx,ax
	mov v86r_ax,3f00h
	mov ax,v86r_si
	mov v86r_bx,ax
	mov al,21h
	int 33h
	jc copydone2
	mov ax,v86r_ax
	or ax,ax
	jz copydone
	mov v86r_cx,ax
	mov v86r_ax,4000h
	mov ax,v86r_di
	mov v86r_bx,ax
	mov al,21h
	int 33h
	jc copydone2
	movzx edx,v86r_ax
	add ebp,edx
	sub ecx,edx
	ja copylongl
copydone:
	clc
copydone2:
	mov [esp+28],ebp
	popad
	ret


;
; Do an AH=4E findfirst
; In:
;   AL - type of search: 4E-first, 4F-next
;   CX - search attributes
;   EDX -> 13 byte buffer for filename found
;   EDI -> search mask
; Out:
;   CX	 - Attribute of file
;   CF=1 - file not found
;     [EDX] - ?
;   CF=0 - file found
;     [EDX] - filename
;
_findfile:
	push eax
	push esi
	push edi
	add edi,_code32a
	mov esi,edi
	and esi,0fh
	shr edi,4
	mov v86r_ds,di
	mov v86r_dx,si
	mov v86r_ah,al
	mov v86r_cx,cx
	mov esi,_code16a
	sub esi,62h
	mov edi,edx
	mov al,21h
	int 33h
	mov ecx,_pspa
	movzx cx,byte ptr gs:[ecx+149]
	mov ax,gs
	mov ds,ax
	movsd
	movsd
	movsd
	movsb
	mov ax,es
	mov ds,ax
	pop edi
	pop esi
	pop eax
	ret
;
; Rename a file
; In:
;   EDX -> Old FileName  (asciiz)
;   EDI -> New FileName  (asciiz)
; Out:
;   CF=1 - Error
;    EAX - ErrorCode
;
_renfile:
	push edx
	push edi
	push esi
	add edi,_code32a
	mov esi,edi
	and esi,0fh
	shr edi,4
	mov v86r_es,di
	mov v86r_di,si
	mov edi,edx
	add edi,_code32a
	mov esi,edi
	and esi,0fh
	shr edi,4
	mov v86r_ds,di
	mov v86r_dx,si
	mov v86r_ah,56h
	mov al,21h
	int 33h
	pop esi
	pop edi
	pop edx
	movzx eax,v86r_ax
	ret

ends
end

