;--------------------------------------------------------------------------
;--------------------------------------------------------------------------
;--------------------------------------------------------------------------
;--------------------------------------------------------------------------
;
;  DOS32 V2.4  routines for using V2.4 code with DOS32 v3.0.
;
;
;--------------------------------------------------------------------------
;--------------------------------------------------------------------------
;--------------------------------------------------------------------------
.386
.model flat, pascal
.stack 8000h
.code

IFDEF masm                                         ; Allow MASM assembly
global  EQU  externdef
ENDIF

INCLUDE     V24.INC                          ; Define all publics and externs

;GetIRQVector    PROC Uses EAX EBX
;                and     bl,0fh
;                cmp     bl,8
;                jb  J2
;                add     bl,60h
;J2:             add     bl,8h
;                mov     ax,204h
;                int     31h
;                ret
;GetIRQVector    ENDP
;
;SetIRQVector    PROC Uses EAX EBX
;                and     bl,0fh
;                cmp     bl,8
;                jb  J1
;                add     bl,60h
;J1:             add     bl,8h
;                mov     ax,205h
;                int     31h
;                ret
;SetIRQVector    ENDP
;
;GetIntVector    PROC Uses EAX
;                mov     ax,204h
;                int     31h
;                ret
;GetIntVector    ENDP
;
;SetIntVector    PROC Uses EAX
;                mov     ax,205h
;                int     31h
;                ret
;SetIntVector    ENDP

AllocDMAregion PROC Uses EAX
                mov     ax,0EE41h
                int     31h
                ret
AllocDMAregion ENDP

Allocate_Memory PROC
                mov     ax,0EE42h
                int     31h
                ret
Allocate_Memory ENDP

align 4
CODE32_sel              DW  ?           ; Selector
DATA32_sel              DW  ?       	; Selector
Zero_sel                DW  ?          	; Selector
PIC1_Base               DB  8           ; IRQ 0..7
PIC2_Base               DB  70h         ; IRQ 0..7
Environment_segment     DW  ?           ; real mode segment
Environment_addr        DD  ?      	; 32bit offset
PSP_segment             DW  ?           ; real mode segment
PSP_addr                DD  ?           ; 32bit offset
_0b8000h                DD  0b8000h     ; 32bit offset
_0a0000h                DD  0a0000h     ; 32bit offset
CODE32_addr             DD  ?          	; 32bit offset
Zero_Addr               DD  ?          	; 32bit offset




_the_start:

        mov     ax,0EE00h
        int     31h
        mov     Zero_sel,bx
        mov     CODE32_sel,cs
        mov     DATA32_sel,ds

        mov     ax,0EE02h
        int     31h

        mov     CODE32_addr,ebx
        neg     ebx
        mov     Zero_Addr,ebx
        add     _0a0000h,ebx
        add     _0b8000h,ebx

        mov     PSP_addr, esi
        sub     esi,ebx
        shr     esi,4
        mov     PSP_segment,si

        mov	Environment_addr, edi
        sub     edi,ebx
        shr     edi,4
        mov     Environment_segment,di

        jmp Start32


END _the_start
