#ifdef __BORLANDC__
#define _inp inp
#define _unlink unlink
#endif

#define IDM_START       100
#define IDM_OPENFILE    200
#define IDM_READLINE    300
#define IDM_WAIT        400
#define IDM_SEND        500
#define IDM_QUIT        600
#define IDM_DELAY       700
#define IDM_EXPAND      800
#define IDM_ONERR       900
#define IDM_GOTO       1000
#define IDM_MSGBOX     1100
#define IDM_REOPEN     1200
#define IDM_WHILE      1300
#define IDM_EXIST      1400
#define IDM_ONMSG      1500

#define GOODCMD         1
#define PARMS           -1
#define SYNTAX          -2
#define BADESC          -3
#define BADSPEC         -4

#define KSHIFT         0x100
#define KCONTROL       0x200
#define KALT           0x400
#define KSPECIAL       0x8000

#define NARG0          1
#define NARG1          2
#define NARG2          4
#define NARG3          8

#define SEP            0xff
#define KTAB           0xfe
#define DNAR           0xfd
#define UPAR           0xfc
#define LFAR           0xfb
#define RTAR           0xfa
#define SIWC           0xf9
#define MUWC           0xf8
#define F0             0xf7
#define F1             0xf6
#define F2             0xf5
#define F3             0xf4
#define F4             0xf3
#define F5             0xf2
#define F6             0xf1
#define F7             0xf0
#define F8             0xef
#define F9             0xee
#define F10            0xed
#define F11            0xec
#define F12            0xeb

typedef struct cmd {
    int function;
    char *cmdstring;
    WORD *attrbuf;
    struct cmd *next;
} CMD;

typedef struct label {
    CMD *line;
    char *labeltext;
    struct label *next;
} LABEL;


int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
BOOL InitApplication(HANDLE);
BOOL InitInstance(HANDLE, int);
HANDLE OpenScriptFile(char *);
BOOL ReadBlock(HANDLE, unsigned char *, DWORD *);
BOOL FileProc(HANDLE);
void FreeCMD(CMD *);
void FreeLabel(LABEL *);
long FAR PASCAL MainWndProc(HWND, UINT, WPARAM, LPARAM);

