TITLE VT52 Terminal Emulator

DEFINE LOWER 0
DEFINE CTLPR 1
DEFINE CTLDSCTL 2
DEFINE SHIFTPR 3
DEFINE SHIFTDSUPPER 4
DEFINE CAPS 5
DEFINE NEXTNOSHIFT 6
DEFINE CAPSWITHSHIFT 7
DEFINE CAPSCTLDSCTL 8
DEFINE CAPSCTLPR 9

DEFINE col 22GETLAM
DEFINE colSTO 22PUTLAM
DEFINE row 21GETLAM
DEFINE rowSTO 21PUTLAM
DEFINE cur 20GETLAM
DEFINE curSTO 20PUTLAM
DEFINE spc 19GETLAM
DEFINE spcSTO 19PUTLAM
DEFINE chr 18GETLAM
DEFINE chrSTO 18PUTLAM
DEFINE upper 17GETLAM
DEFINE upperSTO 17PUTLAM
DEFINE lower 16GETLAM
DEFINE lowerSTO 16PUTLAM
DEFINE ctl 15GETLAM
DEFINE ctlSTO 15PUTLAM
DEFINE es 14GETLAM
DEFINE esSTO 14PUTLAM
DEFINE bs 13GETLAM
DEFINE bsSTO 13PUTLAM
DEFINE lr 12GETLAM
DEFINE lrSTO 12PUTLAM
DEFINE lc 11GETLAM
DEFINE lcSTO 11PUTLAM
DEFINE wi 10GETLAM
DEFINE wiSTO 10PUTLAM
DEFINE hi 9GETLAM
DEFINE hiSTO 9PUTLAM
DEFINE csize 8GETLAM
DEFINE csizeSTO 8PUTLAM
DEFINE ch 7GETLAM
DEFINE chSTO 7PUTLAM
DEFINE cw 6GETLAM
DEFINE cwSTO 6PUTLAM
DEFINE state 5GETLAM
DEFINE stateSTO 5PUTLAM
DEFINE key 4GETLAM
DEFINE keySTO 4PUTLAM
DEFINE room 3GETLAM
DEFINE roomSTO 3PUTLAM
DEFINE exit? 2GETLAM
DEFINE exit?STO 2PUTLAM
DEFINE special 1GETLAM
DEFINE specialSTO 1PUTLAM

DEFINE UNDISPCUR col row chr XYGROBDISP
DEFINE WAITFORIO BEGIN UARTBUFLEN DROP #0<> UNTIL

DEFINE	xFNTSTR		$ "FNT"
DEFINE	xFNT		ROMPTR 101 0
DEFINE	Font		ROMPTR 101 1
DEFINE	Font?		ROMPTR 101 2
DEFINE	FNT1		ROMPTR 101 3
DEFINE	FNT2		ROMPTR 101 4

DEFINE	UFLErr		#6A6A1

xROMID 1702
xTITLE VT52  :2.3 (UFL)
xCONFIG VT52CFG
xMESSAGE VT52MSG

EXTERNAL xVT52

STITLE VT52CFG
LABEL VT52CFG
::
 1702 TOSRRP
;

STITLE VT52MSG
LABEL VT52MSG
ARRY 2E C2A201000010000F10005564C402E6F6470264F657E646

STITLE xVT52
xNAME VT52
::
 CK0
 OpenIOPrt
 CkFnt
 CLRDISP 
 ZEROZERO ( col row )
 NULL$ ( cur )
 DUPDUP ( spc chr )
 $ "ABCDEFGHIJKLMNOPQRSTUVWX\\rYZ\\7F\\08\\1B{<([.$%^&.,~`'.=?_|"
 $ "abcdefghijklmnopqrstuvwx\\ryz\\7F\\08\\1B789/.456*.123-.0. +"
 $ "\\01\\02\\03\\04\\05\\06\\07\\08\\t\\n\\0B\\0C\\r\\0E\\0F\\10\\11\\12\\13\\14\\15\\16\\17\\18\\r\\19\\1A\\7F\\08\\\\}>)].\\1C\\1D\\1E\\1F.;@#"".\\00!\\t:"
 ZEROZERO ( es bs )
 ZEROZERO ( lr lc )
 ZEROZERO ( wi hi )
 1 ( csize )
 6 ( ch )
 4 ( cw )
 LOWER ( state )
 ZEROZERO ( key room )
 FalseFalse ( exit? special )
 ' NULLLAM 22 NDUPN DOBIND
 $ "\\7F" $>grob curSTO
 SPACE$ $>grob DUP
 spcSTO chrSTO
 ch #1- hiSTO
 cw #1- wiSTO
 XHI cw #- #1+ lcSTO
 YHI ch #/ ch #* bsSTO DROP
 bs #1- esSTO
 bs ch #- lrSTO
 ZEROZERO cur XYGROBDISP
 BEGIN
    ATTN? 
    ITE
       :: ATTNFLGCLR TRUE exit?STO ;
       :: GETTOUCH IT HANDLEKEY ;
    HANDLEIO
    exit?
 UNTIL
 ABND
 CLOSEUART
 ClrDAsOK
; 

STITLE CkFnt
NULLNAME CkFnt
::
 xFNTSTR
 palparse
 DROP
 '
 xFNT
 EQUALNOTcase
 ::
   UFLErr
   ERROROUT
 ;
 FNT1
 DROP
;

STITLE CLRDISP
NULLNAME CLRDISP
::
 RECLAIMDISP ClrDA1IsStat TURNMENUOFF
;

STITLE QUIT
NULLNAME QUIT
::
 TRUE exit?STO LOWER
;

STITLE SENDCHAR
NULLNAME SENDCHAR
::
 #>CHR CHR>$ xXMIT DROP
;

STITLE SENDSTR
NULLNAME SENDSTR
::
 key
 YHI #/ DROPDUP SUB$
 xXMIT DROP
;

STITLE SENDCTL
NULLNAME SENDCTL
::
 ctl SENDSTR
;

STITLE SENDUPPER
NULLNAME SENDUPPER
::
 upper SENDSTR
;

STITLE SENDLOWER
NULLNAME SENDLOWER
::
 lower SENDSTR
;

STITLE DOLOWER
NULLNAME DOLOWER
::
  key
  ::
    128 #=casedrop :: 27 SENDCHAR LOWER ;
    YHI #=casedrop SHIFTPR
    192 #=casedrop CTLPR
    DROP SENDLOWER LOWER
  ;
;

STITLE DOCAPSCTLDSCTL
NULLNAME DOCAPSCTLDSCTL
::
  key
  ::
    128 #=casedrop :: 92 SENDCHAR CAPSCTLDSCTL ;
    YHI #=casedrop QUIT
    192 #=casedrop CAPSCTLPR
    YHI #<case :: SENDUPPER CAPS ;
        SENDCTL CAPSCTLDSCTL
  ;
;

STITLE DOCTLPR
NULLNAME DOCTLPR
::
  key
  ::
    128 #=casedrop :: 92 SENDCHAR CTLDSCTL ;
    YHI #=casedrop QUIT
    192 #=casedrop :: DOSBRK LOWER ;
    YHI #<ITE LOWER CTLDSCTL SENDCTL
  ;
;

STITLE DOCTLDSCTL
NULLNAME DOCTLDSCTL
::
  key
  ::
    128 #=casedrop :: 92 SENDCHAR CTLDSCTL ;
    YHI #=casedrop QUIT
    192 #=casedrop CTLPR
    YHI #<ITE :: SENDLOWER LOWER ;
              :: SENDCTL CTLDSCTL ;
  ;
;

STITLE DOSHIFTPR
NULLNAME DOSHIFTPR
::
  key
  ::
    128 #=casedrop :: DoBadKey SHIFTPR ;
    192 #=casedrop :: DoBadKey SHIFTPR ;
    YHI #=casedrop CAPS
    YHI #<ITE LOWER SHIFTDSUPPER SENDUPPER
  ;
;

STITLE DOCAPS
NULLNAME DOCAPS
::
  key
  ::
    128 #=casedrop :: 27 SENDCHAR CAPS ;
    192 #=casedrop CAPSCTLPR
    YHI #=casedrop NEXTNOSHIFT
    DROP SENDUPPER CAPS
  ;
;

STITLE DOSHIFTDSUPPER
NULLNAME DOSHIFTDSUPPER
::
  key
  ::
    YHI #=casedrop SHIFTPR
    128 #=casedrop :: DoBadKey SHIFTDSUPPER ;
    192 #=casedrop CTLPR
    YHI #<case :: SENDLOWER LOWER ;
        SENDUPPER SHIFTDSUPPER
  ;
;

STITLE DONEXTNOSHIFT
NULLNAME DONEXTNOSHIFT
::
  key
  ::
    YHI #=casedrop LOWER
    128 #=casedrop :: 27 SENDCHAR NEXTNOSHIFT ;
    192 #=casedrop :: DoBadKey NEXTNOSHIFT ;
    YHI #<ITE CAPS CAPSWITHSHIFT SENDLOWER
  ;
;

STITLE DOCAPSWITHSHIFT
NULLNAME DOCAPSWITHSHIFT
::
  key
  ::
    128 #=casedrop :: 27 SENDCHAR CAPSWITHSHIFT ;
    192 #=casedrop :: DoBadKey CAPSWITHSHIFT ;
    YHI #=casedrop NEXTNOSHIFT
    YHI #<case :: SENDUPPER CAPS ;
        SENDLOWER CAPSWITHSHIFT
  ;
;

STITLE DOCAPSCTLPR
NULLNAME DOCAPSCTLPR
::
  key
  ::
    128 #=casedrop :: 92 SENDCHAR CAPSCTLDSCTL ;
    YHI #=casedrop QUIT
    192 #=casedrop :: DOSBRK CAPS ;
    YHI #<ITE CAPS CAPSCTLDSCTL SENDCTL
  ;
;

STITLE HANDLEKEY
NULLNAME HANDLEKEY
::
  keySTO
  state
  ::
    LOWER #=casedrop DOLOWER
    CTLPR #=casedrop DOCTLPR
    CTLDSCTL #=casedrop DOCTLDSCTL
    SHIFTPR #=casedrop DOSHIFTPR
    SHIFTDSUPPER #=casedrop DOSHIFTDSUPPER
    CAPS #=casedrop DOCAPS
    NEXTNOSHIFT #=casedrop DONEXTNOSHIFT
    CAPSWITHSHIFT #=casedrop DOCAPSWITHSHIFT
    CAPSCTLDSCTL #=casedrop DOCAPSCTLDSCTL
    CAPSCTLPR #=casedrop DOCAPSCTLPR
  ;
  stateSTO
;

*STITLE $TOGROB
*NULLNAME $TOGROB
*::
*  csize
*  :: ONE #=casedrop $>grob
*     TWO #=casedrop $>GROB
*     DROP $>BIGGROB
*  ;
*;

STITLE HANDLEIO
NULLNAME HANDLEIO
::
  UARTBUFLEN DROP
  #0<>
  NOT?SEMI
  XHI col #-
  cw #/
  roomSTO
  DROPNULL$
  BEGIN
    %1 DOSRECV DROPDUP
    ONE SUB$1#
    DUP 31 #> SWAP 127 #<
    ANDITE &$
           :: TRUE specialSTO SWAP ;
    DUPLEN$ room #>
    special OR
    UARTBUFLEN DROP #0= OR
  UNTIL
  DUPLEN$ DUP#0=ITE
    2DROP
    :: cw #* SWAP write ;
  special
  NOT?SEMI
  FALSE specialSTO ONE SUB$1# DUP
  27 #=ITE escvt52 cntrl
;

STITLE DISPCUR
NULLNAME DISPCUR
::
  col row HARDBUFF 3PICK3PICK 2DUP
  ch #+SWAP
  cw #+SWAP
  SUBGROB
  chrSTO
  cur XYGROBDISP
;

STITLE write
NULLNAME write
::
  col row VTSDISP
  col #+DUP
  XHI
  #>case :: DROPZERO colSTO doNL ;
  colSTO DISPCUR
;

STITLE doNL
NULLNAME doNL
::
  row lr
  #<ITE :: ch row #+ rowSTO ;
        :: ZEROZERO
           HARDBUFF ZERO ch 132 bs SUBGROB
           XYGROBDISP
           lr ch BLANKIT
        ;
  DISPCUR
;

STITLE escvt52
NULLNAME escvt52
::
  DROP
  WAITFORIO
  %1 DOSRECV DROPONE SUB$1#
  :: 65 #=casedrop CURSORUP
     66 #=casedrop CURSORDOWN
     67 #=casedrop CURSORRIGHT
     68 #=casedrop CURSORLEFT
     72 #=casedrop HOME
     73 #=casedrop REVERSELF
     74 #=casedrop ERASETOEOS
     75 #=casedrop ERASETOEOL
     89 #=casedrop DIRECTCSR
     90 #=casedrop :: $ "\\1B/Z" xXMIT DROP ;
     DROP
  ;
;

STITLE CURSORUP
NULLNAME CURSORUP
::
  row hi #>
  NOT?SEMI
  UNDISPCUR
    row ch #- rowSTO
  DISPCUR
;

STITLE CURSORDOWN
NULLNAME CURSORDOWN
::
  row lr #<
  NOT?SEMI
  UNDISPCUR
    row ch #+ rowSTO
  DISPCUR
;

STITLE CURSORRIGHT
NULLNAME CURSORRIGHT
::
  col lc #1- #<
  NOT?SEMI
  UNDISPCUR
    col cw #+ colSTO
  DISPCUR
;

STITLE CURSORLEFT
NULLNAME CURSORLEFT
::
  col cw 2DUP#= 3UNROLL #> OR
  NOT?SEMI
  UNDISPCUR
    col cw #- colSTO
  DISPCUR
;

STITLE HOME
NULLNAME HOME
::
  UNDISPCUR
  ZEROZERO colSTO rowSTO
  DISPCUR
;

STITLE REVERSELF
NULLNAME REVERSELF
::
  UNDISPCUR
  row hi
  #>ITE
    :: row ch #- rowSTO ;
    :: ZERO ch 2DUP
       HARDBUFF ZEROZERO 132 lr SUBGROB
       XYGROBDISP
       BLANKIT
    ;
  DISPCUR
;

STITLE ERASETOEOS
NULLNAME ERASETOEOS
::
  row bs OVER#- BLANKIT
  DISPCUR
;

STITLE ERASETOEOL
NULLNAME ERASETOEOL
::
  col row ch XHI col #-
  MAKEGROB XYGROBDISP
  DISPCUR
;

STITLE cntrl
NULLNAME cntrl
::
   10 #=casedrop :: UNDISPCUR doNL ;
   13 #=casedrop :: UNDISPCUR ZERO colSTO DISPCUR ;
  127 #=casedrop doDEL
    8 #=casedrop doBS
   11 #=casedrop :: UNDISPCUR doNL ;
   12 #=casedrop :: UNDISPCUR doNL ;
    7 #=casedrop :: ONEHUNDRED 440 setbeep ;
    9 #=casedrop doTAB
 DROP
;

STITLE doTAB
NULLNAME doTAB
::
  UNDISPCUR
  col cw #2* #/ SWAPDROP #1+
  cw #2* #*
  DUP XHI
  #>case :: DROPZERO colSTO doNL ;
  colSTO DISPCUR
;

STITLE doDEL
NULLNAME doDEL
::
  col DUP row spc XYGROBDISP
  cw 2DUP#= 3UNROLL #> OR
  ITE :: col cw #- colSTO
      ;
      :: lc colSTO
         row ch #- rowSTO
      ;
  col row cur XYGROBDISP
;

STITLE doBS
NULLNAME doBS
::
  col DUP row chr XYGROBDISP
  cw 2DUP#= 3UNROLL #> OR
  ITE :: col cw #- colSTO
      ;
      :: lc colSTO
         row hi
         #>case
             :: row ch #-
                rowSTO
             ;
             ZEROZERO ch
             HARDBUFF ZEROZERO
             132 lr
             SUBGROB XYGROBDISP
             ZERO ch
             BLANKIT
      ;
  DISPCUR
;

STITLE DIRECTCSR
NULLNAME DIRECTCSR
::
  UNDISPCUR
  WAITFORIO
  %1 DOSRECV DROPONE SUB$1#
  32 #- ch #* rowSTO
  WAITFORIO
  %1 DOSRECV DROPONE SUB$1#
  32 #- cw #* colSTO
  DISPCUR
;

*****************************************************************************
* $Id: sdisp.s,v 1.1 1996/10/21 04:38:45 levyj WK $
*
* $Log: sdisp.s,v $
* Revision 1.1  1996/10/21 04:38:45  levyj
* Initial revision
*
*****************************************************************************
*
*ASSEMBLE
*        NIBASC  /HPHP48-X/
*RPL
*INCLUDE UFL.H
*
**************************************************************************
* SDISP v1.0 by Jack Levy ( $ % % --> ) modified by Mark Power           *
* Displays text via FNT1 from the UFL at any X/Y coordinate              *
* Truncates if reaches end of line                                       *
* Notes:                                                                 *
*  - Requires UFL and FNT1                                               *
*  - Checks range (X<132, Y<58)                                          *
* Register Usage:                                                        *
* D0   : screen location address                                         *
* D1   : string location address                                         *
* B[A] : characters left to draw                                         *
* D[A] : characters spaces left in row                                   *
* R0[A]: Body of font                                                    *
* R1[A]: X-coordinate                                                    *
* R2[A]: Y-coordinate                                                    *
**************************************************************************

STITLE VTSDISP
NULLNAME VTSDISP
::
*  CK3NOLASTWD
*  CKREAL
*  OVER  TYPEREAL? NcaseTYPEERR  
*  3PICK TYPECSTR? NcaseTYPEERR
*  COERCE2
FNT1
CODE
        A=DAT1  A               *
        A=A+CON A,10            *
        R0=A.F  A               * body of font -> R0[A]
        D1=D1+  5               *
        D=D+1   A               *
        GOSBVL  =POP#           *
        R2=A.F  A               * y-coordinate -> R2[A]
        GOSBVL  =POP#           *
        ASRB.F  A               * x-coordinate needs
        ASRB.F  A               *  dividing by 4
        R1=A.F  A               * x-coordinate -> R1[A]

        GOSBVL  =PopASavptr     *
        D1=A                    * string address -> D1
        GOSBVL  =GetStrLen      * characters -> C[A], body -> D1
        ?C#0    A               * string has characters?
        GOYES   +               *
        GOTO    Quit            *

+       B=C     A               * characters -> B[A]
        C=R2.F  A               *
        A=C     A               *
        C=0     A               *
        LC(2)   58              *
        ?C>A    A               * 58 > y-coordinate?
        GOYES   ++              *
        GOTO    Quit            * if not, display nothing

++      C=A     A               * y-coordinate -> C[A]
        A=A+A   A               *
        CSL     A               *
        C=C+C   A               *
        C=C+A   A               * x34

        GOSBVL  =D0->Row1       * screen address -> D0
        A=A+C   A               * add offset to display pointer
        C=R1.F  A               *
        D=C     A               * x-coordinate -> D[A]
        C=0     A               *
        LC(2)   33              *
        ?C<D    A               * 33 < x-coordinate?
        GOYES   Quit            * if so, display nothing

        CDEX    A               *
        D=D-C   A               * characters left in line -> D[A]
        A=A+C   A               *
        D0=A                    * display address -> D0

NextChr B=B-1   A               *
        GOC     Quit            * if no more characters, quit
        D=D-1   A               *
        GOC     Quit            * if no more space, quit
        C=0     A               *
        A=0     A               *
        A=DAT1  B               * read charater from string
        C=R0.F  A               * recall address for body of font
        A=A+A   A               *
        C=C+A   A               *
        C=C+A   A               *
        C=C+A   A               * x6
        CD1EX                   * font address for character -> D1
        A=DAT1  6               * read the data for this character

DrwChLp DAT0=A  P               * write data to screen
        D0=D0+  16              *
        D0=D0+  16              *
        D0=D0+  2               * advance to next line
        P=P+1                   *
        ?P#     6               * finished yet?
        GOYES   DrwChLp         * no, then continue drawing next line

        P=      0               *
        D1=C                    *
        D1=D1+  2               * next character

        AD0EX                   * screen address -> A[A]
        C=0     A               *
        LC(3)   203             *
        A=A-C   A               *
        D0=A                    * new screen position -> D0
        GOTO    NextChr         * jump back to start drawing

Quit    GOVLNG  =GETPTRLOOP     * get pointers, restore inner loop
ENDCODE
;

