*****************************************************************
**
** This is the Pro-Tools' Library library builder module.
**
*****************************************************************
*****************************************************************

	STITLE Pro-Tools Library Builder Equates, Version 3.0
*****************************************************************
*****************************************************************
**
** These are the necessary library builder equate statements.
**
*****************************************************************
*****************************************************************
ASSEMBLE
sVISI_ID	EQU	0
sHIDD_ID	EQU	1
sNULL_ID	EQU	2
sOMIT_ID	EQU	3

sPASS1		EQU	5
sPASS2		EQU	6
sPASS3		EQU	7

sMESSAGE	EQU	4
sCONFIG		EQU	5
sTITLE		EQU	6
sROMID		EQU	7

svisi_id	EQU	8
shidd_id	EQU	9
snull_id	EQU	10
somit_id	EQU	11

TITLE#		EQU	(16*5)+5
ROMID#		EQU	(16*5)+10
CONFIG#		EQU	(16*5)+15
LINK#		EQU	(16*5)+20
MESSAGE#	EQU	(16*5)+25
HASH#		EQU	(16*5)+30

RPL


	STITLE Directory-to-Library Conversion, Version 3.0
** begin dir>lib ************************************************
*****************************************************************
**
** NAME: dir>lib
**
** ENTRY: rrp
**
** EXIT: library
**
** ABSTRACT: Converts a directory to a library data structure.
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
** Reconstructed		10/25/93	Rick Grevelle
** First speedup		11/14/93	Rick Grevelle
** Inclusion in HACK library	??/??/??	Mika Heiskanen
** Minor space optimizations	06/09/96	Mika Heiskanen
** Made to work from tempob	06/09/96	Mika Heiskanen
** (stack pushes still questionable)
**
** DETAIL:
**
** 5 distinct loops are utilized in this conversion process, one
** of which is a multi-pass loop that may make additional sweeps
**
** Most of the required work occurs prior to the final pass that
** is responsible for the actual directory-to-library conversion
**
** The duties performed by each of these loops are the following
**
** 1) SUM_TBL computes the amount of memory to allocate in order
**    to support the master HASH table used to build the library
**
** 2) STATUS! determines the status of each non-null IDNT within
**    the source directory in the following hierarchical fashion
**
**    a) $VARS    - IDNTs in this list will be excluded
**
**    b) $HIDDEN  - IDNTs in this list lose thier names
**
**    c) $NULL    - IDNTs in this list keep thier names
**		    but do not appear in the menu pages
**
**    d) $VISIBLE - IDNTs in this list keep thier names
**		    and generate menu labels in library
**
** 3) NUMBER! assigns the XLIB number each IDNT will have in the
**    result library in the reverse order of the above hierarchy
**
** 4) SUM_RRP computes the amount of memory to allocate in order
**    to support the various components in the resulting library
**
** 5) SET_LIB performs all the mundane library conversion chores
**
**
**		    Example Directory Structure
**		    ###########################
**
**
**  A(0)----B(0)----DIR1----C(0)----D(0)----DIR2----E(0)----F(0)
**		     |			     |
**	 	     |			     |
**  A(1)----B(1)----DIR3----DIR4    A(2)----B(2)----DIR5----DIR6
**		     |	     |			     |	     |
**		     |	     |			     |	     |
**	   A(3)----B(3)	     |		   A(5)----B(5)	     |
**			     |				     |
**			     |				     |
**		   A(4)----B(4)			   A(6)----B(6)
**
**
**		    Example HASH TABLE Structure
**		    ############################
**
**		   02A4E			prolog
**		   lllll			length
**		   s*xxx			F(0)
**		   s*xxx			E(0)
**	    ------>ppppp ----->			A(0) offset
**	   |    -->ppppp -->  |			A(2) offset
**	   |   |   s*xxx   |  |			B(6)
**	   |   |   s*xxx   |  |			A(6)
**	   |   <-- bbbbb   |  |			END6 offset
**	   |    -->ppppp -->  |			A(2) offset
**	   |   |   s*xxx   |  |			B(5)
**	   |   |   s*xxx   |  |			A(5)
**	   |   <-- bbbbb   |  |			END5 offset
**	   |	   s*xxx   |  |			B(2)
**	   |	   s*xxx<--   |			A(2)
**	   <------ bbbbb      |			END2 offset
**		   s*xxx      |			D(0)
**		   s*xxx      |			C(0)
**	    ------>ppppp ----->			A(0) offset
**	   |    -->ppppp -->  |			A(1) offset
**	   |   |   s*xxx   |  |			B(4)
**	   |   |   s*xxx   |  |			A(4)
**	   |   <-- bbbbb   |  |			END4 offset
**	   |    -->ppppp -->  |			A(1) offset
**	   |   |   s*xxx   |  |			B(3)
**	   |   |   s*xxx   |  |			A(3)
**	   |   <-- bbbbb   |  |			END3 offset
**	   |	   s*xxx   |  |			B(1)
**	   |	   s*xxx<--   |			A(1)
**	   <------ bbbbb      |			END1 offset
**	  	   s*xxx      |			B(0)
**		   s*xxx<-----			A(0)
**		   00000			(00) offset
**		   11111			(01) offset
**		   22222			(02) offset
**		   33333			(03) offset
**		   44444			(04) offset
**		   55555			(05) offset
**		   66666			(06) offset
**		   77777			(07) offset
**		   88888			(08) offset
**		   99999			(09) offset
**		   AAAAA			(10) offset
**		   BBBBB			(11) offset
**		   CCCCC			(12) offset
**		   DDDDD			(13) offset
**		   EEEEE			(14) offset
**		   FFFFF			(15) offset
**		   nnnnn			$TITLE
**		   hhh**			$ROMID
**		   nnnnn			$CONFIG
**		   nnnnn			LINK table
**		   nnnnn			$MESSAGE
**		   nnnnn			HASH table
**		   **
**
**
**			    LEGEND
**			    ######
**
**	     bbbbb = back pointer for end of directory
**
**	     nnnnn = hexadecimal value or nibble count
**
**	     ppppp = forward offset that points to the
**                   1st variable up 1 directory level
**
**	     hhh   = hexadecimal ROMID (must be < 7FF)
**
**	     s     = status (i.e. $HIDDEN, $NULL, etc)
**
**	     *     = unused nibble
**
**
*****************************************************************
*****************************************************************

ASSEMBLE
	CON(1)	8
RPL
xNAME D\8DLIB
::
  CK0
  DEPTH #0<> ITE		( Check if user wants to split rrp on stack )
	DUPTYPERRP?
	FALSE
  ITE
	CK1NOLASTWD		( stack_rrp )
	CONTEXT@		( context_rrp )

  ( Disallow home directory )

  DUP SYSRRP? case SETTYPEERR  

  CODE
	GOSBVL	=SAVPTR
	SETHEX

** Clear the CPU working registers.
	CLRST			\
	P=	0		\
	A=0	W		 ZEROS CPU
	B=0	W		 REGISTERS
	C=0	W		/
	D=0	W		/

** Clear the CPU scratch registers.
	R0=A			\
	R1=A			 ZEROS CPU
	R2=A			 (SCRATCH)
	R3=A			 REGISTERS
	R4=A			/

** Go to the start of the RRP.
	C=DAT1	A
	D1=C			D1->:DORRP
	D1=D1+	8
	A=DAT1	A
	?A#0	A
	GOYES	sum_tbl		go to hook
	GOTO	do_hash


	STITLE  Master Hash Table Summation Loop, Version 1.0
** begin SUM_TBL ************************************************
*****************************************************************
**
** NAME: SUM_TBL
**
** ENTRY: D1->:rrp
**
** EXIT: D[A]:HASH mem (nibbles)
**
** CALLS: None.
**
** REGISTERS: A[A], B[X], C[A], D[A], D0, and D1.
**
** ABSTRACT:
**
** Computes amount of memory needed to support main HASH table.
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
SUM_TBL	D1=D1+	8	<-------------------------------
 	A=DAT1	A					|
	?A=0	A					|
	GOYES	next_id					|
** Increment PATH; point to 1st IDNT.			|
	B=B+1	X		B[X]:(PATH)+1		|
	D=D+CON	A,10		add directory		|
sum_tbl	CD1EX			start-up hook		|
	C=C+A	A					|
** Trap all null named vairables.			|
lis@d01	D0=C		<<-----(D0->:new IDNT)--	|
	A=0	A				|	|
	A=DAT0	B				|	|
	?A=0	B				|	|
	GOYES	next_id				|	|
** Trap all embedded directories.		|	|
	CD0EX					|	|
	D0=C					|	|
	A=A+A	A				|	|
	C=C+A	A				|	|
	D1=C					|	|
	D1=D1+	4				|	|
	A=DAT1	A				|	|
	LC(5)	=DORRP				|	|
	?A=C	A				|	|
	GOYES	SUM_TBL	 ------------------------------>
** Add IDNT to build HASH table.		|
	D=D+CON	A,5		D[A]:HASH mem	|
** Attempt to process next IDNT.		|
next_id	D0=D0-  5	<<<-----------------------------
	A=DAT0	A				|	|
	CD0EX					|	|
	C=C-A	A				|	|
	?A#0	A				|	|
	GOYES	lis@d01	 --------------------->>	|
	B=B-1	X		B[X]:(PATH)-1		|
	GOC	do_hash					|
** Move up 1 subdirectory.				|
	D0=C						|
	D0=D0-  15					|
	A=0	A					|
	A=DAT0	B					|
	A=A+1	A					|
	A=A+A	A					|
	CD0EX						|
	C=C-A	A					|
	D0=C						|
	GONC	next_id	 ---------------------------->>>

** Add DORRP prologue, length field, HASH offsets, etc.
do_hash	ST=0    sGARBAGE
	LC(5)	10+(16*5)+32	C[A]:overhead
	D=D+C	A
chkroom	GOSBVL =ROOM
	A=C	A		A[A]:# memory
	C=D	A
	C=C+CON	A,11		C[A]:required (including stack)
	?A>=C	A
	GOYES	DO_HASH
	C=D	A
	R0=C.F	A
*	GOSBVL	=DOGARBAGE	Commented out by M.H.
*	C=R0.F	A
*	D=C	A
*	GOTO	chkroom		and replaced by following
	?ST=1	sGARBAGE	Already tried GC?
	GOYES	liberr		Yes - out of memory
	GOSUB	libgc
	CON(5)	=DOCOL
	CON(5)	=GARBAGE
	CON(5)	=COLA
	CON(5)	=DOCODE
	REL(5)	dtolibend
	ST=1	sGARBAGE
	GOSBVL	=SAVPTR
	C=R0.F	A
	D=C	A
	GOTO	chkroom
liberr	GOVLNG	=GPMEMERR
libgc	C=RSTK
	GOVLNG	=GETPTREVALC

** Allocate HASH memory.
DO_HASH	C=D	A
	GOSBVL	=CREATETEMP
	LC(5)	=DOHSTR
	DAT0=C	A		D0-->prologue
	CD0EX
	RSTK=C
	D0=C
	D0=D0+	5		D0->:$ length
	B=B-CON	A,11
	A=B	A
	DAT0=A	A		D0-->$ length

** Initilize HASH tracking.
	A=A+C	A
	LC(5)	(16*5)+32
	A=A-C	A
	R3=A.F	A		R3->:1st HASH
	R2=A.F	A		R2->:new HASH

** Initialize HASH offsets.
	D0=A
	D0=D0+	5		D0->:tab IDNT
	P=	9
	A=0	W
0OFFSET	DAT0=A	W	<-------
	D0=D0+	16		|
	P=P+1			|
	GONC	0OFFSET	 ------->

** Push HASH onto data stack.
	GOSBVL	=GETPTR
	D1=D1-	5
	D=D-1	A
	C=RSTK
	DAT1=C	A
	GOSBVL	=SAVPTR

** Partially zero the CPU.
	A=0	W		\
	B=0	W		 ZEROS CPU
	C=0	W		 REGISTERS
	D=0	W		/

** Advance to start of RRP.
	D1=D1+	5
	C=DAT1	A
	D1=C			D1->:DORRP
	D1=D1+	8
	A=DAT1	A
	?A#0	A
	GOYES	status!		go-to-hook
	GOLONG	OVRHEAD


	STITLE Compute IDNT-XLIB Status, Version 1.0
** begin STATUS! ************************************************
*****************************************************************
**
** NAME: STATUS!
**
** ENTRY: D1->:rrp
**        R2->:new HASH
**        R3->:1st HASH
**
** EXIT: R1->:1st IDNT
**       R3->:1st HASH
**
** CALLS: LIS@D0, STATUS?
**
** REGISTERS: A[A], B[X], C[A], D0, and D1.
**
** ABSTRACT:
**
** Determines the status the IDNT will have in resulting library.
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
STATUS!	D1=D1+	8	<-------------------------------
 	A=DAT1	A					|
	?A#0	A					|
	GOYES	DO_SRRP					|
	GOTO	PREP_ID					|
** Increment PATH; track 1st HASH entry.		|
DO_SRRP	B=B+1	X		B[X]:(PATH)+1		|
	C=R2.F	A					|
	D0=C						|
	C=R3.F	A		C[A]:1st HASH		|
	DAT0=C	A		save 1st HASH		|
	D0=D0-	5					|
	CD0EX						|
	R2=C.F	A		R2->:new HASH		|
	R3=C.F	A		R3->:1st HASH		|
** Go to the start of the RRP.				|
status!	CD1EX			start-up hook		|
	C=C+A	A					|
	R1=C.F	A		R1->:1st IDNT		|
** Omit all $LIBRARY paramters.				|
lis@d02	D0=C		<<-----(D0->:new IDNT)--	|
	R0=C.F	A		R0->:new IDNT	|	|
	GOSUB	LIS@D0?				|	|
	LC(3)	#800		C[XS]:$OMIT	|	|
	GONC	SET_BIT				|	|
** Trap all null named vaiables.		|	|
	A=0	A				|	|
	A=DAT0	B				|	|
	?A=0	B				|	|
	GOYES	NEXT_ID				|	|
** Trap all embedded directories.		|	|
	CD0EX					|	|
	A=A+A	A				|	|
	C=C+A	A				|	|
	D1=C					|	|
	D1=D1+	4				|	|
	A=DAT1	A				|	|
	LC(5)	=DORRP				|	|
	?A=C	A				|	|
	GOYES	STATUS!	 ------------------------------->
** Determine IDNT's status.			|
	C=B	A				|
	RSTK=C					|
	GOSUB	STATUS?				|
	C=RSTK					|
	B=C	A				|
	C=ST					|
	?C#0	XS				|
	GOYES	set_bit				|
	C=C+1	XS		C[XS]:default	|
	?CBIT=1	4				|
	GOYES	do_null				|
	?CBIT=0	5				|
	GOYES	set_bit				|
do_null	LC(3)	#400		C[XS]:$NULL	|
set_bit	A=R4.F  XS                              |
	A=A!C   XS              A[XS]:$status   |
	R4=A.F  XS                              |
SET_BIT	A=R2.F	A				|
	D1=A					|
	A=A-CON	A,5				|
	R2=A.F	A		R2->:new HASH	|
	DAT1=C	XS				|
PREP_ID	C=R0.F	A				|
	D0=C					|
** Attempt to process next IDNT.		|
NEXT_ID	D0=D0-  5	<<<-----------------------------
	A=DAT0	A				|	|
	CD0EX					|	|
	C=C-A	A				|	|
	?A=0	A				|	|
	GOYES	decPATH				|	|
	GOTO	lis@d02	 ---------------------->>	|
decPATH	B=B-1	X		B[X]:(PATH)-1		|
	GOC	number!					|
** Move up 1 subdirectory.				|
	D0=C						|
	D0=D0-  15					|
	A=0	A					|
	A=DAT0	B					|
	A=A+1	A					|
	A=A+A	A					|
	CD0EX						|
	C=C-A	A					|
	D0=C						|
	D1=C						|
** Compute address of 1st IDNT.				|
backrrp	D1=D1-	5	<<<-----			|
	A=DAT1	A		|			|
	CD1EX			|			|
	C=C-A	A		|			|
	D1=C			|			|
	?A#0	A		|			|
	GOYES	backrrp	 ----->>>			|
	D1=D1-	5					|
	A=DAT1	A					|
	CD1EX						|
	C=C+A	A					|
	R1=C.F	A		R1->:1st IDNT		|
** Compute and set SRRP pointer fields.			|
	A=R2.F	A					|
	C=R3.F	A					|
	D1=C						|
	D1=D1+	5					|
	C=DAT1	A					|
	R3=C.F	A		R3->:1st HASH (entry)	|
	C=C-A	A					|
	AD1EX						|
	DAT1=C	A		D1->:first up (ppppp)	|
	C=A	A					|
	AD1EX						|
	C=C-A	A					|
	DAT1=C	A		D1->:end SRRP (bbbbb)	|
	A=A-CON	A,5					|
	R2=A.F	A		R2->:new HASH (entry)	|
	GOTO	NEXT_ID	 ----------------------------->>>

** Partially zero the CPU again.
number!	A=0	W		\
	B=0	W		 ZEROS CPU
	C=0	W		 REGISTERS
	D=0	W		/

** Set IDNTs flags.
	C=R4.F	XS
	ST=C			ST[2]:present

** Advance to start of RRP and HASH.
	C=R3.F	A
	D=C	A		D[A]:1st HASH
	C=R1.F	A		C[A]:1st IDNT
	GOTO	0thPASS


	STITLE Compute IDNT-XLIB Number, Version 1.0
** begin NUMBER! ************************************************
*****************************************************************
**
** NAME: NUMBER!
**
** ENTRY: D1->:rrp
**        D[A]:end SRRP
**
** EXIT: R1->:1st IDNT
**       R3->:1st HASH
**
** CALLS: None.
**
** REGISTERS: A[A], B[W], C[A], D[A], D0, and D1.
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
NUMBER!	D1=D1+	8	<-------------------------------
 	A=DAT1	A					|
	?A=0	A					|
	GOYES	next_no					|
** Increment PATH; point to 1st IDNT.			|
	B=B+1	M		B[M]:(PATH)+1		|
	D=D-CON	A,5		skip end SRRP		|
	CD1EX						|
	C=C+A	A					|
** Trap all null named vaiables.			|
LIS@D03	D0=C		<<-----(D0->:new IDNT)--	|
lis@d03	A=0	A				|	|
	A=DAT0	B				|	|
	?A=0	B				|	|
	GOYES	next_no				|	|
** Trap all embedded directories.		|	|
	CD0EX					|	|
	D0=C					|	|
	A=A+A	A				|	|
	C=C+A	A				|	|
	D1=C					|	|
	D1=D1+	4				|	|
	A=DAT1	A				|	|
	LC(5)	=DORRP				|	|
	?A=C	A				|	|
	GOYES	NUMBER!	 ------------------------------->
** Determine IDNT's status.			|
	C=D	A				|
	D1=C					|
	D=D-CON	A,5				|
	C=DAT1	S				|
	?B#C	S				|
	GOYES	next_no				|
	D1=D1+	2				|
	C=B	X		C[X]:new XLIB	|
	DAT1=C	X				|
	B=B+1	X		B[X]:add XLIB	|
** Trap all named XLIBs.			|
	?ST=0	sPASS3				|
	GOYES	offset!				|
** Attempt to process next IDNT.		|
next_no	D0=D0-  5	<<<-----------------------------
	A=DAT0	A				|	|
	CD0EX					|	|
	C=C-A	A				|	|
	?A#0	A				|	|
	GOYES	LIS@D03	 ---------------------->>	|
	B=B-1	M		B[M]:(PATH)-1	|	|
	GOC	nextcat				|	|
	GOTO	up1srrp				|	|
** Attempt to process next status category	|	|
nextcat	B=0	M		B[M]:(PATH)=0   |       |
	C=R3.F	A				|	|
	D=C	A		D[A]:1st HASH	|	|
	C=R1.F	A				|	|
	?ST=1	sPASS1				|	|
	GOYES	1stPASS				|	|
	?ST=1	sPASS2				|	|
	GOYES	2ndPASS				|	|
	GOTO	sum_rrp				|	|
** Trap $VISIBLE IDNTs.				|	|
0thPASS	B=B+1	S		B[S]:$VISIBLE	|	|
	?ST=0	svisi_id			|	|
	GOYES	1stpass				|	|
	ST=1	sPASS1				|	|
	GOTO	LIS@D03	 ---------------------->>	|
** Trap $HIDDEN IDNTs.				|	|
1stPASS	ST=0	sPASS1				|	|
1stpass	B=B+B	S		B[S]:<status>	|	|
	?ST=0	shidd_id			|	|
	GOYES	2ndpass				|	|
	B=B+1	X		B[X]:pad XLIB	|	|
	ST=1	sPASS2				|	|
	GOTO	LIS@D03	 ---------------------->>	|
** Trap $NULL IDNTs.				|	|
2ndPASS	ST=0	sPASS2				|	|
2ndpass	B=B+B	S		B[S]:<status>	|	|
	D0=C			D0->:new IDNT	|	|
	GOSUB	ENTRIES				|	|
	?ST=0	snull_id			|	|
	GOYES	sum_rrp				|	|
	ST=1	sPASS3				|	|
	GOTO	lis@d03	 ---------------------->>	|
** Add IDNT to offset table.				|
offset!	A=0	A					|
	A=DAT0	B					|
	C=R3.F	A					|
	C=C+A	A					|
	A=A+A	A					|
	C=C+A	A					|
	C=C+A	A					|
	D1=C						|
	A=A+CON	A,5					|
	C=DAT1	A					|
	C=C+A	A					|
	DAT1=C	A					|
	GOTO	next_no	 ----------------------------->>>
** Move up 1 subdirectory.				|
up1srrp	D=D-CON	A,5		skip first up		|
	D0=C						|
	D0=D0-  15					|
	A=0	A					|
	A=DAT0	B					|
	A=A+1	A					|
	A=A+A	A					|
	CD0EX						|
	C=C-A	A					|
	D0=C						|
	GOTO	next_no	 ----------------------------->>>

** Set the total number of XLIBs.
sum_rrp	LC(5)	LINK#
	GOSUB	entries

** Partially zero the CPU again.
	A=0	W		\
	B=0	W		 ZEROS CPU
	C=0	W		 REGISTERS
	D=0	W		/

** Handle $HIDDEN  case.
	?ST=0	shidd_id
	GOYES	.0
	LC(5)	115
	GONC	.2

** Handle $VISIBLE case.
.0	?ST=0	svisi_id
	GOYES	.1
	LC(5)	105
	GONC	.2

** Handle $NULL    case.
.1	?ST=0	snull_id
	GOYES	.2
	C=C+CON	A,10

** Advance to start of RRP and HASH.
.2	D=C	A		D[A]:#initial
	A=R3.F	A
	R4=A.F	A
	D1=A			D1->:1st HASH
	C=R1.F	A		C[A]:1st IDNT
	CLRST			clear status!
	GOTO	par@d01		start summing

** Compute size of offset portion of HASH/LINK.
ENTRIES	LC(5)	HASH#
entries	?B=0	X
	RTNYES
	A=R3.F	A
	A=A+C	A
	D1=A			D1->:set XLIB
	A=0	A
	A=B	X
	A=A+1	A
	C=A	A
	A=A+A	A
	A=A+A	A
	A=A+C	A
	DAT1=A	A
	RTN


	STITLE Library-Parameter ID Test, Version 1.1
** begin LIS@D0? ************************************************
*****************************************************************
**
** NAME: LIS@D0?
**
** ENTRY: D0->:rrp variable ID
**
** EXIT: D0->:rrp variable ID
**
** CALLS: $table1
**
** TRASHES: A[A], C[A], D1, and P
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			05/11/92	Rick Grevelle
** Optimized			09/11/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
LIS@D0?	A=DAT0  A		A[A]:[?(??)bb]
	C=A	A
	P=	2
	LCASC	\$\		C[A]:[?(24)bb]
	P=	0
	?A#C	A
	RTNYES
	A=A-CON B,5
	RTNC
	LC(2)	3		C[A]:[?(24)03]
	?A>C    B
	RTNYES
	C=0	B		C[A]:[?(24)00]
	A=A-C	A
	A=A+A	A
	ASL	A		A[A]:0,16,or32
	GOSUB	$table1


	STITLE	Library Paramater Lookup Table, Version 1.1
*****************************************************************
*****************************************************************
**
**	OPCODE	\NAME   \				 OBJECT
**	OPCODE	##		LEN STATUS-BIT
**	------	---------	--- ----------		 ------
*****************************************************************
*****************************************************************
	NIBASC	\VARS   \				( list	)
	NIBHEX  78		P:7 ST[0]:1000

	NIBASC	\NULL   \				( list	)
	NIBHEX	72		P:7 ST[0]:0010

	NIBASC	\ROMID  \				( #	)
	NIBHEX	90		P:9 ST[0]:0000

	NIBASC	\TITLE  \				( $	)
	NIBHEX	90		P:9 ST[0]:0000

	NIBASC	\HIDDEN \				( list	)
	NIBHEX	B4		P:B ST[0]:0100

	NIBASC	\CONFIG \				( seco	)
	NIBHEX	B0		P:B ST[0]:0000

	NIBASC	\VISIBLE\				( list	)
	NIBHEX	D1		P:D ST[0]:0001

	NIBASC	\MESSAGE\				( list	)
	NIBHEX	D0		P:D ST[0]:0000


	STITLE Library-Parameter ID Lookup, Version 1.1
*****************************************************************
*****************************************************************
**
** NAME: $table1
**
** ENTRY: D0->:rrp variable ID
**        RSTK:table's address
**
** EXIT: D0->:rrp variable ID
**       C[S]:ID's status bit
**       ONLY IF CARRY CLEAR!
**
** CALLS: None
**
** TRASHES: A[W], C[W], D1, and P
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			05/11/92	Rick Grevelle
** Changed pointer field	09/11/92	Rick Grevelle
**
*****************************************************************
*****************************************************************
$table1	C=RSTK
	C=C+A	A
	D1=C
	C=DAT1	W
	P=C	14
	D0=D0+	4
	A=DAT0	14
	D0=D0-	4
	?A=C	WP
	GOYES	$match1
	D1=D1+	16
	C=DAT1	W
	?A=C	WP
	GOYES	$match1
	P=	0
	RTNSC
$match1	P=	0
	RTNCC


	STITLE IDNT Status Assessment Utility, Version 1.0
** begin STATUS? ************************************************
*****************************************************************
**
** NAME: STATUS?
**
** ENTRY: R0->:new IDNT in current directory
**        R1->:1st IDNT in current directory
**        B[A]:PATH levels current directory
**
** EXIT: 
**
** CALLS: LIS@D0?, SKIPOB,
**
** TRASHES: A[W], B[X], C[W], D[A], D0, D1, and P.
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			09/11/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
STATUS?	CLRST
	C=R1.F	A
	D0=C
** Determine whether ID is a parameter ID.
status?	GOSUB	LIS@D0?	<---------------
	GONC	chklist			|
** Attempt to process yet another ID.	|
nextpar	D0=D0-	5	<<----------------------
	A=DAT0	A			|	|
	CD0EX				|	|
	C=C-A	A			|	|
	D0=C				|	|
	?A#0	A			|	|
	GOYES	status?	 -------------->	|
	B=B-1	X			|	|
	RTNC				|	|
** Move up 1 subdirectory in path.	|	|
	D0=D0-	15			|	|
	A=0	A			|	|
	A=DAT0	B			|	|
	A=A+1	A	(** RRP IS NOT NULL NAMED **)
	A=A+A	A			|	|
	CD0EX				|	|
	C=C-A	A			|	|
	D0=C				|	|
** Compute address of 1st IDNT.		|	|
1stID.1	D0=D0-	5	<<<-----	|	|
	A=DAT0	A		|	|	|
	CD0EX			|	|	|
	C=C-A	A		|	|	|
	D0=C			|	|	|
	?A#0	A		|	|	|
	GOYES	1stID.1	 ---->>>	|	|
	D0=D0-	5			|	|
	A=DAT0	A			|	|
	CD0EX				|	|
	C=C+A	A			|	|
	D0=C				|	|
	GONC	status?	 -------------->	|
** Attempt to process another $LIST.		|
restart	C=RSTK					|
	D0=C					|
	GOTO	nextpar	 --------------------->>
** Skip non-IDNT.				|
skip_ob	GOSBVL	=SKIPOB				|
	GOTO	matchid				|
** Check for 'list' parameter.			|
chklist	?C=0	S				|
	GOYES	nextpar	 --------------------->>
	A=0	A				|
	A=DAT0	B				|
	CD0EX					|
	RSTK=C					|
	A=A+A	A				|
	C=C+A	A				|
	D0=C					|
	D0=D0+	4	(** RRP IS NOT NULL NAMED **)
	A=DAT0	A				|
	LC(5)	=DOLIST				|
	?A#C	A				|
	GOYES	restart				|
** Update status bits by priority.		|
	C=ST			C[X]:[IDNT|LIST]|
	B=C	S				|
	P=C	2				|
	C=P	15		C[X]:[IDNT](old)|
	P=	0				|
	?B<=C	S		is IDNT < list?	|
	GOYES	restart		YES, try again!	|
	P=C	1				|
	C=P	15		C[S]:[LIST](old)|
	P=	0				|
	?B<=C	S		is LIST < list?	|
	GOYES	pointID		YES, skip reset	|
	C=B	S				|
	P=C	15				|
	C=P	1				|
	P=	0				|
	ST=C			reset LIST type	|
pointID	D0=D0+	5				|
** Check IDNT match loop.			|
matchid	A=DAT0	A	<<<-----------------------------
	LC(5)	=SEMI				|	|
	?A=C	A				|	|
	GOYES	restart				|	|
	LC(4)	=DOIDNT				|	|
	?A#C	A				|	|
	GOYES	skip_ob				|	|
	D0=D0+	5				|	|
	CD0EX					|	|
	RSTK=C					|	|
	D0=C					|	|
	C=R0.F	A				|	|
	D1=C					|	|
	A=DAT1	B				|	|
	C=DAT0	B				|	|
	?A#C	B				|	|
	GOYES	-match1				|	|
	C=0	XS				|	|
	C=C+1	X				|	|
	C=C+C	X				|	|
	P=C	0				|	|
	D=C	X				|	|
	DSR	X				|	|
	D=D-1	B				|	|
	GOC	initzm1				|	|
zoomin1	A=DAT1	W	<<<<------------	|	|
	C=DAT0	W			|	|	|
	D1=D1+	16			|	|	|
	D0=D0+	16			|	|	|
	?A#C	W			|	|	|
	GOYES	-match1			|	|	|
	D=D-1	B			|	|	|
	GONC	zoomin1	 ----------->>>>	|	|
initzm1	P=P-1					|	|
	GOC	+match1				|	|
	A=DAT1	WP				|	|
	C=DAT0	WP				|	|
	?A=C	WP				|	|
	GOYES	+match1				|	|
-match1	P=	0				|	|
	C=RSTK					|	|
	D0=C					|	|
	A=0	A				|	|
	A=DAT0	B				|	|
	A=A+1	A				|	|
	A=A+A	A				|	|
	C=C+A	A				|	|
	D0=C					|	|
	GOTO	matchid	 ---------------------------->>>
+match1	P=	0				|
	C=RSTK					|
	C=RSTK					|
	D0=C					|
	C=ST			C[X]:[IDNT|LIST]|
	C=B	S		\		|
	P=C	15				|
	C=P	2		 set new status	|
	P=	0				|
	ST=C			/		|
	GOTO	nextpar	 --------------------->>


	STITLE Result-Library Summation Loop, Version 1.0
** begin SUM_RRP ************************************************
*****************************************************************
**
** NAME: SUM_RRP
**
** ENTRY: D0->:rrp
**        R3->:1st HASH
**
**
** EXIT:
**
** CALLS: LIS@D0
**
** REGISTERS:
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
SUM_RRP	D0=D0+	8	<-------------------------------
 	A=DAT0	A					|
	?A=0	A					|
	GOYES	PREP_NO					|
** Increment PATH; point to 1st IDNT.			|
	B=B+1	X		B[X]:(PATH)+1		|
	D1=D1-	5		D1->:new HASH		|
	CD1EX						|
	D1=C						|
	R3=C.F	A		R3->:1st HASH		|
	CD0EX						|
	C=C+A	A					|
** Trap all $LIBRARY paramters.				|
par@d01	D0=C		<<-----(D0->:new IDNT)--	|
	GOSUB	PAR@D0?				|	|
	GONC	miscpar				|	|
** Trap all null named vaiables.		|	|
	A=0	A				|	|
	A=DAT0	B				|	|
	?A=0	B				|	|
	GOYES	NEXT_NO				|	|
** Trap all embedded directories.		|	|
	CD0EX					|	|
	R0=C.F	A		R0->:new IDNT	|	|
	A=A+A	A				|	|
	C=C+A	A				|	|
	D0=C					|	|
	D0=D0+	4				|	|
	A=DAT0	A				|	|
	LC(5)	=DORRP				|	|
	?A=C	A				|	|
	GOYES	SUM_RRP	 ------------------------------->
** Determine IDNT's status.			|
	A=DAT1	P				|
	D1=D1-	5		D1->:new HASH	|
	CD1EX					|
	RSTK=C			save new HASH	|
	?ABIT=1	sNULL_ID			|
	GOYES	null_id				|
	?ABIT=0	sOMIT_ID			|
	GOYES	visi_id				|
RESETID	C=RSTK					|
	D1=C			D1->:new HASH	|
PREP_NO	C=R0.F	A				|
	D0=C					|
** Attempt to process next IDNT.		|
NEXT_NO	D0=D0-  5	<<<-----------------------------
	A=DAT0	A				|	|
	CD0EX					|	|
	C=C-A	A				|	|
	?A#0	A				|	|
	GOYES	par@d01	 ---------------------->>	|
	B=B-1	X		B[X]:(PATH)-1		|
	GONC	UP1SRRP					|
	GOTO	OVRHEAD					|
** Trap all ${} parameters.				|
miscpar	D1=D1-	5		D1->:new HASH		|
	?C=0	S					|
	GOYES	NEXT_NO					|
	GOTO	MISCPAR					|
** Move up 1 subdirectory.				|
UP1SRRP	D0=C						|
	D0=D0-  15					|
	A=0	A					|
	A=DAT0	B					|
	A=A+1	A					|
	A=A+A	A					|
	CD0EX						|
	C=C-A	A					|
	D0=C						|
	A=DAT1	A					|
	CD1EX						|
	D1=C						|
	D1=D1-	5		D1->:new HASH		|
	C=C+A	A					|
	R3=C.F	A		R3->:1st HASH		|
	GOTO	NEXT_NO	 ----------------------------->>>


	STITLE Variable Summation Utility, Version 1.0
*****************************************************************
*****************************************************************
**
** NAME: null_id
**       visi_id
**
** ENTRY: D0->:object
**        D1->:new HASH
**        R0->:new IDNT
**
** EXIT:
**
** CALLS: 1stID.2
**
** REGISTERS:
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
** HERE D0->:object's PROLOGUE, D1->:new HASH, R0->:object's IDNT
null_id	D=D+CON	A,5
	A=B	X
	R2=A.F	X		save rrp PATH
	B=0	A		B[A]:new SECO
	A=DAT0	A
	GONC	NEW_OBJ

** HERE D0->:object's PROLOGUE, D1->:new HASH, R0->:object's IDNT
visi_id	D=D+CON	A,15
	A=B	X
	R2=A.F	X		save rrp PATH
	B=0	A		B[A]:new SECO
	CD0EX
	CR0EX.F	A		R0->:PROLOGUE
	D0=C			D0->:new IDNT
	A=0	A
	A=DAT0	B
	A=A+A	A
	LC(5)	32		C[A]:max IDNT
	?A>C	A
	GOYES	addidnt
	C=A	A
addidnt	D=D+C	A
	CD0EX
	CR0EX.F	A		R0->:new IDNT
	D0=C			D0->:PROLOGUE
	A=DAT0	A
	LC(5)	=DOCOL
	?A#C	A
	GOYES	new_obj
	D=D+CON	A,7
	GONC	compobj	

NEW_OBJ	LC(5)	=DOCOL
	?A=C	A
	GOYES	compobj
new_obj	LC(3)	=DOLIST
	?A=C	A
	GOYES	compobj
	LC(2)	=DOSYMB
	?A=C	A
	GOYES	compobj
	LC(3)	=DOIDNT
	?A=C	A
	GOYES	idntobj

sum_obj	CD0EX
	RSTK=C
	D0=C
	GOSBVL	=SKIPOB
	AD0EX
	D0=A
	C=RSTK
	C=A-C	A
	D=D+C	A
	?B#0	A
	GOYES	finish?
	A=R2.F	X		save rrp PATH
	B=A	X
	GOTO	RESETID

compobj	B=B+1	A
nextobj	D0=D0+	5
	D=D+CON	A,5
finish?	LC(5)	=SEMI
	A=DAT0	A
	?A#C	A
	GOYES	NEW_OBJ
	B=B-1	A
	?B#0	A
	GOYES	nextobj
	D=D+CON	A,5
	A=R2.F	X		save rrp PATH
	B=A	X
	GOTO	RESETID

** HERE D0->:object's PROLOGUE, D1->:new HASH, R0->:new IDNT
**      R1->:(save above here), R2->:rrp PATH, R3->:1st HASH
idntobj	C=R0.F	A
	D0=D0+	5
	CD0EX			D0->:new IDNT
	R1=C.F	A		R1->:run BYTE
	C=R3.F	A
	D1=C
	C=R2.F	X
	BCEX	A		B[A]:rrp PATH
	RSTK=C			save new SECO
	GOSUB	1stID.2
	C=RSTK
	B=C	A		B[A]:new SECO
	A=R1.F	A
	D0=A			D0->:run BYTE
	C=0	A
	C=DAT0	B		C[B]:run BYTE
	GOC	addIDNT
	C=C+1	A
	C=C+C	A
	A=A+C	A
	D0=A
	D=D+CON	A,11		add XLIB
end_obj	?B#0	A
	GOYES	finish?
	A=R2.F	X		save rrp PATH
	B=A	X
	GOTO	RESETID
addIDNT	C=C+1	A
	C=C+C	A
	A=A+C	A
	D0=A
	D=D+C	A		add IDNT body
	D=D+CON	A,5		with prologue
	GOTO	end_obj


	STITLE Miscellaneous Parameter Summation, Version 1.0
** begin MISCPAR ************************************************
*****************************************************************
**
** NAME: MISCPAR
**
** ENTRY:
**
** EXIT:
**
** CALLS:
**
** REGISTERS:
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
MISCPAR	A=0	A
	A=DAT0	B
	CD0EX
	R0=C.F	A		R0->:new IDNT
	A=A+A	A
	C=C+A	A
	D0=C
	D0=D0+	4		D0->:obj IDNT
	A=DAT0	A		A[A]:prologue

** Trap $MESSAGE parameter.
	C=C+C	S
	GONC	$CONFG?
	LC(5)	=DOLIST
	?A#C	A
	GOYES	abort00
	C=0	A
	CDEX	A
	RSTK=C
	D0=D0+	5

summesg	A=DAT0	A
	LC(5)	=SEMI
	?A=C	A
	GOYES	setmesg
	LC(4)	=DOCSTR
	?A#C	A
	GOYES	nextstr
	ST=1	sMESSAGE
	D0=D0+	5
	C=DAT0	A
	D=D+C	A
	AD0EX
	A=A+C	A
	D0=A
	GOTO	summesg

nextstr	GOSBVL	=SKIPOB
	GOTO	summesg

setmesg	LC(5)	MESSAGE#
	A=R4.F	A
	A=A+C	A
	D0=A
	C=DAT0	A
	C=C+D	A
	DAT0=C	A
	C=RSTK
	D=D+C	A

abort00	GOTO	PREP_NO


** Trap $CONFIG  parameter.
$CONFG?	C=C+C	S
	GONC	$TITLE?
	?ST=1	sCONFIG
	GOYES	abort00
	LC(5)	=DOCOL
	?A#C	A
	GOYES	abort00
	ST=1	sCONFIG

** Save new HASH and rrp PATH.
	CD1EX
	RSTK=C			save new HASH
	A=B	A
	R2=A.F	A		save rrp PATH
	B=0	A		B[A]:new SECO

** Cache current counter.
	LC(5)	CONFIG#
	A=R4.F	A
	A=A+C	A
	D1=A
	C=D	A
	DAT1=C	A		save old nibs
	A=DAT0	A
	GOTO	config+

** Trap $TITLE   parameter.
$TITLE?	C=C+C	S
	GONC	$romid!
	?ST=1	sTITLE
	GOYES	abort01
	LC(5)	=DOCSTR
	?A#C	A
	GOYES	abort01
	ST=1	sTITLE
	D0=D0+	5
	C=DAT0	A
	LA(5)	3
	C=C-A	A
	?C<=A	A
	GOYES	abort01
	RSTK=C
	D=D+C	A
	LC(5)	TITLE#

sethash	A=R4.F	A
	A=A+C	A
	D0=A
	C=RSTK
	DAT0=C	A

abort01	GOTO	PREP_NO

$romid!	?ST=1	sROMID
	GOYES	abort01
	LC(5)	=DOHSTR
	?A#C	A
	GOYES	romid.3
	D0=D0+	5
	C=DAT0	A
	C=C-CON	A,6
	GOC	abort01
	ST=1	sROMID
	A=0	W
	LA(1)	15
	?A>=C	A
	GOYES	romid.1
	C=A	A
romid.1	LA(3)	#7FF
	P=C	0
	D0=D0+	5
	C=0	X
	C=DAT0	WP
	?A>=C	WP
	GOYES	romid.2
	C=A	X
romid.2	P=	0
	RSTK=C
	LC(5)	ROMID#
	GOTO	sethash

romid.3	LC(5)	=DOREAL
	?A#C	A
	GOYES	abort01
	ST=1	sROMID
	D0=D0+	5
	C=D	A
	R1=C.F	A
	A=B	X
	R2=A.F	X


	STITLE Real-to-Hexidecimal Conversion, Version 3.0
*****************************************************************
*****************************************************************
**
** NAME: COERCE
**
** ENTRY: A[W]: BCD-12
**
** EXIT: C[A]: hex value
**
** ABSTRACT: Coerce real to binary integer
**
** DETAIL: If % < ZERO, then # is ZERO.
**         If % > #7FF, then # is #7FF.
**
*****************************************************************
*****************************************************************
	A=DAT0	W
	?A=0	S
	GOYES	COER15

CEXIT4	C=0	A
	GOTO	UNDFLOW

CEXIT1	LA(5)	#7FF
	GOTO	OVRFLOW

COER15	?A=0	W               
	GOYES	undflow

** Trap numbers less than 1.
	LCHEX	500
	?A<C	X		exponent positive?
	GOYES	COER30		YES
	LCHEX	999
	?A#C	X		exponent < -1 now?
	GOYES	CEXIT4		YES, return #00000
	P=	14		exponent = -1 here
	LCHEX	4               
	C=C-A	P               Mantissa < .5 now?
	P=	0               
	GONC	CEXIT4		YES, return #00000
	C=0	A		NO,  return #00001
	C=C+1	A
undflow	GOTO	UNDFLOW

** Trap numbers greater than 1E3.
COER30	LCHEX	003
	?A>C	X		exponent > 6 here?
	GOYES	CEXIT1		YES, return #007FF

** Round fractional part.
	B=A	X
	C=A     X
	P=      14
COER35	P=P-1			determine fraction
	C=C-1   X
	GONC    COER35
	SETDEC
	A=A+A   P		double first digit
	A=0     WP		fractional part 0s
	GONC    COER40		integer part round
	A=A-1   WP
	A=A+1   W
	?A=0    S
	GOYES   COER40
	ASR     W
	B=B+1	X

** Coerce real to integer.
COER40	C=0	W
	SETHEX
COER42	C=C+C	W
	D=C	W
	C=C+C	W
	C=C+C	W
	C=C+D	W
	ASL	W
	?A=0	S
	GOYES	COER47
COER45	C=C+1	W
	A=A-1	S
	?A#0	S
	GOYES	COER45
COER47	B=B-1	X
	GONC	COER42

** Overflow trap.
	P=	0
	A=0	W
	LA(3)	#7FF
	?C<=A	W		OVERFLOW?
	GOYES	UNDFLOW
OVRFLOW	C=A	A
UNDFLOW	RSTK=C
	C=R1.F	A
	D=C	A
	A=R2.F	X
	B=A	X
	LC(5)	ROMID#
	GOTO	sethash

** Determine conversion nibbles.
CONFIG+	LC(5)	=DOCOL
	?A=C	A
	GOYES	config+
	LC(3)	=DOLIST
	?A=C	A
	GOYES	config+
	LC(2)	=DOSYMB
	?A=C	A
	GOYES	config+
	LC(3)	=DOIDNT
	?A=C	A
	GOYES	idntcon

sum_con	CD0EX
	RSTK=C
	D0=C
	GOSBVL	=SKIPOB
	AD0EX
	D0=A
	C=RSTK
	C=A-C	A
	D=D+C	A
	?B#0	A
	GOYES	theEND?
	A=R2.F	X		save rrp PATH
	B=A	X
	GOTO	setsize

config+	B=B+1	A
nextcon	D0=D0+	5
	D=D+CON	A,5
theEND?	LC(5)	=SEMI
	A=DAT0	A
	?A#C	A
	GOYES	CONFIG+
	B=B-1	A
	?B#0	A
	GOYES	nextcon
	D=D+CON	A,5
	A=R2.F	X		save rrp PATH
	B=A	X
	GOTO	setsize

** HERE D0->:object's PROLOGUE, D1->:new HASH, R0->:new IDNT
**      R1->:(save above here), R2->:rrp PATH, R3->:1st HASH
idntcon	C=R0.F	A
	D0=D0+	5
	CD0EX			D0->:new IDNT
	R1=C.F	A		R1->:run BYTE
	C=R3.F	A
	D1=C
	C=R2.F	X
	BCEX	A		B[A]:rrp PATH
	RSTK=C			save new SECO
	GOSUB	1stID.2
	C=RSTK
	B=C	A		B[A]:new SECO
	A=R1.F	A
	D0=A			D0->:run BYTE
	C=0	A
	C=DAT0	B		C[B]:run BYTE
	GOC	addNAME
	C=C+1	A
	C=C+C	A
	A=A+C	A
	D0=A
	D=D+CON	A,11		add XLIB
end_con	?B#0	A
	GOYES	theEND?
	A=R2.F	X		save rrp PATH
	B=A	X

setsize	LC(5)	CONFIG#
	A=R4.F	A
	A=A+C	A
	D1=A
	A=DAT1	A
	C=D	A
	C=C-A	A
	DAT1=C	A
	GOTO	RESETID

addNAME	C=C+1	A
	C=C+C	A
	A=A+C	A
	D0=A
	D=D+C	A		add IDNT body
	D=D+CON	A,5		with prologue
	GOTO	end_con

** Tack on necessary overhead.
OVRHEAD	?ST=0	sMESSAGE
	GOYES	ovrhead
	LC(5)	25
	D=D+C	A

ovrhead	LC(5)	39
**	LC(5)	(dolib)+(len)+(bytes)+(romid)+(hash)+(mesg)+(link)+(crc)
	C=C+D	A
	GOTO	MAKELIB


	STITLE Library-Parameter ID Test, Version 1.1
** begin PAR@D0? ************************************************
*****************************************************************
**
** NAME: PAR@D0?
**
** ENTRY: D0->:rrp variable ID
**
** EXIT: D0->:rrp variable ID
**
** CALLS: $table2
**
** TRASHES: A[A], C[A], D1, and P
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			05/11/92	Rick Grevelle
** Optimized			09/11/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
PAR@D0?	A=DAT0  A		A[A]:[?(??)bb]
	C=A	A
	P=	2
	LCASC	\$\		C[A]:[?(24)bb]
	P=	0
	?A#C	A
	RTNYES
	A=A-CON B,5
	RTNC
	LC(2)	3		C[A]:[?(24)03]
	?A>C    B
	RTNYES
	C=0	B		C[A]:[?(24)00]
	A=A-C	A
	A=A+A	A
	ASL	A		A[A]:0,16,or32
	GOSUB	$table2


	STITLE	Library Paramater Lookup Table, Version 1.1
*****************************************************************
*****************************************************************
**
**	OPCODE	\NAME   \				 OBJECT
**	OPCODE	##		LEN STATUS-BIT
**	------	---------	--- ----------		 ------
*****************************************************************
*****************************************************************
	NIBASC	\VARS   \				( list	)
	NIBHEX  70		P:7 ST[0]:0000

	NIBASC	\NULL   \				( list	)
	NIBHEX	70		P:7 ST[0]:0000

	NIBASC	\ROMID  \				( #	)
	NIBHEX	91		P:9 ST[0]:0001

	NIBASC	\TITLE  \				( $	)
	NIBHEX	92		P:9 ST[0]:0010

	NIBASC	\HIDDEN \				( list	)
	NIBHEX	B0		P:B ST[0]:0000

	NIBASC	\CONFIG \				( seco	)
	NIBHEX	B4		P:B ST[0]:0100

	NIBASC	\VISIBLE\				( list	)
	NIBHEX	D0		P:D ST[0]:0000

	NIBASC	\MESSAGE\				( list	)
	NIBHEX	D8		P:D ST[0]:1000


	STITLE Library-Parameter ID Lookup, Version 1.1
*****************************************************************
*****************************************************************
**
** NAME: $table2
**
** ENTRY: D0->:rrp variable ID
**        RSTK:table's address
**
** EXIT: D0->:rrp variable ID
**       C[S]:ID's status bit
**       ONLY IF CARRY CLEAR!
**
** CALLS: None
**
** TRASHES: A[W], C[W], D1, and P
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			05/11/92	Rick Grevelle
** Changed pointer field	09/11/92	Rick Grevelle
**
*****************************************************************
*****************************************************************
$table2	C=RSTK
	C=C+A	A
	CD1EX
	RSTK=C
	C=DAT1	W
	P=C	14
	D0=D0+	4
	A=DAT0	14
	D0=D0-	4
	?A=C	WP
	GOYES	$match2
	D1=D1+	16
	C=DAT1	W
	?A=C	WP
	GOYES	$match2
	P=	0
	C=RSTK
	D1=C
	RTNSC
$match2	P=	0
	C=RSTK
	D1=C
	RTNCC


	STITLE IDNT Path Assessment Utility, Version 1.0
** begin INPATH? ************************************************
*****************************************************************
**
** NAME: INPATH?
**
** ENTRY: D0->:new IDNT in current directory
**        D1->:new HASH in current directory
**        B[X]:rrp PATH
**
** EXIT: D0->: new IDNT
**       D1->: new HASH
**       R1->: run IDNT
**       in PATH if CARRY CLEAR
**
** HOOK: (1stID.2)
**       D0->:new IDNT
**       D1->:1st HASH
**       B[X]:rrp PATH
**
** CALLS: PAR@D0?
**
** TRASHES: A[W], B[A], C[W], D0, D1, and P.
**
** ABSTRACT:
**
** STACK LEVELS: 3
**
** MODULE HISTORY:
**
** Written			09/11/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
** Trap all null named variables.
INPATH?	A=0	A	<---------------
	A=DAT0	B			|
	?A=0	B			|
	GOYES	nextvar			|
** Trap all embedded directories.	|
	CD0EX				|
	RSTK=C				|
	A=A+A	A			|
	C=C+A	A			|
	D0=C				|
	D0=D0+	4			|
	A=DAT0	A			|
	LC(5)	=DORRP			|
	?A#C	A			|
	GOYES	chkidnt			|
** Trap all null SRRPs.			|
	D0=D0+	8			|
	A=DAT0	A			|
	?A=0	A			|
	GOYES	backoff			|
** Use bbbbb to skip over HASH SRRP.	|
	A=DAT1	A			|
	CD1EX				|
	C=C-A	A			|
	D1=C				|
	D1=D1-	5			|
** Back D0 off and do nextvar.		|
backoff	C=RSTK				|
	D0=C				|
** Attempt to process yet another ID.	|
nextvar	D0=D0-	5	<<----------------------
	A=DAT0	A			|	|
	CD0EX				|	|
	C=C-A	A			|	|
	D0=C				|	|
	?A#0	A			|	|
	GOYES	INPATH?	 -------------->	|
	B=B-1	X	B[X]:(PATH)-1	|	|
	RTNC				|	|
** Use ppppp to skip to 1st HASH up 1 SRRP.	|
	A=DAT1	A			|	|
	CD1EX				|	|
	C=C+A	A			|	|
	D1=C		D1->:1st HASH	|	|
** Move up 1 subdirectory in path.	|	|
	D0=D0-	15			|	|
	A=0	A			|	|
	A=DAT0	B			|	|
	A=A+1	A	(** RRP IS NOT NULL NAMED **)
	A=A+A	A			|	|
	CD0EX				|	|
	C=C-A	A			|	|
	D0=C				|	|
** Compute address of 1st IDNT.		|	|
1stID.2	D0=D0-	5	<<<-----	|	|
	A=DAT0	A		|	|	|
	CD0EX			|	|	|
	C=C-A	A		|	|	|
	D0=C			|	|	|
	?A#0	A		|	|	|
	GOYES	1stID.2	 ---->>>	|	|
	D0=D0-	5			|	|
	A=DAT0	A			|	|
	CD0EX				|	|
	C=C+A	A			|	|
	D0=C		D0->:1st IDNT	|	|
	GOTO	INPATH?	 -------------->	|
** Check IDNT match loop.			|
chkidnt	C=RSTK					|
	D0=C		D0->:new IDNT		|
	RSTK=C		save new IDNT		|
	C=R1.F	A				|
	CD1EX		D1->:run IDNT		|
	RSTK=C		save new HASH		|
**	D1=D1+	5				|
	A=DAT0	B				|
	C=DAT1	B				|
	?A#C	B				|
	GOYES	-MATCH2				|
	C=0	XS				|
	C=C+1	X				|
	C=C+C	X				|
	P=C	0				|
	BCEX	A				|
	BSR	X				|
	RSTK=C					|
	B=B-1	B				|
	GOC	initzm2				|
zoomin2	A=DAT1	W	<<<<------------	|
	C=DAT0	W			|	|
	D1=D1+	16			|	|
	D0=D0+	16			|	|
	?A#C	W			|	|
	GOYES	-match2			|	|
	B=B-1	B			|	|
	GONC	zoomin2	 ----------->>>>	|
initzm2	P=P-1					|
	GOC	+match2				|
	A=DAT1	WP				|
	C=DAT0	WP				|
	?A=C	WP				|
	GOYES	+match2				|
-match2	P=	0				|
	C=RSTK					|
	B=C	A	B[A]:rrp PATH		|
-MATCH2	C=RSTK					|
	D1=C					|
	D1=D1-	5	D1->:new HASH		|
	C=RSTK					|
	D0=C		D0->:new IDNT		|
	GOTO	nextvar	 --------------------->>
+match2	P=	0
	C=RSTK
	C=RSTK
	D1=C		D1->:new HASH
	C=RSTK
	D0=C		D0->:new IDNT
	A=DAT1	P
	?ABIT=1	sOMIT_ID
	RTNYES
	RTN


	STITLE Initialize Library Object, Version 1.0
** begin MAKELIB ************************************************
*****************************************************************
**
** NAME: MAKELIB
**
** ENTRY: C[A]:nibbles needed to support library!
**
** EXIT:
**
** CALLS:
**
** TRASHES:
**
** ABSTRACT:
**
** STACK LEVELS:
**
** MODULE HISTORY:
**
** Written			09/11/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
MAKELIB	ST=0	sGARBAGE
	R3=C.F	A
makelib	GOSBVL	=CREATETEMP
	GONC	initlib
*	?ST=0	sGARBAGE		Commented out by M.H
*	GOYES	garbage
*	GOSBVL	=GETPTR
*	LA(5)	=SETMEMERR
*	PC=(A)
*
*garbage
*	ST=1	sGARBAGE
*	GOSBVL	=GARBAGECOL
*	GOSBVL	=GETPTR
*	C=R3.F	A
*	GOTO	makelib			and replaced by the following

	?ST=1	sGARBAGE
	GOYES	mkliber
	GOSUB	mklib:
	CON(5)	=DOCOL
	CON(5)	=GARBAGE
	CON(5)	=COLA
	CON(5)	=DOCODE
	REL(5)	dtolibend
	ST=1	sGARBAGE
	GOSBVL	=SAVPTR
	C=R3.F	A
	GOTO	makelib
mkliber	GOVLNG	=GPMEMERR
mklib:	C=RSTK
	GOVLNG	=GETPTREVALC

** Initialize library object.
initlib	LC(5)	=DOLIB
	DAT0=C	A
	AD0EX
	D0=A
	D0=D0+	5
	B=B-CON	A,11
	C=B	A
	DAT0=C	A

** Push library onto data stack.
	GOSBVL	=GETPTR
	C=DAT1	A
	D0=C
	D1=D1+	5
	C=DAT1	A
	RSTK=C			save argument
	DAT1=A	A		D1-->LIBRARY!
	D1=A

** Initilize HASH tracking.
	AD0EX
	D0=A
	D0=D0+	5
	C=DAT0	A
	A=A+C	A
	LC(5)	(16*5)+32
	A=A-C	A
	R3=A.F	A		R3->:1st HASH

** Initialize library $TITLE.
	D1=D1+	10
	LC(5)	TITLE#
	A=A+C	A
	D0=A
	A=DAT0	A
	?A=0	A
	GOYES	++
	A=A-CON	A,2
	ASRB.F	A
	LC(5)	#FF
	?C>=A	A
	GOYES	+
	A=C	A
+	DAT1=A	B		D1-->$byte(s)
	CD1EX			\
	C=C+A	A		\
	C=C+A	A		 skips $TITLE
	D1=C			/
	D1=D1+	2		/
++	DAT1=A	B		D1-->$byte(s)
	D1=D1+	2

** Initialize library $ROMID.
	D0=D0+	5		D0->:ROMID#
	A=DAT0	X
	DAT1=A	X		D1-->$ROMID
	D1=D1+	3

** Initialize library $CONFIG.
	D1=D1+	15
	D0=D0+	5		D0->:CONFIG#
	C=0	A
	A=DAT0	A
	?A=0	A
	GOYES	+
	LC(1)	5
+	DAT1=C	A		D1-->offset
	B=A	A
	B=B+CON	A,10		B[A]:offset
	D1=D1-	5

** Initialize LINK table.
	D0=D0+	5
	A=DAT0	A
	?A=0	A
	GOYES	+
	ABEX	A		B[A]:length
+	DAT1=A	A		D1-->offset
	GOC	+
	CD1EX
	RSTK=C
	C=C+A	A
	D1=C
	LC(5)	=DOHSTR
	DAT1=C	A		D1-->DOHSTR
	D1=D1+	5
	ABEX	A
	DAT1=A	A		D1-->length
	B=B+A	A
	B=B+CON	A,5
	C=A	A		C[A]:length
	GOSUB	zeroout
	C=RSTK
	D1=C
+	B=B+CON	A,5
	D1=D1-	5

** Initialize library $MESSAGE.
	D0=D0+	5
	A=DAT0	A
	?A=0	A
	GOYES	+
	ABEX	A		B[A]:length
+	DAT1=A	A		D1-->offset
	GOC	+
	CD1EX
	RSTK=C
	C=C+A	A
	D1=C
	LC(5)	=DOARRY
	DAT1=C	A		D1-->DOARRY
	D1=D1+	5
	ABEX	A
	LC(5)	20
	A=A+C	A
	DAT1=A	A		D1-->length
	B=B+A	A
	B=B+CON	A,5
	D1=D1+	5
	LCHEX	000000000102A2C
	DAT1=C	15
	C=RSTK
	D1=C
+	B=B+CON	A,5
	D1=D1-	5

** Initialize HASH table.
	D0=D0+	5
	A=DAT0	A
	?A=0	A
	GOYES	+
	ABEX	A		B[A]:length
+	DAT1=A	A		D1-->offset
	CD1EX
	R4=C.F	A		R4->:tables
	GOC	output!
	C=C+A	A
	D1=C		**(HASH table start)**
	RSTK=C
	LC(5)	=DOHSTR
	DAT1=C	A		D1-->DOHSTR
	D1=D1+	5
	ABEX	A		A[A]:length
	LC(5)	85
	D=C	A		D[A]:fields
	C=R3.F	A
	D0=C
-	D0=D0+	5	<---------------
	D1=D1+	5			|
	C=DAT0	A			|
	?C=0	A			|
	GOYES	+			|
	CDEX	A			|
+	DAT1=C	A			|
	GOC	+			|
	D=D+C	A			|
+	D=D-CON	A,5			|
	P=P+1				|
	GONC	-	 --------------->
	D1=D1+	5
	C=D	A
	DAT1=C	A		D1-->offset
	A=A+C	A
	C=A	A
	C=C-CON	A,5		C[A]:length
	GOSUB	zeroout
	LC(5)	80
	A=A+C	A
	C=RSTK
	D1=C
	D1=D1+	5
	DAT1=A	A
	B=B+A	A
	B=B+CON	A,5

** Compute output address.
output!	C=R4.F	A
	C=C+B	A
	D=C	A		D[A]:output!

** Initilize 1st HASH.
	A=R3.F	A
	D1=A			D1->:1st HASH

** Advance to start of RRP.
	CLRST
	B=0	X		B[X]:(PATH)=0
	C=RSTK
	D0=C			D1->:DORRP
	D0=D0+	8
	A=DAT0	A
	?A#0	A
	GOYES	set_lib		go-to-hook
	GOTO	SET_CRC

** Zero C[A]:nibbles-5 starting at D1+5.
zeroout	C=C-CON	A,5
	P=C	0
	CSR	A
	D=C	A
	C=0	W
	D1=D1+	5
	D=D-1	A
	GOC	+
-	DAT1=C	W
	D1=D1+	16
	D=D-1	A
	GONC	-
+	P=P-1
	GOC	+
	DAT1=C	WP
+	P=	0
	RTN


	STITLE Result-Library Write Loop, Version 1.0
** begin SET_LIB ************************************************
*****************************************************************
**
** NAME: SET_LIB
**
** ENTRY: D0->:rrp
**        R3->:1st HASH
**
**
** EXIT:
**
** CALLS: LIS@D0
**
** REGISTERS:
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
SET_LIB	D0=D0+	8	<-------------------------------
 	A=DAT0	A					|
	?A=0	A					|
	GOYES	nextset					|
** Increment PATH; point to 1st IDNT.			|
	B=B+1	X		B[X]:(PATH)+1		|
	D1=D1-	5		D1->:new HASH		|
	CD1EX						|
	D1=C						|
	R3=C.F	A		R3->:1st HASH		|
set_lib	CD0EX						|
	C=C+A	A					|
** Trap all $LIBRARY paramters.				|
par@d02	D0=C		<<-----(D0->:new IDNT)--	|
	GOSUB	PAR@D0?				|	|
	GONC	miscset				|	|
** Trap all null named vaiables.		|	|
	A=0	A				|	|
	A=DAT0	B				|	|
	?A=0	B				|	|
	GOYES	NEXTSET				|	|
** Trap all embedded directories.		|	|
	CD0EX					|	|
	R0=C.F	A		R0->:new IDNT	|	|
	A=A+A	A				|	|
	C=C+A	A				|	|
	D0=C					|	|
	D0=D0+	4				|	|
	A=DAT0	A				|	|
	LC(5)	=DORRP				|	|
	?A=C	A				|	|
	GOYES	SET_LIB	 ------------------------------->
** Determine IDNT's status.			|
	A=DAT1	P				|
	?ABIT=1	sNULL_ID			|
	GOYES	NULL_ID				|
	?ABIT=0	sOMIT_ID			|
	GOYES	VISI_ID				|
RESTART	D1=D1-	5		D1->:new HASH	|
nextset	C=R0.F	A				|
	D0=C					|
** Attempt to process next IDNT.		|
NEXTSET	D0=D0-  5	<<<-----------------------------
	A=DAT0	A				|	|
	CD0EX					|	|
	C=C-A	A				|	|
	?A#0	A				|	|
	GOYES	par@d02	 ---------------------->>	|
	B=B-1	X		B[X]:(PATH)-1		|
	GONC	UP_SRRP					|
	GOTO	SET_CRC					|
** Trap all ${} parameters.				|
miscset	D1=D1-	5					|
	?C=0	S					|
	GOYES	NEXTSET					|
	GOTO	MISCSET					|
** Move up 1 subdirectory.				|
UP_SRRP	D0=C						|
	D0=D0-  15					|
	A=0	A					|
	A=DAT0	B					|
	A=A+1	A					|
	A=A+A	A					|
	CD0EX						|
	C=C-A	A					|
	D0=C						|
	A=DAT1	A					|
	CD1EX						|
	D1=C						|
	D1=D1-	5		D1->:new HASH		|
	C=C+A	A					|
	R3=C.F	A		R3->:1st HASH		|
	GOTO	NEXTSET	 ----------------------------->>>


	STITLE Variable Conversion Utility, Version 1.0
*****************************************************************
*****************************************************************
**
** NAME: NULL_ID
**       VISI_ID
**
** ENTRY: D0->:object
**        D1->:new HASH
**        R0->:new IDNT
**
** EXIT:
**
** CALLS: 1stID.2
**
** REGISTERS:
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
** HERE D0->:object's PROLOGUE, D1->:new HASH, R0->:object's IDNT
NULL_ID	CD1EX
	RSTK=C			save new HASH
	D1=C
	D1=D1+	2
	C=0	A
	C=DAT1	X		C[A]:00(XLIB)
	RSTK=C			RSTK:1:2:
	GOTO	SETLINK

** HERE D0->:object's PROLOGUE, D1->:new HASH, R0->:object's IDNT
VISI_ID	CD1EX
	RSTK=C			save new HASH
	D1=C
	A=DAT0	A
	LC(5)	=DOCOL
	?A#C	A
	GOYES	set_hash

** Set properties list data.
	A=DAT1	A
	ASL	W		A[5-0]:xxx*s0
	C=R4.F	A
	CD1EX
	RSTK=C			RSTK:1:2:
	D1=D1-	3
	A=DAT1	X		A[5-0]:xxxhhh
	ASL	W
	LA(1)	8		property list
	C=D	A
	D1=C	A		D1->:output!
	DAT1=A	7
	D1=D1+	7
	C=RSTK			RSTK:1:
	CD1EX
	D=C	A		save output!

** Set HASH category data.
set_hash
	D1=D1+	2
	C=0	A
	C=DAT1	X		C[A]:00(XLIB)
	RSTK=C			RSTK:1:2:
	A=R4.F	A
	D1=A
	C=DAT1	A
	A=A+C	A
	D1=A			D1->:prologue
	D1=D1+	5
	LC(5)	90
	C=C+A	A		C[A]:pointers
	RSTK=C			RSTK:1:2:3:
	C=R0.F	A
	D0=C			D0->:new IDNT
	A=0	A
	A=DAT0	B
	LC(5)	16		C[A]:max IDNT
	?A<=C	A
	GOYES	putback
	A=C	A
putback	C=A	A
	C=C+C	A
	A=A+C	A
	A=A+C	A		A[A]=(A[A]x5)
	C=C+CON	A,5		C[A]:category
	RSTK=C			RSTK:1:2:3:4:
	CD1EX
	C=C+A	A
	D1=C
	A=DAT1	A
	C=C+A	A
	D1=C			D1->:CATEGORY
	C=RSTK			RSTK:1:2:3:
gethole	A=DAT1	B	<---------------
	?A=0	B			|
	GOYES	setcate			|
	AD1EX				|
	A=A+C	A			|
	D1=A				|
	GOTO	gethole	 --------------->
setcate	C=C-CON	A,3
	GOSBVL	=MOVEDOWN

** Set HASH offset field.
	C=RSTK			RSTK:1:2:
	A=C	A
	C=RSTK			RSTK:1:
	RSTK=C			RSTK:1:2:
	DAT1=C	X		D1-->new XLIB
	ACEX	A		A[A]:new XLIB
	CD1EX			D1->:pointers
	RSTK=C			RSTK:1:2:3:
	C=DAT1	A
	C=C+A	A
	A=A+A	A
	A=A+A	A
	C=C+A	A
	AD1EX
	A=A+C	A
	D1=A
	C=RSTK			RSTK:1:2:
	A=A-C	A
	C=0	A
	C=DAT0	B
	D0=D0+	2
	C=C+1	A
	C=C+C	A
	A=A+C	A
	DAT1=A	A

** Set LINK offset field.
SETLINK	A=B	X
	R2=A.F	X		save rrp PATH
	B=0	A		B[A]:new SECO
	C=R4.F	A
	C=C+CON	A,10
	D1=C
	A=DAT1	A
	A=A+C	A
	A=A+CON	A,10
	C=RSTK			RSTK:1:
	A=A+C	A
	C=C+C	A
	C=C+C	A
	A=A+C	A
	D1=A
	C=D	A
	C=C-A	A
	DAT1=C	A
	A=DAT0	A
	C=D	A
	D1=C

NEWXLIB	LC(5)	=DOCOL
	?A=C	A
	GOYES	nestobj
	LC(3)	=DOLIST
	?A=C	A
	GOYES	nestobj
	LC(2)	=DOSYMB
	?A=C	A
	GOYES	nestobj
	LC(3)	=DOIDNT
	?A=C	A
	GOYES	IDNTOBJ

SET_OBJ	CD0EX
	RSTK=C
	D0=C
	GOSBVL	=SKIPOB
	AD0EX
	C=RSTK
	D0=C
	C=A-C	A
	GOSBVL	=MOVEDOWN
END_OBJ	?B#0	A
	GOYES	FINISH?
	C=RSTK
	CD1EX
	D=C	A		D[A]:output!
	A=R2.F	X		save rrp PATH
	B=A	X
	GOTO	RESTART

nestobj	DAT1=A	A
	B=B+1	A

NEXTOBJ	D0=D0+	5
	D1=D1+	5

FINISH?	LC(5)	=SEMI
	A=DAT0	A
	?A#C	A
	GOYES	NEWXLIB
	DAT1=A	A
	B=B-1	A
	?B#0	A
	GOYES	NEXTOBJ
	D1=D1+	5
	C=RSTK
	CD1EX
	D=C	A		D[A]:output!
	A=R2.F	X		save rrp PATH
	B=A	X
	GOTO	RESTART

** HERE D0->:object's PROLOGUE, D1->:new HASH, R0->:new IDNT
**      R1->:(save above here), R2->:rrp PATH, R3->:1st HASH
IDNTOBJ	C=R0.F	A
	D0=D0+	5
	CD0EX			D0->:new IDNT
	R1=C.F	A		R1->:run BYTE
	C=R3.F	A
	CD1EX
	D=C	A
	C=R2.F	X
	BCEX	A		B[A]:rrp PATH
	RSTK=C			save new SECO
	GOSUB	1stID.2
	C=RSTK
	B=C	A		B[A]:new SECO
	A=R1.F	A
	D0=A			D0->:run BYTE
	GOC	setIDNT
	C=0	A		\
	C=DAT0	B		\
	C=C+1	A		 skip
	C=C+C	A		 IDNT
	A=A+C	A		/
	D0=A			/
	A=DAT1	A
	ASL	W		A[5-0]:xxx*s0
	C=R4.F	A
	D1=C
	D1=D1-	3
	A=DAT1	X		A[5-0]:xxxhhh
	C=D	A
	D1=C
	LC(5)	=DOROMP
	DAT1=C	A
	D1=D1+	5
	DAT1=A	6
	D1=D1+	6
	GOTO	END_OBJ
setIDNT	C=D	A
	D1=C
	LC(5)	=DOIDNT
	DAT1=C	A
	D1=D1+	5
	C=0	A
	C=DAT0	B
	C=C+1	A
	C=C+C	A
	GOSBVL	=MOVEDOWN
	GOTO	END_OBJ


	STITLE Miscellaneous Parameter Conversion, Version 1.0
** begin MISCSET ************************************************
*****************************************************************
**
** NAME: MISCSET
**
** ENTRY:
**
** EXIT:
**
** CALLS:
**
** REGISTERS:
**
** ABSTRACT:
**
** MODULE HISTORY:
**
** Written			09/18/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
MISCSET	A=0	A
	A=DAT0	B
	CD0EX
	R0=C.F	A		R0->:new IDNT
	A=A+A	A
	C=C+A	A
	D0=C
	D0=D0+	4		D0->:obj IDNT
	A=DAT0	A		A[A]:prologue

** Trap $MESSAGE parameter.
	C=C+C	S
	GOC	messg00
	GOTO	$confg?

ABORTFF	C=RSTK
	D1=C
ABORT00	GOTO	nextset

messg00	LC(5)	=DOLIST
	?A#C	A
	GOYES	ABORT00
	C=R4.F	A
	C=C+CON	A,5
	CD1EX
	RSTK=C			RSTK:1:		(SAVE D1	)
	A=DAT1	A
	?A=0	A
	GOYES	ABORTFF
	CD1EX
	A=A+C	A
	LC(5)	20
	C=C+A	A
	RSTK=C			RSTK:1:2:	(SAVE ->ELEMENTS)
	D1=C
	C=DAT1	A		C[A]:elements
	CBEX	A
	RSTK=C			RSTK:1:2:3:	(SAVE B[A]	)
	C=B	A
	D0=D0+	5		D0->:1st list
	D1=D1+	5		D1->:elements
	B=B-1	A
	GOC	messg02
	RSTK=C			RSTK:1:2:3:4:	(SAVE ELEMENTS	)

messg01	A=DAT1	A	<-------
	CD1EX			|
	C=C+A	A		|
	D1=C			|
	B=B-1	A		|
	GONC	messg01	 ------->
	C=RSTK			RSTK:1:2:3:	(RESTORE ELEMENTS)
messg02	B=C	A

set_mesg
	A=DAT0	A
	LC(5)	=SEMI
	?A=C	A
	GOYES	SETELEM
	LC(5)	=DOCSTR
	?A#C	A
	GOYES	NEXTSTR
	B=B+1	A
	D0=D0+	5
	C=DAT0	A
	GOSBVL	=MOVEDOWN
	GOTO	set_mesg

NEXTSTR	GOSBVL	=SKIPOB
	GOTO	set_mesg

SETELEM	C=RSTK			RSTK:1:2:	(RESTORE B[A]	)
	CBEX	A
	A=C	A
	C=RSTK			RSTK:1:		(RESTORE ->ELEMS)
	D1=C
	DAT1=A	A		D1-->elements
	C=RSTK			RSTK:		(RESTORE D1	)
	D1=C

ABORT01	GOTO	nextset

** Trap $CONFIG  parameter.
$confg?	C=C+C	S
	GONC	$title?
	?ST=1	sCONFIG
	GOYES	ABORT01
	LC(5)	=DOCOL
	?A#C	A
	GOYES	ABORT01
	ST=1	sCONFIG
	C=R4.F	A
	CD1EX
	RSTK=C			RSTK:1:
	D1=D1+	15
	C=D	A
	DAT1=C	A		cache output!
	D1=D1+	5
	C=B	A
	R2=C.F	A		save rrp PATH
	B=0	A		B[A]:new SECO
	GOTO	config!

** Trap $TITLE   parameter.
$title?	C=C+C	S
	GONC	ABORT02
	?ST=1	sTITLE
	GOYES	ABORT02
	LC(5)	=DOCSTR
	?A#C	A
	GOYES	ABORT02
	ST=1	sTITLE
	D0=D0+	5
	A=DAT0	A
	CD0EX
	C=C+A	A
	D0=C
	A=A-CON	A,5
	?A=0	A
	GOYES	ABORT02
	C=R4.F	A
	CD1EX
	RSTK=C			RSTK:1:2:
	D1=D1-	5
	C=A	A
	CBIT=0	0
	GOSBVL	=MOVEUP		RSTK:1:2:3:
	C=RSTK
	D1=C

ABORT02	GOTO	nextset

CONFIG!	LC(5)	=DOCOL
	?A=C	A
	GOYES	config!
	LC(3)	=DOLIST
	?A=C	A
	GOYES	config!
	LC(2)	=DOSYMB
	?A=C	A
	GOYES	config!
	LC(3)	=DOIDNT
	?A=C	A
	GOYES	IDNTCON

SET_CON	CD0EX
	RSTK=C
	D0=C
	GOSBVL	=SKIPOB
	AD0EX
	C=RSTK
	D0=C
	C=A-C	A
	GOSBVL	=MOVEDOWN
END_CON	?B#0	A
	GOYES	THEEND?
	GOTO	bailcon

config!	DAT1=A	A
	B=B+1	A

NEXTCON	D0=D0+	5
	D1=D1+	5

THEEND?	LC(5)	=SEMI
	A=DAT0	A
	?A#C	A
	GOYES	CONFIG!
	DAT1=A	A
	B=B-1	A
	?B#0	A
	GOYES	NEXTCON
bailcon	C=RSTK
	D1=C
	A=R2.F	X		save rrp PATH
	B=A	X
	C=R4.F	A
	D0=C
	D0=D0+	15
	C=DAT0	A
	D=C	A
	LC(5)	5
	DAT0=C	A
	GOTO	nextset

** HERE D0->:object's PROLOGUE, D1->:new HASH, R0->:new IDNT
**      R1->:(save above here), R2->:rrp PATH, R3->:1st HASH
IDNTCON	C=R0.F	A
	D0=D0+	5
	CD0EX			D0->:new IDNT
	R1=C.F	A		R1->:run BYTE
	C=R3.F	A
	CD1EX
	D=C	A
	C=R2.F	X
	BCEX	A		B[A]:rrp PATH
	RSTK=C			save new SECO
	GOSUBL	1stID.2
	C=RSTK
	B=C	A		B[A]:new SECO
	A=R1.F	A
	D0=A			D0->:run BYTE
	GOC	setNAME
	C=0	A		\
	C=DAT0	B		\
	C=C+1	A		 skip
	C=C+C	A		 IDNT
	A=A+C	A		/
	D0=A			/
	A=DAT1	A
	ASL	W		A[5-0]:xxx*s0
	C=R4.F	A
	D1=C
	D1=D1-	3
	A=DAT1	X		A[5-0]:xxxhhh
	C=D	A
	D1=C
	LC(5)	=DOROMP
	DAT1=C	A
	D1=D1+	5
	DAT1=A	6
	D1=D1+	6
	GOTO	END_CON
setNAME	C=D	A
	D1=C
	LC(5)	=DOIDNT
	DAT1=C	A
	D1=D1+	5
	C=0	A
	C=DAT0	B
	C=C+1	A
	C=C+C	A
	GOSBVL	=MOVEDOWN
	GOTO	END_CON

** Compute and set library CRC.
SET_CRC	GOSBVL	=GETPTR
	D1=D1+	5
	A=DAT1	A
	D0=A
	D0=D0+	5
	A=DAT0	A
	A=A-CON	A,4
	GOSBVL	=DoCRC
	DAT0=A	4

** Restore RPL, drop HASH, and loop.
	LC(5)	=DROP
	GOVLNG	=GETPTREVALC
dtolibend
  ENDCODE
;
**********************************************************************

