
*  TITLE Pro-Tools Library Library Splitter, Version 3.0
** PROUIRRP.S ***************************************************
*
* This is the Pro-Tools' Library library splitter module.
*
****************************************************************

       STITLE Pro-Tools Library Splitter Equates, Version 3.0
****************************************************************
*
* These are the necessary library splitter equate statements.
*
****************************************************************
RPL
ASSEMBLE
sBRANCH		EQU     9
sCONF		EQU     8
RPL

       STITLE Library-to-Directory Conversion, Version 1.0
** begin LIB->DIR ***********************************************
*
* NAME: LIB->DIR
*
* ENTRY: library
*
* EXIT: rrp
*
* ABSTRACT: Converts a library to a directory data structure.
*
* MODULE HISTORY:
*
* 30.10.93 Rick Grevelle
*	Rewritten
* 08.01.95 Will Laughlin
*	Fixed CONFIG bug, ID's created for ROMPTR's in $CONFIG
*	Packed code for writing field size
*	Packed code for reloading R0
* 09.06.96 Mika Heiskanen
*	Added HACK library special features
*	Made to work from covered ports
*
* DETAIL:
*
*               Example HASH TABLE Structure
*               ############################
*
*               02A4E                   prolog
*               lllll                   length
*               hhh                     $ROMID
*               hhh                     #XLIBs
*               hhh                     #IDNTs
*
*
*****************************************************************
ASSEMBLE
	CON(1)	8
RPL
xNAME L\8DDIR
::
  CK1

  ( Check possible arguments )

  DUPTYPEREAL? IT COERCE		( %lid --> #lid )
  DUPTYPEHSTR? IT HXS>#			( hxs_lid --> #lid )

  ( Now if #lid then try to fetch that library )

  DUPTYPEBINT? IT
  :: UNCOERCE "&" >TAG xXRCL ;		( Find & recall library )

  ( Now we should have a library )

  NOTLIBcase SETTYPEERR

  NULLHXS NINE EXPAND			( Make data storage )

  CODE
		GOSBVL	=SAVPTR

		CLRST

		A=0	W
		B=0	W
		C=0	W
		D=0	W

		C=DAT1	A
		C=C+CON A,10
		D0=C			D0->:LINK entries

** Compute $TITLE nibbles.
		D1=D1+	5
		A=DAT1	A
		D1=A
		D1=D1+	10
		C=0	A
		C=DAT1	B
		D1=D1+	2
		?C=0	B
		GOYES	+
		C=C+C	A
		AD1EX
		A=A+C	A
		D1=A
		D1=D1+	2
+		D=C	A		D[A]:$TITLE bytes

** Record $ROMID integer.
		C=DAT1	X
		DAT0=C	X		set library ROMID
		D0=D0+	3
		D1=D1+	3

** Attempt HASH start.
		CD1EX
		R4=C			R4->:table offset
		C=C+CON A,10
		D1=C			D1->:LINK's field
		A=DAT1	A
		?A#0	A		LINK table exist?
		GOYES	+
		GOTO	$config		NO, check $CONFIG

** Trap invalid LINK prologue.
+		C=C+A	A
		D1=C
		C=C+CON A,10
		R3=C	A		R3->:LINK's start
		A=DAT1	A
		LC(5)	=DOHSTR
		?A=C	A		LINK table valid?
		GOYES	+
		GOTO	$config		NO, check $CONFIG

** Trap empty LINK.
+		D1=D1+	5
		C=DAT1	A		C[A]:length field
		C=C-CON A,5
		?C#0	A
		GOYES	+
		GOTO	$config

** Compute LINK entries.
+		D=D+C	A		D[A]:+rrp offsets
		CDEX	A
		RSTK=C
		C=D	A
		GOSBVL	=DIV5		C[A]:number XLIBs
		DAT0=C	X		record the number
		R2=C			save loop counter
		C=RSTK
		D=C	A
		D0=D0+	3
		C=0	A
		LC(2)	35		C[A]:$VISIBLE+{ }
		D=D+C	A

** Attempt HASH start.
		C=R4
		D1=C			D1->:HASH's field
		A=DAT1	A
		?A#0	A		HASH table exist?
		GOYES	+
		GOTO	initlibsum	NO, check $CONFIG

** Trap invalid HASH prologue.
+		C=C+A	A
		D1=C
		A=DAT1	A
		LC(5)	=DOHSTR
		?A=C	A		HASH table valid?
		GOYES	+
		GOTO	initlibsum	NO, check $CONFIG

** Trap empty HASH.
+		D1=D1+	5
		A=DAT1	A		C[A]:length field
		C=0	A
		LC(2)	90
		?A<=C	A		HASH empty table?
		GOYES	initlibsum	YES

** Trap empty offset field.
		B=A	A
		AD1EX
		B=B+A	A
		C=C-CON A,5		C[A]:85
		C=C+A	A
		D1=C			D1->:field offset
		A=DAT1	A
		?A=0	A		HASH table entry?
		GOYES	initlibsum	NO

** Trap bad offset field.
		C=C+A	A
		R1=C			R1->:HASH's start
		D1=C
		B=B-C	A
		GOC	initlibsum	fucked up tables?

** Compute HASH entries.
		C=B	A
		CDEX	A
		RSTK=C
		C=D	A
		GOSBVL	=DIV5		C[A]:number NAMES

		DAT0=C	X		record the number
		C=RSTK
		D=C	A
** Initialize main loop.
initlibsum	C=DAT0	X
		B=C	A
		C=R2
		C=C-B	A
		RSTK=C
		D0=D0-	6
		GOSUBL	loadlibvars
		CR3EX	W		R3->:[ |IDNTs|ROMID]
		D0=C
*		ST=0	sBRANCH
		GOTO	init#00

       STITLE , Version 1.0
**begin LIBSUMLOOP ************************************************
*
* NAME: LIBSUMLOOP
*
* CATEGORY: Memory
*
* ENTRY: D0->:LINK's offset field
*	 D1->:HASH's offset field
*
* EXIT: 
*
* CALLS: NewRrpObj
*
* REGISTERS: 
*
****************************************************************
LIBSUMLOOP	?ST=1	sBRANCH
		GOYES	libgeneric
		C=DAT1	A
		?C=0	A
		GOYES	libpaddadj
		AD1EX
		C=A-C	A
		D1=C
		C=0	A
		C=DAT1	B
		C=C+1	A
		C=C+C	A
		C=C+C	A
		C=C+CON A,7
		D=D+C	A
		D1=A
		D1=D1+	5
		GOTO	NewRrpObj

libgeneric	D=D+CON A,12		D[A]:add LIBGENERIC
		GOTO	NewRrpObj

libpaddadj	C=0	A
		LC(2)	24		C[A]:($NULL)+5
		D=D+C	A
		D0=D0+	5
		D1=D1+	5
		GONC	init#00
		GOC	libnewjmp

libsumcont 	?ST=1	sCONF
		GOYES	libnewjmp
		C=RSTK
		D0=C
		D0=D0+	5

init#00		B=B-1	X
		GONC	LIBSUMLOOP
		?ST=1	sBRANCH
		GOYES	$config
		ST=1	sBRANCH
		C=RSTK
		B=C	X
		GONC	init#00

** Attempt to add $CONFIG.
$config		C=R4
		C=C+CON A,15
		D0=C			D1->:CONFIG field
		A=DAT0	A
		?A=0	A		no configuration?
		GOYES	$messag
		C=C+A	A
		D0=C
		A=DAT0	A
		LC(5)	=DOCOL
		?A#C	A
		GOYES	$messag
		ST=1	sCONF
		GOTO	NewRrpObj.1

libnewjmp	C=0	A
		LC(2)	23		C[A]:add $CONFIG
		D=D+C	A

** Attempt to add $MESSAGE.
$messag		C=R4
		C=C+CON A,5
		D0=C			D1->:ARRAY field
		A=DAT0	A
		?A=0	A		no message array?
		GOYES	messagok
		C=C+A	A
		D0=C
		A=DAT0	A
		LC(5)	=DOARRY
		?A#C	A
		GOYES	messagok
		D0=D0+	10
		A=DAT0	A
		LC(5)	=DOCSTR
		?A#C	A
		GOYES	messagok
		D0=D0+	5
		C=DAT0	A		C[A]:#dimensions
		C=C-1	A
		GOC	messagok
		RSTK=C
		D0=D0+	5		D0->:dimension N
		A=DAT0	A
		B=A	A

-		D0=D0+	5
		C=RSTK
		C=C-1	A
		GOC	+
		RSTK=C
		C=DAT0	A
		GOSUB	multi00
		A=B	A		A[A]:accumulator
		GOTO	-

-		C=DAT0	A
		D=D+C	A
		D=D+CON A,5
		AD0EX	A
		A=A+C	A
		D0=A
+		B=B-1	A
		GONC	-
		C=0	A
		LC(2)	35
		D=D+C	A
messagok

** Add extra overhead

		C=0	A
		LC(2)	78		C[A]:RRP support
		C=C+D	A

       STITLE Initialize Directory Object, Version 1.0
*begin MAKERRP ************************************************
*
* NAME: MAKERRP
*
* ENTRY: C[A]:nibbles needed to support library!
*
* EXIT:
*
* CALLS:
*
* TRASHES:
*
* ABSTRACT:
*
* STACK LEVELS:
*
* MODULE HISTORY:
*
* Written			11/08/93	Rick Grevelle
*
****************************************************************
MAKERRP		R3=C	A		Save needed memory
-		GOSBVL	=CREATETEMP
		GONC	+
		?ST=1	sGARBAGE
		GOYES	mkrrper
		GOSUB	mkrrp:
		CON(5)	=DOCOL
		CON(5)	=GARBAGE
		CON(5)	=COLA
		CON(5)	=DOCODE
		REL(5)	ltodirend
		GOSBVL	=SAVPTR
		ST=1	sGARBAGE
		C=R3	A
		GOTO	-
mkrrper		GOVLNG	=GPMEMERR
mkrrp:		C=RSTK
		GOVLNG	=GETPTREVALC

** Initialize library object.
+		LC(5)	=DORRP
		DAT0=C	A
		AD0EX
		D0=A
		D0=D0+	5
		C=0	W
		LC(3)	#7FF
		DAT0=C	W

** Push directory onto data stack.
		GOSBVL	=GETPTR
		C=DAT1	A
		R0=C
		D1=D1+	5
		C=DAT1	A
		D0=C
		D0=D0+	10		D0->:TITLE byte
		DAT1=A	A		D1-->DIRECTORY!
		C=0	A
		LC(2)	18
		C=C+A	A
		D=C	A		D[A]:top output
		A=A+CON A,8
		R3=A			R3->:1st offset

** Set $TITLE IDNT.
		D1=C
		LC(2)	6
		A=C	B
		DAT1=A	B
		D1=D1+	2
		LCSTR	\$TITLE\
		DAT1=C	12
		D1=D1+	12
		DAT1=A	B
		D1=D1+	2
		LC(5)	=DOCSTR
		DAT1=C	A
		D1=D1+	5

** Compute $TITLE nibbles.
		A=0	A
		A=DAT0	B
		D0=D0+	2
		?A#0	B
		GOYES	+
		C=0	A
		LC(1)	5
		DAT1=C	A
		D1=D1+	5
		GONC	++

** Set $TITLE ASCII.
+		A=A+A	A
		C=A	A
		A=A+CON A,5
		DAT1=A	A
		D1=D1+	5
		GOSBVL	=MOVEDOWN
		D0=D0+	2
++

** Set link field.
		GOSUB	SetRrpLink

** Set $ROMID IDNT.
		LC(2)	6
		A=C	B
		DAT1=A	B
		D1=D1+	2
		LCSTR	\$ROMID\
		DAT1=C	12
		D1=D1+	12
		DAT1=A	B
		D1=D1+	2
		LC(5)	=DOHSTR
		DAT1=C	A
		D1=D1+	5
		C=0	A
		LC(1)	8
		DAT1=C	A
		D1=D1+	5

** Set $ROMID HEX.
		C=DAT0	X
		DAT1=C	X		set library ROMID
		D1=D1+	3
		D0=D0+	3
		CD0EX
		R4=C			R4->:table offset
		R2=C

** Test for $MESSAGE.

		C=C+CON A,5		(old code had 15?)
		D0=C
		A=DAT0	A
		?A#0	A
		GOYES	+
		GOTO	$VISIBL

+		C=C+A	A
		D0=C			D0->:ARRAY field
** Set link field For $ROMID
		GOSUB	SetRrpLink

** Set $MESSAGE IDNT.
		LC(2)	8
		A=C	B
		DAT1=A	B
		D1=D1+	2
		LCSTR	\$MESSAGE\
		DAT1=C	16
		D1=D1+	16
		DAT1=A	B
		D1=D1+	2
		LC(5)	=DOLIST
		DAT1=C	A
		D1=D1+	5

** Set $MESSAGE ASCII.
		D0=D0+	15
		C=DAT0	A		C[A]:#dimensions
		C=C-1	A
		GOC	$VISIBL
		RSTK=C
		D0=D0+	5		D0->:dimension N
		A=DAT0	A
		B=A	A

-		D0=D0+	5
		C=RSTK
		C=C-1	A
		GOC	+
		RSTK=C
		C=DAT0	A
		GOSUB	multi00
		A=B	A		A[A]:accumulator
		GOTO	-

-		LC(5)	=DOCSTR
		DAT1=C	A
		D1=D1+	5
		C=DAT0	A
		GOSBVL	=MOVEDOWN
+		B=B-1	A
		GONC	-
		LC(5)	=SEMI
		DAT1=C	A
		D1=D1+	5

** Test for LINK.
$VISIBL 	C=R0
		D0=C
		D0=D0+	13
		C=DAT0	X
		?C#0	X
		GOYES	+
		GOTO	initrrp		NO XLIBs found!

** Set link field for $ROMID or $MESSAGE
+		GOSUB	SetRrpLink

** Set $VISIBLE IDNT.
		LC(2)	8
		A=C	B
		DAT1=A	B
		D1=D1+	2
		LCSTR	\$VISIBLE\
		DAT1=C	16
		D1=D1+	16
		DAT1=A	B
		D1=D1+	2
		LC(5)	=DOLIST
		DAT1=C	A
		D1=D1+	5

** Test for HASH.
		D0=D0+	3
		C=DAT0	X
		C=C-1	X
		GONC	+
		GOTO	endvisi		NO IDNTs found!

** Set $VISIBLE ASCII.
+		B=C	X
		A=R4
		D0=A
		C=DAT0	A
		A=A+C	A
		C=0	A
		LC(2)	90
		A=A+C	A
		D0=A
		C=DAT0	A
		A=A+C	A
		R1=A			R1->:HASH's offset field
		D0=A

** Set IDNTs loop.
--		A=DAT0	A	<-------
		?A=0	A		|
		GOYES	ENDVISI		|
		CD0EX			|
		RSTK=C			|
		C=C-A	A		|
		D0=C			|
		LC(5)	=DOIDNT		|
		DAT1=C	A		|
		D1=D1+	5		|
		C=0	A		|
		C=DAT0	B		|
		DAT1=C	B		|
		D0=D0+	2		|
		D1=D1+	2		|
		C=C+C	A		|
		GOSBVL	=MOVEDOWN	|
		C=RSTK			|
		D0=C			|
hook#00		D0=D0+	5		|
		B=B-1	X		|
		GONC	--	-------->

endvisi		LC(5)	=SEMI
		DAT1=C	A
		D1=D1+	5
		GOTO	initrrp

ENDVISI		LC(5)	=SEMI
		DAT1=C	A
		D1=D1+	5

** Set link field.
		GOSUB	SetRrpLink

** Set $NULL IDNT.
		LC(2)	5		*DETLEF*
		A=C	B
		DAT1=A	B
		D1=D1+	2
		LCSTR	\$NULL\		*DETLEF*
		DAT1=C	10		*DETLEF*
		D1=D1+	10		*DETLEF*
		DAT1=A	B
		D1=D1+	2
		LC(5)	=DOLIST
		DAT1=C	A
		D1=D1+	5
		GOTO	hook#00

initrrp		C=R0
		D0=C
		D0=D0+	10

		GOSUB	loadlibvars
		A=C	W
		D0=D0+	3
		A=DAT0	X
		B=A	W
		D0=D0+	3
		A=DAT0	X
		B=B-A	X
		CR4EX			R4->:[   |IDNTs|ROMID]
		C=C+CON A,10
		D0=C
		A=DAT0	A
		C=C+A	A
		D0=C
		D0=D0+	5
		A=DAT0	A
		C=C+A	A
		RSTK=C			RSTK:->terminal LINK entry
		ST=0	sBRANCH

** Test for $CONFIG.
		C=R2
		C=C+CON A,15
		D0=C
		A=DAT0	A
		?A=0	A
		GOYES	libout
		C=C+A	A
		D0=C			D0->:configuration
		LC(5)	=DOCOL
		A=DAT0	A
		?A#C	A
		GOYES	libout
** Set link field for $VISIBL
		GOSUB	SetRrpLink

** Set $CONFIG IDNT.

		LC(2)	7
		A=C	B
		DAT1=A	B
		D1=D1+	2
		LCSTR	\$CONFIG\
		DAT1=C	14
		D1=D1+	14
		DAT1=A	B
		D1=D1+	2
	
** Set $CONFIG HEX.
		GOTO	SET_VAR

libout		C=RSTK
		D0=C
		ST=0	sCONF
		GOTO	INIT#00


       STITLE , Version 1.0
** begin SET_RRP ************************************************
*
* NAME: SET_RRP
*
* CATEGORY: Memory
*
* ENTRY: D0->:terminal LINK entry
*	 D1->:RRP current output!
*	 R0->:[     |XLIBs|ROMID]
*	 R1->:HASH's offset field
*	 R4->:[	    |IDNTs|ROMID]
*
* EXIT: 
*
* CALLS: SET_VAR
*
* REGISTERS: 
*
*****************************************************************
SET_RRP 	GOSUB	SetRrpLink
		?ST=1	sBRANCH
		GOYES	SETIDNT

** Set GENERIC IDNTs.
		LC(4)	#7804		(\x\*256)+4
		DAT1=C	4
		D1=D1+	4
		P=	15
		LC(1)	2
		P=	0
		A=B	M
		ASR	W
		ASR	W
		ASR	W
		A=A+B	X
		ASRC	W
		ASRC	W
		ASRC	W
setNULL		A=0	B
		ASLC	W
		LCASC	'0'
		A=A+C	B
		LCASC	'9'
		?C>=A	B
		GOYES	setCHAR
		A=A+CON B,7
setCHAR		DAT1=A	B
		D1=D1+	2
		C=C-1	S
		GONC	setNULL
		LC(2)	4
		DAT1=C	B
		D1=D1+	2

** Set variable.
		A=DAT0	A
		CD0EX
		RSTK=C
		C=C+A	A
		D0=C
		GOTO	SET_VAR

** Set IDNTs.
SETIDNT		A=0	A
		A=B	X
		C=R1
		C=C+A	A
		A=A+A	A
		A=A+A	A
		C=C+A	A
		A=C	A
		CD0EX
		RSTK=C
		C=DAT0	A
		C=A-C	A
		D0=C
		C=0	A
		C=DAT0	B
		DAT1=C	B
		D1=D1+	2
		D0=D0+	2
		RSTK=C
		C=C+C	A
		GOSBVL	=MOVEDOWN
		C=RSTK
		DAT1=C	B
		D1=D1+	2
		C=RSTK
		D0=C
		
** Set variable.
		A=DAT0	A
		RSTK=C
		C=C+A	A
		D0=C
		GOTO	SET_VAR
-		GOTO	libout

set_rrp 	?ST=1	sCONF
		GOYES	-
		C=RSTK
		D0=C
		?ST=1	sBRANCH
		GOYES	set_rrp_lp
		D0=D0-	5

INIT#00		B=B-1	X
		GOC	+
		GOTO	SET_RRP
+		ST=1	sBRANCH
		BSR	W
		BSR	W
		BSR	W
		GOTO	+

set_rrp_lp	D0=D0-	5
+		B=B-1	X
		GOC	setMAIN
		C=DAT0	A
		?C=0	A
		GOYES	set_rrp_lp
		GOTO	SET_RRP

setMAIN		A=R3
		D1=A
		C=D	A
		C=C-A	A
		DAT1=C	A
		GOSBVL	=GETPTR
		D1=D1+	5
		D=D+1	A
		LOOP


       STITLE Short Integer Multiplication, Version 1.0
** begin multi00 ************************************************
*
* NAME: multi00
*
* CATEGORY: Arithmetic
*
* ENTRY: A[A]:multiplicand
*	 C[A]:multiplicand
*
* EXIT: B[A]:product
*
* CALLS: None
*
* REGISTERS: A[A], B[A], and C[A]
*
*****************************************************************
multi00		B=0	A
		?A#0	A
		GOYES	multi01
		RTN
multi01		?CBIT=0 0
		GOYES	multi02
		B=A+B	A
		RTNC
		CBIT=0	0
multi02		?C#0	A
		GOYES	multi03
		RTN
multi03		CSRB.F	A
		A=A+A	A
		GONC	multi01
		RTN


       STITLE , Version 1.0
** begin NewRrpObj *********************************************
*
* NAME: NewRrpObj
*
* CATEGORY: Memory
*
* ENTRY: D0->:object
*	 R0->:[    |XLIBs|ROMID]
*	 R1->:HASH's offset field
*	 R3->:[	   |IDNTs|ROMID]
*
* EXIT:
*
* CALLS: SKIPOB
*
* REGISTERS:
*
*****************************************************************
NewRrpObj	A=DAT0	A
		CD0EX
		RSTK=C
		C=C+A	A
		D0=C
NewRrpObj.1	C=B	X
		R2=C
		B=0	A
		A=DAT0	A


NewObjLoop	LC(5)	=DOCOL
		?A=C	A
		GOYES	NewObjComp
		LC(3)	=DOLIST
		?A=C	A
		GOYES	NewObjComp
		LC(2)	=DOSYMB
		?A=C	A
		GOYES	NewObjComp
		LC(3)	=DOROMP
		?A=C	A
		GOYES	NewObjRomp
		CD0EX
		RSTK=C
		D0=C
		GOSBVL	=SKIPOB
		AD0EX
		C=RSTK
		D0=A
		C=A-C	A
		D=D+C	A
NewObjCont	?B#0	A
		GOYES	NewObFinish?
		C=R2
		B=C	X
		GOTO	libsumcont
NewObjComp 	B=B+1	A
NewObjNext	D0=D0+	5
		D=D+CON A,5

NewObFinish?	LC(5)	=SEMI
		A=DAT0	A
		?A#C	A
		GOYES	NewObjLoop
		B=B-1	A
		?B#0	A
		GOYES	NewObjNext
		D=D+CON A,5
		C=R2			save rrp PATH
		B=C	X
		GOTO	libsumcont

NewObjRomp	D0=D0+	5
		D=D+CON A,5
		C=R0
		A=0	W
		A=DAT0	6
		?A#C	X
		GOYES	addnewxlib
		?A>=C	M
		GOYES	addnewxlib
		C=R3
		?A>=C	M
		GOYES	addnewnull
		D0=D0+	3
		A=0	A
		A=DAT0	X
		C=R1
		C=C+A	A
		A=A+A	A
		A=A+A	A
		C=C+A	A
		A=C	A
		CD0EX
		RSTK=C
		C=DAT0	A
		C=A-C	A
		D0=C
		C=0	A
		C=DAT0	B
		C=C+1	A
		C=C+C	A
		D=D+C	A
		C=RSTK
		D0=C
		D0=D0+	3
		GOTO	NewObjCont
addnewnull	D=D+CON A,4
addnewxlib	D=D+CON A,6
		D0=D0+	6
		GOTO	NewObjCont

       STITLE , Version 1.0
** begin SET_VAR ************************************************
*
* NAME: SET_VAR
*
* CATEGORY: Memory
*
* ENTRY: D0->:object
*	 R0->:[	    |XLIBs|ROMID]
*	 R1->:HASH's offset field
*
* EXIT:
*
* CALLS: SKIPOB
*
* REGISTERS:
*
*****************************************************************
SET_VAR 	C=B	W
		R2=C
		B=0	A
		A=DAT0	A

set_var_loop	LC(5)	=DOCOL
		?A=C	A
		GOYES	set_var_comp
		LC(3)	=DOLIST
		?A=C	A
		GOYES	set_var_comp
		LC(2)	=DOSYMB
		?A=C	A
		GOYES	set_var_comp
		LC(3)	=DOROMP
		?A=C	A
		GOYES	set_var_romp
		CD0EX
		RSTK=C
		D0=C
		GOSBVL	=SKIPOB
		AD0EX
		C=RSTK
		D0=C
		C=A-C	A
		GOSBVL	=MOVEDOWN
set_var_cont	?B#0	A
		GOYES	set_var_fin?
		C=R2			save rrp PATH
		B=C	W
		GOTO	set_rrp
set_var_comp 	DAT1=A	A
		B=B+1	A

set_var_next	D0=D0+	5
		D1=D1+	5

set_var_fin?	LC(5)	=SEMI
		A=DAT0	A
		?A#C	A
		GOYES	set_var_loop
	
		DAT1=A	A
		B=B-1	A
		?B#0	A
		GOYES	set_var_next
		D1=D1+	5
		C=R2			save rrp PATH
		B=C	W
		GOTO	set_rrp

* HERE D0->:object's PROLOGUE, R0->:[   |XLIBs|ROMID],
*      D1->:output!	     , R1->:HASH's offset field,
*			     , R4->:[   |IDNTs|ROMID].

set_var_romp	D0=D0+	5
		C=R0
		A=0	W
		A=DAT0	6
		?A#C	X
		GOYES	setxlib
		?A>=C	M
		GOYES	setxlib
		C=R4
		?A>=C	M
		GOYES	setnull
		LC(5)	=DOIDNT
		DAT1=C	A
		D1=D1+	5
		D0=D0+	3
		A=0	A
		A=DAT0	X
		C=R1
		C=C+A	A
		A=A+A	A
		A=A+A	A
		C=C+A	A
		A=C	A
		CD0EX
		RSTK=C
		C=DAT0	A
		C=A-C	A
		D0=C
		C=0	A
		C=DAT0	B
		DAT1=C	B
		D1=D1+	2
		D0=D0+	2
		C=C+C	A
		GOSBVL	=MOVEDOWN
		C=RSTK
		D0=C
		D0=D0+	3
		GOTO	set_var_cont

setxlib		LC(5)	=DOROMP
		DAT1=C	A
		D1=D1+	5
		DAT1=A	6
		D1=D1+	6
		D0=D0+	6
		GOTO	set_var_cont 
	
setnull		LC(5)	=DOIDNT
		DAT1=C	A
		D1=D1+	5
		LC(4)	#7804		(\x\*256)+4
		DAT1=C	4
		D1=D1+	4
		P=	15
		LC(1)	16-3
		P=	0
		D0=D0+	5
setloop		A=0	B
		A=DAT0	1
		LCASC	'0'
		A=A+C	B
		LCASC	'9'
		?C>=A	B
		GOYES	setchar
		A=A+CON B,7
setchar		DAT1=A	B
		D1=D1+	2
		D0=D0-	1
		C=C+1	S
		GONC	setloop
		D0=D0+	4
		GOTO	set_var_cont

SetRrpLink	AD1EX
		D1=A
		C=D	A
		C=A-C	A
		DAT1=C	A
		D1=D1+	5
		CD1EX
		D=C	A		D[A]:Nth output
		D1=C
		RTN

loadlibvars	C=0	W
		C=DAT0	6
		R0=C			R0->:[	   |XLIBs|ROMID]
		C=DAT0	9
		CSR	M
		CSR	M
		CSR	M
		RTN
ltodirend
  ENDCODE
;
**********************************************************************
