*	TITLE Multi-Row Peek Poke Memory Scanner, Version 1.3
** begin scan ***************************************************
*****************************************************************
**
** NAME: SC
**
** CATEGORY: Memory
**
** ENTRY: ADISP
**
** EXIT: -
**                    
** CALLS: SAVPTR, CINRTN, AllowIntr, GETPTRLOOP.
**
** ABSTRACT: Maybe later.
**
** MODULE HISTORY:
**
** 06.08.93 Rick Grevelle
**	Written
** 03.09.93 Rick Grevelle
**	Optimized
** 09.09.93 Detlef Mueller
**	Reviewed
** 04.02.94 Mika Heiskanen
**	Merged display loops
**	Minor speedups and packs
**	Added new keys
** 04.03.94 Mika Heiskanen
**	Optimized, fixed a key
** 09.06.96 Mika Heiskanen
**	Fixed to use object address if no address is given
**	Fixed the skip key [y^x]
**
*****************************************************************
*****************************************************************
ASSEMBLE
scCURSOR		EQU 3
scASCII		EQU 4
scALPHA		EQU 5
scPRESS		EQU 6
onerow		EQU 34	number of nibbles per row
dblp		EQU 6	6 passes with BITMAP stable
RPL

ASSEMBLE
	CON(1)	8
RPL
xNAME SC
::
  DEPTH ZERO #=ITE #100		( view dump at #100 when empty	)

  ::
    DUPTYPEBINT? ?SEMI		( provide user dump start hook	)
    DUPTYPEHSTR? case HXS>#	( ... )
    TRUE
  ;

  FNT2				( UFL medium font set )
  RECLAIMDISP TURNMENUOFF	( access entire display		)

* Register allocation:
*	[A]		[A1]		[A2]		[S]
* R0	scratch for CMPT/WaitScanKey
* R1
* R2	->cursor	
* R3	->display
* R4	->font
* D0	->memory

CODE

** Pop font
	A=DAT1	A
	D1=D1+	5
	D=D+1	A
	A=A+CON	A,10
	R4=A			* R4[A] = ->font

** Pop dump address
	GOSBVL	=popflag	* A[A] = ->object
	GONC	+		* Not TRUE - must be #address then
	GOSBVL	=PopASavptr
	GONC	++
+	GOSBVL	=SAVPTR
	D0=A
	D0=D0+	5
	A=DAT0	A
++	R2=A	A		* R2[A] = ->cursor address

** Initialize display start address
	GOSBVL	=D0->Row1
	R3=A	A		* R3[A] = ->display

** Setup flags
	CLRST			initialize default
	ST=0	scPRESS		Assume no key is down

** Start main loop
	A=R2
	D0=A			* D0 = ->memory start address
** Main memory scanner loop.
scanmem	INTOFF			disables interupts
	ST=0	15
	CD0EX			\
	RSTK=C			 save memory start
	D0=C			/
	GOSUB	dispdmp		update the display
	C=RSTK
	D0=C			D0->:memory starts
	GOSUB	WaitScanKey	B[B] = key
	GOC	ExScan
	GOSUB	DoTabKey
	GOTO	scanmem

ExScan	GOSUB	busyon
	GOSBVL	=AllowIntr
	GOVLNG	=GETPTRLOOP

**********************************************************************
* Name:		WaitScanKey
**********************************************************************
WaitScanKey

** Setup key repeat speed / delay
	D1=(5)	=TIMERCTRL.1	[SRQ WKE INT XTRA]
	LC(1)	4		[ 0   1   0   0  ]
	DAT1=C	1
	D1=(2)	=TIMER1
	LC(1)	5		6/16 second delay
	?ST=0	scPRESS
	GOYES	settim1
	LC(1)	0		Minimum delay for repeat speed
*	C=DAT1	B		Advance based on last timer value
*	C=C+1	P
*	GOC	settim1
*	LC(1)	#F
settim1	DAT1=C	1
	LC(3)	=allkeys
	OUT=C			loads all keyboard
**	******
	SHUTDN			WAIT FOR INTERUPTS
**	******
	D1=(2)	=TIMERCTRL.1
** Trap illegitimate wakeups.
enough?	GOSBVL	=BITMAP
	RTNC			Carry if ON key down
	?A=0	W		catch no keys down
	GOYES	sctimeout
	C=DAT1	B
	?CBIT=0	3		legitimate wakeup?
	GOYES	enough?		NO, keep checking!
	B=A	W
	ST=1	scPRESS		Flag repeat is ok
	GOTO	count00

** Set 10 minute timeout
sctimeout
	D1=(5)	=ANNCTRL
	C=DAT1	B		C[B]:[AON XTRA io busy alarm alpha -> <-]
	CBIT=0	4		C[B]:[ *    *  *   0     *     *   *  * ]
	DAT1=C	B		turn off busy annunciator
	CD0EX
	RSTK=C			RSTK = ->memory
	GOSBVL	=GetTimChk
	A=0	W
	LA(6)	10*60*8192	10 minute timeout
*	LA(6)	10*8192		10 second timeout
	A=A+C	W
	GOSBVL	=WrtTIMEOUTA
	C=ST	X
	RSTK=C			RSTK = ->st ->memory
	CLRST			Clear sCLKON
	GOSBVL	=CMPT		Setup timeout/alarm wakeup
	C=RSTK
	ST=C	X
	C=RSTK
	D0=C			D0 = ->memory

** Set 3/8 second cursor blink

blink	D1=(5)	=TIMERCTRL.1	[SRQ WKE INT XTRA]
	LC(1)	4		[ 0   1   0   0  ]
	DAT1=C	1
	D1=(2)	=TIMER1
	LC(1)	5		3/8 seconds
	DAT1=C	1
	LC(3)	=allkeys
	OUT=C			loads all keyboard
**	******
	SHUTDN
**	******
	D1=(2)	=TIMERCTRL.1
	C=DAT1	B
	?CBIT=1	7		wtimeout/alarm?
	RTNYES			Carry if timeout
	?CBIT=0	3		blink?
	GOYES	blink01
	GOSUBL	CURSOR+		Yes
blink01	GOSBVL	=BITMAP
	RTNC			carry if [ON] down
	?A=0	W		catch no keys down
	GOYES	blink		fall asleep again
	ST=0	scPRESS		Flag key just down

** Key debounce loop.
dbnce00	B=A	W
	D1=(5)	(=TIMER2)+1
dbnce01	C=DAT1	S	<--- ( hang until match ) <---------
	P=	14					    |
	LC(1)	(dblp)-1				    |
dbnce02	A=DAT1	S	<<-- ( hang until stable ) <<---    |
	?A=C	S	    |				|   |
	GOYES	dbnce02	 ---	wait for TIMER2[1] tick	|   |
	C=A	S		save the TIMER2[1] tick	|   |
	GOSBVL	=BITMAP		A[12-0]:kbd bitmap	|   |
	RTNC			carry if [ON] down	|   |
	?A=0	W		catch no keys down	|   |
	GOYES	blink					|   |
	ABEX	W		A[12-0]:old B[12-0]:new	|   |
	?A#B	W		match?			|   |
	GOYES	dbnce01	 --> ( no ) ------------------------
	P=	14					|
	C=C-1	P		stable long enough?	|
	GONC	dbnce02	 --> ( no ) --------------------
	P=	0

** Insure only 1 key is being held down.
** Here A[12-0]=B[12-0]:stable kbd bitmap.
count00	LC(1)	1		only 1 key allowed down
count01	?B=0	W	<-----	any more bits to count?
	GOYES	countok	      |	NO
count02	?B#0	P	<<--  |	any bits set in nibble?
	GOYES	double	    | |
	BSR	W	    | |
	GONC	count01	 ----->	BET
double	B=B+B	P	    |	shift left until carry!
	GONC	double	    |
	C=C-1	P	    |	more than one key held?
	GONC	count02	 -->> 	NO, continue keys count
	GOTO	sctimeout	YES, keep scanning keys

** Compute key code of key being held down.
countok	ASRB.F	W
count03	?A#0	P	<---	\
	GOYES	count04	    |	 isolate
	B=B+CON	B,4	    |	 the
	ASR	W	    |	 nibble
	GONC	count03	 ---	/
count04	B=B+1	B	<---	\
	SB=0		    |	 isolate
	ASRB.F	P	    |	 the
	?SB=0		    |	 bit
	GOYES	count03	 ---	/

** Turn on busy ann
busyon	D1=(5)	=ANNCTRL
	C=DAT1	B		C[B]:[AON XTRA io busy alarm alpha -> <-]
	CBIT=1	4		C[B]:[ *    *  *   1     *     *   *  * ]
	DAT1=C	B		turn on busy annunciator
	RTNCC

**********************************************************************

DoTabKey	GOSUB	keytabs

	STITLE Key Codes-Offsets Table, Version 1.1
*****************************************************************
*****************************************************************
**
** These are the offsets to the individual key routines.
**
*****************************************************************
*****************************************************************
	CON(3)	0		(0)	[ON]		      OR0
	REL(3)	incr#1		(49)	[+]
	REL(3)	dump32		(48)	[SPC]
	REL(3)	badkey		(47)	[.]
	REL(3)	poke#0		(46)	[0]
	REL(3)	badkey		(13)	[']

	REL(3)	decr#1		(44)	[-]		      OR1
	REL(3)	poke#3		(43)	[3]
	REL(3)	poke#2		(42)	[2]
	REL(3)	poke#1		(41)	[1]
	REL(3)	poke#A		(1)	[A]
	REL(3)	badkey		(40)	right-shift

	REL(3)	in#100		(39)	[*]		      OR2
	REL(3)	poke#6		(38)	[6]
	REL(3)	poke#5		(37)	[5]
	REL(3)	poke#4		(36)	[4]
	REL(3)	badkey		(7)	[MTH]
	REL(3)	badkey		(35)	left-shift

	REL(3)	de#100		(34)	[/]		      OR3
	REL(3)	poke#9		(33)	[9]
	REL(3)	poke#8		(32)	[8]
	REL(3)	poke#7		(31)	[7]
	REL(3)	go#TEMPTOP	(19)	[SIN]
	REL(3)	badkey		(30)	alpha-shift

	REL(3)	go#RAM		(29)	[<=]		      OR4
	REL(3)	go#C0k		(28)	[DEL]
	REL(3)	go#80k		(27)	[EEX]
	REL(3)	format?		(26)	[+/-]
	REL(3)	go#.1k		(25)	[ENTER]

	REL(3)	go#5		(24)	[1/X]		      OR5
	REL(3)	go#skip		(23)	Y-to-the-X
	REL(3)	go#ROMPARTS	(22)	square-root
	REL(3)	go#DSKTOP	(21)	[TAN]
	REL(3)	go#RSKTOP	(20)	[COS]

	REL(3)	RGARROW		(18)	right-arrow	      OR6
	REL(3)	DNARROW		(17)	down-arrow
	REL(3)	LFARROW		(16)	left-arrow
	REL(3)	eval		(15)	[EVAL]
	REL(3)	badkey		(14)	[STO]

	REL(3)	badkey		(12)	[NXT]		      OR7
	REL(3)	UPARROW		(11)	up-arrow
	REL(3)	badkey		(10)	[VAR]
	REL(3)	badkey		(9)	[CST]
	REL(3)	badkey		(8)	[PRG]

	REL(3)	poke#F		(6)	[F]		      OR8
	REL(3)	poke#E		(5)	[E]
	REL(3)	poke#D		(4)	[D]
	REL(3)	poke#C		(3)	[C]
	REL(3)	poke#B		(2)	[B]

** Compute destination of the subroutine of the pressed key.
keytabs	C=RSTK
	C=C+B	A
	B=B+B	A
	C=C+B	A
	D1=C
	A=0	A
	A=DAT1	X
	A=A+C	A		* Note: carry clear
	INTON
	ST=1	15
	PC=A

	STITLE Individual Key Subroutines, Version 1.1
*****************************************************************
*****************************************************************
**
** These are the subroutines for each of the key assignments.
**
** MODULE HISTORY:
**
** Written			08/06/93	Rick Grevelle
** Packed			09/09/93	Detlef Mueller
** ASCII mode features added	10/08/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
** Poke keys
poke#0	P=	0
	GONC	poke#?
poke#1	P=	1
	GONC	poke#?
poke#2	P=	2
	GONC	poke#?
poke#3	P=	3
	GONC	poke#?
poke#4	P=	4
	GONC	poke#?
poke#5	P=	5
	GONC	poke#?
poke#6	P=	6
	GONC	poke#?
poke#7	P=	7
	GONC	poke#?
poke#8	P=	8
	GONC	poke#?
poke#9	P=	9
	GONC	poke#?
poke#A	P=	#A
	GONC	poke#?
poke#B	P=	#B
	GONC	poke#?
poke#C	P=	#C
	GONC	poke#?
poke#D	P=	#D
	GONC	poke#?
poke#E	P=	#E
	GONC	poke#?
poke#F	P=	#F

poke#?	C=0	A
	CPEX	0
	A=R2.F	A
	D1=A
	?ST=1	scASCII
	GOYES	poke$
	DAT1=C	1
	GONC	RGARROW
poke$	A=C	A
	LCASC	'9'
	ACEX	P		A: 9  C:n
	?A>=C	P
	GOYES	poke$.1
	C=C+CON	B,7
poke$.1	DAT1=C	B

** Right arrow key.
RGARROW	A=R2	A
	A=A+1	A
	?ST=0	scASCII
	GOYES	RDARem
	A=A+1	A
        GOTO	RDARem

** Down arrow key.
DNARROW	A=R2	A
	A=A+CON	A,16
	?ST=0	scASCII
	GOYES	RDARem
	A=A+CON	A,16
RDARem	R2=A	A
	CD0EX
	D0=C
	A=A-C	A
	LC(5)	#80
	?ST=0	scASCII
	GOYES	?a<c.1
	C=C+C	A
?a<c.1	?A<C	A
	RTNYES
	D0=D0+	16
	?ST=0	scASCII
	RTNYES
	D0=D0+	16
	RTN

** Left arrow key.
LFARROW	A=R2	A
	A=A-1	A
	?ST=0	scASCII
	GOYES	LUARem
	A=A-1	A
	GOTO	LUARem

** Up arrow key.
UPARROW	A=R2	A
	A=A-CON	A,16
	?ST=0	scASCII
	GOYES	LUARem
	A=A-CON	A,16
LUARem	R2=A	A
	CD0EX
	D0=C
	A=A-C	A
	LC(5)	#80
	?ST=0	scASCII
	GOYES	?a<c.2
	C=C+C	A
?a<c.2	?A<C	A
	RTNYES
	D0=D0-	16
	?ST=0	scASCII
	RTNYES
	D0=D0-	16
	RTN

** Goto RAM
go#RAM	D0=(5)	(=IRAM@)-4
	C=DAT0	A
	LC(4)	0
	GONC	GoRem

** Goto #00100.
go#.1k	LC(5)	#00100
	GONC	GoRem

** Goto #80000.
go#80k	LC(5)	#80000
	GONC	GoRem

** Goto #C0000.
go#C0k	LC(5)	#C0000
GoRem	R2=C	A
	D0=C
	GOTO	NODOWN?

** RAM variable jumps
go#TEMPTOP	D0=(5)	=aTEMPTOP
		GONC	GoHook
go#RSKTOP	D0=(5)	=aRSKTOP
		GONC	GoHook
go#DSKTOP	D0=(5)	=aDSKTOP
		GONC	GoHook
go#ROMPARTS	D0=(5)	=aROMPARTS

GoHook	C=DAT0	A
go#c	D0=C
	C=DAT0	A
	GONC	GoRem
** Go to read value
go#5	C=R2
	GONC	go#c

** Go to object end
go#skip	C=R2
	CD0EX
	RSTK=C			* Save ->memory to RSTK
	C=DAT0	A
	CD0EX			* M.H: Fixed this from D0=C
	A=DAT0	A
	CD0EX
	LC(5)	=PRLG
	?A#C	A
	GOYES	noskp
	GOSBVL	=SAFESKIPOB
	GOC	noskp		* Invalid object
	C=RSTK			* Pop ->memory
	CD0EX
	GONC	GoRem		* Set new ->memory and ->cursor
noskp	C=RSTK			* Restore ->memory
	D0=C
	GOTO	badkey

** Decrement #1.
decr#1	LC(5)	0-#1
	GONC	AddRem
** Decrement #100.
de#100	LC(5)	0-#100
	GONC	AddRem
** Increment #1.
incr#1	LC(5)	#1
	GONC	AddRem
** Increment #100.
in#100	LC(5)	#100
AddRem	AD0EX
	A=A+C	A
	D0=A
	A=R2	A
	A=A+C	A
	R2=A	A
	RTN

** Toggle HEX/ASCII display mode.
format?	CD0EX
	A=R2.F	A
	?ST=0	scASCII
	GOYES	expand1
shrink1	ST=0	scASCII
	A=A-C	A
	ASRB.F	A
	C=C+A	A
	D0=C
	GOTO	nodown?
expand1	ST=1	scASCII
	A=A-C	A
	C=C-A	A
	D0=C
	GOTO	nodown?

** Do bad key beep.
badkey	LC(2)	#F4
	GOSBVL	=RCKBp

** Trap initial key press.
nodown?	?ST=1	scPRESS
	RTNYES

** Do nothing while key(s) down!
NODOWN?	LC(5)	=allkeys	<-------------------
	OUT=C			load all keyboard   |
	GOSBVL	=CINRTN				    |
	?C#0	A		loop until it's 0   |
	GOYES	NODOWN?		 ------------------>
	RTN

** Experimental EVAL key.
eval	A=R2.F	A
	GOSBVL	=GETPTR
	PC=(A)


	STITLE 32k I/O ASCII Memory Dump, Version 1.1
** begin dump32 *************************************************
*****************************************************************
**
** NAME: dump32
**
** CATEGORY: Memory
**
** ENTRY:
**
** EXIT:
**                    
** CALLS: AllowIntr, init_UART*, OUTUART.
**
** STACK LEVELS: 2
**
** ABSTRACT: Dumps 32k bytes of memory starting at cursor.
**
** MODULE HISTORY:
**
** Written			08/12/93	Rick Grevelle
** Optimized			09/03/93	Rick Grevelle
** Fixed & optimized		09/04/94	Mika Heiskanen
**	- Now it really dumps starting from cursor
**	- Removed usage of scratch registers
*****************************************************************
*****************************************************************
dump32
	P=	0
	GOSBVL	=AllowIntr
	LC(1)	6		9600 BAUD
	GOSBVL	=init_UART*
	LC(5)	(32*1024*2/16)-1	32k bytes

** Main transmit loop.
iodmplp	RSTK=C		<-------------------------------
** Initilize memory pointer loop.			|
	A=R2		Note that R2 will be fixed back	|
	ASRC		in the next loop!!		|
	ASRC						|
	ASRC						|
	ASRC						|
	ASRC						|
	R2=A						|
	LC(5)	4					|
** Transmit the 5 nibble address in memory.		|
ioptrlp	RSTK=C	A	<<-----------------------	|
	C=R2					 |	|
	CSLC					 |	|
	R2=C					 |	|
** Compute ASCII translation one byte at a time. |	|
	LAASC	\9\				 |	|
	ACEX	P				 |	|
	?A<=C	P				 |	|
	GOYES	xmitptr				 |	|
	A=A+CON	B,7				 |	|
** Transmit pointer character.			 |	|
xmitptr	GOSBVL	=OUTUART			 |	|
	C=RSTK	A				 |	|
	C=C-1	A				 |	|
	GONC	ioptrlp	----------------------->>	|
** Transmit colon.					|
	LAASC	\:\					|
	GOSBVL	=OUTUART				|
** Initilize memory loop.				|
**	P=	0					|
	LC(5)	15					|
** Transmit 16 nibbles of memory @D0.			|
iomemlp	RSTK=C	A	<<-----------------------	|
	A=R2.F	A				 |	|
	D1=A					 |	|
	A=A+1	A				 |	|
	R2=A.F	A				 |	|
** Compute ASCII translation one byte at a time. |	|
	LCASC	\9\				 |	|
	A=C	B				 |	|
	A=DAT1	1				 |	|
	?A<=C	P				 |	|
	GOYES	xmitmem				 |	|
	A=A+CON	B,7				 |	|
** Transmit memory character.			 |	|
xmitmem	GOSBVL	=OUTUART			 |	|
	C=RSTK	A				 |	|
	C=C-1	A				 |	|
	GONC	iomemlp	 ---------------------->>	|
** Transmit CR.						|
	LA(2)	13					|
	GOSBVL	=OUTUART				|
** Transmit LF.						|
	LA(2)	10					|
	GOSBVL	=OUTUART				|
** Update the dump screen.				|
	A=R2.F	A					|
	D0=A						|
	GOSUB	dispdmp					|
** Advance screen pointer, and test for end of dump.	|
	C=RSTK						|
	C=C-1	A					|
	GOC	dumpok					|
	GOTO	iodmplp	 ------------------------------>

** Turn off I/O annunciator.
dumpok	A=R2.F	A		Set new dump start address to cursor
	D0=A

ioann-	D1=(5)	=ANNCTRL
	C=DAT1	B		C[B]:[AON XTRA A6 A5 A4 A3 A2 A1]
	CBIT=0	5               C[B]:[ *    *  0  *  *  *  *  * ]
	DAT1=C	B		turn off I/O annunciator
	RTN


	STITLE Main Memory Dump Display Routine, Version 1.1
** begin dispdmp ************************************************
*****************************************************************
**
** NAME: dispdmp
**
** CATEGORY: Display
**
** ENTRY: D0->:1st nibble of current memory dump screen
**        R2->:current cursor position
**        R3->:upper most left-hand corner of display GROB
**
** EXIT: D0 is trashed and must be saved by the caller!
**                    
** CALLS: dispA[], disp@D0, disp$D0
**
** STACK LEVELS: 2
**
** ABSTRACT: Displays the memory dump screen.
**
** MODULE HISTORY:
**
** Written			08/08/93	Rick Grevelle
** Optimized			09/03/93	Rick Grevelle
** ASCII display mode added	10/08/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
** Prepare to display the current memory dump screen.
dispdmp	P=	15
	LCHEX	7
	P=	0
	D=C	S		D[S]:row counter
	A=R3.F	A
	D1=A
	ST=0	scCURSOR

** Setup and display a row address of memory dump.
rowloop	GOSUB	dispD0:		* Display D0 as "hhhhh:"
	LC(5)	16
	D=C	A		* D[A] = 16 chars
	?ST=0	scASCII
	GOYES	rwl.1
	GOSUB	disp$D0
	GOTO	rwl.2
rwl.1	GOSUB	disp@D0
rwl.2	GOSUB	CURSOR?
	AD1EX
	LC(5)	(onerow)*7+1
	A=A+C	A
	AD1EX
	D=D-1	S
	GONC	rowloop
	RTNSC

	STITLE Conditional Cursor Display-Update, Version 1.1
** begin CURSOR? ************************************************
*****************************************************************
**
** NAME: CURSOR?
**
** CATEGORY: Display
**
** ENTRY: D0->:1st nibble of some row in memory dump
**        R2->:current cursor position in memory dump
**        R3->:upper most left-hand corner of display GROB
**
** EXIT: (same as ENTRY:)
**                    
** CALLS: None
**
** STACK LEVELS: 0
**
** ABSTRACT: Displays a cursor at current cursor position.
**
** MODULE HISTORY:
**
** Written			10/08/93	Rick Grevelle
**
*****************************************************************
*****************************************************************
CURSOR?	?ST=0	scCURSOR
	RTNYES
	ST=0	scCURSOR
	CD0EX
	RSTK=C
	A=R2.F	A
	A=A-C	A
	B=0	A
	?ST=0	scASCII
	GOYES	setdiv1
	ASRB.F	A
setdiv1	B=A	P		B[A]:remainder
	AD1EX
	D1=A
	LC(5)	((onerow)*1)-1
	C=A-C	A
	D=C	A
	GOTO	getmask


**********************************************************************
* Name:		CURSOR+
* Entry:	D0    = ->memory (1st nibble in dump)
*		R2[A] = ->cursor position in dump
*		R3[A] = ->display (upper left corner)
* Exit:		Above
* Stack:	1
**********************************************************************
CURSOR+	CD0EX
	RSTK=C
	A=R2.F	A
	A=A-C	A	* A[A]=offset to cursor
	?ST=0	scASCII
	GOYES	setdiv2
	ASRB.F	A	* Offset in chars
setdiv2	B=0	A
	B=A	P	* X location
	ASR	A	* Y location

* Calculate display row
* Note: (onerow)*8 = 34*8 = 272 = #110

	C=A	A	* Y
	CSL	A	* #10*Y
	D=C	A
	CSL	A	* #100*Y
	D=D+C	A	* #110*Y
	C=R3.F	A
	D=D+C	A	* D[A] = ->disprow

* Add X location and prepare mask

getmask	A=B	A					     [ 7]
**	ABIT=0	0					     [ 6]
**	LC(3)	#3F	C[X]:odd mask			     [ 6]
	LC(3)	#3F8	(** cursor width expansion experiment **)
	SB=0						     [ 3]
	BSRB.F	A					     [11]
	?SB=0						[13]/[ 6]
	GOYES	add1/2	STICKY BIT SET IF THE CURSOR IS 6 MSB!!!!
**	LC(4)	#FC0					     [ 7]
	LC(4)	#FE0	(** cursor width expansion experiment **)
add1/2	B=B+A	A					     [ 7]
	B=B-1	A	(** cursor width expansion experiment **)
	CDEX	A	D[X]:has mask; C[A]:row offset	     [ 7]
	C=C+B	A					     [ 7]
	D0=C						     [ 8]
	D0=D0+	9					     [ 7]


	STITLE Toggle Display Cursor, Verison 1.0
*****************************************************************
*****************************************************************
**
** NAME: cursor!
**
** ENTRY: D0->:cursor MARK
**        D[X]:cursor mask
**        RSTK:memory save
**
** EXIT: D0 restored
**
*****************************************************************
*****************************************************************
cursor!	P=	16-7					     [ 2]
cursor+	C=DAT0	3	<---	C[X]:the pixel row	     [19]
	A=C	X	    |	save the pixel row	     [ 6]
	C=C&D	X	    |	\			     [ 7]
	C=-C-1	X	    |	\			     [ 6]
	ACEX	X	    |	 COMPUTES A CURSOR	     [ 7]
	C=C!D	X	    |	/			     [ 7]
	C=C&A	X	    |	/			     [ 7]
	DAT0=C	3	    |	sets the pixel row	     [18]
	D0=D0+	16	    |	\			     [ 7]
	D0=D0+	16	    |	 moves to next row	     [ 7]
	D0=D0+	2	    |	/			     [ 7]
	P=P+1		    |				     [ 3]
	GONC	cursor+	 ---				[10]/[ 3]
	C=RSTK						     [ 8]
	D0=C						     [ 8]
	RTN						     [ 9]

**********************************************************************
* Name:		dispD0:
* Entry:	D0 = address
*		D1 = ->display
* Exit:		D0 = address
*		D1 = ->display (next)
* Description:	Displays D0 as "hhhhh:"
* Uses:		A[W] B[W] C[W] P D1
* Stack:	1
**********************************************************************

NIB>CHR	MACRO
	LC(2)	'9'
	ACEX	P
	?C<=A	P
	GOYES	L$0
	C=C+CON	B,7
L$0
NIB>CHR	ENDM

dispD0:	AD0EX
	D0=A
	ASR	A
	ASR	A
	ASR	X
	NIB>CHR
	B=C	B	* B[B]=h2
	ASR	B
	NIB>CHR
	CBEX	B
	GOSUB	WRCHR2!

	AD0EX
	D0=A
	ASR	X
	NIB>CHR
	B=C	B	* B[B]=h4
	ASR	B
	NIB>CHR
	CBEX	B
	GOSUB	WRCHR2!

	AD0EX
	D0=A
	NIB>CHR
	A=C	B	* A[B]=h5
	LCASC	':'
	GOTO	WRCHR2

*****************************************************************
* Name:		disp@D0
* Entry:	D0 = ->memory
*		D1 = ->display
*		D[A] = #chars
* Exit:		D0 = ->memory (next)
*		D1 = ->display (next)
* Uses:		A[W] B[A] C[W] D[A] D0 D1 P CRY
* Calls:	WRCHR2 CRSIN? Nib>Chr
* Stack:	1
* Description:	Displays D[A] hex nibbles at D0.
*****************************************************************
disp@D0	GOSUB	CRSIN?
	DSRB.F	A
	GOTO	d@D0.3
d@D0.2	A=DAT0	B
	D0=D0+	2
	NIB>CHR
	B=C	B		* B[B] = chr1
	ASR	B
	NIB>CHR			* C[B] = chr2
	GOSUB	WRCHR2!
d@D0.3	D=D-1	A
	GONC	d@D0.2
	RTN

*****************************************************************
* Name:		disp$D0
* Entry:	D0 = ->memory
*		D1 = ->display
*		D[A] = #chars
* Exit:		D0 = ->memory (next)
*		D1 = ->display (next)
* Uses:		A[W] B[A] C[W] D[A] D0 D1 P CRY
* Calls:	WRCHR2 CRSIN?
* Stack:	1
* Description:	Displays D[A] ascii chars at D0.
*****************************************************************

disp$D0	D=D+D	A
	GOSUB	CRSIN?
	DSRB.F	A
	DSRB.F	A
	GOTO	d$D0.3

d$D0.2	A=DAT0	B		* A[B] = chr1
	D0=D0+	2
	C=DAT0	B		* C[B] = chr2
	D0=D0+	2
	GOSUB	WRCHR2
d$D0.3	D=D-1	A
	GONC	d$D0.2
	RTNCC


	STITLE Char-to-Display Write Loop, Version 1.0
**********************************************************************
* Name:		WRCHR2
* Entry:	D1 = ->display
*		A[B] = chr1
*		C[B] = chr2
* Exit:		D1 = ->display (next location)
* Uses:		A[W] B[A] C[W] P D1
* Stack:	0
* Alternate:	WRCHR2	B[B]=chr1 C[B]=chr2
**********************************************************************

WRCHR2	B=A	B	* B[B] = chr1
WRCHR2!	CSL	X
	P=	3
	LC(2)	0
	P=	0
	A=R4.F	A	* A[A] = ->font
	A=A+C	A
	AD0EX
	C=DAT0	W	* C[W] = data2
	AD0EX
	CBEX	A	* C[B] = chr1
	CSL	X
	P=	3
	LC(2)	0
	P=	0
	A=R4.F	A
	C=C+A	A
	CD0EX
	A=DAT0	W	* A[W] = data1
	CD0EX
	C=B	A	* C[W] = data2

* Fall through

	STITLE Pixel-to-Display Write
**********************************************************************
* Name:		WRPIX2
* Entry:	D1 = ->display
*		A[W] = font data for 1st char
*		C[W] = font data for 2nd char
* Exit:		D1 = ->display (next location)
* Uses:		A[W] C[W] P D1
* Stack:	0
*****************************************************************
WRPIX2	C=C+C	W		[19]
	C=C+C	W		[19]

** Loop version:

*	DAT1=A	P		[17]
*	D1=D1+	1		[ 7]
*	ASR	W		[20]
*	GONC	WR2IN		[10]
*WR2LP	D1=D1+	16		[ 7]
*	D1=D1+	16		[ 7]
*	DAT1=A	P		[17]
*	D1=D1+	1		[ 7]
*	P=P+1			[ 3]
*WR2IN	A=A+C	P		[ 4]
*	DAT1=A	P		[17]
*	D1=D1+	1		[ 7]
*	P=P+1			[ 3]
*	DAT1=C	P		[17]
*	?P#	15		[13/6] = [102]
*	GOYES	WR2LP
*	P=	0
*	AD1EX
*	LC(5)	(onerow)*7-1	* Advance D1 2 chars
*	A=A-C	A
*	AD1EX
*	RTNCC

** Loop removed:

	DAT1=A	P
	D1=D1+	1
	ASR	W
	A=A+C	P
	DAT1=A	P
	D1=D1+	1
	P=	1
	DAT1=C	P

	D1=D1+	16
	D1=D1+	16
	DAT1=A	P
	D1=D1+	1
	P=	2
	A=A+C	P
	DAT1=A	P
	D1=D1+	1
	P=	3
	DAT1=C	P

	D1=D1+	16
	D1=D1+	16
	DAT1=A	P
	D1=D1+	1
	P=	4
	A=A+C	P
	DAT1=A	P
	D1=D1+	1
	P=	5
	DAT1=C	P

	D1=D1+	16
	D1=D1+	16
	DAT1=A	P
	D1=D1+	1
	P=	6
	A=A+C	P
	DAT1=A	P
	D1=D1+	1
	P=	7
	DAT1=C	P

	D1=D1+	16
	D1=D1+	16
	DAT1=A	P
	D1=D1+	1
	P=	8
	A=A+C	P
	DAT1=A	P
	D1=D1+	1
	P=	9
	DAT1=C	P

	D1=D1+	16
	D1=D1+	16
	DAT1=A	P
	D1=D1+	1
	P=	10
	A=A+C	P
	DAT1=A	P
	D1=D1+	1
	P=	11
	DAT1=C	P

	D1=D1+	16
	D1=D1+	16
	DAT1=A	P
	D1=D1+	1
	P=	12
	A=A+C	P
	DAT1=A	P
	D1=D1+	1
	P=	13
	DAT1=C	P

	D1=D1+	16
	D1=D1+	16
	DAT1=A	P
	D1=D1+	1
	P=	14
	A=A+C	P
	DAT1=A	P
	D1=D1+	1
	P=	15
	DAT1=C	P

	P=	0
	AD1EX
	LC(5)	(onerow)*7-1	* Advance D1 2 chars
	A=A-C	A
	AD1EX
	RTNCC


	STITLE Misc Utilities

**********************************************************************
* Set scCURSOR and return CC if D0 <= R2[A] < D0+D[A]
**********************************************************************
CRSIN?	AD0EX
	D0=A
	C=R2.F	A
	?C<A	A	* Cursor already done
	RTNYES
	C=D	A
	A=A+C	A
	C=R2.F	A
	?C>=A	A
	RTNYES
	ST=1	scCURSOR
	RTNCC
ENDCODE

  TURNMENUON
;
**********************************************************************



