*****************************************************************
*****************************************************************
**
*+ Name: NOISE - A white noise example
**
** Author: Douglas R. Cannon
**
** Abstract:   Compatible with all current ROM versions of the HP48
**             as of August 29, 1995.  S, SX, G, or GX.
**
**		Use TIMER2 and the CRC for a random byte which is
**		used as a tone delay.  When many are used in a loop,
**		The HP48 produces white noise.
**
** Entry:      None
**
** Exit:       None
**
**     Date     Prog             Modification
**   --------   ----   ------------------------------------------
**   08/29/95   DRC    Program modified for SASM format
**===============================================================


ASSEMBLE
        NIBASC  /HPHP48-L/

RPL

::

CODE

CRC	EQU	#00104

	P=	0
	GOSBVL	=SAVPTR

	D0=(5)	=TIMER2	8 nibbles here is the clock
	D1=(5)	CRC	4 nibbles here is the CRC
	LC(5)	600	length of noise
	B=C	A 
	D=0	A	zero (to turn speaker off)
	LCHEX	800	800 (to turn speaker on)

Again	OUT=C		twiddle speaker
	CDEX	A	get next twiddler (either #0h or #800h)

	A=DAT0	8	read 8 clock nibbles (randomize the CRC)
	A=0	A	clear A
	A=DAT1	2	get 2 nibbles of the CRC

Delay	A=A-1	A
	GONC	Delay
	B=B-1	A	decrement the tone length counter
	GONC	Again	do some more noise

	GOVLNG	=GETPTRLOOP


ENDCODE

;



