/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControllerGroup;
import controlP5.Label;
import processing.core.PApplet;

public class ControlGroup
extends ControllerGroup
implements ControlListener {
    Button _myCloseButton;

    public ControlGroup(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2);
        this._myValueLabel = new Label("-");
        this._myWidth = n3;
        this._myHeight = n4;
    }

    public void mousePressed() {
        if (!ControlP5.keyHandler.isAltDown) {
            this.isOpen = !this.isOpen;
            this._myValueLabel.set(this.isOpen ? "-" : "+");
        }
    }

    protected void postDraw(PApplet pApplet) {
        pApplet.fill(this.isInside ? this.color.colorForeground : this.color.colorBackground);
        pApplet.rect(0.0f, -1.0f, (float)this._myWidth, (float)(-this._myHeight));
        this._myLabel.draw(pApplet, 2, -this._myHeight);
        this._myValueLabel.draw(pApplet, this._myWidth - 9, -this._myHeight);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setName("group");
        controlP5XMLElement.setAttribute("width", new Integer(this._myWidth));
        controlP5XMLElement.setAttribute("height", new Integer(this._myHeight));
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (!this.controllers.get(i).isXMLsavable()) continue;
            controlP5XMLElement.addChild(this.controllers.get(i).getAsXML());
        }
    }

    public void addCloseButton() {
        if (this._myCloseButton == null) {
            this._myCloseButton = new Button(this.controlP5, this, this.name() + "close", 1.0f, this._myWidth + 1, -10, 12, 9);
            this._myCloseButton.setLabel("X");
            this._myCloseButton.addListener(this);
        }
    }

    public void removeCloseButton() {
        if (this._myCloseButton == null) {
            this._myCloseButton.remove();
        }
        this._myCloseButton = null;
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.controller().name().equals(this.name() + "close")) {
            this.hide();
        }
    }

    public String stringValue() {
        return "";
    }

    public float value() {
        return 0.0f;
    }
}

