'/* BASDEF.MSB  03.04.2003 */

dim cbyt(8)                                  '"byte"-type ("binary") data array
dim char(287)                              'replacement for Basic CHR$ function
dim dflt(7)                             'float increment values for dfn.round()

for i = 2 to 9                               'loop thru the applicable elements
   cbyt(i - 1) = string$(i - (i mod 2), 0)    'set array elements to even sizes
next
for i = 0 to 255                             'loop thru the ASCII character set
   char(i) = chr$(i)             'set each array element to its CHR$ equivalent
next
dflt(0) = 2000000000#               'initialize the first float increment value
for i = 1 to 7                       'loop thru the float increment value array
   dflt(i) = dflt(i - 1) * 10        'set the subsequent float increment values
next

cdsp = space$(80)                    'video display buffer = 80 character width
cprt = space$(79)                            'print buffer = 79 character width

lmaxlng = 2147483647&                               'maximum long-integer value

dexp32 = 4294967296#                                    '(2 ^ 32) = 4294967296#
dexp64 = dexp32 * dexp32                        '(2 ^ 64) = (2 ^ 32) * (2 ^ 32)

function cmkd(dval)              'convert double-precision number to MBF string
   if dval = 0 then                                        'IEEE number == zero
      cmkd = string$(8, 0)                'return zero value to calling program
   else                               'IEEE number != zero; continue processing
      if dval < 0 then                                      'IEEE number < zero
         isgn = 128                                       'set sign value to -1
      else                                                  'IEEE number > zero
         isgn = 0                                         'set sign value to +1
      end if
      iexp = int(log(abs(dval)) / log(2))            'get nearest exponent of 2
      do                                             'loop to generate mantissa
         dmnt = abs(dval) / (2 ^ iexp) 'normalized mantissa of dest. MBF number
         if dmnt >= 2 then              'exponent too small; mantissa too large
            iexp = iexp + 1                             'increment the exponent
         elseif dmnt < 1 then           'exponent too large; mantissa too small
            iexp = iexp - 1                             'decrement the exponent
         else                                                '1 <= mantissa < 2
            exit do                                     'mantissa OK; exit loop
         end if
      loop
      if iexp >= -128 and iexp <= 126 then    'IEEE exponent -> MBF exponent OK
         dmnt = (dmnt - 1) * 2147483648#  '"integerize" top 31 bits of mantissa
         dtmp = fix(dmnt)               'extract top 31 bits only from mantissa
         mid$(cbyt(8), 1) = mkl$((dmnt - dtmp) * 16777216#)'low 24 bit mantissa
         mid$(cbyt(8), 4) = char(clng(dtmp) and 255)'prevents long-int overflow
         mid$(cbyt(8), 5) = mkl$(clng(dtmp) \ 256 + clng(isgn) * 65536)
         mid$(cbyt(8), 8) = char(iexp + 129)  'put MBF exponent into MBF string
         cmkd = cbyt(8)                   'return MBF "mkd$" to calling program
      else                                'IEEE exponent -> MBF exponent NOT OK
         if iexp > 126 then             'IEEE exponent > range of MBF exponents
            cmkd = string$(6, 255) + char(127 + isgn) + char(255)'return maxval
         else                           'IEEE exponent < range of MBF exponents
            cmkd = string$(8, 0)          'return zero value to calling program
         end if
      end if
   end if
end function

function cmks(fval)              'convert single-precision number to MBF string
   if fval = 0 then                                        'IEEE number == zero
      cmks = string$(4, 0)                'return zero value to calling program
   else                               'IEEE number != zero; continue processing
      if fval < 0 then                                      'IEEE number < zero
         isgn = 128                                       'set sign value to -1
      else                                                  'IEEE number > zero
         isgn = 0                                         'set sign value to +1
      end if
      iexp = int(log(abs(fval)) / log(2))            'get nearest exponent of 2
      do                                             'loop to generate mantissa
         dmnt = abs(fval) / (2 ^ iexp) 'normalized mantissa of dest. MBF number
         if dmnt >= 2 then              'exponent too small; mantissa too large
            iexp = iexp + 1                             'increment the exponent
         elseif dmnt < 1 then           'exponent too large; mantissa too small
            iexp = iexp - 1                             'decrement the exponent
         else                                                '1 <= mantissa < 2
            exit do                                     'mantissa OK; exit loop
         end if
      loop
      if iexp >= -128 and iexp <= 126 then    'IEEE exponent -> MBF exponent OK
         dmnt = (dmnt - 1) * 8388608# '"integerize" the 23 bits of the mantissa
         dmnt = fix(dmnt)       'do the fix() operation separately for accuracy
         mid$(cbyt(4), 1) = mkl$(clng(dmnt) + clng(isgn) * 65536)'mantissa+sign
         mid$(cbyt(4), 4) = char(iexp + 129)  'put MBF exponent into MBF string
         cmks = cbyt(4)  'return MBF single-precision string to calling program
      else                                'IEEE exponent -> MBF exponent NOT OK
         if iexp > 126 then             'IEEE exponent > range of MBF exponents
            cmks = string$(2, 255) + char(127 + isgn) + char(255)'return maxval
         else                           'IEEE exponent < range of MBF exponents
            cmks = string$(4, 0)          'return zero value to calling program
         end if
      end if
   end if
end function

function dcvd(cmbf)              'convert MBF string to double-precision number
   iexp = midchar(cmbf, 8)                                'get the MBF exponent
   if iexp = 0 then                                           'exponent == zero
      dcvd = 0                            'return zero value to calling program
   else                                  'exponent != zero; continue processing
      ibyt = midchar(cmbf, 7)                          'get the MBF "sign byte"
      if ibyt >= 128 then                                      'sign bit == one
         isgn = -1                                        'set sign value to -1
      else                                                    'sign bit == zero
         isgn = 1                                         'set sign value to +1
         ibyt = ibyt + 128                     'add implied one-bit to mantissa
      end if            'NOTE: sign bit [above] will now become implied one-bit
      mid$(cbyt(3), 1) = mid$(cmbf, 1, 3) + char(0)       'rebuild the mantissa
      mid$(cbyt(4), 1) = mid$(cmbf, 5, 2) + char(ibyt) + char(0)
      itmp = midchar(cmbf, 4)'extract top byte to prevent long-integer overflow
      dcvd = (cvl(cbyt(3)) / 4294967296# + cvl(cbyt(4)) + itmp / 256#) * _
             (2 ^ (iexp - 152)) * isgn
   end if       'return IEEE double-precision number to calling program [above]
end function

function dfn.round(dval, idec)            'round 'dval' to 'idec' no. of places
   select case idec                        'select on the no. of decimal places
      case 0                                  'current case is 0 decimal places
         dfactor = 1#                           'set multiply and divide factor
      case 1                                  'current case is 1 decimal places
         dfactor = 10#                          'set multiply and divide factor
      case 2                                  'current case is 2 decimal places
         dfactor = 100#                         'set multiply and divide factor
      case 3                                  'current case is 3 decimal places
         dfactor = 1000#                        'set multiply and divide factor
      case 4                                  'current case is 4 decimal places
         dfactor = 10000#                       'set multiply and divide factor
      case 5                                  'current case is 5 decimal places
         dfactor = 100000#                      'set multiply and divide factor
      case 6                                  'current case is 6 decimal places
         dfactor = 1000000#                     'set multiply and divide factor
      case 7                                  'current case is 7 decimal places
         dfactor = 10000000#                    'set multiply and divide factor
      case 8                                  'current case is 8 decimal places
         dfactor = 100000000#                   'set multiply and divide factor
      case else                            'current case is >= 9 decimal places
         dfactor = 1000000000#                  'set multiply and divide factor
   end select
   dfn.round = fix(dval * dfactor + .5# * sgn(dval)) / dfactor'round the number
end function

function fcvs(cmbf)              'convert MBF string to single-precision number
   iexp = midchar(cmbf, 4)                                'get the MBF exponent
   if iexp = 0 then                                           'exponent == zero
      fcvs = 0                            'return zero value to calling program
   else                                  'exponent != zero; continue processing
      ibyt = midchar(cmbf, 3)                          'get the MBF "sign byte"
      if ibyt >= 128 then                                      'sign bit == one
         isgn = -1                                        'set sign value to -1
      else                                                    'sign bit == zero
         isgn = 1                                         'set sign value to +1
         ibyt = ibyt + 128                     'add implied one-bit to mantissa
      end if            'NOTE: sign bit [above] will now become implied one-bit
      mid$(cbyt(4), 1) = mid$(cmbf, 1, 2) + char(ibyt) + char(0)
      fcvs = cvl(cbyt(4)) * (2 ^ (iexp - 152)) * isgn 'rebuild mantissa [above]
   end if       'return IEEE single-precision number to calling program [above]
end function

function ifn.rand(irnd)               'get next pseudorandom number from 'irnd'
   'dtemp = cdbl(irnd) * 214013& + 2531011&    '
   'while dtemp > 2147483647&                  ' This is the original routine,
   '   dtemp = dtemp - 2147483647& - 1         ' using double-precision values
   'wend                                       ' due to 16-bit BASIC's lack of
   'irnd = clng(dtemp) mod 32768&              ' double-long integers.
   '                                           '
   ltemp = 2531011&                           'pre-save the PRN additive factor
   while irnd > 10034                        'can't create a # larger than 2^31
      irnd = irnd - 10034                   'remove a factor of 10034 from irnd
      ltemp = ltemp - 77206&                'adjust by the difference from 2^31
   wend
   lrnd = clng(irnd) * 214013&             'apply the PRN multiplicative factor
   if lrnd > lmaxlng - ltemp then          'resulting value is larger than 2^31
      irnd = (lrnd - lmaxlng - 1 + ltemp) mod 32768& 'normalize next # <= 32767
   else                                   'resulting value NOT larger than 2^31
      irnd = (lrnd + ltemp) mod 32768&               'normalize next # <= 32767
   end if
end function

function lfn.rand(lrnd)               'get next pseudorandom number from 'lrnd'
  'drnd = cdbl(lrnd) * 214013# + 2531011#  'multiply by and add "magic" numbers
  'dtmp = int(drnd / 1048576#) * 1048576#  'total of all multiples of 1,048,576
  'lrnd = clng(drnd - dtmp)                         'return modulo of 1,048,576
   l1 = lrnd mod 8                           'these 5 lines are an integer-only
   l2 = (lrnd - l1) mod 16                    'equivalent to the floating-point
   l3 = (lrnd - l1 - l2) mod 64             'operations shown above (16-bit DOS
   l4 = (lrnd - l1 - l2 - l3)               'compiler doesn't have double long)
   lrnd = (l1 * 214013& + l2 * 82941& + l3 * 17405 + l4 * 1021 + 2531011&) mod 1048576&
end function

function ifn.rtab(clin, itab)       'replace 'hard' tab characters in text line
   do                              'begin loop to replace 'hard' tab characters
      ilen = instr(clin, char(9)) - 1        'position of tab in text line (-1)
      if ilen < 0 then                        'tab-character position NOT found
         exit do                            'tab character NOT found; exit loop
      elseif len(clin) = ilen + 1 then      'tab is last character in text line
         clin = left$(clin, ilen)          'remove tab character from text line
         exit do                             'tab character removed - exit loop
      end if
      if ilen = 0 then                    'tab occurs at beginning of text line
         clin = space$(itab) + mid$(clin, 2)  'use 'itab' spaces to replace tab
      else                             'tab occurs after beginning of text line
         ichr = midchar(clin, ilen + 2)  '1st character following tab character
         imod = ilen mod itab             'no. of spaces past last tab boundary
         if imod > 0 or ichr = 9 or ichr = 32 or midchar(clin, ilen) = 32 then
            clin = left$(clin, ilen) + _
                   space$(itab - imod) + _
                   mid$(clin, ilen + 2)       'use 'itab' spaces to replace tab
         else                          'tab occurs at tab boundary in text line
            clin = left$(clin, ilen) + mid$(clin, ilen + 2)'just remove the tab
         end if          'remove tab without adding spaces to text line [above]
      end if
   loop                                'loop while tab-character position found
end function

sub nosnow(inop)          'turns off snow suppression when linking with PDQ.LIB
end sub

sub pdqprint(cdat, irow, icol, iclr)                    'display data on screen
   color iclr mod 16, iclr \ 16                              'set display color
   locate irow, icol, 0                                      'locate the cursor
   print cdat;                                                'display the data
end sub

function pdqrand(imax)                      'random-number generator substitute
   pdqrand = cint(rnd * imax)         'return random integer between 0 and imax
end function

sub pdqrandomize(irnd)                  'initialize the random number generator
   randomize irnd                                  'initialize with seed = irnd
end sub

function pdqvali(cstr1)                      'integer val() function substitute
   init = 0                          'initialize the first-character-found flag
   inum = 0                                'initialize the numeric return value
   isgn = 1                              'set the default numeric sign positive
   for i = 1 to len(cstr1)                         'loop thru the target string
      ichr = midchar(cstr1, i)                 'ASCII value at current position
      if ichr <> 32 then             'non-blank character found (ignore blanks)
         if ichr = 45 then                                 '-' (sign) character
            if not init then              'sign character is in proper position
               isgn = -1                         'set the numeric sign negative
            else                         'sign character NOT in proper position
               exit for                  'assume end of string value; exit loop
            end if
         else                                  'character other than '-' (sign)
            if ichr < 48 or ichr > 57 then            'character NOT '0' to '9'
               exit for                         'non-digit character; exit loop
            else                                         'characters '0' to '9'
               inum = inum * 10 + ichr - 48   'multiply previous value by 10...
            end if                 '...then add current digit less ASCII offset
         end if
         init = not 0                    'set the first-character-found flag ON
      end if
   next
   pdqvali = inum * isgn                   'return value with numeric sign bias
end function

function pdqvall&(cstr1)                'long-integer val() function substitute
   init = 0                          'initialize the first-character-found flag
   lnum = 0                                'initialize the numeric return value
   isgn = 1                              'set the default numeric sign positive
   for i = 1 to len(cstr1)                         'loop thru the target string
      ichr = midchar(cstr1, i)                 'ASCII value at current position
      if ichr <> 32 then             'non-blank character found (ignore blanks)
         if ichr = 45 then                                 '-' (sign) character
            if not init then              'sign character is in proper position
               isgn = -1                         'set the numeric sign negative
            else                         'sign character NOT in proper position
               exit for                  'assume end of string value; exit loop
            end if
         else                                  'character other than '-' (sign)
            if ichr < 48 or ichr > 57 then            'character NOT '0' to '9'
               exit for                         'non-digit character; exit loop
            else                                         'characters '0' to '9'
               lnum = lnum * 10 + ichr - 48   'multiply previous value by 10...
            end if                 '...then add current digit less ASCII offset
         end if
         init = not 0                    'set the first-character-found flag ON
      end if
   next
   pdqvall& = lnum * isgn                  'return value with numeric sign bias
end function
