'/* BITDUMP.BAS Dump bits values from a file into an output file */
'/*             By: Dale Thorn                                   */
'/*             Rev. 11.05.2000                                  */

'$include: 'basdef.h'
'$include: 'bitops.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'bitops.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'scrnparm.bas'
'$include: 'string.bas'

dim cbit(1)                   'create zero ("0") and one ("1") bit text strings
cbit(0) = "0"                              'set the zero-bit text string to "0"
cbit(1) = "1"                               'set the one-bit text string to "1"

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                    'command-line parameters were NOT supplied
   i = ifn.msgs("Usage:  BITDUMP  filename", iofs, irow, icol, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm >= 0 then        'user gave an invalid filename or supplied a parameter
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)   'invalid filename
end if                       'display invalid-filename message [above] and exit

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if

i = ifn.msgs("Please standby", iofs, irow, icol, 0, 0) 'hide cursor and proceed

if cext = "out" then                      'target filename has '.OUT' extension
   cout = cnam + ".tmp"                 'add '.TMP' extension to temporary file
else                                      'target filename has '.???' extension
   cout = cnam + ".out"                 'add '.OUT' extension to temporary file
end if

i = ifn.kill(2, cout)                              'kill any existing temp file
open cout for binary as 2                    'open the temp file in binary mode

ibuf = 2048                             'set the size of the source-file buffer
csrc = space$(ibuf)                            'allocate the source-file buffer
cdst = space$(ibuf * 8)                   'allocate the destination-file buffer

for lbyt = 0 to llof - 1 step ibuf    'walk source file in ibuf-length segments
   if lbyt + ibuf > llof then          'current buffer spans end of source file
      csrc = ""                              'deallocate the source-file buffer
      cdst = ""                         'deallocate the destination-file buffer
      ibuf = llof - lbyt              'reset the size of the source-file buffer
      csrc = space$(ibuf)                    'reallocate the source-file buffer
      cdst = space$(ibuf * 8)           'reallocate the destination-file buffer
   end if
   get 1, lbyt + 1, csrc                           'load the source-file buffer
   for isrc = 0 to ibuf - 1             'process each byte in the source buffer
      idst = isrc * 8                  'write-to position in destination buffer
      mid$(cdst, idst + 1) = cbit(bitget(csrc, idst + 0))'write byte#isrc bit#0
      mid$(cdst, idst + 2) = cbit(bitget(csrc, idst + 1))'write byte#isrc bit#1
      mid$(cdst, idst + 3) = cbit(bitget(csrc, idst + 2))'write byte#isrc bit#2
      mid$(cdst, idst + 4) = cbit(bitget(csrc, idst + 3))'write byte#isrc bit#3
      mid$(cdst, idst + 5) = cbit(bitget(csrc, idst + 4))'write byte#isrc bit#4
      mid$(cdst, idst + 6) = cbit(bitget(csrc, idst + 5))'write byte#isrc bit#5
      mid$(cdst, idst + 7) = cbit(bitget(csrc, idst + 6))'write byte#isrc bit#6
      mid$(cdst, idst + 8) = cbit(bitget(csrc, idst + 7))'write byte#isrc bit#7
   next
   put 2, lbyt * 8 + 1, cdst                 'write the destination-file buffer
next
close                     'close all files prior to browsing temp (output) file

shell "view " + cout                  'browse temp (output) file in binary mode
close                                 'close all files in case not closed above
system                                              'return to operating system
