'/* BPAD.BAS Bitpad or unpad a 7-bit DOS file
'/*          By: Dale Thorn
'/*          Rev. 10.01.2002

'$include: 'basdef.h'
'$include: 'bitops.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'

declare function ifn.bpad(ifil, copr, llof, lcnt, ltot)

'$include: 'basdef.bas'
'$include: 'bitops.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                    'command-line parameters were NOT supplied
   i = ifn.msgs("Usage:  BPAD  filename  [/p /u]", 5, 24, 79, 0, 1)
end if                                  'display usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)          'invalid filename
end if                                  'display error message [above] and exit

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1) 'error (wildcard filespec)
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)   'error (file not found)
end if                                  'display error message [above] and exit

if not(cprm(0) = "P" or cprm(0) = "U") then                  'invalid parameter
   i = ifn.msgs("'P'ad or 'U'npad parameter not specified", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed
i = ifn.bpad(1, cprm(0), llof, lcnt, ltot)             'perform bit-pad process
if copr = "U" then                                        'opcode == unpad bits
   i = ifn.msgs("Bit-unpadding complete", 4, 24, 79, 0, 1)  'completion message
else                                                        'opcode == pad bits
   i = ifn.msgs("Bit-padding complete", 4, 24, 79, 0, 0)    'completion message
end if                                   '2nd message [above] continues [below]
locate 7, 1, 1                                             'relocate the cursor
print "Total bits in source: "; llof * 8                    'total bits in file
locate 9, 1, 1                                             'relocate the cursor
print "Total one-bits begin: "; lcnt                       'one-bits before pad
locate 11, 1, 1                                            'relocate the cursor
print "Total one-bits added: "; ltot                      'no.of one-bits added
close                                                     'close all open files
system                                              'return to operating system

function ifn.bpad(ifil, copr, llof, lcnt, ltot)        'perform bit-pad process
   ibuff = 2048                                 'set maximum file buffer length
   itemp = ibuff                               'make copy of file buffer length
   lcnt = 0                                  'initialize current total one-bits
   cbuff = space$(ibuff)                'allocate the actual source-file buffer
   for lbyt = 0 to llof - 1 step itemp   'process source file in itemp segments
      if lbyt + itemp > llof then       'current file pointer + itemp spans EOF
         itemp = llof - lbyt                  'reset maximum file buffer length
         cbuff = ""                          'deallocate the source-file buffer
         cbuff = space$(itemp)               'reallocate the source-file buffer
      end if
      get ifil, lbyt + 1, cbuff              'read data into source-file buffer
      if copr = "U" then                                  'opcode == unpad bits
         for ibuffbyt = 0 to itemp - 1      'process each byte in source buffer
            i = bitput(cbuff, ibuffbyt * 8 + 7, 0)  'clear each 8th bit in byte
         next
         put ifil, lbyt + 1, cbuff          'write data from source-file buffer
      else                                                  'opcode == pad bits
         for ibuffbyt = 0 to itemp - 1      'process each byte in source buffer
            for ibit = 0 to 7                 'process each bit in current byte
               lcnt = lcnt + bitget(cbuff, ibuffbyt * 8 + ibit)'increment total
               if ibit = 7 then                        '8th bit of current byte
                  if bitget(cbuff, ibuffbyt * 8 + ibit) then 'the 8th bit is ON
                     cmsg = "8th bit(s) are ON - can't do bit-pad"
                     i = ifn.msgs(cmsg, 4, 24, 79, 1, 1)
                  end if      'can't add bits; display message [above] and exit
               end if
            next
         next
      end if
   next
   if copr = "U" then                                     'opcode == unpad bits
      exit function                                    'exit to calling program
   end if
   ltot = llof * 4 - lcnt            'set ltot as the no. of 8th bits to set ON
   if ltot > 0 then                     'one-bits < zero bits; commence padding
      if ltot > llof then                 'one-bits required exceed total bytes
         ltot = llof                       'reset one-bits to equal total bytes
      end if
      itemp = ibuff                            'make copy of file buffer length
      ltmp = ltot                              'make copy of 8th bits to set ON
      cbuff = ""                             'deallocate the source-file buffer
      cbuff = space$(ibuff)                  'reallocate the source-file buffer
      for lbyt = 0 to llof - 1 step itemp'process source file in itemp segments
         if lbyt + itemp > llof then    'current file pointer + itemp spans EOF
            itemp = llof - lbyt               'reset maximum file buffer length
            cbuff = ""                       'deallocate the source-file buffer
            cbuff = space$(itemp)            'reallocate the source-file buffer
         end if
         get ifil, lbyt + 1, cbuff           'read data into source-file buffer
         incr = (llof - lbyt) \ ltmp            'set the bit-pad loop increment
         for ibuffbyt = 0 to itemp - 1 step incr   'process each byte in buffer
            i = bitput(cbuff, ibuffbyt * 8 + 7, 1)      'set each 8th bit to ON
            ltmp = ltmp - 1                    'decrement total one-bits padded
            if ltmp = 0 then                       'all 8th bits are now set ON
               exit for               'all 8th bits are ON - exit ibuffbyt loop
            end if
         next
         put ifil, lbyt + 1, cbuff          'write data from source-file buffer
         if ltmp = 0 then                          'all 8th bits are now set ON
            exit for                      'all 8th bits are ON - exit lbyt loop
         end if
      next
   else                              'one-bits >= zero bits; padding not needed
      ltot = 0                  'reset one-bits required for completion message
   end if
end function
